/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory$KeyCreator;
import com.ibm.gsk.ikeyman.util.AliasRange;
import com.ibm.gsk.ikeyman.util.AliasRange$ValidationMode;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

abstract class KeyCreatorFactory$AbstractKeyCreator
implements KeyCreatorFactory$KeyCreator {
    private String provider;

    public KeyCreatorFactory$AbstractKeyCreator(String string) {
        this.provider = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public KeyPair generateKeyPair(CommandParameters commandParameters) throws KeyManagerException {
        try {
            KeyPair keyPair;
            PublicKey publicKey;
            int n;
            SecureRandom secureRandom = null;
            secureRandom = KeymanUtil.isIBMJCE() ? SecureRandom.getInstance("HASHDRBG", this.provider) : SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed((long)Math.random());
            String string = KeymanUtil.getKeyType(commandParameters.getSigAlg().toString());
            int n2 = commandParameters.getSize();
            KeyPairGenerator keyPairGenerator = this.getKeyPairGenerator(string, commandParameters.getLabel(), n2, secureRandom);
            int n3 = string.equals("RSA") || string.equals("DSA") ? 5 : 0;
            while ((n = KeymanUtil.computeKeySize(publicKey = (keyPair = keyPairGenerator.generateKeyPair()).getPublic())) < n2 && n3-- > 0) {
            }
            if (n < n2 && string.equals("RSA")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_SIZE, new Exception(), new String[]{n + "", string});
            }
            return keyPair;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{this.provider});
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALGORITHM_PARAMETERS, (Throwable)invalidAlgorithmParameterException);
        }
        catch (InvalidParameterException invalidParameterException) {
            if (invalidParameterException.getMessage() != null && invalidParameterException.getMessage().startsWith("Modulus size")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_SIZE_FOR_ALGORITHM, invalidParameterException, new String[]{commandParameters.getSize() + "", KeymanUtil.getKeyType()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)invalidParameterException);
        }
    }

    public Map generateSecretKeys(CommandParameters commandParameters) throws KeyManagerException {
        try {
            HashMap<String, SecretKey> hashMap = new HashMap<String, SecretKey>();
            SecureRandom secureRandom = null;
            secureRandom = KeymanUtil.isIBMJCE() ? SecureRandom.getInstance("HASHDRBG", this.provider) : SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed((long)Math.random());
            if (commandParameters.isParameterPresent(Constants$Parameter.Label)) {
                KeyGenerator keyGenerator = this.getKeyGenerator(commandParameters.getKeyAlgorithm(), commandParameters.getLabel(), commandParameters.getKeySize(), secureRandom);
                SecretKey secretKey = keyGenerator.generateKey();
                hashMap.put(commandParameters.getLabel(), secretKey);
            } else {
                AliasRange aliasRange = new AliasRange(commandParameters.getLabelRange());
                aliasRange.validate(AliasRange$ValidationMode.NORMAL);
                Enumeration enumeration = aliasRange.getAliasEnumerator();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    KeyGenerator keyGenerator = this.getKeyGenerator(commandParameters.getKeyAlgorithm(), string, commandParameters.getKeySize(), secureRandom);
                    SecretKey secretKey = keyGenerator.generateKey();
                    hashMap.put(string, secretKey);
                }
            }
            return hashMap;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALGORITHM_PARAMETER, invalidParameterException, new String[]{invalidParameterException.getMessage()});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{this.provider});
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALGORITHM_PARAMETER, (Throwable)invalidAlgorithmParameterException);
        }
    }

    protected abstract KeyPairGenerator getKeyPairGenerator(String var1, String var2, int var3, SecureRandom var4) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyManagerException, NoSuchProviderException;

    protected abstract KeyGenerator getKeyGenerator(String var1, String var2, int var3, SecureRandom var4) throws KeyManagerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException;
}

