/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.SymtabEntry;
import java.security.MessageDigest;
import java.util.Hashtable;

public class ValueRepositoryId {
    private MessageDigest sha;
    private int index;
    private Hashtable types;
    private String hashcode;

    public ValueRepositoryId() {
        try {
            this.sha = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.index = 0;
        this.types = new Hashtable();
        this.hashcode = null;
    }

    public void addValue(int n) {
        this.sha.update((byte)(n >> 24 & 0xF));
        this.sha.update((byte)(n >> 16 & 0xF));
        this.sha.update((byte)(n >> 8 & 0xF));
        this.sha.update((byte)(n & 0xF));
        ++this.index;
    }

    public void addType(SymtabEntry symtabEntry) {
        this.types.put(symtabEntry, new Integer(this.index));
    }

    public boolean isNewType(SymtabEntry symtabEntry) {
        Object v = this.types.get(symtabEntry);
        if (v == null) {
            this.addType(symtabEntry);
            return true;
        }
        this.addValue(-1);
        this.addValue((Integer)v);
        return false;
    }

    public String getHashcode() {
        if (this.hashcode == null) {
            byte[] byArray = this.sha.digest();
            this.hashcode = ValueRepositoryId.hexOf(byArray[0]) + ValueRepositoryId.hexOf(byArray[1]) + ValueRepositoryId.hexOf(byArray[2]) + ValueRepositoryId.hexOf(byArray[3]) + ValueRepositoryId.hexOf(byArray[4]) + ValueRepositoryId.hexOf(byArray[5]) + ValueRepositoryId.hexOf(byArray[6]) + ValueRepositoryId.hexOf(byArray[7]);
        }
        return this.hashcode;
    }

    private static String hexOf(byte by) {
        int n = by >> 4 & 0xF;
        int n2 = by & 0xF;
        return "0123456789ABCDEF".substring(n, n + 1) + "0123456789ABCDEF".substring(n2, n2 + 1);
    }
}

