/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPChannelHelper;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.jtc.orb.nio.ByteBufferUtils;
import com.ibm.rmi.IOR;
import com.ibm.rmi.Profile;
import com.ibm.rmi.ServiceContext;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.CancelRequestMessage;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.IDROutputStream;
import com.ibm.rmi.iiop.LocateReplyMessage;
import com.ibm.rmi.iiop.LocateRequestMessage;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;

public class Message
implements com.ibm.CORBA.iiop.Message,
Externalizable {
    private static final String CLASS = Message.class.getName();
    protected static final boolean debug = false;
    static final int GIOPBigEndian = 0;
    static final int GIOPLittleEndian = 1;
    static final int FragHdrLength = 4;
    static final int GIOPBigMagic = 1195986768;
    static final int GIOPLittleMagic = 1347373383;
    public static final int KeyAddr = 0;
    public static final int ProfileAddr = 1;
    public static final int ReferenceAddr = 2;
    public static final byte HighestGIOPMajor = 1;
    public static final byte HighestGIOPMinor = 2;
    protected static final byte BYTE_ORDER_MASK = 1;
    private static final byte FRAG_MASK = 2;
    private static final byte INV_FRAG_MASK = -3;
    private static final int[] b4Align = new int[]{0, 3, 2, 1};
    private static final byte[] b = new byte[]{60, 45, 45, 62};
    private static final ServiceContext alignSC = new ServiceContext(1229081864, b);
    private int magic;
    private byte byteOrder = 0;
    private byte flags = 0;
    private boolean fragToFollow = false;
    private byte type;
    private int size = 0;
    private final byte GIOPMajor;
    private final byte GIOPMinor;
    private boolean isPreGIOP12;
    private transient Object flagsPosition = null;
    private transient Object typePosition = null;
    private transient Object sizePosition = null;
    private transient EncoderOutputStream cdrWriter = null;
    protected int bodyOffset;
    protected transient GIOPMessageContext msgContext = null;
    private boolean hdrWritten = false;
    protected int requestId;

    public Message(byte by, byte by2) {
        this.GIOPMajor = by;
        this.GIOPMinor = by2;
        this.isPreGIOP12 = by == 1 && by2 <= 1;
    }

    public Message() {
        this.GIOPMajor = 1;
        this.GIOPMinor = (byte)2;
    }

    @Override
    public boolean preGIOP12() {
        return this.isPreGIOP12;
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int n) {
        this.requestId = n;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    void setType(int n) {
        this.type = (byte)n;
        if (this.typePosition != null) {
            this.cdrWriter.rewriteOctet(this.type, this.typePosition);
        }
    }

    protected void setHeaderWritten(boolean bl) {
        this.hdrWritten = bl;
    }

    protected boolean headerWritten() {
        return this.hdrWritten;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isFragmentToFollow() {
        return this.fragToFollow;
    }

    @Override
    public boolean isLittleEndian() {
        return this.byteOrder == 1;
    }

    byte getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public byte getGIOPMajor() {
        return this.GIOPMajor;
    }

    @Override
    public byte getGIOPMinor() {
        return this.GIOPMinor;
    }

    public void setSize(int n) {
        this.size = n - 12;
        if (this.sizePosition != null) {
            this.cdrWriter.rewriteLong(this.size, this.sizePosition);
            this.cdrWriter.clearPaddingPending();
        }
    }

    void setFragmentToFollow(boolean bl) {
        this.fragToFollow = bl;
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
        if (this.flagsPosition != null) {
            this.cdrWriter.rewriteOctet(this.flags, this.flagsPosition);
        }
    }

    protected void initializeData(int n, byte by, byte by2, int n2, int n3) {
        this.magic = n;
        this.flags = by;
        this.byteOrder = (byte)(by & 1);
        this.fragToFollow = (by & 2) == 2;
        this.type = by2;
        this.size = n2;
        this.requestId = n3;
    }

    static Message createMessage(byte by, byte by2, byte by3) {
        Message message = null;
        switch (by3) {
            case 0: {
                message = new RequestMessage(by, by2);
                break;
            }
            case 3: {
                message = new LocateRequestMessage(by, by2);
                break;
            }
            case 2: {
                message = new CancelRequestMessage(by, by2);
                break;
            }
            case 1: {
                message = new ReplyMessage(by, by2);
                break;
            }
            case 4: {
                message = new LocateReplyMessage(by, by2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                message = new Message(by, by2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad message type: " + by3);
            }
        }
        return message;
    }

    Message createAssociatedMessage(byte by) {
        Message message = null;
        if (this.type == 7 && by == 7) {
            this.resetPositions();
            message = this;
        } else {
            message = Message.createMessage(this.GIOPMajor, this.GIOPMinor, by);
            message.initializeData(this.magic, this.flags, by, 0, this.requestId);
        }
        message.setFragmentToFollow(false);
        return message;
    }

    public static int discriminate(WsByteBuffer[] wsByteBufferArray) throws GIOPVersionException {
        int n = ByteBufferUtils.get(wsByteBufferArray, 0) << 24 & 0xFF000000 | ByteBufferUtils.get(wsByteBufferArray, 1) << 16 & 0xFF0000 | ByteBufferUtils.get(wsByteBufferArray, 2) << 8 & 0xFF00 | ByteBufferUtils.get(wsByteBufferArray, 3) << 0 & 0xFF;
        if (n != 1195986768 && n != 1347373383) {
            throw new GIOPVersionException("0x" + Integer.toHexString(n));
        }
        return n;
    }

    public static int discriminate(byte[] byArray, int n) throws GIOPVersionException {
        int n2 = byArray[n + 0] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] << 0 & 0xFF;
        if (n2 != 1195986768 && n2 != 1347373383) {
            throw new GIOPVersionException("0x" + Integer.toHexString(n2));
        }
        return n2;
    }

    public static Message createMessage(byte[] byArray, int n) throws SystemException, IOException, GIOPVersionException {
        int n2;
        int n3;
        int n4;
        int n5;
        Message message = null;
        if (byArray.length < 12) {
            throw new GIOPVersionException("0x" + Utility.bytesToHexString(byArray));
        }
        byte by = byArray[n + 7];
        int n6 = Message.discriminate(byArray, n);
        byte by2 = byArray[n + 4];
        byte by3 = byArray[n + 5];
        if (by2 != 1 || by2 == 1 && by3 > 2) {
            throw new GIOPVersionException(by2 + "." + by3);
        }
        try {
            message = Message.createMessage(by2, by3, by);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new INTERNAL("Bad GIOP request:" + by, 1229125003, CompletionStatus.COMPLETED_NO);
        }
        byte by4 = byArray[n + 6];
        if ((by4 & 1) == 0) {
            n5 = byArray[n + 8] << 24 & 0xFF000000;
            n4 = byArray[n + 9] << 16 & 0xFF0000;
            n3 = byArray[n + 10] << 8 & 0xFF00;
            n2 = byArray[n + 11] << 0 & 0xFF;
        } else {
            n5 = byArray[n + 11] << 24 & 0xFF000000;
            n4 = byArray[n + 10] << 16 & 0xFF0000;
            n3 = byArray[n + 9] << 8 & 0xFF00;
            n2 = byArray[n + 8] << 0 & 0xFF;
        }
        int n7 = (n5 | n4 | n3 | n2) + 12;
        message.initializeData(n6, by4, by, n7, 0);
        return message;
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = 0;
            int n4 = 0;
            while (true) {
                try {
                    n3 = inputStream.read(byArray, n + i, n2 - i);
                }
                catch (IOException iOException) {
                    if (n4++ < 5) continue;
                    throw iOException;
                }
                break;
            }
            if (n3 >= 0) continue;
            throw new IOException();
        }
    }

    public void write(EncoderOutputStream encoderOutputStream) throws SystemException {
        byte by = encoderOutputStream.getMode();
        encoderOutputStream.setMode((byte)1);
        if (this.cdrWriter != encoderOutputStream) {
            if (this.cdrWriter != null && (encoderOutputStream.getWriter() instanceof CDROutputStream || encoderOutputStream.getWriter() instanceof IDROutputStream)) {
                throw new IllegalStateException("EncoderOutputStream already set for message");
            }
            this.cdrWriter = encoderOutputStream;
        }
        encoderOutputStream.write_long(1195986768);
        encoderOutputStream.write_octet(this.GIOPMajor);
        encoderOutputStream.write_octet(this.GIOPMinor);
        this.flagsPosition = encoderOutputStream.writePlaceHolderOctet(this.flags);
        this.typePosition = encoderOutputStream.writePlaceHolderOctet(this.type);
        this.sizePosition = encoderOutputStream.writePlaceHolderLong(this.size);
        encoderOutputStream.setMode(by);
    }

    public void read(org.omg.CORBA.portable.InputStream inputStream) throws SystemException {
    }

    public String getTypeName() {
        String string;
        switch (this.type) {
            case 3: {
                string = "GIOPLocateRequest";
                break;
            }
            case 0: {
                string = "GIOPRequest";
                break;
            }
            case 1: {
                string = "GIOPReply";
                break;
            }
            case 4: {
                string = "GIOPLocateReply";
                break;
            }
            case 2: {
                string = "GIOPCancelRequest";
                break;
            }
            case 5: {
                string = "GIOPCloseConnection";
                break;
            }
            case 6: {
                string = "GIOPMessageError";
                break;
            }
            case 7: {
                string = "GIOPFragment";
                break;
            }
            default: {
                string = "UNKNOWN MESSAGE TYPE";
            }
        }
        return string;
    }

    void resetPositions() {
        this.sizePosition = null;
        this.typePosition = null;
        this.flagsPosition = null;
        this.cdrWriter = null;
    }

    public void dumpMessageIfTracing(ORB oRB, WsByteBuffer[] wsByteBufferArray, TransportConnection transportConnection) {
        if (oRB.CommTraceIsEnabled()) {
            boolean bl = true;
            int n = this.getType();
            if (!(this.headerWritten() || n != 0 && n != 3 && n != 1 && n != 4 && n != 7)) {
                bl = false;
            }
            byte[] byArray = WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray);
            Trace.dump(com.ibm.rmi.ras.Utility.getMessage("Trace.outGoing"), bl, true, byArray, byArray.length, 0, transportConnection);
        }
    }

    public GIOPMessageContext createMessageContext(WsByteBuffer[] wsByteBufferArray) throws Exception {
        this.msgContext = new GIOPMessageContextBase(this, wsByteBufferArray, this.getBodyOffset());
        return this.msgContext;
    }

    public GIOPMessageContext getMessageContext() {
        return this.msgContext;
    }

    public GIOPMessageContext flushToMessageContext(ByteBuffer byteBuffer) throws Exception {
        this.msgContext = new GIOPMessageContextBase(this, byteBuffer);
        return this.msgContext;
    }

    public void writeContext(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        try {
            this.msgContext = new GIOPMessageContextBase(this, byteBuffer);
            ((GIOPMessageContextBase)this.msgContext).write(outputStream, 0);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public int getBodyOffset() {
        return this.bodyOffset;
    }

    public void setBodyOffset(int n) {
        this.bodyOffset = n;
    }

    public int getWriteOffset() {
        return this.cdrWriter.get_offset();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.isPreGIOP12);
        objectOutput.writeInt(this.requestId);
        objectOutput.writeInt(this.bodyOffset);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.isPreGIOP12 = objectInput.readBoolean();
        this.requestId = objectInput.readInt();
        this.bodyOffset = objectInput.readInt();
    }

    protected static void writeIOR(ObjectOutput objectOutput, com.ibm.CORBA.iiop.IOR iOR) throws IOException {
        if (iOR == null) {
            objectOutput.writeObject(null);
        } else {
            objectOutput.writeObject(iOR.stringify());
        }
    }

    protected static com.ibm.CORBA.iiop.IOR readIOR(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        IOR iOR = null;
        String string = (String)objectInput.readObject();
        if (string != null) {
            com.ibm.CORBA.iiop.ORB oRB = GIOPChannelHelper.getOrb();
            if (oRB != null) {
                iOR = new IOR(oRB, string);
            } else {
                Trc.ffdc("No ORB available from GIOPChannelHelper: cannot reconstruct IOR object.", CLASS, "readIOR:861");
                throw new IOException("No ORB available from GIOPChannelHelper: cannot reconstruct IOR object.");
            }
        }
        return iOR;
    }

    protected static void writeProfile(ObjectOutput objectOutput, Profile profile) throws IOException {
        objectOutput.writeObject(profile.getHost());
        objectOutput.writeInt(profile.getPort());
        objectOutput.writeObject(profile.getObjectKeyObject());
    }

    protected static Profile readProfile(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        int n = objectInput.readInt();
        ObjectKey objectKey = (ObjectKey)objectInput.readObject();
        Profile profile = null;
        com.ibm.CORBA.iiop.ORB oRB = GIOPChannelHelper.getOrb();
        if (oRB == null) {
            Trc.ffdc("No ORB available from GIOPChannelHelper: cannot reconstruct Profile object", CLASS, "readProfile:901");
            throw new IOException("No ORB available from GIOPChannelHelper: cannot reconstruct Profile object");
        }
        profile = new Profile(oRB, string, n, objectKey);
        return profile;
    }

    protected void addAlignmentContext(EncoderOutputStream encoderOutputStream, int n, Object object) {
        alignSC.write((org.omg.CORBA.portable.OutputStream)encoderOutputStream);
        encoderOutputStream.rewriteLong(n, object);
    }

    protected int alignToWordBoundary(int n) {
        return n + b4Align[n & 3];
    }
}

