/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public final class IssuerAlternativeNameExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.IssuerAlternativeName";
    public static final String NAME = "IssuerAlternativeName";
    public static final String ISSUER_NAME = "issuer_name";
    GeneralNames names = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.IssuerAlternativeNameExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "encodeThis");
        }
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(16384L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        try {
            this.names.encode(os);
        }
        catch (GeneralNamesException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encodeThis", e);
            }
            throw new IOException(e.toString());
        }
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "encodeThis_2");
        }
    }

    public IssuerAlternativeNameExtension(GeneralNames names) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuerAlternativeNameExtension", names);
        }
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = false;
        this.names = names != null ? names.clone() : names;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAlternativeNameExtension");
        }
    }

    public IssuerAlternativeNameExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAlternativeNameExtension");
        }
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = false;
        this.names = new GeneralNames();
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAlternativeNameExtension");
        }
    }

    public IssuerAlternativeNameExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAlternativeNameExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.getData() == null) {
            this.names = new GeneralNames();
            return;
        }
        try {
            this.names = new GeneralNames(val);
        }
        catch (GeneralNamesException e) {
            if (debug != null) {
                debug.exception(16384L, className, "IssuerAlternativeNameExtension", e);
            }
            throw new IOException("IssuerAlternativeNameExtension" + e.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAlternativeNameExtension");
        }
    }

    public IssuerAlternativeNameExtension(Boolean critical, GeneralNames names) throws IOException {
        this.names = names;
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = critical;
        this.encodeThis();
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.names == null) {
            return "";
        }
        String s = super.toString() + "IssuerAlternativeName [\n" + this.names.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(ISSUER_NAME)) {
            if (!(obj instanceof GeneralNames)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralNames.");
                }
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = obj != null ? ((GeneralNames)obj).clone() : null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public GeneralNames get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(ISSUER_NAME)) {
            if (this.names != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.names.clone());
                }
                return this.names.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.names);
            }
            return this.names;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(ISSUER_NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
        }
        this.names = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(ISSUER_NAME);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

