/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;

public class ConnectChannelSelector
extends ChannelSelector {
    static final TraceComponent tc = Tr.register(ConnectChannelSelector.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected WorkQueueManager wqm;
    int countIndex;
    int channelType;
    private static final int BATCH_SIZE = 10;
    private ConnectionManager.ConnectInfo[] workBatch = new ConnectionManager.ConnectInfo[10];
    private int batchCount = 0;
    private int batchIndex = 0;

    public ConnectChannelSelector(boolean bl, WorkQueueManager workQueueManager, int n, int n2) throws IOException {
        super(bl, false);
        this.wqm = workQueueManager;
        this.countIndex = n;
        this.channelType = n2;
    }

    protected void addWork(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addWork");
        }
        this.addToWorkQueue(object);
        this.wakeup();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addWork");
        }
    }

    protected void updateSelector() {
        ConnectionManager.ConnectInfo connectInfo = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updateSelector - processing " + this.getWorkQueueSize() + " items");
        }
        block2: while (true) {
            if (this.batchIndex == 0 || this.batchIndex >= this.batchCount) {
                this.batchIndex = 0;
                this.batchCount = this.removeBatchFromWorkQueue(this.workBatch, 10);
                if (this.batchCount <= 0) break;
            }
            while (true) {
                block11: {
                    if (this.batchIndex >= this.batchCount) continue block2;
                    connectInfo = this.workBatch[this.batchIndex];
                    ++this.batchIndex;
                    try {
                        tc.checkTraceLevelChanged();
                        connectInfo.channel.register(this.selector, 8, connectInfo);
                        if (connectInfo.timeout != -1) {
                            connectInfo.nextTimeoutTime = System.currentTimeMillis() + (long)connectInfo.timeout;
                            if (connectInfo.nextTimeoutTime < this.nextTimeoutTime) {
                                this.nextTimeoutTime = connectInfo.nextTimeoutTime;
                            }
                        }
                        this.updateCount();
                    }
                    catch (ClosedChannelException closedChannelException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "SocketChannel connect failed, local: " + connectInfo.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + connectInfo.ioSocket.getSocket().getRemoteSocketAddress());
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "SocketChannel.register ClosedChannelException caught " + closedChannelException);
                        }
                        connectInfo.setError(closedChannelException);
                        if (this.wqm.connectDispatcher(connectInfo)) break block11;
                        this.addWork(connectInfo);
                    }
                }
                this.workBatch[this.batchIndex - 1] = null;
            }
            break;
        }
        if (connectInfo != null) {
            this.waitingToQuit = false;
            this.quit = false;
        }
    }

    protected void updateCount() {
        int n = this.selector.keys().size();
        if (n == 0 && this.countIndex != 0) {
            this.wqm.updateCount(this.countIndex, WorkQueueManager.CS_DELETE_IN_PROGRESS, this.channelType);
        } else {
            this.waitingToQuit = false;
            this.wqm.updateCount(this.countIndex, this.selector.keys().size(), this.channelType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelSelectorClose() {
        Object object = this.wqm.shutdownSync;
        synchronized (object) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.wqm.updateCount(this.countIndex, WorkQueueManager.CS_NULL, this.channelType);
        }
    }

    protected boolean performRequest() {
        boolean bl = false;
        Set<SelectionKey> set = this.selector.selectedKeys();
        Iterator<SelectionKey> iterator = set.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "performRequest - processing " + set.size() + " items");
        }
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "calling selectorIterator.remove()");
            }
            iterator.remove();
            ConnectionManager.ConnectInfo connectInfo = (ConnectionManager.ConnectInfo)selectionKey.attachment();
            connectInfo.setFinish();
            if (!this.wqm.connectDispatcher(connectInfo)) continue;
            selectionKey.cancel();
            bl = true;
        }
        return bl;
    }

    protected void checkForTimeouts() {
        if (this.currentTime >= this.nextTimeoutTime) {
            Set<SelectionKey> set = this.selector.keys();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkForTimeouts - checking " + set.size() + " keys for timeouts");
            }
            if (set.isEmpty()) {
                if (this.countIndex != 0) {
                    if (this.waitingToQuit) {
                        this.quit = true;
                    } else {
                        this.wqm.updateCount(this.countIndex, WorkQueueManager.CS_DELETE_IN_PROGRESS, this.channelType);
                        this.waitingToQuit = true;
                        this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorWaitToTerminate();
                    }
                } else {
                    this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
                }
            } else {
                this.waitingToQuit = false;
                Iterator<SelectionKey> iterator = set.iterator();
                this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
                SelectionKey selectionKey = null;
                while (iterator.hasNext()) {
                    selectionKey = iterator.next();
                    try {
                        int n = selectionKey.interestOps();
                        if (n <= 0) continue;
                        ConnectionManager.ConnectInfo connectInfo = (ConnectionManager.ConnectInfo)selectionKey.attachment();
                        if (connectInfo.timeout == -1) continue;
                        if (connectInfo.nextTimeoutTime <= this.currentTime) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "Inactivity timeout on connect operation for channel" + connectInfo.ioSocket.getChannel());
                            }
                            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("Socket operation timed out before it could be completed");
                            connectInfo.setError(socketTimeoutException);
                            if (this.wqm.connectDispatcher(connectInfo)) {
                                selectionKey.cancel();
                                connectInfo.ioSocket.close();
                            }
                            this.addWork(connectInfo);
                            continue;
                        }
                        if (connectInfo.nextTimeoutTime >= this.nextTimeoutTime) continue;
                        this.nextTimeoutTime = connectInfo.nextTimeoutTime;
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
            }
        }
    }
}

