/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.stacks;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.healthcenter.stacks.CallSiteNode;
import com.ibm.java.diagnostics.healthcenter.stacks.CallStack;
import com.ibm.java.diagnostics.healthcenter.stacks.StackEntry;
import com.ibm.java.diagnostics.healthcenter.stacks.StackLabels;

public class CallSiteTreeData
extends DataImpl {
    private CallSiteNode rootNode;

    public CallSiteNode getRootNode() {
        return this.rootNode;
    }

    protected CallSiteTreeData(String string) {
        super(StackLabels.CALL_SITE_TREE);
        this.rootNode = new CallSiteNode(new StackEntry(string));
        this.addData(this.rootNode);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public void addCallStack(CallStack callStack) {
        StackEntry stackEntry;
        int n = callStack.getStackSize();
        if (n == 0) {
            return;
        }
        StackEntry stackEntry2 = callStack.getStackEntry(0);
        if (!stackEntry2.equals(this.rootNode.getCallSite())) {
            return;
        }
        this.rootNode.incrementCount();
        CallSiteNode callSiteNode = this.rootNode;
        for (int i = 1; i < n && (stackEntry = callStack.getStackEntry(i)) != null; ++i) {
            CallSiteNode callSiteNode2;
            DataBuilder dataBuilder = callSiteNode.getTopLevelData(stackEntry.getEntry());
            if (dataBuilder == null) {
                callSiteNode2 = new CallSiteNode(stackEntry);
                callSiteNode2.setParentNode(callSiteNode);
                callSiteNode.addData(callSiteNode2);
            } else {
                callSiteNode2 = (CallSiteNode)dataBuilder;
            }
            callSiteNode2.incrementCount();
            callSiteNode = callSiteNode2;
        }
    }
}

