/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Messages;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Method;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.util.logging.Logger;

public abstract class MethodNode
extends DataImpl {
    protected static final String REVERSE_HIDDEN_ROOT = "ReverseHiddenRoot";
    protected static final String FORWARD_HIDDEN_ROOT = "ForwardHiddenRoot";
    private static final Logger TRACE = LogFactory.getTrace(MethodNode.class);
    protected final Method anchorMethod;
    protected final MethodNode parent;
    protected int count;
    private int childCount;

    protected MethodNode(String string, Method method, MethodNode methodNode) {
        this(string, method, methodNode, 1);
    }

    protected MethodNode(Method method, MethodNode methodNode, int n) {
        this(method != null ? method.getUniqueId() : null, method, methodNode, n);
    }

    protected MethodNode(String string, Method method, MethodNode methodNode, int n) {
        super(string);
        this.anchorMethod = method;
        this.parent = methodNode;
        this.count = 0;
        this.incrementRefCount(n);
    }

    private String generateLabel(Method method) {
        return method.getMethodName();
    }

    public void incrementRefCount() {
        this.incrementRefCount(1);
    }

    public void incrementRefCount(int n) {
        this.count += n;
        if (this.parent != null) {
            this.parent.incrementChildCount(n);
        }
        this.notifyListeners();
    }

    public double getWeight() {
        if (this.parent == null) {
            return -1.0;
        }
        return 100.0 * (double)this.count / (double)this.parent.getChildCount();
    }

    private void incrementChildCount(int n) {
        this.childCount += n;
    }

    public int getChildCount() {
        return this.childCount;
    }

    @Override
    public String getLabel() {
        if (this.anchorMethod != null) {
            this.label = this.generateLabel(this.anchorMethod);
        }
        return this.label;
    }

    @Override
    public MethodNode getParent() {
        return this.parent;
    }

    public MethodNode findChild(Method method) {
        return (MethodNode)this.getTopLevelData(method.getUniqueId());
    }

    public String getValue() {
        return this.getCount() + " " + Messages.getString("MethodNode.samples");
    }

    public Method getMethod() {
        return this.anchorMethod;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public String toString() {
        if (this.anchorMethod == null) {
            return Messages.getString("MethodNode.hidden.root");
        }
        return this.anchorMethod.getName() + " (" + this.count + ")";
    }

    @Override
    public int compareTo(Data data) {
        if (data instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)data;
            int n = this.count - methodNode.count;
            if (n != 0) {
                return n;
            }
            return this.anchorMethod.getName().compareTo(methodNode.anchorMethod.getName());
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)object;
            boolean bl = true;
            if (this.count != methodNode.count) {
                bl = false;
            } else if (this.anchorMethod != null && !this.anchorMethod.equals(methodNode.anchorMethod)) {
                bl = false;
            } else if (this.parent != null && !this.parent.equals(methodNode.parent)) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        if (this.anchorMethod != null) {
            return this.anchorMethod.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public void addChild(MethodNode methodNode) {
        this.addData(methodNode);
    }

    public long getMethodId() {
        return this.anchorMethod.getUniqueIdAsNumber();
    }

    public String getMethodName() {
        return this.anchorMethod.getMethodName();
    }

    public String getFullyQualifiedName() {
        return this.anchorMethod.getName();
    }

    public MethodNode createChild(Method method) {
        return this.createChild(method, 1);
    }

    public abstract MethodNode createChild(Method var1, int var2);

    public abstract boolean isASyntheticRoot();

    public boolean isTopLevel() {
        return this.parent != null && this.parent.isASyntheticRoot();
    }
}

