/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import com.ibm.security.util.PropertyExpander;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import sun.security.util.Debug;

final class ProviderConfig {
    private static final Debug debug = Debug.getInstance("jca", "ProviderConfig");
    private static final String P11_SOL_NAME = "sun.security.pkcs11.SunPKCS11";
    private static final String P11_SOL_ARG = "${java.home}/lib/security/sunpkcs11-solaris.cfg";
    private static final int MAX_LOAD_TRIES = 30;
    private static final Class[] CL_STRING = new Class[]{String.class};
    private final String className;
    private final String argument;
    private int tries;
    private volatile Provider provider;
    private boolean isLoading;

    ProviderConfig(String string, String string2) {
        if (string.equals(P11_SOL_NAME) && string2.equals(P11_SOL_ARG)) {
            this.checkSunPKCS11Solaris();
        }
        this.className = string;
        this.argument = ProviderConfig.expand(string2);
    }

    ProviderConfig(String string) {
        this(string, "");
    }

    ProviderConfig(Provider provider) {
        this.className = provider.getClass().getName();
        this.argument = "";
        this.provider = provider;
    }

    private void checkSunPKCS11Solaris() {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file = new File("/usr/lib/libpkcs11.so");
                if (!file.exists()) {
                    return Boolean.FALSE;
                }
                if ("false".equalsIgnoreCase(System.getProperty("sun.security.pkcs11.enable-solaris"))) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        if (bl == Boolean.FALSE) {
            this.tries = 30;
        }
    }

    private boolean hasArgument() {
        return this.argument.length() != 0;
    }

    private boolean shouldLoad() {
        return this.tries < 30;
    }

    private void disableLoad() {
        this.tries = 30;
    }

    boolean isLoaded() {
        return this.provider != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProviderConfig)) {
            return false;
        }
        ProviderConfig providerConfig = (ProviderConfig)object;
        return this.className.equals(providerConfig.className) && this.argument.equals(providerConfig.argument);
    }

    public int hashCode() {
        return this.className.hashCode() + this.argument.hashCode();
    }

    public String toString() {
        if (this.hasArgument()) {
            return this.className + "('" + this.argument + "')";
        }
        return this.className;
    }

    synchronized Provider getProvider() {
        Provider provider = this.provider;
        if (provider != null) {
            return provider;
        }
        if (!this.shouldLoad()) {
            return null;
        }
        if (this.isLoading) {
            if (debug != null) {
                debug.println("Recursion loading provider: " + this);
                new Exception("Call trace").printStackTrace();
            }
            return null;
        }
        try {
            this.isLoading = true;
            ++this.tries;
            provider = this.doLoadProvider();
        }
        finally {
            this.isLoading = false;
        }
        this.provider = provider;
        return provider;
    }

    private Provider doLoadProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<Provider>(){

            @Override
            public Provider run() {
                if (debug != null) {
                    debug.println("Loading provider: " + ProviderConfig.this);
                }
                try {
                    Object obj;
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(ProviderConfig.this.className) : Class.forName(ProviderConfig.this.className);
                    if (!ProviderConfig.this.hasArgument()) {
                        obj = clazz.newInstance();
                    } else {
                        Constructor<?> constructor = clazz.getConstructor(CL_STRING);
                        obj = constructor.newInstance(ProviderConfig.this.argument);
                    }
                    if (obj instanceof Provider) {
                        if (debug != null) {
                            debug.println("Loaded provider " + obj);
                        }
                        return (Provider)obj;
                    }
                    if (debug != null) {
                        debug.println(ProviderConfig.this.className + " is not a provider");
                    }
                    ProviderConfig.this.disableLoad();
                    return null;
                }
                catch (Exception exception) {
                    Throwable throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getCause() : exception;
                    if (debug != null) {
                        debug.println("Error loading provider " + ProviderConfig.this);
                        throwable.printStackTrace();
                    }
                    if (throwable instanceof ProviderException) {
                        throw (ProviderException)throwable;
                    }
                    if (throwable instanceof UnsupportedOperationException) {
                        ProviderConfig.this.disableLoad();
                    }
                    return null;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    if (debug != null) {
                        debug.println("Error loading provider " + ProviderConfig.this);
                        exceptionInInitializerError.printStackTrace();
                    }
                    ProviderConfig.this.disableLoad();
                    return null;
                }
            }
        });
    }

    private static String expand(final String string) {
        if (!string.contains("${")) {
            return string;
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return PropertyExpander.expand(string);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException(generalSecurityException);
                }
            }
        });
    }
}

