/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    private static final String defaultBundle = "sun.util.logging.resources.logging";
    private final String name;
    private final int value;
    private final String resourceBundleName;
    private transient String localizedLevelName;
    private transient Locale cachedLocale;
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE, "sun.util.logging.resources.logging");
    public static final Level SEVERE = new Level("SEVERE", 1000, "sun.util.logging.resources.logging");
    public static final Level WARNING = new Level("WARNING", 900, "sun.util.logging.resources.logging");
    public static final Level INFO = new Level("INFO", 800, "sun.util.logging.resources.logging");
    public static final Level CONFIG = new Level("CONFIG", 700, "sun.util.logging.resources.logging");
    public static final Level FINE = new Level("FINE", 500, "sun.util.logging.resources.logging");
    public static final Level FINER = new Level("FINER", 400, "sun.util.logging.resources.logging");
    public static final Level FINEST = new Level("FINEST", 300, "sun.util.logging.resources.logging");
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE, "sun.util.logging.resources.logging");
    private static final long serialVersionUID = -8176160795706313070L;

    protected Level(String string, int n) {
        this(string, n, null);
    }

    protected Level(String string, int n, String string2) {
        this(string, n, string2, true);
    }

    private Level(String string, int n, String string2, boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.value = n;
        this.resourceBundleName = string2;
        this.localizedLevelName = string2 == null ? string : null;
        this.cachedLocale = null;
        if (bl) {
            KnownLevel.add(this);
        }
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return this.getLocalizedLevelName();
    }

    final String getLevelName() {
        return this.name;
    }

    private String computeLocalizedLevelName(Locale locale) {
        if (!defaultBundle.equals(this.resourceBundleName)) {
            return ResourceBundle.getBundle(this.resourceBundleName, locale, ClassLoader.getSystemClassLoader()).getString(this.name);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(defaultBundle, locale);
        String string = resourceBundle.getString(this.name);
        Locale locale2 = resourceBundle.getLocale();
        Locale locale3 = Locale.ROOT.equals(locale2) || this.name.equals(string.toUpperCase(Locale.ROOT)) ? Locale.ROOT : locale2;
        return Locale.ROOT.equals(locale3) ? this.name : string.toUpperCase(locale3);
    }

    final String getCachedLocalizedLevelName() {
        if (this.localizedLevelName != null && this.cachedLocale != null && this.cachedLocale.equals(Locale.getDefault())) {
            return this.localizedLevelName;
        }
        if (this.resourceBundleName == null) {
            return this.name;
        }
        return null;
    }

    final synchronized String getLocalizedLevelName() {
        String string = this.getCachedLocalizedLevelName();
        if (string != null) {
            return string;
        }
        Locale locale = Locale.getDefault();
        try {
            this.localizedLevelName = this.computeLocalizedLevelName(locale);
        }
        catch (Exception exception) {
            this.localizedLevelName = this.name;
        }
        this.cachedLocale = locale;
        return this.localizedLevelName;
    }

    static Level findLevel(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        KnownLevel knownLevel = KnownLevel.findByName(string);
        if (knownLevel != null) {
            return knownLevel.mirroredLevel;
        }
        try {
            int n = Integer.parseInt(string);
            knownLevel = KnownLevel.findByValue(n);
            if (knownLevel == null) {
                Level level = new Level(string, n);
                knownLevel = KnownLevel.findByValue(n);
            }
            return knownLevel.mirroredLevel;
        }
        catch (NumberFormatException numberFormatException) {
            knownLevel = KnownLevel.findByLocalizedLevelName(string);
            if (knownLevel != null) {
                return knownLevel.mirroredLevel;
            }
            return null;
        }
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    private Object readResolve() {
        Level level;
        KnownLevel knownLevel;
        do {
            if ((level = KnownLevel.levelObject(knownLevel = KnownLevel.matches(this))) == null) continue;
            return level;
        } while (knownLevel != null);
        level = new Level(this.name, this.value, this.resourceBundleName);
        return level;
    }

    public static synchronized Level parse(String string) throws IllegalArgumentException {
        Level level;
        KnownLevel knownLevel;
        string.length();
        do {
            if ((level = KnownLevel.levelObject(knownLevel = KnownLevel.findByName(string))) == null) continue;
            return level;
        } while (knownLevel != null);
        try {
            int n = Integer.parseInt(string);
            do {
                if ((level = KnownLevel.levelObject(knownLevel = KnownLevel.findByValue(n))) == null) continue;
                return level;
            } while (knownLevel != null);
            Level level2 = new Level(string, n);
            knownLevel = KnownLevel.findByValue(n);
            return KnownLevel.levelObject(knownLevel);
        }
        catch (NumberFormatException numberFormatException) {
            do {
                if ((level = KnownLevel.levelObject(knownLevel = KnownLevel.findByLocalizedLevelName(string))) == null) continue;
                return level;
            } while (knownLevel != null);
            throw new IllegalArgumentException("Bad level \"" + string + "\"");
        }
    }

    public boolean equals(Object object) {
        try {
            Level level = (Level)object;
            return level.value == this.value;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    static final class KnownLevel
    extends WeakReference<Level> {
        private static Map<String, List<KnownLevel>> nameToLevels = new HashMap<String, List<KnownLevel>>();
        private static Map<Integer, List<KnownLevel>> intToLevels = new HashMap<Integer, List<KnownLevel>>();
        private static final ReferenceQueue<Level> QUEUE = new ReferenceQueue();
        final Level mirroredLevel;

        KnownLevel(Level level) {
            super(level, QUEUE);
            this.mirroredLevel = level.getClass() == Level.class ? level : new Level(level.name, level.value, level.resourceBundleName, false);
        }

        private void remove() {
            List<KnownLevel> list;
            List<KnownLevel> list2 = nameToLevels.get(this.mirroredLevel.name);
            if (list2 != null) {
                list2.remove(this);
            }
            if ((list = intToLevels.get(this.mirroredLevel.value)) != null) {
                list.remove(this);
            }
        }

        static synchronized void purge(KnownLevel knownLevel) {
            knownLevel.remove();
        }

        static synchronized void purge() {
            Reference<Level> reference;
            while ((reference = QUEUE.poll()) != null) {
                if (!(reference instanceof KnownLevel)) continue;
                ((KnownLevel)reference).remove();
            }
        }

        static synchronized void add(Level level) {
            KnownLevel.purge();
            KnownLevel knownLevel = new KnownLevel(level);
            List<KnownLevel> list = nameToLevels.get(level.name);
            if (list == null) {
                list = new ArrayList<KnownLevel>();
                nameToLevels.put(level.name, list);
            }
            list.add(knownLevel);
            list = intToLevels.get(level.value);
            if (list == null) {
                list = new ArrayList<KnownLevel>();
                intToLevels.put(level.value, list);
            }
            list.add(knownLevel);
        }

        static synchronized KnownLevel findByName(String string) {
            KnownLevel.purge();
            List<KnownLevel> list = nameToLevels.get(string);
            if (list != null) {
                return list.get(0);
            }
            return null;
        }

        static synchronized KnownLevel findByValue(int n) {
            KnownLevel.purge();
            List<KnownLevel> list = intToLevels.get(n);
            if (list != null) {
                return list.get(0);
            }
            return null;
        }

        static synchronized KnownLevel findByLocalizedLevelName(String string) {
            KnownLevel.purge();
            for (List<KnownLevel> list : nameToLevels.values()) {
                for (KnownLevel knownLevel : list) {
                    String string2;
                    Level level = (Level)knownLevel.get();
                    if (level == null || !string.equals(string2 = level.getLocalizedLevelName())) continue;
                    return knownLevel;
                }
            }
            return null;
        }

        static synchronized KnownLevel matches(Level level) {
            KnownLevel.purge();
            List<KnownLevel> list = nameToLevels.get(level.name);
            if (list != null) {
                for (KnownLevel knownLevel : list) {
                    Level level2 = knownLevel.mirroredLevel;
                    if (level.value != level2.value || level.resourceBundleName != level2.resourceBundleName && (level.resourceBundleName == null || !level.resourceBundleName.equals(level2.resourceBundleName))) continue;
                    return knownLevel;
                }
            }
            return null;
        }

        static Level levelObject(KnownLevel knownLevel) {
            if (knownLevel == null) {
                return null;
            }
            Level level = (Level)knownLevel.get();
            if (level == null) {
                KnownLevel.purge(knownLevel);
            }
            return level;
        }
    }
}

