/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.SequenceInputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.spi.MidiFileWriter;

public final class StandardMidiFileWriter
extends MidiFileWriter {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MTrk_MAGIC = 1297379947;
    private static final int ONE_BYTE = 1;
    private static final int TWO_BYTE = 2;
    private static final int SYSEX = 3;
    private static final int META = 4;
    private static final int ERROR = 5;
    private static final int IGNORE = 6;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int bufferSize = 16384;
    private DataOutputStream tddos;
    private static final int[] types = new int[]{0, 1};
    private static final long mask = 127L;

    @Override
    public int[] getMidiFileTypes() {
        int[] nArray = new int[types.length];
        System.arraycopy(types, 0, nArray, 0, types.length);
        return nArray;
    }

    @Override
    public int[] getMidiFileTypes(Sequence sequence) {
        Track[] trackArray = sequence.getTracks();
        int[] nArray = trackArray.length == 1 ? new int[]{0, 1} : new int[]{1};
        return nArray;
    }

    @Override
    public boolean isFileTypeSupported(int n) {
        for (int i = 0; i < types.length; ++i) {
            if (n != types[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        int n2 = 0;
        long l = 0L;
        if (!this.isFileTypeSupported(n, sequence)) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        InputStream inputStream = this.getFileStream(n, sequence);
        if (inputStream == null) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        byArray = new byte[16384];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
            l += (long)n2;
        }
        return (int)l;
    }

    @Override
    public int write(Sequence sequence, int n, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n2;
            int n3 = n2 = this.write(sequence, n, fileOutputStream);
            return n3;
        }
    }

    private InputStream getFileStream(int n, Sequence sequence) throws IOException {
        int n2;
        int n3;
        Track[] trackArray = sequence.getTracks();
        int n4 = 0;
        int n5 = 14;
        int n6 = 0;
        PipedOutputStream pipedOutputStream = null;
        DataOutputStream dataOutputStream = null;
        PipedInputStream pipedInputStream = null;
        InputStream[] inputStreamArray = null;
        InputStream inputStream = null;
        SequenceInputStream sequenceInputStream = null;
        if (n == 0) {
            if (trackArray.length != 1) {
                return null;
            }
        } else if (n == 1) {
            if (trackArray.length < 1) {
                return null;
            }
        } else if (trackArray.length == 1) {
            n = 0;
        } else if (trackArray.length > 1) {
            n = 1;
        } else {
            return null;
        }
        inputStreamArray = new InputStream[trackArray.length];
        int n7 = 0;
        for (n3 = 0; n3 < trackArray.length; ++n3) {
            try {
                inputStreamArray[n7] = this.writeTrack(trackArray[n3], n);
                ++n7;
                continue;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
        if (n7 == 1) {
            inputStream = inputStreamArray[0];
        } else if (n7 > 1) {
            inputStream = inputStreamArray[0];
            for (n3 = 1; n3 < trackArray.length; ++n3) {
                if (inputStreamArray[n3] == null) continue;
                inputStream = new SequenceInputStream(inputStream, inputStreamArray[n3]);
            }
        } else {
            throw new IllegalArgumentException("invalid MIDI data in sequence");
        }
        pipedOutputStream = new PipedOutputStream();
        dataOutputStream = new DataOutputStream(pipedOutputStream);
        pipedInputStream = new PipedInputStream(pipedOutputStream);
        dataOutputStream.writeInt(1297377380);
        dataOutputStream.writeInt(n5 - 8);
        if (n == 0) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(1);
        }
        dataOutputStream.writeShort((short)n7);
        float f = sequence.getDivisionType();
        if (f == 0.0f) {
            n2 = sequence.getResolution();
        } else if (f == 24.0f) {
            n2 = -6144;
            n2 += sequence.getResolution() & 0xFF;
        } else if (f == 25.0f) {
            n2 = -6400;
            n2 += sequence.getResolution() & 0xFF;
        } else if (f == 29.97f) {
            n2 = -7424;
            n2 += sequence.getResolution() & 0xFF;
        } else if (f == 30.0f) {
            n2 = -7680;
            n2 += sequence.getResolution() & 0xFF;
        } else {
            return null;
        }
        dataOutputStream.writeShort(n2);
        sequenceInputStream = new SequenceInputStream(pipedInputStream, inputStream);
        dataOutputStream.close();
        n6 = n4 + n5;
        return sequenceInputStream;
    }

    private int getType(int n) {
        if ((n & 0xF0) == 240) {
            switch (n) {
                case 240: 
                case 247: {
                    return 3;
                }
                case 255: {
                    return 4;
                }
            }
            return 6;
        }
        switch (n & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        return 5;
    }

    private int writeVarInt(long l) throws IOException {
        int n;
        int n2 = 1;
        for (n = 63; n > 0 && (l & 127L << n) == 0L; n -= 7) {
        }
        while (n > 0) {
            this.tddos.writeByte((int)((l & 127L << n) >> n | 0x80L));
            n -= 7;
            ++n2;
        }
        this.tddos.writeByte((int)(l & 0x7FL));
        return n2;
    }

    private InputStream writeTrack(Track track, int n) throws IOException, InvalidMidiDataException {
        int n2 = 0;
        boolean bl = false;
        int n3 = track.size();
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(pipedOutputStream);
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.tddos = new DataOutputStream(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        SequenceInputStream sequenceInputStream = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n4 = -1;
        block8: for (int i = 0; i < n3; ++i) {
            MidiEvent midiEvent = track.get(i);
            byte[] byArray = null;
            ShortMessage shortMessage = null;
            MetaMessage metaMessage = null;
            SysexMessage sysexMessage = null;
            l3 = midiEvent.getTick();
            l2 = midiEvent.getTick() - l;
            l = midiEvent.getTick();
            int n5 = midiEvent.getMessage().getStatus();
            int n6 = this.getType(n5);
            switch (n6) {
                case 1: {
                    shortMessage = (ShortMessage)midiEvent.getMessage();
                    int n7 = shortMessage.getData1();
                    n2 += this.writeVarInt(l2);
                    if (n5 != n4) {
                        n4 = n5;
                        this.tddos.writeByte(n5);
                        ++n2;
                    }
                    this.tddos.writeByte(n7);
                    ++n2;
                    continue block8;
                }
                case 2: {
                    shortMessage = (ShortMessage)midiEvent.getMessage();
                    int n7 = shortMessage.getData1();
                    int n8 = shortMessage.getData2();
                    n2 += this.writeVarInt(l2);
                    if (n5 != n4) {
                        n4 = n5;
                        this.tddos.writeByte(n5);
                        ++n2;
                    }
                    this.tddos.writeByte(n7);
                    ++n2;
                    this.tddos.writeByte(n8);
                    ++n2;
                    continue block8;
                }
                case 3: {
                    sysexMessage = (SysexMessage)midiEvent.getMessage();
                    int n9 = sysexMessage.getLength();
                    byArray = sysexMessage.getMessage();
                    n2 += this.writeVarInt(l2);
                    n4 = n5;
                    this.tddos.writeByte(byArray[0]);
                    ++n2;
                    n2 += this.writeVarInt(byArray.length - 1);
                    this.tddos.write(byArray, 1, byArray.length - 1);
                    n2 += byArray.length - 1;
                    continue block8;
                }
                case 4: {
                    metaMessage = (MetaMessage)midiEvent.getMessage();
                    int n9 = metaMessage.getLength();
                    byArray = metaMessage.getMessage();
                    n2 += this.writeVarInt(l2);
                    n4 = n5;
                    this.tddos.write(byArray, 0, byArray.length);
                    n2 += byArray.length;
                    continue block8;
                }
                case 6: {
                    continue block8;
                }
                case 5: {
                    continue block8;
                }
                default: {
                    throw new InvalidMidiDataException("internal file writer error");
                }
            }
        }
        dataOutputStream.writeInt(1297379947);
        dataOutputStream.writeInt(n2);
        n2 += 8;
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        sequenceInputStream = new SequenceInputStream(pipedInputStream, byteArrayInputStream);
        dataOutputStream.close();
        this.tddos.close();
        return sequenceInputStream;
    }
}

