/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import com.ibm.tools.rmic.iiop.BatchEnvironment;
import com.ibm.tools.rmic.iiop.CompoundType;
import com.ibm.tools.rmic.iiop.Constants;
import com.ibm.tools.rmic.iiop.ContextStack;
import com.ibm.tools.rmic.iiop.EscapedUnicodeFilterWriter;
import com.ibm.tools.rmic.iiop.Type;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;

public class PrintGenerator
implements Generator,
Constants {
    private static final int JAVA = 0;
    private static final int IDL = 1;
    private static final int BOTH = 2;
    private int whatToPrint;
    private boolean global = false;
    private boolean qualified = false;
    private boolean trace = false;
    private boolean valueMethods = false;
    private IndentingWriter out;

    public PrintGenerator() {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        this.out = new IndentingWriter(new EscapedUnicodeFilterWriter(outputStreamWriter));
    }

    @Override
    public boolean parseArgs(String[] stringArray, Main main) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            String string = stringArray[i].toLowerCase();
            if (string.equals("-xprint")) {
                this.whatToPrint = 0;
                stringArray[i] = null;
                if (i + 1 >= stringArray.length) continue;
                if (stringArray[i + 1].equalsIgnoreCase("idl")) {
                    stringArray[++i] = null;
                    this.whatToPrint = 1;
                    continue;
                }
                if (!stringArray[i + 1].equalsIgnoreCase("both")) continue;
                stringArray[++i] = null;
                this.whatToPrint = 2;
                continue;
            }
            if (string.equals("-xglobal")) {
                this.global = true;
                stringArray[i] = null;
                continue;
            }
            if (string.equals("-xqualified")) {
                this.qualified = true;
                stringArray[i] = null;
                continue;
            }
            if (string.equals("-xtrace")) {
                this.trace = true;
                stringArray[i] = null;
                continue;
            }
            if (!string.equals("-xvaluemethods")) continue;
            this.valueMethods = true;
            stringArray[i] = null;
        }
        return true;
    }

    @Override
    public void generate(sun.rmi.rmic.BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file) {
        CompoundType compoundType;
        BatchEnvironment batchEnvironment2 = (BatchEnvironment)batchEnvironment;
        ContextStack contextStack = new ContextStack(batchEnvironment2);
        contextStack.setTrace(this.trace);
        if (this.valueMethods) {
            batchEnvironment2.setParseNonConforming(true);
        }
        if ((compoundType = CompoundType.forCompound(classDefinition, contextStack)) != null) {
            try {
                Type[] typeArray = compoundType.collectMatching(0x2000000);
                block7: for (int i = 0; i < typeArray.length; ++i) {
                    this.out.pln("\n-----------------------------------------------------------\n");
                    Type type = typeArray[i];
                    switch (this.whatToPrint) {
                        case 0: {
                            type.println(this.out, this.qualified, false, false);
                            continue block7;
                        }
                        case 1: {
                            type.println(this.out, this.qualified, true, this.global);
                            continue block7;
                        }
                        case 2: {
                            type.println(this.out, this.qualified, false, false);
                            type.println(this.out, this.qualified, true, this.global);
                            continue block7;
                        }
                        default: {
                            throw new CompilerError("Unknown type!");
                        }
                    }
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new CompilerError("PrintGenerator caught " + iOException);
            }
        }
    }
}

