/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CosNaming;

import com.ibm.CORBA.iiop.INSUtil;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CosNaming.NamingContextDataStore;
import com.ibm.CosNaming.NamingUtils;
import com.ibm.rmi.corba.Corbaname;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

public abstract class NamingContextImpl
extends NamingContextExtPOA {
    protected transient ORB orb;
    public static final boolean debug = true;

    public NamingContextImpl(ORB oRB) throws Exception {
        this.orb = oRB;
    }

    public void bind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        NamingContextImpl.dprint("bind " + NamingContextImpl.nameToString(nameComponentArray) + " to " + object);
        NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        NamingContextImpl.doBind(namingContextDataStore, nameComponentArray, object, false, BindingType.nobject);
    }

    public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        NamingContextImpl.dprint("bind_context " + NamingContextImpl.nameToString(nameComponentArray) + " to " + namingContext);
        NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        NamingContextImpl.doBind(namingContextDataStore, nameComponentArray, (Object)namingContext, false, BindingType.ncontext);
    }

    public void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
        try {
            NamingContextImpl.dprint("rebind " + NamingContextImpl.nameToString(nameComponentArray) + " to " + object);
            NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
            NamingContextImpl.doBind(namingContextDataStore, nameComponentArray, object, true, BindingType.nobject);
        }
        catch (AlreadyBound alreadyBound) {
            throw new INTERNAL("Naming Context - rebind  Already Bound", 1229125023, CompletionStatus.COMPLETED_NO);
        }
    }

    public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
        try {
            NamingContextImpl.dprint("rebind_context " + NamingContextImpl.nameToString(nameComponentArray) + " to " + namingContext);
            NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
            NamingContextImpl.doBind(namingContextDataStore, nameComponentArray, (Object)namingContext, true, BindingType.ncontext);
        }
        catch (AlreadyBound alreadyBound) {
            throw new INTERNAL("Naming Context - rebind context  Already Bound", 1229125024, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object resolve(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl.dprint("resolve " + NamingContextImpl.nameToString(nameComponentArray));
        NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        return NamingContextImpl.doResolve(namingContextDataStore, nameComponentArray);
    }

    public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl.dprint("unbind " + NamingContextImpl.nameToString(nameComponentArray));
        NamingContextDataStore namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        NamingContextImpl.doUnbind(namingContextDataStore, nameComponentArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(int n, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        NamingContextDataStore namingContextDataStore;
        NamingContextImpl.dprint("list(" + n + ")");
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        synchronized (namingContextDataStore2) {
            namingContextDataStore.List(n, bindingListHolder, bindingIteratorHolder);
        }
        if (bindingListHolder.value != null) {
            NamingContextImpl.dprint("list(" + n + ") -> bindings[" + bindingListHolder.value.length + "] + iterator: " + bindingIteratorHolder.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NamingContext new_context() {
        NamingContextDataStore namingContextDataStore;
        NamingContextImpl.dprint("new_context()");
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        synchronized (namingContextDataStore2) {
            return namingContextDataStore.NewContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        NamingContext namingContext = null;
        NamingContext namingContext2 = null;
        try {
            NamingContextImpl.dprint("bind_new_context " + NamingContextImpl.nameToString(nameComponentArray));
            namingContext = this.new_context();
            this.bind_context(nameComponentArray, namingContext);
            namingContext2 = namingContext;
            namingContext = null;
        }
        finally {
            try {
                if (namingContext != null) {
                    namingContext.destroy();
                }
            }
            catch (NotEmpty notEmpty) {}
        }
        return namingContext2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws NotEmpty {
        NamingContextDataStore namingContextDataStore;
        NamingContextImpl.dprint("destroy ");
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore = (NamingContextDataStore)((java.lang.Object)this);
        synchronized (namingContextDataStore2) {
            if (!namingContextDataStore.IsEmpty()) {
                throw new NotEmpty();
            }
            namingContextDataStore.Destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doBind(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray, Object object, boolean bl, BindingType bindingType) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nameComponentArray.length < 1) {
            throw new InvalidName("name is missing");
        }
        if (nameComponentArray.length == 1) {
            if (nameComponentArray[0].id.length() == 0) {
                throw new InvalidName("identifier length is 0");
            }
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
                if (bl) {
                    if (namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder) != null && !bindingType.equals(bindingTypeHolder.value)) {
                        if (bindingType == BindingType.ncontext) {
                            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
                        }
                        throw new NotFound(NotFoundReason.not_object, nameComponentArray);
                    }
                    namingContextDataStore.Unbind(nameComponentArray[0]);
                } else if (namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder) != null) {
                    throw new AlreadyBound();
                }
                namingContextDataStore.Bind(nameComponentArray[0], object, bindingType);
            }
        } else {
            NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray[0]);
            NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
            System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
            switch (bindingType.value()) {
                case 0: {
                    if (bl) {
                        namingContext.rebind(nameComponentArray2, object);
                        break;
                    }
                    namingContext.bind(nameComponentArray2, object);
                    break;
                }
                case 1: {
                    NamingContext namingContext2 = (NamingContext)object;
                    if (bl) {
                        namingContext.rebind_context(nameComponentArray2, namingContext2);
                        break;
                    }
                    namingContext.bind_context(nameComponentArray2, namingContext2);
                    break;
                }
                default: {
                    throw new INTERNAL("Naming Context - doBind bad bind type", 1229125025, CompletionStatus.COMPLETED_NO);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doResolve(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        Object object = null;
        BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
        if (nameComponentArray.length < 1) {
            throw new InvalidName("name is missing");
        }
        if (nameComponentArray.length == 1) {
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                object = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
            }
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            return object;
        }
        if (nameComponentArray[1].id.length() == 0) {
            throw new InvalidName("identifier length is 0");
        }
        NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray[0]);
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
        return namingContext.resolve(nameComponentArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doUnbind(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (nameComponentArray.length < 1) {
            throw new InvalidName("name is missing");
        }
        if (nameComponentArray.length == 1) {
            if (nameComponentArray[0].id.length() == 0) {
                throw new InvalidName("identifier length is 0");
            }
            Object object = null;
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                object = namingContextDataStore.Unbind(nameComponentArray[0]);
            }
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            return;
        }
        NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray[0]);
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
        namingContext.unbind(nameComponentArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NamingContext resolveFirstAsContext(NamingContextDataStore namingContextDataStore, NameComponent nameComponent) throws NotFound {
        NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
        Object object = null;
        BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
        NamingContext namingContext = null;
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
        synchronized (namingContextDataStore2) {
            object = namingContextDataStore.Resolve(nameComponent, bindingTypeHolder);
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
        }
        if (bindingTypeHolder.value != BindingType.ncontext) {
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        try {
            namingContext = NamingContextHelper.narrow((Object)object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        return namingContext;
    }

    public static String nameToString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (nameComponentArray != null && nameComponentArray.length > 0) {
            for (int i = 0; i < nameComponentArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("[").append(nameComponentArray[i].id).append(",").append(nameComponentArray[i].kind).append("]");
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static void dprint(String string) {
        if (Trc.enabled()) {
            NamingUtils.dprint("NamingContextImpl(" + Thread.currentThread().getName() + " at " + System.currentTimeMillis() + " ems): " + string);
        }
    }

    public String to_string(NameComponent[] nameComponentArray) throws InvalidName {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName("name is missing");
        }
        return INSUtil.nameToString(nameComponentArray);
    }

    public NameComponent[] to_name(String string) throws InvalidName {
        return INSUtil.stringToName(string);
    }

    public String to_url(String string, String string2) throws InvalidAddress, InvalidName {
        Corbaname corbaname;
        try {
            corbaname = new Corbaname(INSUtil.encodeCorbaname(string, string2));
        }
        catch (BAD_PARAM bAD_PARAM) {
            NamingUtils.printException((Exception)((java.lang.Object)bAD_PARAM));
            switch (bAD_PARAM.minor) {
                case 1330446343: 
                case 1330446344: 
                case 1330446345: {
                    InvalidAddress invalidAddress = new InvalidAddress(string + ":" + bAD_PARAM.getMessage());
                    invalidAddress.initCause((Throwable)bAD_PARAM);
                    throw invalidAddress;
                }
            }
            InvalidName invalidName = new InvalidName(string2 + ":" + bAD_PARAM.getMessage());
            invalidName.initCause((Throwable)bAD_PARAM);
            throw invalidName;
        }
        return corbaname.toString();
    }

    public Object resolve_str(String string) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(string));
    }
}

