/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.util;

import com.ibm.dtfj.phd.util.PrimitiveArray;

public final class LongArray
extends PrimitiveArray {
    long[][] chunks;

    public LongArray() {
        this.chunks = new long[1][4096];
    }

    public LongArray(int length) {
        this.chunks = new long[(length + 4096 - 1) / 4096][4096];
        this.size = length;
        this.chunkOffset = length % 4096;
    }

    public LongArray(int length, long value) {
        this();
        for (int i = 0; i < length; ++i) {
            this.add(value);
        }
    }

    public Object clone() {
        LongArray clone = new LongArray();
        clone.chunks = new long[this.chunks.length][4096];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, clone.chunks[i], 0, 4096);
        }
        clone.chunkOffset = this.chunkOffset;
        clone.size = this.size;
        return clone;
    }

    public long[] toArray() {
        long[] a = new long[this.size()];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, a, i << 12, i == this.chunks.length - 1 ? this.chunkOffset : 4096);
        }
        return a;
    }

    public void add(long value) {
        if (this.chunkOffset >= 4096) {
            long[][] newchunks = new long[this.chunks.length + 1][];
            for (int i = 0; i < this.chunks.length; ++i) {
                newchunks[i] = this.chunks[i];
            }
            newchunks[this.chunks.length] = new long[4096];
            this.chunks = newchunks;
            this.chunkOffset = 0;
        }
        this.chunks[this.chunks.length - 1][this.chunkOffset++] = value;
        ++this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    long lget(int index) {
        if (index >= this.size) {
            throw new Error("Attempt to get " + index + " greater than size " + this.size);
        }
        return this.chunks[index >> 12][index & 0xFFF];
    }

    public long get(int index) {
        return this.lget(index);
    }

    @Override
    void lput(int index, long value) {
        if (index >= this.size) {
            throw new Error("Attempt to put " + index + " greater than size " + this.size);
        }
        this.chunks[index >> 12][index & 0xFFF] = value;
    }

    public void put(int index, long value) {
        this.lput(index, value);
    }

    public void add(int index, long value) {
        for (int i = 0; i < index + 1 - this.size; ++i) {
            this.add(0L);
        }
        this.put(index, value);
    }

    public void putAll(long value) {
        for (int i = 0; i < this.size; ++i) {
            this.put(i, value);
        }
    }

    public int memoryUsage() {
        return this.chunks.length * 4096 * 8;
    }
}

