/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaRuntime;

public class JavaStaticField
extends JavaField {
    private String _value;

    public JavaStaticField(JavaRuntime runtime, String name, String sig, int modifiers, String value, long declaringClassID) {
        super(runtime, name, sig, modifiers, declaringClassID);
        if (null == runtime) {
            throw new IllegalArgumentException("A Java static field cannot exist in a null Java VM");
        }
        this._value = value;
    }

    @Override
    public Object getReferenceType(JavaObject object) throws CorruptDataException, MemoryAccessException {
        String sig = this.getSignature();
        if (sig.startsWith("L") || sig.startsWith("[")) {
            try {
                ImagePointer pointer = this.getDeclaringClass().getID().getAddressSpace().getPointer(this.parse(16));
                if (0L == pointer.getAddress()) {
                    return null;
                }
                try {
                    return this._javaVM.getObjectAtAddress(pointer);
                }
                catch (IllegalArgumentException e) {
                    throw new CorruptDataException(new CorruptData(e.getMessage(), pointer));
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("field is not of suitable type. Actual signature is " + this.getSignature());
    }

    @Override
    public boolean getBoolean(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("Z")) {
            if (null == this._value) {
                throw new CorruptDataException(new CorruptData("parse error: value is null", null));
            }
            return this._value.charAt(0) != '0';
        }
        throw new IllegalArgumentException("field is not of type boolean. actual signature is " + this.getSignature());
    }

    @Override
    public byte getByte(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("B")) {
            return (byte)this.parse(2);
        }
        throw new IllegalArgumentException("field is not of type byte. actual signature is " + this.getSignature());
    }

    @Override
    public char getChar(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("C")) {
            return (char)this.parse(4);
        }
        throw new IllegalArgumentException("field is not of type char. actual signature is " + this.getSignature());
    }

    @Override
    public double getDouble(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("D")) {
            long temp = this.parse(16);
            return Double.longBitsToDouble(temp);
        }
        return super.getDouble(object);
    }

    @Override
    public float getFloat(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("F")) {
            int temp = (int)this.parse(8);
            return Float.intBitsToFloat(temp);
        }
        return super.getFloat(object);
    }

    @Override
    public int getInt(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("I")) {
            return (int)this.parse(8);
        }
        return super.getInt(object);
    }

    @Override
    public long getLong(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("J")) {
            return this.parse(16);
        }
        return super.getLong(object);
    }

    @Override
    public short getShort(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("S")) {
            return (short)this.parse(4);
        }
        return super.getShort(object);
    }

    private long parse(int maxLength) throws CorruptDataException {
        if (null == this._value) {
            throw new CorruptDataException(new CorruptData("parse error: value is null", null));
        }
        if (this._value.length() > maxLength) {
            throw new CorruptDataException(new CorruptData("parse error: value [" + this._value + "] length " + this._value.length() + " exceeds maximum of " + maxLength, null));
        }
        if (16 == this._value.length()) {
            String highS = this._value.substring(0, 8);
            String lowS = this._value.substring(8, 16);
            long high = Long.parseLong(highS, 16);
            long low = Long.parseLong(lowS, 16);
            return high << 32 | low;
        }
        return Long.parseLong(this._value, 16);
    }
}

