/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$DisplayItem;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.misc.BASE64Encoder;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

class DisplayItemFactory$FingerprintItem
implements DisplayItemFactory$DisplayItem {
    private String fingerprint;

    public DisplayItemFactory$FingerprintItem(CertificationRequestInfo certificationRequestInfo) throws KeyManagerException {
        try {
            this.fingerprint = DisplayItemFactory$FingerprintItem.getMD5(certificationRequestInfo.encode());
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)iOException);
        }
    }

    public DisplayItemFactory$FingerprintItem(Certificate certificate) throws KeyManagerException {
        try {
            this.fingerprint = this.getFingerPrintsForCert(DisplayItemFactory$FingerprintItem.getSHA1(certificate.getEncoded()), DisplayItemFactory$FingerprintItem.getSHA256(certificate.getEncoded()), DisplayItemFactory$FingerprintItem.getSubjectPublicKeyInfoHash(((X509Certificate)certificate).getPublicKey().getEncoded()));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateEncodingException);
        }
    }

    private String getFingerPrintsForCert(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    SHA1: " + string + "\n");
        stringBuffer.append("    SHA256: " + string2 + "\n");
        stringBuffer.append("    HPKP: " + string3 + "\n");
        return stringBuffer.toString();
    }

    private static String getSHA1(byte[] byArray) {
        return DisplayItemFactory$FingerprintItem.getDigest(byArray, "SHA-1");
    }

    private static String getSHA256(byte[] byArray) {
        return DisplayItemFactory$FingerprintItem.getDigest(byArray, "SHA-256");
    }

    private static String getSubjectPublicKeyInfoHash(byte[] byArray) {
        String string = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            string = bASE64Encoder.encodeBuffer(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string = Messages.getString("Message.DigestNotSupported");
        }
        catch (Exception exception) {
            string = Messages.getString("Message.NotComputed");
        }
        return string;
    }

    public static String getMD5(byte[] byArray) {
        return DisplayItemFactory$FingerprintItem.getDigest(byArray, "MD5");
    }

    public static String getDigest(byte[] byArray, String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray2 = messageDigest.digest(byArray);
            string2 = DisplayItemFactory$FingerprintItem.formatBinaryDataWithColon(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string2 = Messages.getString("Message.DigestNotSupported");
        }
        catch (Exception exception) {
            string2 = Messages.getString("Message.NotComputed");
        }
        return string2;
    }

    public static String formatBinaryDataWithColon(byte[] byArray) {
        String string = Messages.getString("Message.NotComputed");
        if (byArray == null || byArray.length > 32) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(48);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(':');
            }
            byte by = byArray[i];
            stringBuffer.append("0123456789ABCDEF".charAt(by >> 4 & 0xF));
            stringBuffer.append("0123456789ABCDEF".charAt(by & 0xF));
        }
        string = stringBuffer.toString();
        return string;
    }

    public String toString() {
        return this.fingerprint;
    }
}

