/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory$AbstractKeyStoreBag;
import com.ibm.gsk.ikeyman.keystore.EntryFilterFactory$EntryFilter;
import com.ibm.gsk.ikeyman.keystore.EntryMakerFactory$EntryMaker;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$KeyStoreProxy;
import com.ibm.gsk.ikeyman.keystore.ProtectionParameterCreatorFactory$ProtectionParameterCreator;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractUnloadableEntry;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.util.List;

class EntryBagFactory$BasicKeyStoreBag
extends EntryBagFactory$AbstractKeyStoreBag {
    private final EntryMakerFactory$EntryMaker entryMaker;

    public EntryBagFactory$BasicKeyStoreBag(KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxyCreatorFactory$KeyStoreProxy, EntryFilterFactory$EntryFilter entryFilterFactory$EntryFilter, ProtectionParameterCreatorFactory$ProtectionParameterCreator protectionParameterCreatorFactory$ProtectionParameterCreator, String string, EntryMakerFactory$EntryMaker entryMaker) throws KeyManagerException {
        super(keyStoreProxyCreatorFactory$KeyStoreProxy, entryFilterFactory$EntryFilter, protectionParameterCreatorFactory$ProtectionParameterCreator, string);
        this.entryMaker = entryMaker;
    }

    protected Entry makeEntry(String string) throws KeyManagerException {
        Entry entry = null;
        KeyStore.Entry entry2 = null;
        try {
            KeyStore.Entry entry3 = this.keyStore.getKeyStore().getEntry(string, this.protectionCreater.getParameter(this.password));
            entry = this.entryMaker.makeEntry(this.getExactAlias(string), entry3);
            return entry;
        }
        catch (KeyStoreException keyStoreException) {
            Debug.log(keyStoreException.getMessage(), new Object[]{string});
            try {
                entry = this.entryMaker.makeEntry(this.getExactAlias(string), entry2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string2 = KeymanUtil.getStackTraceString(keyStoreException);
            if (string2.contains("Illegal key size")) {
                if (entry != null && entry instanceof AbstractUnloadableEntry) {
                    ((AbstractUnloadableEntry)entry).setErr(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, keyStoreException, string);
                }
                throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)keyStoreException);
            }
            if (keyStoreException.getMessage().contains("Couldn't find the record with alias:")) {
                if (entry != null && entry instanceof AbstractUnloadableEntry) {
                    ((AbstractUnloadableEntry)entry).setErr(KeyManagerException$ExceptionReason.INVALID_ALIAS, keyStoreException, string);
                }
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALIAS, (Throwable)keyStoreException);
            }
            if (entry != null && entry instanceof AbstractUnloadableEntry) {
                ((AbstractUnloadableEntry)entry).setErr(KeyManagerException$ExceptionReason.ENTRY_LOAD_ERROR, keyStoreException, string);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.ENTRY_LOAD_ERROR, keyStoreException, new String[]{string});
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            Debug.log(unrecoverableEntryException.getMessage(), new Object[]{string});
            Certificate certificate = null;
            try {
                certificate = this.keyStore.getKeyStore().getCertificate(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                entry = this.entryMaker.makeEntry(this.getExactAlias(string), certificate);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entry != null && entry instanceof AbstractUnloadableEntry) {
                ((AbstractUnloadableEntry)entry).setErr(KeyManagerException$ExceptionReason.UNRECOVERABLE_KEY, unrecoverableEntryException, string);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.UNRECOVERABLE_KEY, unrecoverableEntryException, new String[]{string});
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Debug.log(noSuchAlgorithmException.getMessage(), new Object[]{string});
            try {
                entry = this.entryMaker.makeEntry(this.getExactAlias(string), entry2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entry != null && entry instanceof AbstractUnloadableEntry) {
                ((AbstractUnloadableEntry)entry).setErr(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, noSuchAlgorithmException.getMessage());
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (Exception exception) {
            Debug.log(exception.getMessage(), new Object[]{string});
            try {
                entry = this.entryMaker.makeEntry(this.getExactAlias(string), entry2);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (entry != null && entry instanceof AbstractUnloadableEntry) {
                ((AbstractUnloadableEntry)entry).setErr(KeyManagerException$ExceptionReason.UNRECOVERABLE_KEY, exception, string);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.UNRECOVERABLE_KEY, exception, new String[]{string});
        }
        return entry;
    }

    protected String getExactAlias(String string) {
        if (this.getAliases() != null) {
            for (String string2 : this.getAliases()) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return string2;
            }
        }
        return string;
    }

    public List getSupportedTypes() {
        return this.entryMaker.getSupportedTypes();
    }
}

