/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.NioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.NioTCPChannel;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;

public class NioTCPReadRequestContextImpl
extends TCPReadRequestContextImpl {
    private static final TraceComponent tc = Tr.register(NioTCPReadRequestContextImpl.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public NioTCPReadRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
    }

    public long processSyncReadRequest(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "read(" + l + "," + n + ")");
        }
        if (l != 0L) {
            if (!this.config.isDispatchWorkToThreads()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Can't perform read. Dispatch to Worker threads = false");
                }
                throw new IOException("Can't perform read. Dispatch to Worker threads = false");
            }
            if (this.blockWait == null) {
                this.blockWait = new SimpleSync();
            }
            this.blockingIOError = null;
            VirtualConnection virtualConnection = null;
            this.blockedThread = true;
            virtualConnection = this.readInternal(l, null, false, n);
            while (virtualConnection == null) {
                this.blockWait.simpleWait();
                if (this.blockingIOError != null) break;
                virtualConnection = ((NioTCPChannel)this.oTCPConnLink.getTCPChannel()).getWorkQueueManager().processWork(this, 1);
            }
            this.blockedThread = false;
            if (this.blockingIOError != null) {
                throw this.blockingIOError;
            }
            return this.getIOCompleteAmount();
        }
        this.jITAllocateAction = false;
        long l2 = 0L;
        if (this.jITAllocateSize > 0 && this.getBuffers() == null) {
            if (this.config.getAllocateBuffersDirect() == 1) {
                this.setBuffer(this.oTCPConnLink.getTCPChannel().getWsByteBufferManager().allocateDirect(this.jITAllocateSize));
            } else {
                this.setBuffer(this.oTCPConnLink.getTCPChannel().getWsByteBufferManager().allocate(this.jITAllocateSize));
            }
            this.jITAllocateAction = true;
        }
        WsByteBuffer[] wsByteBufferArray = this.getBuffers();
        SocketIOChannel socketIOChannel = this.oTCPConnLink.getSocketIOChannel();
        l2 = wsByteBufferArray.length == 1 ? (long)((NioSocketIOChannel)socketIOChannel).read(wsByteBufferArray[0].getWrappedByteBufferNonSafe()) : ((NioSocketIOChannel)socketIOChannel).read(this.getByteBufferArray());
        if (l2 < 0L) {
            if (this.jITAllocateAction) {
                this.getBuffer().release();
                this.setBuffer(null);
                this.jITAllocateAction = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Throwing IOException");
            }
            if (readException == null) {
                readException = new IOException("Read failed.  End of data reached.");
            }
            throw readException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "read ");
        }
        return l2;
    }

    public VirtualConnection processAsyncReadRequest() {
        return ((NioTCPChannel)this.oTCPConnLink.getTCPChannel()).getWorkQueueManager().processWork(this, 0);
    }

    protected void immediateTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "immediateTimeout");
        }
        this.timeoutTime = System.currentTimeMillis() - 2000L;
        ((NioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).getChannelSelectorRead().resetTimeout(this.timeoutTime);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "immediateTimeout");
        }
    }
}

