/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.postprocessor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VMLevelChecker {
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("J... 1\\.([0-9])\\.[0-9] IBM");
    private static final Pattern VM_DATE_PATTERN = Pattern.compile("(.*)(\\d{8})(.*)");
    private static final Pattern VM_VERSION_PATTERN = Pattern.compile("(?<=IBM J9 (?:real-time ){0,1})([\\d.]+)");
    private static final String BLANK = "";
    public static final int JAVA5_SR10VM = 20090430;
    public static final int JAVA6_SR5VM = 20090330;
    public static final int PROFILING_VM = 20080301;
    public static final int REALTIME_DATE = 20100331;
    public static final int SOFT_REALTIME_DATE = 20090901;
    private static final String REALTIME_IDENTIFIER = "real-time";
    private static final String SOFT_REALTIME_IDENTIFIER = "srt";
    protected static final int JAVA6SR1_DATE = 20080416;
    protected static final int JAVA6SR13_DATE = 20121025;
    protected static final int JAVA626SR3_DATE = 20120801;
    protected static final int JAVA7SR3_DATE = 20121007;
    private final int vmDate;
    private String fullVersion;
    private boolean realtimeVM = false;
    private boolean softRealtimeVM = false;
    private boolean realtimeUpdated = false;
    private boolean softRealtimeUpdated = false;

    public VMLevelChecker(String string) {
        this.fullVersion = string;
        String string2 = this.getVMLevel(string);
        this.vmDate = this.convertStringDateToInt(string2);
    }

    public boolean isVMOlderThan(int n) {
        return this.vmDate < n || n == 0 || this.vmDate == 0;
    }

    public boolean isVMRealtime() {
        if (this.realtimeUpdated) {
            return this.realtimeVM;
        }
        return this.fullVersion.contains(REALTIME_IDENTIFIER);
    }

    public boolean isVMSoftRealtime() {
        if (this.softRealtimeUpdated) {
            return this.softRealtimeVM;
        }
        return this.isVMRealtime() && this.fullVersion.contains(SOFT_REALTIME_IDENTIFIER);
    }

    public boolean isJava6AfterSr1() {
        return this.fullVersion.contains("1.7.0") && this.isVMThisLevelOrNewer(20080416);
    }

    public boolean isJava7Onwards() {
        return !this.fullVersion.contains("1.6.0") && !this.fullVersion.contains("1.5.0");
    }

    public boolean isSystemCPUAvailable() {
        if (this.fullVersion.contains("1.8.0")) {
            return true;
        }
        if (this.fullVersion.contains("1.7.0") && this.isVMThisLevelOrNewer(20121007)) {
            return true;
        }
        if (this.fullVersion.contains("1.6.0") && this.isVMThisLevelOrNewer(20121025)) {
            return true;
        }
        return this.fullVersion.contains("Java626") && this.isVMThisLevelOrNewer(20120801);
    }

    public boolean isJava5() {
        return this.fullVersion.contains("1.5.0");
    }

    private String getVMLevel(String string) {
        String string2 = BLANK;
        Matcher matcher = VM_DATE_PATTERN.matcher(string);
        if (matcher.find() && matcher.groupCount() >= 3) {
            string2 = matcher.group(2);
        }
        return string2;
    }

    private int convertStringDateToInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public boolean isVMThisLevelOrNewer(int n) {
        return !this.isVMOlderThan(n);
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public int getJavaVersion() {
        int n = 0;
        Matcher matcher = JAVA_VERSION_PATTERN.matcher(this.fullVersion);
        if (matcher.find()) {
            n = Integer.parseInt(matcher.group(1));
        }
        return n;
    }

    public String getVMVersion() {
        String string = BLANK;
        Matcher matcher = VM_VERSION_PATTERN.matcher(this.fullVersion);
        if (matcher.find()) {
            string = matcher.group(1);
        }
        return string;
    }
}

