/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodprofiling.dictionary;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DictionaryDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.JavaMethod;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.MethodDictionaryDataImpl;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.dictionary.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.java.diagnostics.healthcenter.sources.RequestableSource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MethodDictionaryParser
implements LineParser {
    private static final String HASH = "#";
    private static final String SOURCE_TAG = "MethodDictionarySource";
    private static final String L_BRACKET = "(";
    private static final String DOT = ".";
    private static final String F_SLASH = "/";
    private static final String EQUALS = "=";
    private static final Logger TRACE = LogFactory.getTrace(MethodDictionaryParser.class);
    private boolean gotGoodData = false;
    private static final String CLASSNAME = MethodDictionaryParser.class.getName();

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        void var9_12;
        TRACE.entering(CLASSNAME, "parse");
        DataBuilder dataBuilder2 = dataBuilder.getData(ProfilingLabels.METHOD_DICTIONARY);
        MethodDictionaryDataImpl methodDictionaryDataImpl = (MethodDictionaryDataImpl)dataBuilder2;
        int n = 0;
        int n2 = 0;
        for (String string : stringArray) {
            Object object;
            if (!this.gotGoodData && string.startsWith(HASH) && string.toLowerCase().contains(SOURCE_TAG.toLowerCase())) {
                this.gotGoodData = true;
                if (methodDictionaryDataImpl == null) {
                    methodDictionaryDataImpl = new MethodDictionaryDataImpl(ProfilingLabels.METHOD_DICTIONARY);
                    dataBuilder.addData(methodDictionaryDataImpl);
                }
                if (dynamicSource instanceof RequestableSource) {
                    object = (RequestableSource)dynamicSource;
                    methodDictionaryDataImpl.setRequestableSource((RequestableSource)object);
                }
            } else if (this.gotGoodData && methodDictionaryDataImpl != null) {
                if (!string.startsWith(HASH)) {
                    boolean bl = this.parseLine(string, methodDictionaryDataImpl);
                    if (!bl) {
                        String string2 = Messages.getString("MethodDictionaryParser.unable.to.parse");
                        TRACE.warning(MessageFormat.format(string2, string));
                    }
                } else if (string.contains(SOURCE_TAG)) {
                    object = MessageFormat.format("Received MethodDictionarySource eyecatcher again.  Parsing line: '{0}'", string);
                    TRACE.fine((String)object);
                }
            }
            if (this.gotGoodData && (!this.gotGoodData || methodDictionaryDataImpl == null)) continue;
            n += string.getBytes().length;
            ++n2;
        }
        if (this.gotGoodData) {
            ProgressIndicatorImpl progressIndicatorImpl = new ProgressIndicatorImpl(n2, n, 1000);
        } else {
            ProgressIndicator progressIndicator = ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
        }
        TRACE.exiting(CLASSNAME, "parse");
        return var9_12;
    }

    private boolean parseLine(String string, DictionaryDataBuilder<Long, JavaMethod> dictionaryDataBuilder) {
        boolean bl = true;
        try {
            String string2 = string.trim();
            if (string2.length() == 0) {
                return bl;
            }
            if (string2.contains(EQUALS)) {
                String[] stringArray = string2.split(EQUALS, 2);
                long l = Long.parseLong(stringArray[0], 16);
                JavaMethod javaMethod = (JavaMethod)dictionaryDataBuilder.get(l);
                if (javaMethod == null || javaMethod.isNameKnown()) {
                    javaMethod = new JavaMethod(l);
                }
                if (stringArray.length > 1) {
                    this.updateMethodObject(stringArray[1], l, javaMethod);
                    dictionaryDataBuilder.put(l, javaMethod);
                }
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void updateMethodObject(String string, long l, JavaMethod javaMethod) {
        String string2 = "@omr@";
        String string3 = "@@";
        if (string.startsWith(string2)) {
            int n;
            String string4 = string.substring(string2.length());
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((n = string4.indexOf(string3)) != -1) {
                arrayList.add(string4.substring(0, n));
                string4 = string4.substring(n + string3.length());
            }
            if (arrayList.size() == 4) {
                String string5 = "";
                if (((String)arrayList.get(2)).length() > 0) {
                    string5 = string5 + "@" + (String)arrayList.get(2);
                    if (((String)arrayList.get(3)).length() > 0) {
                        string5 = string5 + ":" + (String)arrayList.get(3);
                    }
                }
                javaMethod.setName((String)arrayList.get(1) + "::" + (String)arrayList.get(0), string5, " ");
            } else if (arrayList.size() == 3) {
                javaMethod.setName((String)arrayList.get(1), (String)arrayList.get(0) + "@" + (String)arrayList.get(2) + " ", "()");
            }
        } else {
            int n = string.indexOf(L_BRACKET);
            int n2 = string.lastIndexOf(DOT, n);
            string = string.replace(F_SLASH, DOT);
            String string6 = string.substring(0, n2);
            String string7 = string.substring(n2 + 1, n);
            String string8 = string.substring(n);
            javaMethod.setName(string6, string7, string8);
        }
    }
}

