/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc;

public class Threshold {
    private static final long MAX_32_BIT_THRESHOLD = 0xFFFFFFFFL;
    private static final long MAX_64_BIT_THRESHOLD = Long.MAX_VALUE;
    private static final String EMPTY_STRING = "";
    public static final long LOW_THRESHOLD_WARN_LIMIT = 8192L;
    private String value;
    private long bytes = -1L;
    private boolean isValid = false;
    private static final String VALID_THRESHOLD_PATTERN = "[1-9][0-9]*[km]?";
    private static final String KILOBYTES = "k";
    private static final String MEGABYTES = "m";

    public Threshold(long l, boolean bl) {
        new Threshold(new String(Long.toString(l)), bl);
    }

    public Threshold(String string, boolean bl) {
        this.value = EMPTY_STRING;
        if (string != null) {
            this.value = string.trim().toLowerCase();
        }
        this.isValid = this.value.matches(VALID_THRESHOLD_PATTERN);
        if (this.isValid) {
            long l = 1L;
            if (this.value.endsWith(KILOBYTES)) {
                l = 1024L;
            } else if (this.value.endsWith(MEGABYTES)) {
                l = 0x100000L;
            }
            try {
                this.bytes = l != 1L ? Long.parseLong(this.value.substring(0, this.value.length() - 1)) : Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                this.isValid = false;
            }
            this.bytes *= l;
            if (this.bytes < 0L || !bl && this.bytes > 0xFFFFFFFFL || bl && this.bytes > Long.MAX_VALUE) {
                this.isValid = false;
            }
        } else if (this.value.equals(EMPTY_STRING)) {
            this.bytes = bl ? Long.MAX_VALUE : 0xFFFFFFFFL;
            this.isValid = true;
        }
    }

    public String asMinimalString() {
        long l;
        if (this.isValid && this.bytes > 0L && this.bytes % (l = 1024L) == 0L) {
            long l2 = this.bytes / l;
            if (l2 % l == 0L) {
                long l3 = this.bytes / l;
                return Long.toString(l3) + MEGABYTES;
            }
            return Long.toString(l2) + KILOBYTES;
        }
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public long getBytes() {
        return this.bytes;
    }
}

