/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class FindModulesCommand
extends Command {
    public FindModulesCommand() {
        this.addCommand("findmodules", "[all|name <moduleName>|requires <moduleName>|package <packageName>|help]", "Find a module or set of modules that are loaded by the runtime.");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        Subcommand subcommand;
        String filterArg = null;
        ModularityHelper.ModuleIteratorFilter moduleFilter = null;
        ModularityHelper.ModuleOutput moduleOutput = ModularityHelper::printJ9Module;
        ModularityHelper.PackageIteratorFilter packageFilter = null;
        block1 : switch (args.length) {
            case 0: {
                moduleFilter = ModularityHelper::moduleFilterMatchAll;
                subcommand = Subcommand.MODULE;
                break;
            }
            case 1: {
                switch (args[0]) {
                    case "all": {
                        moduleFilter = ModularityHelper::moduleFilterMatchAll;
                        subcommand = Subcommand.MODULE;
                        break block1;
                    }
                    case "help": {
                        subcommand = Subcommand.HELP;
                        break block1;
                    }
                }
                subcommand = Subcommand.INVALID;
                break;
            }
            case 2: {
                filterArg = args[1];
                switch (args[0]) {
                    case "name": {
                        moduleFilter = FindModulesCommand::filterModuleName;
                        subcommand = Subcommand.MODULE;
                        break block1;
                    }
                    case "requires": {
                        moduleFilter = FindModulesCommand::filterModuleName;
                        moduleOutput = FindModulesCommand::printModuleReads;
                        subcommand = Subcommand.MODULE;
                        break block1;
                    }
                    case "package": {
                        packageFilter = FindModulesCommand::filterPackageName;
                        subcommand = Subcommand.PACKAGE;
                        break block1;
                    }
                }
                subcommand = Subcommand.INVALID;
                break;
            }
            default: {
                subcommand = Subcommand.INVALID;
            }
        }
        try {
            switch (subcommand) {
                case MODULE: {
                    int result = ModularityHelper.iterateModules(out, moduleFilter, moduleOutput, filterArg);
                    out.printf("Found %d module%s%n", result, 1 == result ? "" : "s");
                    break;
                }
                case PACKAGE: {
                    ModularityHelper.PackageOutput packageOutput = ModularityHelper::printPackageJ9Module;
                    int result = ModularityHelper.iteratePackages(out, packageFilter, packageOutput, filterArg);
                    out.printf("Found %d module%s%n", result, 1 == result ? "" : "s");
                    break;
                }
                case HELP: {
                    FindModulesCommand.printHelp(out);
                    break;
                }
                default: {
                    out.println("Argument failed to parse or was parsed to an unhandled subcommand.");
                    FindModulesCommand.printHelp(out);
                    break;
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private static void printModuleReads(J9ModulePointer modulePtr, PrintStream out) throws CorruptDataException {
        J9HashTablePointer readTable = modulePtr.readAccessHashTable();
        HashTable<J9ModulePointer> moduleHashTable = ModuleHashTable.fromJ9HashTable(readTable);
        Iterator slotIterator = moduleHashTable.iterator();
        while (slotIterator.hasNext()) {
            J9ModulePointer readModulePtr = (J9ModulePointer)slotIterator.next();
            ModularityHelper.printJ9Module(readModulePtr, out);
        }
    }

    private static boolean filterModuleName(J9ModulePointer modulePtr, String targetName) throws CorruptDataException {
        return ModularityHelper.getModuleName(modulePtr).equals(targetName);
    }

    private static boolean filterRequiresTargetModule(J9ModulePointer modulePtr, String targetModule) throws CorruptDataException {
        boolean result = false;
        J9HashTablePointer readTable = modulePtr.readAccessHashTable();
        HashTable<J9ModulePointer> moduleHashTable = ModuleHashTable.fromJ9HashTable(readTable);
        Iterator slotIterator = moduleHashTable.iterator();
        while (slotIterator.hasNext()) {
            J9ModulePointer readModulePtr = (J9ModulePointer)slotIterator.next();
            if (!ModularityHelper.getModuleName(readModulePtr).equals(targetModule)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean filterPackageName(J9PackagePointer packagePtr, String targetName) throws CorruptDataException {
        return J9UTF8Helper.stringValue(packagePtr.packageName()).equals(targetName);
    }

    private static void printHelp(PrintStream out) {
        out.println("Usage:");
        out.println("  !findmodules");
        out.println("      Returns !findmodules all");
        out.println("  !findmodules all");
        out.println("      Returns all loaded modules");
        out.println("  !findmodules name <moduleName>");
        out.println("      Returns all loaded modules with the same name as provided");
        out.println("  !findmodules requires <moduleName>");
        out.println("      Returns all loaded modules which require the provided module");
        out.println("  !findmodules package <packageName>");
        out.println("      Returns the loaded module which owns the provided package");
        out.println("Output Format:");
        out.println("  <module name>                  !j9module <module hexaddress>");
        out.println("Output Example:");
        out.println("  java.base                      !j9module 0x00007FAC2008EAC8");
    }

    private static enum Subcommand {
        MODULE,
        PACKAGE,
        HELP,
        INVALID;

    }
}

