/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.j9.BCNames;
import com.ibm.j9ddr.vm28.j9.ROMHelp;
import com.ibm.j9ddr.vm28.j9.stackmap.DebugLocalMap;
import com.ibm.j9ddr.vm28.j9.stackmap.LocalMap;
import com.ibm.j9ddr.vm28.j9.stackmap.StackMap;
import com.ibm.j9ddr.vm28.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm28.pointer.U16Pointer;
import com.ibm.j9ddr.vm28.pointer.U8Pointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassRefPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMSingleSlotConstantRefPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMStringRefPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm28.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm28.structure.J9ROMMethod;
import com.ibm.j9ddr.vm28.types.I16;
import com.ibm.j9ddr.vm28.types.I32;
import com.ibm.j9ddr.vm28.types.I8;
import com.ibm.j9ddr.vm28.types.IDATA;
import com.ibm.j9ddr.vm28.types.U16;
import com.ibm.j9ddr.vm28.types.U32;
import com.ibm.j9ddr.vm28.types.U8;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.io.PrintStream;

public class ByteCodeDumper {
    private static final String nl = System.getProperty("line.separator");
    public static int BCT_ERR_NO_ERROR = 0;
    private static final int OPCODE_RELATIVE_BRANCHES = 1;
    private static final int LOCAL_MAP = 0;
    private static final int DEBUG_MAP = 1;
    private static final int STACK_MAP = 2;
    private static final int MAP_COUNT = 3;
    private static boolean bigEndian;
    private static U8Pointer bcIndex;

    public static IDATA dumpBytecodes(PrintStream out, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod, U32 flags) throws Exception {
        out.append(String.format("  Argument Count: %d", romMethod.argCount().intValue()));
        out.append(nl);
        U16 temp = romMethod.tempCount();
        out.append(String.format("  Temp Count: %d", temp.intValue()));
        out.append(nl);
        out.append(nl);
        UDATA length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
        if (length.eq(0L)) {
            return new IDATA(BCT_ERR_NO_ERROR);
        }
        return ByteCodeDumper.j9bcutil_dumpBytecodes(out, romClass, ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod), new UDATA(0L), length.sub(1L), flags, "");
    }

    private static IDATA j9bcutil_dumpBytecodes(PrintStream out, J9ROMClassPointer romClass, U8Pointer bytecodes, UDATA walkStartPC, UDATA walkEndPC, U32 flags, String indent) throws Exception {
        J9ROMConstantPoolItemPointer constantPool = J9ROMClassHelper.constantPool(romClass);
        bigEndian = flags.anyBitsIn(J9BCTranslationData.BCT_BigEndianOutput);
        UDATA index = new UDATA(0L);
        UDATA target = new UDATA(0L);
        J9ROMMethodPointer romMethod = J9ROMMethodPointer.cast(bytecodes.sub(J9ROMMethod.SIZEOF));
        U32 localsCount = new U32(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod).add(ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(romMethod)));
        int[] resultArray = new int[8192];
        String environment = "0";
        boolean envVarDefined = false;
        if (System.getenv().containsKey("j9bcutil_dumpBytecodes")) {
            envVarDefined = true;
            environment = System.getenv().get("j9bcutil_dumpBytecodes");
        }
        UDATA pc = new UDATA(walkStartPC);
        bcIndex = bytecodes.add(pc);
        block47: while (pc.lte(walkEndPC)) {
            if (flags.anyBitsIn(J9BCTranslationData.BCT_DumpMaps)) {
                for (int j = 0; j < 3; ++j) {
                    if (envVarDefined && !pc.eq(Integer.parseInt(environment))) continue;
                    boolean wrapLine = false;
                    UDATA outputCount = new UDATA(0L);
                    U8 mapChar = new U8(48L);
                    switch (j) {
                        case 0: {
                            int result = LocalMap.j9localmap_LocalBitsForPC(romMethod, pc, resultArray);
                            mapChar = new U8(108L);
                            outputCount = new UDATA(localsCount);
                            break;
                        }
                        case 1: {
                            int result = DebugLocalMap.j9localmap_DebugLocalBitsForPC(romMethod, pc, resultArray);
                            mapChar = new U8(100L);
                            outputCount = new UDATA(localsCount);
                            break;
                        }
                        case 2: {
                            int result = StackMap.j9stackmap_StackBitsForPC(pc, romClass, romMethod, null, 0);
                            mapChar = new U8(115L);
                            outputCount = new UDATA(result);
                        }
                    }
                    if (outputCount.eq(0L)) {
                        out.append(String.format("               %cmap [empty]", Character.valueOf((char)mapChar.intValue())));
                    } else {
                        out.append(String.format("               %cmap [%5d] =", Character.valueOf((char)mapChar.intValue()), outputCount.intValue()));
                    }
                    int i = 0;
                    while (outputCount.gt(i)) {
                        int x = i / 32;
                        if (i % 8 == 0) {
                            out.append(" ");
                            if (wrapLine) {
                                out.append(nl);
                            }
                        }
                        out.append(String.format("%d ", resultArray[x] & 1));
                        int n = x;
                        resultArray[n] = resultArray[n] >> 1;
                        wrapLine = (i + 1) % 32 == 0;
                        ++i;
                    }
                    out.append(nl);
                }
            }
            UDATA bc = new UDATA(ByteCodeDumper._GETNEXT_U8());
            out.append(String.format("%s%5d %s ", indent, pc.intValue(), BCNames.getName(bc.intValue())));
            UDATA start = new UDATA(pc);
            pc = pc.add(1L);
            switch (bc.intValue()) {
                case 16: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                    out.append(String.format("%d\n", new I8(index).intValue()));
                    pc = pc.add(1L);
                    continue block47;
                }
                case 17: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    out.append(String.format("%d\n", new I16(index).intValue()));
                    pc = pc.add(2L);
                    continue block47;
                }
                case 18: 
                case 19: {
                    if (bc.eq(18L)) {
                        index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                        pc = pc.add(1L);
                    } else {
                        index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                        pc = pc.add(2L);
                    }
                    out.append(String.format("%d ", index.intValue()));
                    J9ROMConstantPoolItemPointer info = constantPool.add(index);
                    J9ROMSingleSlotConstantRefPointer romSingleSlotConstantRef = J9ROMSingleSlotConstantRefPointer.cast(info);
                    if (!romSingleSlotConstantRef.cpType().eq(J9BCTranslationData.BCT_J9DescriptionCpTypeScalar)) {
                        if (romSingleSlotConstantRef.cpType().eq(J9BCTranslationData.BCT_J9DescriptionCpTypeClass)) {
                            out.append("(java.lang.Class) ");
                        } else {
                            out.append("(java.lang.String) ");
                        }
                        out.append(J9UTF8Helper.stringValue(J9ROMStringRefPointer.cast(info).utf8Data()));
                        out.append(nl);
                        continue block47;
                    }
                    out.append(String.format("(int/float) 0x%08X", romSingleSlotConstantRef.data().longValue()));
                    out.append(nl);
                    continue block47;
                }
                case 20: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    out.append(String.format("%d ", index.intValue()));
                    J9ROMConstantPoolItemPointer info = constantPool.add(index);
                    out.append(String.format("(long) 0x%08X%08X\n", bigEndian ? info.slot1().longValue() : info.slot2().longValue(), bigEndian ? info.slot2().longValue() : info.slot1().longValue()));
                    pc = pc.add(2L);
                    continue block47;
                }
                case 249: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    out.append(String.format("%d ", index.intValue()));
                    J9ROMConstantPoolItemPointer info = constantPool.add(index);
                    out.append(String.format("(double) 0x%08X%08X\n", bigEndian ? info.slot1().longValue() : info.slot2().longValue(), bigEndian ? info.slot2().longValue() : info.slot1().longValue()));
                    pc = pc.add(2L);
                    continue block47;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                    pc = pc.add(1L);
                    out.append(String.format("%d\n", index.intValue()));
                    continue block47;
                }
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    ByteCodeDumper.incIndex();
                    pc = pc.add(3L);
                    out.append(String.format("%d\n", index.intValue()));
                    continue block47;
                }
                case 132: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                    out.append(String.format("%d ", index.intValue()));
                    target = new UDATA(ByteCodeDumper._GETNEXT_U8());
                    out.append(String.format("%d\n", new I8(target).intValue()));
                    pc = pc.add(2L);
                    continue block47;
                }
                case 213: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    out.append(String.format("%d ", index.intValue()));
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    out.append(String.format("%d\n", new I16(index).intValue()));
                    ByteCodeDumper.incIndex();
                    pc = pc.add(5L);
                    continue block47;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 198: 
                case 199: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    pc = pc.add(2L);
                    target = start.add(new I16(index));
                    out.append(String.format("%d\n", target.intValue()));
                    continue block47;
                }
                case 170: {
                    switch (start.intValue() % 4) {
                        case 0: {
                            ByteCodeDumper.incIndex();
                            pc = pc.add(1L);
                        }
                        case 1: {
                            ByteCodeDumper.incIndex();
                            pc = pc.add(1L);
                        }
                        case 2: {
                            ByteCodeDumper.incIndex();
                            pc = pc.add(1L);
                        }
                    }
                    index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                    target = start.add(index);
                    index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                    I32 low = new I32(index);
                    index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                    I32 high = new I32(index);
                    pc = pc.add(12L);
                    out.append(String.format("low %d high %d\n", low.intValue(), high.intValue()));
                    out.append(String.format("        default %10d\n", target.intValue()));
                    U32 npairs = new U32(high.sub(low).add(1L));
                    int i = 0;
                    while (npairs.gt(i)) {
                        index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                        target = start.add(index);
                        out.append(String.format("     %10d %10d\n", low.add(i).intValue(), target.intValue()));
                        pc = pc.add(4L);
                        ++i;
                    }
                    continue block47;
                }
                case 171: {
                    switch (start.intValue() % 4) {
                        case 0: {
                            ByteCodeDumper.incIndex();
                            pc = pc.add(1L);
                            break;
                        }
                        case 1: {
                            ByteCodeDumper.incIndex();
                            pc = pc.add(1L);
                            break;
                        }
                        case 2: {
                            ByteCodeDumper.incIndex();
                            pc = pc.add(1L);
                            break;
                        }
                    }
                    index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                    target = start.add(index);
                    U32 npairs = new U32(ByteCodeDumper._GETNEXT_U32());
                    out.append(String.format("pairs %d\n", npairs.intValue()));
                    out.append(String.format("        default %10d\n", target.intValue()));
                    pc = pc.add(8L);
                    int i = 0;
                    while (npairs.gt(i)) {
                        index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                        out.append(String.format("     %10d", index.intValue()));
                        index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                        target = start.add(index);
                        out.append(String.format(" %10d\n", target.intValue()));
                        pc = pc.add(8L);
                        ++i;
                    }
                    continue block47;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    J9ROMConstantPoolItemPointer info = constantPool.add(index);
                    out.append(String.format("%d ", index.intValue()));
                    J9ROMFieldRefPointer romFieldRef = J9ROMFieldRefPointer.cast(info);
                    out.append(J9UTF8Helper.stringValue(J9ROMClassRefPointer.cast(constantPool.add(romFieldRef.classRefCPIndex())).name()));
                    J9ROMNameAndSignaturePointer nameAndSig = romFieldRef.nameAndSignature();
                    out.append(".");
                    out.append(J9UTF8Helper.stringValue(nameAndSig.name()));
                    out.append(" ");
                    out.append(J9UTF8Helper.stringValue(nameAndSig.signature()));
                    out.append(nl);
                    pc = pc.add(2L);
                    continue block47;
                }
                case 186: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    out.append(String.format("%d ", index.intValue()));
                    long callSiteCount = romClass.callSiteCount().longValue();
                    SelfRelativePointer callSiteData = SelfRelativePointer.cast(romClass.callSiteData());
                    U16Pointer bsmIndices = U16Pointer.cast(callSiteData.addOffset(4L * callSiteCount));
                    J9ROMNameAndSignaturePointer nameAndSig = J9ROMNameAndSignaturePointer.cast(callSiteData.add(index).get());
                    out.append("bsm #" + String.valueOf(bsmIndices.at(index).longValue()));
                    out.append(":");
                    out.append(J9UTF8Helper.stringValue(nameAndSig.name()));
                    out.append(J9UTF8Helper.stringValue(nameAndSig.signature()));
                    out.append(nl);
                    pc = pc.add(2L);
                    continue block47;
                }
                case 231: {
                    ByteCodeDumper.incIndex();
                    pc = pc.add(1L);
                    out.append(nl);
                    continue block47;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 232: 
                case 233: 
                case 234: 
                case 235: {
                    if (bcIndex.longValue() == 0L) {
                        bcIndex = bcIndex.sub(1L);
                    }
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    if (bc.intValue() == 234) {
                        index = new UDATA(romClass.staticSplitMethodRefIndexes().at(index));
                    } else if (bc.intValue() == 235) {
                        index = new UDATA(romClass.specialSplitMethodRefIndexes().at(index));
                    }
                    J9ROMConstantPoolItemPointer info = constantPool.add(index);
                    out.append(String.format("%d ", index.intValue()));
                    J9ROMMethodRefPointer romMethodRef = J9ROMMethodRefPointer.cast(info);
                    U32 classRefCPIndex = romMethodRef.classRefCPIndex();
                    J9ROMConstantPoolItemPointer cpItem = constantPool.add(classRefCPIndex);
                    J9ROMClassRefPointer romClassRef = J9ROMClassRefPointer.cast(cpItem);
                    String name = J9UTF8Helper.stringValue(romClassRef.name());
                    out.append(name);
                    J9ROMNameAndSignaturePointer nameAndSig = romMethodRef.nameAndSignature();
                    out.append(".");
                    out.append(J9UTF8Helper.stringValue(nameAndSig.name()));
                    out.append(J9UTF8Helper.stringValue(nameAndSig.signature()));
                    out.append(nl);
                    pc = pc.add(2L);
                    continue block47;
                }
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 216: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    J9ROMConstantPoolItemPointer info = constantPool.add(index);
                    out.append(String.format("%d ", index.intValue()));
                    out.append(J9UTF8Helper.stringValue(J9ROMStringRefPointer.cast(info).utf8Data()));
                    out.append(nl);
                    pc = pc.add(2L);
                    continue block47;
                }
                case 188: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                    switch (index.intValue()) {
                        case 4: {
                            out.append("boolean\n");
                            break;
                        }
                        case 5: {
                            out.append("char\n");
                            break;
                        }
                        case 6: {
                            out.append("float\n");
                            break;
                        }
                        case 7: {
                            out.append("double\n");
                            break;
                        }
                        case 8: {
                            out.append("byte\n");
                            break;
                        }
                        case 9: {
                            out.append("short\n");
                            break;
                        }
                        case 10: {
                            out.append("int\n");
                            break;
                        }
                        case 11: {
                            out.append("long\n");
                            break;
                        }
                        default: {
                            out.append(String.format("(unknown type %d)\n", index.intValue()));
                        }
                    }
                    pc = pc.add(1L);
                    continue block47;
                }
                case 197: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    J9ROMConstantPoolItemPointer info = constantPool.add(index);
                    out.append(String.format("%d ", index.intValue()));
                    index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                    out.append(String.format("dims %d ", index.intValue()));
                    out.append(J9UTF8Helper.stringValue(J9ROMStringRefPointer.cast(info).utf8Data()));
                    out.append(nl);
                    pc = pc.add(3L);
                    continue block47;
                }
                case 200: {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                    pc = pc.add(4L);
                    target = start.add(index);
                    out.append(String.format("%d\n", target.intValue()));
                    continue block47;
                }
            }
            out.append(nl);
        }
        return new IDATA(BCT_ERR_NO_ERROR);
    }

    private static void incIndex() {
        bcIndex = bcIndex.add(1L);
    }

    private static U32 _GETNEXT_U32() throws CorruptDataException {
        if (bigEndian) {
            return ByteCodeDumper._NEXT_BE_U32();
        }
        return ByteCodeDumper._NEXT_LE_U32();
    }

    private static U32 _NEXT_BE_U32() throws CorruptDataException {
        U32 a = new U32(bcIndex.at(0L)).leftShift(24);
        U32 b = new U32(bcIndex.at(1L)).leftShift(16);
        U32 c = new U32(bcIndex.at(2L)).leftShift(8);
        U32 d = new U32(bcIndex.at(3L));
        U32 value = a.bitOr(b).bitOr(c).bitOr(d);
        bcIndex = bcIndex.add(4L);
        return value;
    }

    private static U32 _NEXT_LE_U32() throws CorruptDataException {
        U32 a = new U32(bcIndex.at(0L));
        U32 b = new U32(bcIndex.at(1L)).leftShift(8);
        U32 c = new U32(bcIndex.at(2L)).leftShift(16);
        U32 d = new U32(bcIndex.at(3L)).leftShift(24);
        U32 value = a.bitOr(b).bitOr(c).bitOr(d);
        bcIndex = bcIndex.add(4L);
        return value;
    }

    private static U16 _GETNEXT_U16() throws CorruptDataException {
        if (bigEndian) {
            return ByteCodeDumper._NEXT_BE_U16();
        }
        return ByteCodeDumper._NEXT_LE_U16();
    }

    private static U16 _NEXT_LE_U16() throws CorruptDataException {
        U16 a = new U16(bcIndex.at(0L));
        U16 b = new U16(bcIndex.at(1L)).leftShift(8);
        U16 value = a.bitOr(b);
        bcIndex = bcIndex.add(2L);
        return value;
    }

    private static U16 _NEXT_BE_U16() throws CorruptDataException {
        U16 a = new U16(bcIndex.at(0L)).leftShift(8);
        U16 b = new U16(bcIndex.at(1L));
        U16 value = a.bitOr(b);
        bcIndex = bcIndex.add(2L);
        return value;
    }

    private static U8 _GETNEXT_U8() throws CorruptDataException {
        U8 result = new U8(bcIndex.at(0L));
        ByteCodeDumper.incIndex();
        return result;
    }
}

