/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.tenant.TenantModel;
import com.ibm.j9ddr.vm27.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MonitorTableListEntryPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9TenantNativeDataPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import java.util.HashMap;

public class J9MonitorTableListEntryHelper {
    private static HashMap<J9MonitorTableListEntryPointer, J9TenantNativeDataPointer> cachedMonitorTableListEntryToTenant;

    public static J9TenantNativeDataPointer getTenant(J9MonitorTableListEntryPointer listEntry) throws CorruptDataException {
        J9TenantNativeDataPointer tenant;
        if (!TenantModel.isTenantEnabled()) {
            return J9TenantNativeDataPointer.NULL;
        }
        if (null == cachedMonitorTableListEntryToTenant) {
            J9MonitorTableListEntryHelper.initializeCache();
        }
        if (null == (tenant = cachedMonitorTableListEntryToTenant.get(listEntry))) {
            tenant = J9TenantNativeDataPointer.NULL;
        }
        return tenant;
    }

    private static void initializeCache() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        J9MonitorTableListEntryPointer monitorTableListEntry = vm.monitorTableList();
        cachedMonitorTableListEntryToTenant = new HashMap();
        while (monitorTableListEntry.notNull()) {
            J9HashTablePointer left = monitorTableListEntry.monitorTable();
            J9TenantNativeDataPointer tenant = J9TenantNativeDataPointer.NULL;
            if (TenantModel.isTenantEnabled()) {
                tenant = vm.tenantGlobals().tenants();
            }
            while (tenant.notNull()) {
                J9HashTablePointer right = tenant.monitorTable();
                if (0 == left.compare(right)) {
                    cachedMonitorTableListEntryToTenant.put(monitorTableListEntry, tenant);
                }
                tenant = tenant.next();
            }
            monitorTableListEntry = monitorTableListEntry.next();
        }
    }
}

