/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm27.j9.gc.GCIterator;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_UnfinalizedObjectListPointer;
import java.util.NoSuchElementException;

public class GCUnfinalizedObjectListIterator
extends GCIterator {
    protected MM_UnfinalizedObjectListPointer head;
    protected MM_UnfinalizedObjectListPointer currentList;
    protected J9ObjectPointer currentObject;
    protected J9ObjectPointer next;

    protected GCUnfinalizedObjectListIterator(MM_UnfinalizedObjectListPointer unfinalizedObjectLists) throws CorruptDataException {
        this.currentList = this.head = unfinalizedObjectLists;
        if (this.currentList.isNull()) {
            this.currentObject = J9ObjectPointer.NULL;
            this.next = null;
        } else {
            this.next = this.currentObject = this.currentList._head();
        }
    }

    public static GCUnfinalizedObjectListIterator from() throws CorruptDataException {
        return new GCUnfinalizedObjectListIterator(GCUnfinalizedObjectListIterator.getExtensions().unfinalizedObjectLists());
    }

    @Override
    public boolean hasNext() {
        if (null != this.next) {
            return true;
        }
        while (this.currentList.notNull()) {
            try {
                if (this.currentObject.notNull()) {
                    this.currentObject = ObjectAccessBarrier.getFinalizeLink(this.currentObject);
                }
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error in unfinalized object list", cde, false);
                this.currentObject = J9ObjectPointer.NULL;
            }
            if (this.currentObject.notNull()) {
                this.next = this.currentObject;
                return true;
            }
            try {
                this.currentList = this.currentList._nextList();
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error in unfinalized object list", cde, true);
                this.currentList = MM_UnfinalizedObjectListPointer.NULL;
            }
            try {
                if (!this.currentList.notNull()) continue;
                this.next = this.currentObject = this.currentList._head();
                return true;
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error in unfinalized object list", cde, false);
                this.currentObject = J9ObjectPointer.NULL;
            }
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            J9ObjectPointer tmp = this.next;
            this.next = null;
            return tmp;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

