/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.view.dtfj;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm24.view.dtfj.DTFJContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class J9RASInfoBootstrapShim
implements IBootstrapRunnable {
    @Override
    public void run(IVMData vmData, Object[] userData) {
        Object[] passbackArray = (Object[])userData[0];
        passbackArray[0] = new J9RASInfoObject();
    }

    private static class J9RASInfoObject
    implements J9RASImageDataFactory.MachineData,
    J9RASImageDataFactory.ProcessData {
        private final J9RASPointer ptr = DataType.getJ9RASPointer();

        private J9RASInfoObject() {
        }

        @Override
        public int version() throws CorruptDataException {
            return this.ptr.version().intValue() >> 16;
        }

        @Override
        public int cpus() throws CorruptDataException {
            try {
                return this.ptr.cpus().intValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.cpus().getHexValue(), e);
            }
        }

        @Override
        public long memoryBytes() throws CorruptDataException {
            try {
                return this.ptr.memory().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.memory().getHexValue(), e);
            }
        }

        @Override
        public String osArch() throws CorruptDataException {
            return this.ptr.osarchEA().getCStringAtOffset(0L);
        }

        @Override
        public String osName() throws CorruptDataException {
            return this.ptr.osnameEA().getCStringAtOffset(0L);
        }

        @Override
        public String osVersion() throws CorruptDataException {
            return this.ptr.osversionEA().getCStringAtOffset(0L);
        }

        @Override
        public long pid() throws CorruptDataException {
            try {
                return this.ptr.pid().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.pid().getHexValue(), e);
            }
        }

        @Override
        public long tid() throws CorruptDataException {
            try {
                return this.ptr.tid().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.tid().getHexValue(), e);
            }
        }

        @Override
        public String gpInfo() throws CorruptDataException {
            if (this.ptr.crashInfo().notNull()) {
                if (this.ptr.crashInfo().gpInfo().notNull()) {
                    return this.ptr.crashInfo().gpInfo().getCStringAtOffset(0L);
                }
                return null;
            }
            return "";
        }

        @Override
        public String hostName() throws DataUnavailableException, CorruptDataException {
            if (this.ptr.hostnameEA().notNull()) {
                return this.ptr.hostnameEA().getCStringAtOffset(0L);
            }
            throw new DataUnavailableException("Host name not available");
        }

        @Override
        public Iterator<Object> ipaddresses() throws DataUnavailableException, CorruptDataException {
            ArrayList<Object> addresses = new ArrayList<Object>();
            U8Pointer ip = this.ptr.ipAddressesEA();
            if (ip.isNull()) {
                throw new DataUnavailableException("IP addresses not available");
            }
            int type2 = ip.at(0L).intValue();
            byte[] ipv4 = new byte[4];
            byte[] ipv6 = new byte[16];
            InetAddress address = null;
            block6: while (0 != type2) {
                try {
                    switch (type2) {
                        case 4: {
                            DataType.getProcess().getBytesAt(ip.getAddress() + 1L, ipv4);
                            ip = ip.add(5L);
                            address = InetAddress.getByAddress(ipv4);
                            break;
                        }
                        case 6: {
                            DataType.getProcess().getBytesAt(ip.getAddress() + 1L, ipv6);
                            ip = ip.add(7L);
                            address = InetAddress.getByAddress(ipv6);
                            break;
                        }
                        default: {
                            addresses.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unknown IP address type identifier : " + type2));
                            break block6;
                        }
                    }
                    if (!addresses.contains(address)) {
                        addresses.add(address);
                    }
                }
                catch (UnknownHostException e) {
                    addresses.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt IP address : " + e.getMessage()));
                }
                type2 = ip.at(0L).intValue();
            }
            if (0 == addresses.size()) {
                throw new DataUnavailableException("IP addresses not available");
            }
            return addresses.iterator();
        }

        @Override
        public IProcess getProcess() {
            return DataType.getProcess();
        }

        @Override
        public long getEnvironment() throws CorruptDataException {
            return this.ptr.environment().longValue();
        }

        @Override
        public Properties systemInfo() throws DataUnavailableException, CorruptDataException {
            return new Properties();
        }

        @Override
        public long dumpTimeMillis() throws DataUnavailableException, CorruptDataException {
            throw new DataUnavailableException("Dump creation time (millisecs) not available in 2.4 JVMs");
        }

        @Override
        public long dumpTimeNanos() throws DataUnavailableException, CorruptDataException {
            throw new DataUnavailableException("Dump creation time (nanosecs) not available in 2.4 JVMs");
        }
    }
}

