/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class EncryptedValue
extends CMPDerObject {
    private AlgorithmId intendedAlg;
    private AlgorithmId symmAlg;
    private byte[] encSymmKey;
    private AlgorithmId keyAlg;
    private byte[] valueHint;
    private byte[] encValue;
    private static final byte TAG_INTENDED_ALG = 0;
    private static final byte TAG_SYMM_ALG = 1;
    private static final byte TAG_ENC_SYMM_KEY = 2;
    private static final byte TAG_KEY_ALG = 3;
    private static final byte TAG_VALUE_HINT = 4;

    public EncryptedValue(AlgorithmId algorithmId, AlgorithmId algorithmId2, byte[] byArray, AlgorithmId algorithmId3, String string, byte[] byArray2) {
        if (byArray2 == null) {
            throw new IllegalArgumentException("EncryptedValue error, encValue not specified");
        }
        this.intendedAlg = algorithmId;
        this.symmAlg = algorithmId2;
        this.encSymmKey = byArray;
        this.keyAlg = algorithmId3;
        if (string != null) {
            try {
                this.valueHint = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.valueHint = null;
            }
        }
        this.encValue = byArray2;
    }

    public EncryptedValue(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new EncryptedValue(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("EncryptedValue parsing error, not a SEQUENCE");
        }
        DerValue derValue2 = null;
        boolean bl = true;
        if (derValue.getData().available() == 0) {
            throw new IOException("EncryptedValue parsing error, missing data");
        }
        derValue2 = derValue.getData().getDerValue();
        bl = false;
        this.intendedAlg = null;
        this.symmAlg = null;
        this.encSymmKey = null;
        this.keyAlg = null;
        this.valueHint = null;
        if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            this.intendedAlg = AlgorithmId.parse((DerValue)derValue2);
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                throw new IOException("EncrytpedValue parsing error, missing data");
            }
        }
        if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            this.symmAlg = AlgorithmId.parse((DerValue)derValue2);
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                throw new IOException("EncrytpedValue parsing error, missing data");
            }
        }
        if (derValue2.isContextSpecific((byte)2) && !derValue2.isConstructed()) {
            derValue2.resetTag((byte)3);
            this.encSymmKey = derValue2.getBitString();
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                throw new IOException("EncrytpedValue parsing error, missing data");
            }
        }
        if (derValue2.isContextSpecific((byte)3) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            this.keyAlg = AlgorithmId.parse((DerValue)derValue2);
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                throw new IOException("EncrytpedValue parsing error, missing data");
            }
        }
        if (derValue2.isContextSpecific((byte)4) && !derValue2.isConstructed()) {
            derValue2.resetTag((byte)4);
            this.valueHint = derValue2.getOctetString();
            bl = true;
        }
        if (bl) {
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                bl = false;
            } else {
                throw new IOException("EncrytpedValue parsing error, missing data");
            }
        }
        this.encValue = derValue2.getBitString();
        if (derValue.getData().available() != 0) {
            throw new IOException("EncryptedValue parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.intendedAlg != null) {
            derOutputStream = new DerOutputStream();
            this.intendedAlg.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream);
        }
        if (this.symmAlg != null) {
            derOutputStream = new DerOutputStream();
            this.symmAlg.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream);
        }
        if (this.encSymmKey != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBitString(this.encSymmKey);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)2), derOutputStream);
        }
        if (this.keyAlg != null) {
            derOutputStream = new DerOutputStream();
            this.keyAlg.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        if (this.valueHint != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.valueHint);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)4), derOutputStream);
        }
        if (this.encValue == null) {
            throw new IOException("EncryptedValue encoding error, encrypted value not specified");
        }
        derOutputStream2.putBitString(this.encValue);
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(EncryptedValue encryptedValue) {
        DerValue derValue;
        DerValue derValue2;
        if (encryptedValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            encryptedValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof EncryptedValue) {
            return this.equals((EncryptedValue)object);
        }
        return false;
    }

    public byte[] getEncSymmKey() throws IOException {
        if (this.encSymmKey == null) {
            return null;
        }
        return (byte[])this.encSymmKey.clone();
    }

    public byte[] getEncValue() {
        return (byte[])this.encValue.clone();
    }

    public AlgorithmId getIntendedAlg() throws IOException {
        if (this.intendedAlg == null) {
            return null;
        }
        return new AlgorithmId(this.intendedAlg.getOID(), this.intendedAlg.getParameters());
    }

    public AlgorithmId getKeyAlg() throws IOException {
        if (this.keyAlg == null) {
            return null;
        }
        return new AlgorithmId(this.keyAlg.getOID(), this.keyAlg.getParameters());
    }

    public AlgorithmId getSymmAlg() throws IOException {
        if (this.symmAlg == null) {
            return null;
        }
        return new AlgorithmId(this.symmAlg.getOID(), this.symmAlg.getParameters());
    }

    public String getValueHint() {
        if (this.valueHint == null) {
            return null;
        }
        try {
            return new String(this.valueHint, 0, this.valueHint.length, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "EncryptedValue:";
        if (this.intendedAlg != null) {
            string = String.valueOf(string) + "\r\n\tintended algorithm: " + this.intendedAlg.toString();
        }
        if (this.symmAlg != null) {
            string = String.valueOf(string) + "\r\n\tsymmetric algorithm: " + this.symmAlg.toString();
        }
        if (this.encSymmKey != null) {
            string = String.valueOf(string) + "\r\n\tencrypted symmetric key: " + this.encSymmKey.toString();
        }
        if (this.keyAlg != null) {
            string = String.valueOf(string) + "\r\n\tkey algorithm: " + this.keyAlg.toString();
        }
        if (this.valueHint != null) {
            string = String.valueOf(string) + "\r\n\tvalue hint: " + this.valueHint.toString();
        }
        if (this.encValue != null) {
            string = String.valueOf(string) + "\r\n\tencrypted value: " + new String(this.encValue);
        }
        return string;
    }
}

