/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.datatype;

import com.ibm.xml.jaxp.datatype.Duration2;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.xerces.jaxp.datatype.DateTimeUtil;
import org.apache.xerces.jaxp.datatype.DurationImpl;
import org.apache.xerces.jaxp.datatype.LightweightDurationImpl;
import org.apache.xerces.jaxp.datatype.XMLGregorianCalendarImpl;
import org.apache.xerces.util.DatatypeMessageFormatter;

abstract class AbstractDurationImpl
extends Duration2 {
    private static final int DIGITS_IN_ONE_BILLION = 10;
    static final int PROPERTY_COUNT = 6;
    static final int PROPERTY_COUNT_MINUS_ONE = 5;
    private static final XMLGregorianCalendar[] SAVED_CAL = new XMLGregorianCalendar[]{new XMLGregorianCalendarImpl("1696-09-01T00:00:00Z"), new XMLGregorianCalendarImpl("1697-02-01T00:00:00Z"), new XMLGregorianCalendarImpl("1903-03-01T00:00:00Z"), new XMLGregorianCalendarImpl("1903-07-01T00:00:00Z")};
    static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    static final BigDecimal ONE = BigDecimal.valueOf(1L);
    static final BigInteger I_ZERO = BigInteger.ZERO;
    static final BigInteger I_ONE = BigInteger.ONE;
    static final BigInteger TWELVE = BigInteger.valueOf(12L);
    static final BigDecimal SIXTY = BigDecimal.valueOf(60L);
    static final BigInteger I_SIXTY = SIXTY.toBigInteger();
    static final BigInteger TWENTY_FOUR = BigInteger.valueOf(24L);
    private static final BigDecimal[] FIELD_MAXVALUES = new BigDecimal[]{ONE, new BigDecimal(12), ZERO, new BigDecimal(24), new BigDecimal(60), new BigDecimal(60)};
    private static final DatatypeConstants.Field[] FIELDS = new DatatypeConstants.Field[]{DatatypeConstants.YEARS, DatatypeConstants.MONTHS, DatatypeConstants.DAYS, DatatypeConstants.HOURS, DatatypeConstants.MINUTES, DatatypeConstants.SECONDS};
    static final Duration2 ZERO_MONTHS = new LightweightDurationImpl(0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    static final Duration2 ZERO_SECONDS = new LightweightDurationImpl(0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0);

    AbstractDurationImpl() {
    }

    static AbstractDurationImpl newDuration(String string, QName qName) throws IllegalArgumentException {
        char c;
        boolean bl = true;
        boolean bl2 = true;
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        BigInteger bigInteger5 = null;
        BigDecimal bigDecimal = null;
        int n7 = string.length();
        if (n7 == 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "IllegalLexicalValue", new Object[]{string}));
        }
        int n8 = 0;
        if ((c = string.charAt(n8++)) != 'P' && c != '-') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "ParseDuration1", new Object[]{string}));
        }
        if (c == '-') {
            bl2 = false;
            if (string.charAt(n8++) != 'P') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "ParseDuration2", new Object[]{string}));
            }
        }
        boolean bl3 = false;
        int n9 = DateTimeUtil.indexOf(string, n8, n7, 'T');
        if (n9 == -1) {
            n9 = n7;
        } else if (qName == DatatypeConstants.DURATION_YEARMONTH) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidYearMonthDuration", new Object[]{string}));
        }
        int n10 = DateTimeUtil.indexOf(string, n8, n9, 'Y');
        if (n10 != -1) {
            if (qName == DatatypeConstants.DURATION_DAYTIME) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDayTimeDuration", new Object[]{string}));
            }
            if (string.charAt(n8) == '-') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{string}));
            }
            try {
                if (n10 - n8 < 10) {
                    n = DateTimeUtil.parseInt(string, n8, n10);
                } else {
                    bl = false;
                    bigInteger = new BigInteger(string.substring(n8, n10));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.getMessage());
            }
            n8 = n10 + 1;
            bl3 = true;
        }
        if ((n10 = DateTimeUtil.indexOf(string, n8, n9, 'M')) != -1) {
            if (qName == DatatypeConstants.DURATION_DAYTIME) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDayTimeDuration", new Object[]{string}));
            }
            if (string.charAt(n8) == '-') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{string}));
            }
            try {
                if (bl) {
                    if (n10 - n8 < 10) {
                        n2 = DateTimeUtil.parseInt(string, n8, n10);
                    } else {
                        bl = false;
                        bigInteger = n != Integer.MIN_VALUE ? BigInteger.valueOf(n) : null;
                        bigInteger2 = new BigInteger(string.substring(n8, n10));
                    }
                } else {
                    bigInteger2 = new BigInteger(string.substring(n8, n10));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.getMessage());
            }
            n8 = n10 + 1;
            bl3 = true;
        }
        if ((n10 = DateTimeUtil.indexOf(string, n8, n9, 'D')) != -1) {
            if (qName == DatatypeConstants.DURATION_YEARMONTH) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidYearMonthDuration", new Object[]{string}));
            }
            if (string.charAt(n8) == '-') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{string}));
            }
            try {
                if (bl) {
                    if (n10 - n8 < 10) {
                        n3 = DateTimeUtil.parseInt(string, n8, n10);
                    } else {
                        bl = false;
                        bigInteger = n != Integer.MIN_VALUE ? BigInteger.valueOf(n) : null;
                        bigInteger2 = n2 != Integer.MIN_VALUE ? BigInteger.valueOf(n2) : null;
                        bigInteger3 = new BigInteger(string.substring(n8, n10));
                    }
                } else {
                    bigInteger3 = new BigInteger(string.substring(n8, n10));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.getMessage());
            }
            n8 = n10 + 1;
            bl3 = true;
        }
        if (n7 == n9 && n8 != n7) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "IllegalLexicalValue", new Object[]{string}));
        }
        if (n7 != n9) {
            if ((n10 = DateTimeUtil.indexOf(string, ++n8, n7, 'H')) != -1) {
                if (string.charAt(n8) == '-') {
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{string}));
                }
                try {
                    if (bl) {
                        if (n10 - n8 < 10) {
                            n4 = DateTimeUtil.parseInt(string, n8, n10);
                        } else {
                            bl = false;
                            bigInteger = n != Integer.MIN_VALUE ? BigInteger.valueOf(n) : null;
                            bigInteger2 = n2 != Integer.MIN_VALUE ? BigInteger.valueOf(n2) : null;
                            bigInteger3 = n3 != Integer.MIN_VALUE ? BigInteger.valueOf(n3) : null;
                            bigInteger4 = new BigInteger(string.substring(n8, n10));
                        }
                    } else {
                        bigInteger4 = new BigInteger(string.substring(n8, n10));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.getMessage());
                }
                n8 = n10 + 1;
                bl3 = true;
            }
            if ((n10 = DateTimeUtil.indexOf(string, n8, n7, 'M')) != -1) {
                if (string.charAt(n8) == '-') {
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{string}));
                }
                try {
                    if (bl) {
                        if (n10 - n8 < 10) {
                            n5 = DateTimeUtil.parseInt(string, n8, n10);
                        } else {
                            bl = false;
                            bigInteger = n != Integer.MIN_VALUE ? BigInteger.valueOf(n) : null;
                            bigInteger2 = n2 != Integer.MIN_VALUE ? BigInteger.valueOf(n2) : null;
                            bigInteger3 = n3 != Integer.MIN_VALUE ? BigInteger.valueOf(n3) : null;
                            bigInteger4 = n4 != Integer.MIN_VALUE ? BigInteger.valueOf(n4) : null;
                            bigInteger5 = new BigInteger(string.substring(n8, n10));
                        }
                    } else {
                        bigInteger5 = new BigInteger(string.substring(n8, n10));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.getMessage());
                }
                n8 = n10 + 1;
                bl3 = true;
            }
            if ((n10 = DateTimeUtil.indexOf(string, n8, n7, 'S')) != -1) {
                if (string.charAt(n8) == '-') {
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{string}));
                }
                try {
                    if (bl) {
                        if (n10 - n8 < 10 && DateTimeUtil.indexOf(string, n8, n10, '.') == -1) {
                            n6 = DateTimeUtil.parseInt(string, n8, n10);
                        } else {
                            bl = false;
                            bigInteger = n != Integer.MIN_VALUE ? BigInteger.valueOf(n) : null;
                            bigInteger2 = n2 != Integer.MIN_VALUE ? BigInteger.valueOf(n2) : null;
                            bigInteger3 = n3 != Integer.MIN_VALUE ? BigInteger.valueOf(n3) : null;
                            bigInteger4 = n4 != Integer.MIN_VALUE ? BigInteger.valueOf(n4) : null;
                            bigInteger5 = n5 != Integer.MIN_VALUE ? BigInteger.valueOf(n5) : null;
                            bigDecimal = new BigDecimal(string.substring(n8, n10));
                        }
                    } else {
                        bigDecimal = new BigDecimal(string.substring(n8, n10));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.getMessage());
                }
                n8 = n10 + 1;
                bl3 = true;
            }
            if (n8 != n7 || string.charAt(--n8) == 'T') {
                throw new IllegalArgumentException();
            }
        }
        if (!bl3) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "IllegalLexicalValue", new Object[]{string}));
        }
        if (bl) {
            return new LightweightDurationImpl(n, n2, n3, n4, n5, n6, bl2);
        }
        return new DurationImpl(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigDecimal, bl2);
    }

    @Override
    public final Duration add(Duration duration) {
        return AbstractDurationImpl.addDuration(this, duration);
    }

    private static Duration addDuration(AbstractDurationImpl abstractDurationImpl, Duration duration) throws IllegalStateException {
        boolean bl;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Number number;
        Number number2;
        BigInteger bigInteger3;
        int n = 0;
        int n2 = abstractDurationImpl.getSign();
        int n3 = duration.getSign();
        BigInteger bigInteger4 = null;
        BigInteger bigInteger5 = abstractDurationImpl.getMonthsField();
        if (bigInteger5 != null || duration.isSet(DatatypeConstants.MONTHS)) {
            bigInteger3 = (BigInteger)duration.getField(DatatypeConstants.MONTHS);
            bigInteger4 = (bigInteger5 != null ? (n2 == -1 ? bigInteger5.negate() : bigInteger5) : I_ZERO).add(bigInteger3 != null ? (n3 == -1 ? bigInteger3.negate() : bigInteger3) : I_ZERO);
        }
        bigInteger3 = null;
        BigInteger bigInteger6 = abstractDurationImpl.getYearsField();
        if (bigInteger6 != null || duration.isSet(DatatypeConstants.YEARS)) {
            number2 = (BigInteger)duration.getField(DatatypeConstants.YEARS);
            bigInteger3 = (bigInteger6 != null ? (n2 == -1 ? bigInteger6.negate() : bigInteger6) : I_ZERO).add((BigInteger)(number2 != null ? (n3 == -1 ? ((BigInteger)number2).negate() : number2) : I_ZERO));
        }
        number2 = null;
        BigDecimal bigDecimal = abstractDurationImpl.getSecondsField();
        if (bigDecimal != null || duration.isSet(DatatypeConstants.SECONDS)) {
            number = (BigDecimal)duration.getField(DatatypeConstants.SECONDS);
            number2 = (bigDecimal != null ? (n2 == -1 ? bigDecimal.negate() : bigDecimal) : ZERO).add((BigDecimal)(number != null ? (n3 == -1 ? ((BigDecimal)number).negate() : number) : ZERO));
        }
        number = null;
        BigInteger bigInteger7 = abstractDurationImpl.getMinutesField();
        if (bigInteger7 != null || duration.isSet(DatatypeConstants.MINUTES)) {
            bigInteger2 = (BigInteger)duration.getField(DatatypeConstants.MINUTES);
            number = (bigInteger7 != null ? (n2 == -1 ? bigInteger7.negate() : bigInteger7) : I_ZERO).add(bigInteger2 != null ? (n3 == -1 ? bigInteger2.negate() : bigInteger2) : I_ZERO);
        }
        bigInteger2 = null;
        BigInteger bigInteger8 = abstractDurationImpl.getHoursField();
        if (bigInteger8 != null || duration.isSet(DatatypeConstants.HOURS)) {
            bigInteger = (BigInteger)duration.getField(DatatypeConstants.HOURS);
            bigInteger2 = (bigInteger8 != null ? (n2 == -1 ? bigInteger8.negate() : bigInteger8) : I_ZERO).add(bigInteger != null ? (n3 == -1 ? bigInteger.negate() : bigInteger) : I_ZERO);
        }
        bigInteger = null;
        BigInteger bigInteger9 = abstractDurationImpl.getDaysField();
        if (bigInteger9 != null || duration.isSet(DatatypeConstants.DAYS)) {
            BigInteger bigInteger10 = (BigInteger)duration.getField(DatatypeConstants.DAYS);
            bigInteger = (bigInteger9 != null ? (n2 == -1 ? bigInteger9.negate() : bigInteger9) : I_ZERO).add(bigInteger10 != null ? (n3 == -1 ? bigInteger10.negate() : bigInteger10) : I_ZERO);
        }
        int n4 = 0;
        do {
            bl = false;
            if (bigInteger3 != null) {
                n4 = bigInteger3.signum();
            }
            if (bigInteger4 != null) {
                if (n4 > 0 && bigInteger4.signum() == -1) {
                    bl = true;
                    while (bigInteger4.signum() == -1) {
                        bigInteger3 = bigInteger3 != null ? bigInteger3.subtract(I_ONE) : I_ONE.negate();
                        bigInteger4 = bigInteger4.add(TWELVE);
                    }
                } else if (n4 < 0 && bigInteger4.compareTo(I_ZERO) == 1) {
                    bl = true;
                    while (bigInteger4.compareTo(I_ZERO) == 1) {
                        bigInteger3 = bigInteger3 != null ? bigInteger3.add(I_ONE) : I_ONE;
                        bigInteger4 = bigInteger4.subtract(TWELVE);
                    }
                }
                if (bigInteger4.signum() != 0) {
                    n4 = bigInteger4.signum();
                }
            }
            if (bigInteger != null && bigInteger.signum() != 0) {
                n4 = bigInteger.signum();
            }
            if (bigInteger2 != null) {
                if (n4 > 0 && bigInteger2.signum() == -1) {
                    bl = true;
                    while (bigInteger2.signum() == -1) {
                        bigInteger = bigInteger != null ? bigInteger.subtract(I_ONE) : I_ONE.negate();
                        bigInteger2 = bigInteger2.add(TWENTY_FOUR);
                    }
                } else if (n4 < 0 && bigInteger2.compareTo(I_ZERO) == 1) {
                    bl = true;
                    while (bigInteger2.compareTo(I_ZERO) == 1) {
                        bigInteger = bigInteger != null ? bigInteger.add(I_ONE) : I_ONE;
                        bigInteger2 = bigInteger2.subtract(TWENTY_FOUR);
                    }
                }
                if (bigInteger2.signum() != 0) {
                    n4 = bigInteger2.signum();
                }
            }
            if (number != null) {
                if (n4 > 0 && ((BigInteger)number).signum() == -1) {
                    bl = true;
                    while (((BigInteger)number).signum() == -1) {
                        bigInteger2 = bigInteger2 != null ? bigInteger2.subtract(I_ONE) : I_ONE.negate();
                        number = ((BigInteger)number).add(I_SIXTY);
                    }
                } else if (n4 < 0 && ((BigInteger)number).compareTo(I_ZERO) == 1) {
                    bl = true;
                    while (((BigInteger)number).compareTo(I_ZERO) == 1) {
                        bigInteger2 = bigInteger2.add(I_ONE);
                        number = ((BigInteger)number).subtract(I_SIXTY);
                    }
                }
                if (((BigInteger)number).signum() != 0) {
                    n4 = ((BigInteger)number).signum();
                }
            }
            if (number2 == null) continue;
            if (n4 > 0 && ((BigDecimal)number2).compareTo(ZERO) == -1) {
                bl = true;
                while (((BigDecimal)number2).compareTo(ZERO) == -1) {
                    number = number != null ? ((BigInteger)number).subtract(I_ONE) : I_ONE.negate();
                    number2 = ((BigDecimal)number2).add(SIXTY);
                }
            } else if (n4 < 0 && ((BigDecimal)number2).compareTo(ZERO) == 1) {
                bl = true;
                while (((BigDecimal)number2).compareTo(ZERO) == 1) {
                    number = ((BigInteger)number).add(I_ONE);
                    number2 = ((BigDecimal)number2).subtract(SIXTY);
                }
            }
            if (((BigDecimal)number2).signum() == 0) continue;
            n4 = ((BigDecimal)number2).signum();
        } while (bl);
        if (bigInteger3 != null && bigInteger3.signum() == 1 || bigInteger4 != null && bigInteger4.signum() == 1 || bigInteger != null && bigInteger.signum() == 1 || bigInteger2 != null && bigInteger2.signum() == 1 || number != null && ((BigInteger)number).signum() == 1 || number2 != null && ((BigDecimal)number2).signum() == 1) {
            if (bigInteger3 != null && bigInteger3.signum() == -1 || bigInteger4 != null && bigInteger4.signum() == -1 || bigInteger != null && bigInteger.signum() == -1 || bigInteger2 != null && bigInteger2.signum() == -1 || number != null && ((BigInteger)number).signum() == -1 || number2 != null && ((BigDecimal)number2).signum() == -1) {
                throw new IllegalStateException();
            }
            n = 1;
        } else if (bigInteger3 != null && bigInteger3.signum() == -1 || bigInteger4 != null && bigInteger4.signum() == -1 || bigInteger != null && bigInteger.signum() == -1 || bigInteger2 != null && bigInteger2.signum() == -1 || number != null && ((BigInteger)number).signum() == -1 || number2 != null && ((BigDecimal)number2).signum() == -1) {
            n = -1;
        }
        return new DurationImpl(n, bigInteger3 != null ? bigInteger3.abs() : null, bigInteger4 != null ? bigInteger4.abs() : null, bigInteger != null ? bigInteger.abs() : null, bigInteger2 != null ? bigInteger2.abs() : null, number != null ? ((BigInteger)number).abs() : null, number2 != null ? ((BigDecimal)number2).abs() : null);
    }

    @Override
    public final void addTo(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "CannotBeNull", new Object[]{"Calendar"}));
        }
        int n = this.getSign();
        if (n != 0) {
            BigDecimal bigDecimal;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.getYears();
            if (n7 != 0) {
                calendar.add(1, n * n7);
            }
            if ((n6 = this.getMonths()) != 0) {
                calendar.add(2, n * n6);
            }
            if ((n5 = this.getDays()) != 0) {
                calendar.add(5, n * n5);
            }
            if ((n4 = this.getHours()) != 0) {
                calendar.add(10, n * n4);
            }
            if ((n3 = this.getMinutes()) != 0) {
                calendar.add(12, n * n3);
            }
            if ((n2 = this.getSeconds()) != 0) {
                calendar.add(13, n * n2);
            }
            if ((bigDecimal = this.getSecondsField()) != null) {
                int n8 = bigDecimal.subtract(bigDecimal.setScale(0, 1)).movePointRight(3).intValue();
                calendar.add(14, n * n8);
            }
        }
    }

    @Override
    public final int compare(Duration duration) {
        return AbstractDurationImpl.compareDates(this, duration);
    }

    private static int compareDates(AbstractDurationImpl abstractDurationImpl, Duration duration) {
        int n = 2;
        int n2 = 2;
        n = AbstractDurationImpl.compareOrder(abstractDurationImpl, duration);
        if (n == 0) {
            return 0;
        }
        XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)SAVED_CAL[0].clone();
        XMLGregorianCalendar xMLGregorianCalendar2 = (XMLGregorianCalendar)SAVED_CAL[0].clone();
        xMLGregorianCalendar.add(abstractDurationImpl);
        xMLGregorianCalendar2.add(duration);
        n = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
        if (n == 2) {
            return 2;
        }
        xMLGregorianCalendar = (XMLGregorianCalendar)SAVED_CAL[1].clone();
        xMLGregorianCalendar2 = (XMLGregorianCalendar)SAVED_CAL[1].clone();
        xMLGregorianCalendar.add(abstractDurationImpl);
        xMLGregorianCalendar2.add(duration);
        n2 = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
        n = AbstractDurationImpl.compareResults(n, n2);
        if (n == 2) {
            return 2;
        }
        xMLGregorianCalendar = (XMLGregorianCalendar)SAVED_CAL[2].clone();
        xMLGregorianCalendar2 = (XMLGregorianCalendar)SAVED_CAL[2].clone();
        xMLGregorianCalendar.add(abstractDurationImpl);
        xMLGregorianCalendar2.add(duration);
        n2 = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
        n = AbstractDurationImpl.compareResults(n, n2);
        if (n == 2) {
            return 2;
        }
        xMLGregorianCalendar = (XMLGregorianCalendar)SAVED_CAL[3].clone();
        xMLGregorianCalendar2 = (XMLGregorianCalendar)SAVED_CAL[3].clone();
        xMLGregorianCalendar.add(abstractDurationImpl);
        xMLGregorianCalendar2.add(duration);
        n2 = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
        n = AbstractDurationImpl.compareResults(n, n2);
        return n;
    }

    private static int compareResults(int n, int n2) {
        if (n2 == 2) {
            return 2;
        }
        if (n != n2) {
            return 2;
        }
        return n;
    }

    private static int compareOrder(AbstractDurationImpl abstractDurationImpl, Duration duration) {
        BigDecimal bigDecimal;
        boolean bl = true;
        int n = abstractDurationImpl.getSign();
        int n2 = duration.getSign();
        if (n == 0 && n2 == 0) {
            return 0;
        }
        if (n == -1 && n2 == -1) {
            bl = false;
        } else {
            if (n == 1 && n2 == -1) {
                return 1;
            }
            if (n == -1 && n2 == 1) {
                return -1;
            }
        }
        BigInteger bigInteger = abstractDurationImpl.isYearsSet() ? abstractDurationImpl.getYearsField() : I_ZERO;
        BigInteger bigInteger2 = duration.isSet(DatatypeConstants.YEARS) ? (BigInteger)duration.getField(DatatypeConstants.YEARS) : I_ZERO;
        int n3 = bigInteger.compareTo(bigInteger2);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        bigInteger = abstractDurationImpl.isMonthsSet() ? abstractDurationImpl.getMonthsField() : I_ZERO;
        n3 = bigInteger.compareTo(bigInteger2 = duration.isSet(DatatypeConstants.MONTHS) ? (BigInteger)duration.getField(DatatypeConstants.MONTHS) : I_ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        bigInteger = abstractDurationImpl.isDaysSet() ? abstractDurationImpl.getDaysField() : I_ZERO;
        n3 = bigInteger.compareTo(bigInteger2 = duration.isSet(DatatypeConstants.DAYS) ? (BigInteger)duration.getField(DatatypeConstants.DAYS) : I_ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        bigInteger = abstractDurationImpl.isHoursSet() ? abstractDurationImpl.getHoursField() : I_ZERO;
        n3 = bigInteger.compareTo(bigInteger2 = duration.isSet(DatatypeConstants.HOURS) ? (BigInteger)duration.getField(DatatypeConstants.HOURS) : I_ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        bigInteger = abstractDurationImpl.isMinutesSet() ? abstractDurationImpl.getMinutesField() : I_ZERO;
        n3 = bigInteger.compareTo(bigInteger2 = duration.isSet(DatatypeConstants.MINUTES) ? (BigInteger)duration.getField(DatatypeConstants.MINUTES) : I_ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        BigDecimal bigDecimal2 = abstractDurationImpl.isSecondsSet() ? abstractDurationImpl.getSecondsField() : ZERO;
        n3 = bigDecimal2.compareTo(bigDecimal = duration.isSet(DatatypeConstants.SECONDS) ? (BigDecimal)duration.getField(DatatypeConstants.SECONDS) : ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        return 0;
    }

    @Override
    public final Number getField(DatatypeConstants.Field field) throws NullPointerException, IllegalArgumentException {
        if (field == null) {
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "CannotBeNull", new Object[]{"Field"}));
        }
        if (field == DatatypeConstants.YEARS) {
            return this.getYearsField();
        }
        if (field == DatatypeConstants.MONTHS) {
            return this.getMonthsField();
        }
        if (field == DatatypeConstants.DAYS) {
            return this.getDaysField();
        }
        if (field == DatatypeConstants.HOURS) {
            return this.getHoursField();
        }
        if (field == DatatypeConstants.MINUTES) {
            return this.getMinutesField();
        }
        if (field == DatatypeConstants.SECONDS) {
            return this.getSecondsField();
        }
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValue", new Object[]{"field", field}));
    }

    abstract BigInteger getYearsField();

    abstract BigInteger getMonthsField();

    abstract BigInteger getDaysField();

    abstract BigInteger getHoursField();

    abstract BigInteger getMinutesField();

    abstract BigDecimal getSecondsField();

    @Override
    public final int hashCode() {
        GregorianCalendar gregorianCalendar = SAVED_CAL[0].toGregorianCalendar();
        this.addTo(gregorianCalendar);
        return (int)gregorianCalendar.getTime().getTime();
    }

    @Override
    public final boolean isSet(DatatypeConstants.Field field) throws NullPointerException, IllegalArgumentException {
        if (field == null) {
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "CannotBeNull", new Object[]{"Field"}));
        }
        if (field == DatatypeConstants.YEARS) {
            return this.isYearsSet();
        }
        if (field == DatatypeConstants.MONTHS) {
            return this.isMonthsSet();
        }
        if (field == DatatypeConstants.DAYS) {
            return this.isDaysSet();
        }
        if (field == DatatypeConstants.HOURS) {
            return this.isHoursSet();
        }
        if (field == DatatypeConstants.MINUTES) {
            return this.isMinutesSet();
        }
        if (field == DatatypeConstants.SECONDS) {
            return this.isSecondsSet();
        }
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValue", new Object[]{"field", field}));
    }

    abstract boolean isYearsSet();

    abstract boolean isMonthsSet();

    abstract boolean isDaysSet();

    abstract boolean isHoursSet();

    abstract boolean isMinutesSet();

    abstract boolean isSecondsSet();

    @Override
    public final Duration multiply(BigDecimal bigDecimal) {
        int n = bigDecimal.signum();
        BigDecimal bigDecimal2 = bigDecimal.abs();
        BigDecimal[] bigDecimalArray = this.createBigDecimalArray();
        BigDecimal[] bigDecimalArray2 = new BigDecimal[6];
        BigDecimal bigDecimal3 = ZERO;
        for (int i = 0; i < 5; ++i) {
            BigDecimal bigDecimal4 = bigDecimalArray[i].multiply(bigDecimal2).add(bigDecimal3.multiply(FIELD_MAXVALUES[i]));
            bigDecimalArray2[i] = bigDecimal4.setScale(0, 1);
            bigDecimal3 = bigDecimal4.subtract(bigDecimalArray2[i]);
            if (bigDecimal3.signum() == 0 || FIELDS[i] != DatatypeConstants.MONTHS) continue;
            throw new IllegalStateException();
        }
        bigDecimalArray2[5] = bigDecimalArray[5].multiply(bigDecimal2).add(bigDecimal3.multiply(FIELD_MAXVALUES[5]));
        return new DurationImpl(this.getSign() * n, this.isYearsSet() ? bigDecimalArray2[0].toBigInteger() : (bigDecimalArray2[0].signum() != 0 ? bigDecimalArray2[0].toBigInteger() : null), this.isMonthsSet() ? bigDecimalArray2[1].toBigInteger() : (bigDecimalArray2[1].signum() != 0 ? bigDecimalArray2[1].toBigInteger() : null), this.isDaysSet() ? bigDecimalArray2[2].toBigInteger() : (bigDecimalArray2[2].signum() != 0 ? bigDecimalArray2[2].toBigInteger() : null), this.isHoursSet() ? bigDecimalArray2[3].toBigInteger() : (bigDecimalArray2[3].signum() != 0 ? bigDecimalArray2[3].toBigInteger() : null), this.isMinutesSet() ? bigDecimalArray2[4].toBigInteger() : (bigDecimalArray2[4].signum() != 0 ? bigDecimalArray2[4].toBigInteger() : null), this.isSecondsSet() ? bigDecimalArray2[5] : (bigDecimalArray2[5].signum() != 0 ? bigDecimalArray2[5] : null));
    }

    abstract BigDecimal[] createBigDecimalArray();

    final String toZeroDurationFOStringFormat() {
        if (!(this.isSecondsSet() || this.isMinutesSet() || this.isHoursSet() || this.isDaysSet())) {
            return "P0M";
        }
        return "PT0S";
    }
}

