/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xylem.JavaClassWrapper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.PrimitiveNumericalType;
import com.ibm.xylem.types.SingletonType;
import java.io.ObjectStreamException;
import java.math.BigDecimal;

public final class DecimalType
extends SingletonType
implements INumericalType {
    private static final long serialVersionUID = -8135514283342527595L;
    public static final DecimalType s_decimalType = new DecimalType();
    public static final int DECIMAL_SCALE = 6;
    public static final ObjectType s_bcelType = new ObjectType("java.math.BigDecimal");
    private static String[] s_arithmeticMethodNames = new String[]{"add", "subtract", "multiply", "divide"};

    private DecimalType() {
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "java.math.BigDecimal";
    }

    @Override
    public Type getImplementationType(BCELCodeGenerationHelper bCELCodeGenerationHelper) {
        return s_bcelType;
    }

    @Override
    public JavaClassWrapper getJavaType() {
        return new JavaClassWrapper(BigDecimal.class);
    }

    @Override
    public Object evaluateOperation(Object object, Object object2, int n) {
        BigDecimal bigDecimal = (BigDecimal)object;
        BigDecimal bigDecimal2 = (BigDecimal)object2;
        switch (n) {
            case 0: {
                return bigDecimal.add(bigDecimal2);
            }
            case 1: {
                return bigDecimal.subtract(bigDecimal2);
            }
            case 2: {
                return bigDecimal.multiply(bigDecimal2);
            }
            case 3: {
                return bigDecimal.divide(bigDecimal2, 6, 4);
            }
            case 4: {
                throw new UnsupportedOperationException("modulo not supported on BigDecimal");
            }
            case 9: {
                return bigDecimal.compareTo(bigDecimal2) == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: 
            case 11: 
            case 12: {
                throw new UnsupportedOperationException("Bitwise operators not supported on BigDecimal");
            }
            case 16: {
                return bigDecimal.negate();
            }
        }
        return IntType.s_intType.evaluateComparisonOperation(object, object2, n);
    }

    @Override
    public String generateCodeForOperation(String string, String string2, int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return "(" + string + ")." + s_arithmeticMethodNames[n] + "(" + string2 + ")";
            }
            case 3: {
                return "(" + string + ").divide(" + string2 + "," + 6 + ",java.math.BigDecimal.ROUND_HALF_UP)";
            }
            case 4: {
                throw new UnsupportedOperationException("modulo not supported on BigDecimal");
            }
            case 10: 
            case 11: 
            case 12: {
                throw new UnsupportedOperationException("Bitwise operators not supported on BigDecimal");
            }
        }
        return "((" + string + ").compareTo(" + string2 + ") " + PrimitiveNumericalType.getOperator(n) + " 0)";
    }

    private Object readResolve() throws ObjectStreamException {
        return s_decimalType;
    }

    @Override
    public void generateCodeForOperation(InstructionListBuilder instructionListBuilder, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefaultValue() {
        return "new java.math.BigDecimal(0.0)";
    }
}

