/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingDependencyInfo;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationOptUtils;
import com.ibm.xylem.codegen.ConventionalGenerationState;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.ExtantGenerationState;
import com.ibm.xylem.codegen.GenerationState;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.LazyStreamFixedIndexGenerationState;
import com.ibm.xylem.codegen.LazyStreamFixedIndexOptimizationStyle;
import com.ibm.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xylem.codegen.StreamInADTOptimizedGenerationState;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.StreamOptimizedGenerationState;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LazyStreamElementInstruction;
import com.ibm.xylem.instructions.LetBaseInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public final class CodeGenerationTracker {
    protected HashMap m_bindings = new HashMap(63);
    protected CodeGenerationTracker m_parent = null;
    protected HashMap m_bindingDependencies;
    public TypeEnvironment m_typeEnvironment;
    public Function m_function;
    public BindingEnvironment m_bindingEnvironment;
    private static final Logger s_logger = Logger.getInstance(CodeGenerationTracker.class);
    protected int m_registerCounter = 1;
    protected Stack m_loops = new Stack();
    static final boolean TRACE_GEN_STATE = false;

    public Function getFunction() {
        return this.m_function;
    }

    public CodeGenerationTracker(HashMap hashMap, Function function) {
        this(hashMap, function, 1);
    }

    private CodeGenerationTracker(HashMap hashMap, Function function, int n) {
        this.m_bindingDependencies = hashMap;
        this.m_typeEnvironment = function.getTypeEnvironment();
        this.m_function = function;
        this.m_bindingEnvironment = function.getBindingEnvironment();
        this.m_registerCounter = n;
    }

    public int allocateRegister() {
        return this.m_registerCounter++;
    }

    public int allocateRegister(com.ibm.xtq.bcel.generic.Type type) {
        int n = this.m_registerCounter;
        this.m_registerCounter += type.getSize();
        return n;
    }

    protected HashMap getBindingDependencies() {
        if (this.m_bindingDependencies.isEmpty()) {
            this.m_function.determineDataDependencies(null, this.m_bindingDependencies);
        }
        return this.m_bindingDependencies;
    }

    public boolean isBindingUsed(IBinding iBinding) {
        HashMap hashMap = this.getBindingDependencies();
        return hashMap.containsKey(iBinding) && ((List)hashMap.get(iBinding)).size() > 0;
    }

    public void startLoop(Instruction instruction) {
        this.m_loops.push(instruction);
    }

    public void endLoop() {
        this.m_loops.pop();
    }

    public int getBindingUseCount(IBinding iBinding) {
        HashMap hashMap = this.getBindingDependencies();
        if (!hashMap.containsKey(iBinding)) {
            return 0;
        }
        return ((List)hashMap.get(iBinding)).size();
    }

    public CodeGenerationTracker cloneBranch() {
        CodeGenerationTracker codeGenerationTracker = new CodeGenerationTracker(this.m_bindingDependencies, this.m_function, this.m_registerCounter);
        codeGenerationTracker.m_parent = this;
        codeGenerationTracker.m_loops = this.m_loops;
        return codeGenerationTracker;
    }

    public void registerBinding(IBinding iBinding, Instruction instruction) {
        Object object;
        List list;
        block12: {
            HashMap hashMap = this.getBindingDependencies();
            list = (List)hashMap.get(iBinding);
            if (list != null) {
                Instruction instruction2;
                if (list.size() == 1 && instruction.supportsCodeGenerationOptimization(StreamOptimizationStyle.s_streamOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
                    this.registerBinding(iBinding, new StreamOptimizedGenerationState(iBinding, instruction));
                    return;
                }
                if (list.size() == 1 && instruction.supportsCodeGenerationOptimization(LazyStreamFixedIndexOptimizationStyle.s_lazyStreamFixedIndexOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
                    object = (BindingDependencyInfo)list.get(0);
                    if (((BindingDependencyInfo)object).m_parent instanceof LazyStreamElementInstruction) {
                        LazyStreamElementInstruction lazyStreamElementInstruction = (LazyStreamElementInstruction)((BindingDependencyInfo)object).m_parent;
                        Object object2 = lazyStreamElementInstruction.getIndex();
                        while (object2 instanceof IdentifierInstruction && (instruction2 = this.m_function.getBindingEnvironment().getVariableBinding(((IdentifierInstruction)object2).getVariable()).getLet()) != null) {
                            object2 = ((LetBaseInstruction)instruction2).getValue();
                        }
                        if (object2 instanceof LiteralInstruction) {
                            this.registerBinding(iBinding, new LazyStreamFixedIndexGenerationState(iBinding, instruction, (Integer)((LiteralInstruction)object2).getValue()));
                            return;
                        }
                    }
                }
                if (instruction.supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug("CodeGenerationTracker::registerBinding: n=" + instruction);
                    }
                    object = null;
                    for (Object object2 : list) {
                        MatchInstruction matchInstruction;
                        Binding binding;
                        instruction2 = ((BindingDependencyInfo)object2).getParent();
                        if (instruction2 instanceof MatchInstruction && (binding = (matchInstruction = (MatchInstruction)instruction2).getMemberToExtract(this.m_bindingEnvironment)) != null) {
                            if (!(binding.getBindingType().resolveType(binding.getTypeEnvironment()) instanceof StreamType)) continue;
                            if (object == null) {
                                object = binding;
                                continue;
                            }
                        }
                        break block12;
                    }
                    if (object != null) {
                        this.registerBinding(iBinding, new StreamInADTOptimizedGenerationState(iBinding, instruction, (Binding)object));
                        return;
                    }
                }
            }
        }
        object = new ConventionalGenerationState(iBinding, instruction, list == null ? -1 : list.size());
        this.registerBinding(iBinding, (GenerationState)object);
    }

    public void registerExtantBinding(IBinding iBinding, String string) {
        this.m_bindings.put(iBinding, new ExtantGenerationState(iBinding, string));
    }

    public void registerExtantBinding(IBinding iBinding, int n, com.ibm.xtq.bcel.generic.Type type) {
        this.m_bindings.put(iBinding, new ExtantGenerationState(iBinding, n, type));
    }

    public void registerBinding(IBinding iBinding, GenerationState generationState) {
        HashMap hashMap;
        List list;
        if (generationState instanceof ConventionalGenerationState && (list = (List)(hashMap = this.getBindingDependencies()).get(iBinding)) != null && list.size() <= 1) {
            ((ConventionalGenerationState)generationState).setOneTime();
        }
        this.m_bindings.put(iBinding, generationState);
    }

    public GenerationState getGenerationState(IBinding iBinding) {
        GenerationState generationState = (GenerationState)this.m_bindings.get(iBinding);
        if (generationState == null && this.m_parent != null && (generationState = this.m_parent.getGenerationState(iBinding)) != null) {
            generationState = (GenerationState)generationState.clone();
            this.m_bindings.put(iBinding, generationState);
        }
        return generationState;
    }

    public GenerationState getGenerationState(Instruction instruction) {
        return this.getGenerationState(((IdentifierInstruction)instruction).getBinding(this.m_bindingEnvironment));
    }

    public String generateConventionally(Instruction instruction, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        return this.generateConventionally(instruction, dataFlowCodeGenerationHelper, false);
    }

    public String generateConventionally(Instruction instruction, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, boolean bl) {
        if (instruction instanceof LiteralInstruction) {
            return instruction.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, this, null, bl);
        }
        if (instruction instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            IBinding iBinding = identifierInstruction.getBinding(this.m_bindingEnvironment);
            return this.generateConventionally(iBinding, dataFlowCodeGenerationHelper, bl);
        }
        throw new XylemError("ERR_SYSTEM", "should not occur in reduced code " + instruction + " " + instruction.getClass());
    }

    public String generateConventionally(IBinding iBinding, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, boolean bl) {
        ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(iBinding);
        if (conventionalGenerationState == null) {
            throw new XylemError("ERR_SYSTEM", "ConventionalGenerationState is null, for b=" + iBinding);
        }
        return conventionalGenerationState.generate(dataFlowCodeGenerationHelper, this, bl);
    }

    public void generateConventionally(Instruction instruction, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        if (instruction instanceof LiteralInstruction) {
            instruction.generateCode(bCELCodeGenerationHelper, this, null, instructionHandle, instructionListBuilder);
        } else if (instruction instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            IBinding iBinding = identifierInstruction.getBinding(this.m_bindingEnvironment);
            this.generateConventionally(iBinding, bCELCodeGenerationHelper, instructionHandle, instructionListBuilder);
        } else {
            throw new XylemError("ERR_SYSTEM", "should not occur in reduced code " + instruction + " " + instruction.getClass());
        }
    }

    public void generateConventionally(IBinding iBinding, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(iBinding);
        if (conventionalGenerationState == null) {
            throw new XylemError("ERR_SYSTEM", "ConventionalGenerationState is null, for b=" + iBinding);
        }
        this.trace(conventionalGenerationState, instructionListBuilder);
        conventionalGenerationState.generate(bCELCodeGenerationHelper, this, instructionHandle, instructionListBuilder);
    }

    public void trace(GenerationState generationState, InstructionListBuilder instructionListBuilder) {
    }

    public void generateConventionally(Instruction instruction, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionHandle instructionHandle, int n, InstructionListBuilder instructionListBuilder) {
        if (instruction instanceof LiteralInstruction) {
            instruction.generateCode(bCELCodeGenerationHelper, this, null, instructionHandle, instructionListBuilder);
            instructionListBuilder.appendStore(((LiteralInstruction)instruction).getType(), n);
        } else if (instruction instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            IBinding iBinding = identifierInstruction.getBinding(this.m_bindingEnvironment);
            this.generateConventionally(iBinding, bCELCodeGenerationHelper, n, instructionListBuilder);
        } else {
            throw new XylemError("ERR_SYSTEM", "should not occur in reduced code " + instruction + " " + instruction.getClass());
        }
    }

    public int generateConventionallyIntoRegister(Instruction instruction, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder) {
        if (instruction instanceof LiteralInstruction) {
            LiteralInstruction literalInstruction = (LiteralInstruction)instruction;
            com.ibm.xtq.bcel.generic.Type type = literalInstruction.getType().getImplementationType(bCELCodeGenerationHelper);
            int n = this.allocateRegister(type);
            instruction.generateCode(bCELCodeGenerationHelper, this, null, null, instructionListBuilder);
            instructionListBuilder.appendStore(type, n);
            return n;
        }
        if (instruction instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            IBinding iBinding = identifierInstruction.getBinding(this.m_bindingEnvironment);
            return this.generateConventionally(iBinding, bCELCodeGenerationHelper, instructionListBuilder);
        }
        throw new XylemError("ERR_SYSTEM", "should not occur in reduced code " + instruction + " " + instruction.getClass());
    }

    public void generateConventionally(IBinding iBinding, BCELCodeGenerationHelper bCELCodeGenerationHelper, int n, InstructionListBuilder instructionListBuilder) {
        ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(iBinding);
        if (conventionalGenerationState == null) {
            throw new XylemError("ERR_SYSTEM", "ConventionalGenerationState is null, for b=" + iBinding);
        }
        this.trace(conventionalGenerationState, instructionListBuilder);
        conventionalGenerationState.generate(bCELCodeGenerationHelper, this, n, instructionListBuilder);
    }

    public int generateConventionally(IBinding iBinding, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder) {
        ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(iBinding);
        if (conventionalGenerationState == null) {
            throw new XylemError("ERR_SYSTEM", "ConventionalGenerationState is null, for b=" + iBinding);
        }
        this.trace(conventionalGenerationState, instructionListBuilder);
        return conventionalGenerationState.generate(bCELCodeGenerationHelper, this, instructionListBuilder);
    }

    public void generateFreeBindings(Instruction instruction, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        HashSet hashSet = new HashSet();
        instruction.accumulateNonLiteralFreeBindings(hashSet, this.m_bindingEnvironment);
        for (IBinding iBinding : hashSet) {
            this.generateConventionally(iBinding, dataFlowCodeGenerationHelper, false);
        }
    }

    public boolean isTheBindingDefinedOutsideLoop(IBinding iBinding) {
        Instruction instruction;
        HashSet hashSet = new HashSet();
        Instruction instruction2 = instruction = this.m_loops.isEmpty() ? null : (Instruction)this.m_loops.peek();
        if (instruction != null) {
            instruction.accumulateNonLiteralFreeBindings(hashSet, this.m_bindingEnvironment);
            if (!hashSet.isEmpty()) {
                for (IBinding iBinding2 : hashSet) {
                    if (iBinding2 != iBinding) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void generateFreeBindings(Instruction instruction, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, IBinding iBinding) {
        HashSet hashSet = new HashSet();
        instruction.accumulateNonLiteralFreeBindings(hashSet, this.m_bindingEnvironment);
        for (IBinding iBinding2 : hashSet) {
            if (iBinding2 == iBinding) continue;
            this.generateConventionally(iBinding2, bCELCodeGenerationHelper, instructionListBuilder);
        }
    }

    public void generateAddToStream(Instruction instruction, String string, StreamType streamType, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, boolean bl) {
        if (instruction instanceof IdentifierInstruction) {
            int n = CodeGenerationOptUtils.getStreamLength(instruction, this.m_bindingEnvironment);
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
            if (conventionalGenerationState == null) {
                throw new XylemError("ERR_SYSTEM", "Null CGS for ii=" + identifierInstruction);
            }
            if (conventionalGenerationState.isGenerated() || !(conventionalGenerationState instanceof StreamOptimizedGenerationState)) {
                String string2 = conventionalGenerationState.generate(dataFlowCodeGenerationHelper, this, false);
                StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2, n);
            } else {
                ((StreamOptimizedGenerationState)conventionalGenerationState).generateAddToStream(dataFlowCodeGenerationHelper, this, string, bl, n);
            }
        } else if (instruction.supportsCodeGenerationOptimization(StreamOptimizationStyle.s_streamOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
            ((IStreamOptimizationInstruction)((Object)instruction)).generateCodeWithStreamOptimization(dataFlowCodeGenerationHelper, string, this, bl);
        } else {
            String string3 = instruction.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, this, null, false);
            int n = CodeGenerationOptUtils.getStreamLength(instruction, this.m_bindingEnvironment);
            StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string3, n);
        }
    }

    public void generateAddToStream(Instruction instruction, int[] nArray, InstructionListBuilder instructionListBuilder, StreamType streamType, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionHandle instructionHandle) {
        int n = CodeGenerationOptUtils.getStreamLength(instruction, this.m_bindingEnvironment);
        if (instruction instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            ConventionalGenerationState conventionalGenerationState = (ConventionalGenerationState)this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
            if (conventionalGenerationState == null) {
                throw new RuntimeException();
            }
            if (conventionalGenerationState.isGenerated() || !(conventionalGenerationState instanceof StreamOptimizedGenerationState)) {
                int n2 = conventionalGenerationState.generate(bCELCodeGenerationHelper, this, instructionListBuilder);
                StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, streamType, this, n2, n);
            } else {
                ((StreamOptimizedGenerationState)conventionalGenerationState).generateAddToStream(bCELCodeGenerationHelper, this, nArray, instructionHandle, instructionListBuilder, n);
            }
        } else if (instruction.supportsCodeGenerationOptimization(StreamOptimizationStyle.s_streamOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
            ((IStreamOptimizationInstruction)((Object)instruction)).generateCodeWithStreamOptimization(bCELCodeGenerationHelper, instructionListBuilder, nArray, this, instructionHandle);
        } else {
            instruction.generateCode(bCELCodeGenerationHelper, this, null, null, instructionListBuilder);
            StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, streamType, this, -1, n);
        }
    }

    public String generateAddToStreamInADT(Instruction instruction, String string, Binding binding, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, boolean bl) {
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
        GenerationState generationState = this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
        try {
            if (!(generationState instanceof StreamInADTOptimizedGenerationState) && ((ConventionalGenerationState)generationState).getNumDependencies() == 1 && ((ConventionalGenerationState)generationState).m_instruction.supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
                Instruction instruction2 = ((ConventionalGenerationState)generationState).m_instruction;
                return ((IStreamInADTOptimizationInstruction)((Object)instruction2)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string, binding, this, ((IStreamInADTOptimizationInstruction)((Object)instruction2)).canGenerateObjectless(this.m_typeEnvironment), bl);
            }
            StreamInADTOptimizedGenerationState streamInADTOptimizedGenerationState = (StreamInADTOptimizedGenerationState)generationState;
            if (streamInADTOptimizedGenerationState.isGenerated()) {
                System.err.println(">> adt opt could not occur unfortunately");
                String string2 = streamInADTOptimizedGenerationState.generate(dataFlowCodeGenerationHelper, this, false);
                StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, (StreamType)streamInADTOptimizedGenerationState.m_binding.getBindingType(), "x.m_" + binding.getName().toString());
                return string2;
            }
            if (!streamInADTOptimizedGenerationState.m_member.getName().equals(binding.getName().toString())) {
                throw new XylemError("ERR_SYSTEM", "Add to stream in ADT called for a member that was not expected");
            }
            return streamInADTOptimizedGenerationState.generateAddToStreamInADT(dataFlowCodeGenerationHelper, this, string, bl);
        }
        catch (ClassCastException classCastException) {
            s_logger.debug("could not generate stream-in-adt state for " + identifierInstruction + " ");
            throw classCastException;
        }
    }

    public void generateAddToStreamInADT(Instruction instruction, int[] nArray, Binding binding, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
        GenerationState generationState = this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
        StreamInADTOptimizedGenerationState streamInADTOptimizedGenerationState = (StreamInADTOptimizedGenerationState)generationState;
        if (streamInADTOptimizedGenerationState.isGenerated()) {
            System.err.println(">> adt opt could not occur unfortunately");
            streamInADTOptimizedGenerationState.generate(bCELCodeGenerationHelper, this, null, instructionListBuilder);
            instructionListBuilder.appendDUP();
            NamedType namedType = (NamedType)this.resolveType(instruction);
            AbstractDataType.Constructor constructor = namedType.resolveNameToADT((Module)this.getCurrentModule()).m_constructors[0];
            instructionListBuilder.appendGetField(constructor, constructor.findBinding(binding), bCELCodeGenerationHelper);
            StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, (StreamType)streamInADTOptimizedGenerationState.m_binding.getBindingType(), this, -1);
        } else if (!streamInADTOptimizedGenerationState.m_member.equals(binding)) {
            throw new XylemError("ERR_SYSTEM", "Add to stream in ADT called for a member that was not expected");
        }
        streamInADTOptimizedGenerationState.generateAddToStreamInADT(bCELCodeGenerationHelper, this, nArray, instructionHandle, instructionListBuilder);
    }

    public boolean isADTBindingGeneratedObjectless(Instruction instruction) {
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
        GenerationState generationState = this.getGenerationState(identifierInstruction.getBinding(this.m_bindingEnvironment));
        if (!(generationState instanceof StreamInADTOptimizedGenerationState)) {
            return false;
        }
        StreamInADTOptimizedGenerationState streamInADTOptimizedGenerationState = (StreamInADTOptimizedGenerationState)generationState;
        return streamInADTOptimizedGenerationState.isObjectless();
    }

    public Type resolveType(Instruction instruction) {
        return instruction.getType(this.m_typeEnvironment, this.m_bindingEnvironment).resolveType(this.m_typeEnvironment);
    }

    public Module getCurrentModule() {
        return this.m_typeEnvironment.getModule();
    }

    public com.ibm.xtq.bcel.generic.Type[] makeBCELTypeArray(BCELCodeGenerationHelper bCELCodeGenerationHelper, Instruction[] instructionArray) {
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            typeArray[i] = this.resolveType(instructionArray[i]).getImplementationType(bCELCodeGenerationHelper);
        }
        return typeArray;
    }
}

