/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xtq.xml.types.ChoiceType;
import com.ibm.xtq.xml.types.NodeType;
import com.ibm.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.XSequenceType;
import com.ibm.xtq.xslt.translator.FunctionDeclaration;
import com.ibm.xtq.xslt.translator.SimpleFunctionDeclaration;
import java.util.ArrayList;

public class PolymorphicFunctionDeclaration
extends FunctionDeclaration {
    private String m_functionName;
    private ArrayList m_declarationEntries = new ArrayList();
    private Type m_returnType = null;
    private String m_signature = null;
    private boolean[] m_polyArguments = null;
    private Boolean m_polyReturnType = null;

    public PolymorphicFunctionDeclaration(String string, int n) {
        this.m_functionName = string;
        this.m_arity = n;
    }

    public PolymorphicFunctionDeclaration(String string, int n, SimpleFunctionDeclaration simpleFunctionDeclaration) {
        this.m_functionName = string;
        this.m_arity = n;
        this.m_declarationEntries.add(simpleFunctionDeclaration);
    }

    public void addDeclarationEntry(SimpleFunctionDeclaration simpleFunctionDeclaration) {
        this.m_declarationEntries.add(simpleFunctionDeclaration);
    }

    @Override
    public String getFunctionName() {
        return this.m_functionName;
    }

    public int getNumberOfDeclarations() {
        return this.m_declarationEntries.size();
    }

    public SimpleFunctionDeclaration getDeclarationEntry(int n) {
        if (n >= 0 && n < this.m_declarationEntries.size()) {
            return (SimpleFunctionDeclaration)this.m_declarationEntries.get(n);
        }
        return null;
    }

    public boolean isPolymorphicArgument(int n) {
        if (this.m_polyArguments == null) {
            this.m_polyArguments = new boolean[this.m_arity];
            if (this.m_declarationEntries.size() >= 2) {
                SimpleFunctionDeclaration simpleFunctionDeclaration = this.getDeclarationEntry(0);
                SimpleFunctionDeclaration simpleFunctionDeclaration2 = this.getDeclarationEntry(1);
                for (int i = 0; i < this.m_arity; ++i) {
                    this.m_polyArguments[i] = simpleFunctionDeclaration.getArgumentType(i) != simpleFunctionDeclaration2.getArgumentType(i);
                }
            }
        }
        if (n >= 0 && n < this.m_arity) {
            return this.m_polyArguments[n];
        }
        return false;
    }

    public boolean isPolymorphicReturnType() {
        if (this.m_polyReturnType == null) {
            XSequenceType xSequenceType;
            XSequenceType xSequenceType2;
            this.m_polyReturnType = this.m_declarationEntries.size() >= 2 ? ((xSequenceType2 = this.getDeclarationEntry(0).getReturnType()).equals(xSequenceType = this.getDeclarationEntry(1).getReturnType()) ? Boolean.FALSE : Boolean.TRUE) : Boolean.FALSE;
        }
        return this.m_polyReturnType;
    }

    public Type getReturnType() {
        if (this.m_returnType == null) {
            int n = this.m_declarationEntries.size();
            ChoiceType choiceType = new ChoiceType();
            for (int i = 0; i < n; ++i) {
                SimpleFunctionDeclaration simpleFunctionDeclaration = (SimpleFunctionDeclaration)this.m_declarationEntries.get(i);
                choiceType.addType(simpleFunctionDeclaration.getReturnType());
            }
            this.m_returnType = choiceType;
        }
        return this.m_returnType;
    }

    @Override
    public String getRuntimeReturnType() {
        if (this.isPolymorphicReturnType()) {
            XSequenceType xSequenceType = this.getDeclarationEntry(0).getReturnType();
            OccurrenceIndicator occurrenceIndicator = xSequenceType.getQuantifier();
            if (occurrenceIndicator == OccurrenceIndicator.ONE || occurrenceIndicator == OccurrenceIndicator.ZERO_OR_ONE) {
                return "com.ibm.xtq.xml.datamodel.XItem";
            }
            return "com.ibm.xtq.xml.datamodel.XSequence";
        }
        return this.getDeclarationEntry(0).getRuntimeReturnType();
    }

    @Override
    public String getRuntimeArgumentType(int n) {
        if (this.isPolymorphicArgument(n)) {
            return "com.ibm.xtq.xml.datamodel.XSequence";
        }
        return this.getDeclarationEntry(0).getRuntimeArgumentType(n);
    }

    @Override
    public XSequenceType getArgumentType(int n) {
        if (this.isPolymorphicArgument(n)) {
            return null;
        }
        return this.getDeclarationEntry(0).getArgumentType(n);
    }

    public boolean hasNodeArguments() {
        SimpleFunctionDeclaration simpleFunctionDeclaration = this.getDeclarationEntry(0);
        if (simpleFunctionDeclaration != null) {
            XSequenceType xSequenceType = simpleFunctionDeclaration.getArgumentType(0);
            return xSequenceType.getBaseType() instanceof NodeType;
        }
        return false;
    }
}

