/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax;

import com.ibm.xml.jaxp.util.ExternalResourceHelper;
import com.ibm.xml.xlxp.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.api.stax.StAXDTDScanner;
import com.ibm.xml.xlxp.api.stax.StAXImplConstants;
import com.ibm.xml.xlxp.api.stax.StAXReaderToWriter;
import com.ibm.xml.xlxp.api.stax.XMLInputFactoryImpl;
import com.ibm.xml.xlxp.api.stax.XMLStreamExceptionWrapper;
import com.ibm.xml.xlxp.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.api.util.Pool;
import com.ibm.xml.xlxp.api.util.SimpleDTDScannerHelper;
import com.ibm.xml.xlxp.api.util.SimplePositionHelper;
import com.ibm.xml.xlxp.api.util.SymbolStringMappings;
import com.ibm.xml.xlxp.scan.DTDScannerHelper;
import com.ibm.xml.xlxp.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.DocumentPosition;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.PositionHelper;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLStreamReaderImpl
extends SimpleDTDScannerHelper
implements XMLStreamReader,
EntityResolver,
Pool.Poolable {
    private static final int NO_EVENT = -1;
    private Pool.PoolableHelper fPoolableHelper = new Pool.PoolableHelper(this);
    protected StAXReaderToWriter fReaderToWriter;
    protected XMLInputFactoryImpl.Properties fProperties;
    protected SymbolStringMappings fSymbolStrings;
    protected StAXDTDScanner fDTDScanner;
    protected SAX2ParsedEntityFactory fEntityFactory;
    protected int fEventType;
    protected int fNextEventType;
    protected String[] fActualEncoding;
    protected boolean fUserSpecifiedEncoding;
    protected char[][] fCharacters = new char[1][];
    protected int[] fCharactersOffset;
    protected int fCharactersLength;
    protected Location fLocation;
    protected StAXNamespaceContext fStAXNamespaceContext;
    protected String fPublicId;
    protected String fSystemId;
    protected ExternalResourceHelper.ProtocolValidator fDTDProtocolValidator;
    private XMLStringBuffer fStringBuffer;
    private XMLString fBufferedContent;
    private int fBufferedContentType;
    private int fBufferedNSContext;
    private char[] fSurrogatePair;
    private boolean fHasBufferedContent;
    private boolean fHasCoalescedContent;
    private boolean fIsSingleCharacter;
    private boolean fIsEmptyElement;
    private PositionHelper fPositionHelper;
    private DocumentPosition fDocumentPosition;
    private boolean fShouldCoalesce;

    public XMLStreamReaderImpl(InputSource inputSource, XMLInputFactoryImpl.Properties properties) throws XMLStreamException {
        this.fCharacters[0] = new char[1024];
        this.fCharactersOffset = new int[1];
        this.fSurrogatePair = new char[2];
        this.fActualEncoding = new String[1];
        this.fSymbolStrings = new SymbolStringMappings(this.fSymbolTable);
        this.fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        this.fDTDScanner = new StAXDTDScanner((DTDScannerHelper)this, this.fDocumentEntityScanner, this.fBufferFactory, this.fSymbolTable, this.fEntityFactory);
        this.fStringBuffer = new XMLStringBuffer(this.fBufferFactory);
        this.fBufferedContent = new XMLString();
        if (StAXImplConstants.JAXP15_SUPPORT) {
            this.fDTDProtocolValidator = ExternalResourceHelper.getDTDProtocolValidator(new ExternalResourceHelper.ProtocolValidatorErrorHandler(){

                @Override
                public void reportError(String string, String string2, String[] stringArray) {
                    XMLStreamReaderImpl.this.setParameter(0, string);
                    XMLStreamReaderImpl.this.setParameter(1, string2);
                    XMLStreamReaderImpl.this.reportFatalError("http://jcp.org/en/jsr/detail?id=173", 55);
                }
            });
        }
        this.setDocumentEntity(inputSource, properties);
    }

    @Override
    public void reset(boolean bl) {
        super.reset(bl);
        this.fSymbolStrings.reset(bl);
        this.fDTDScanner.reset(bl);
        this.fEntityFactory.reset(bl);
        this.fBufferedContent.clear();
        this.fBufferFactory.reset(bl);
    }

    @Override
    public void dropBufferReferences() {
        if (this.fHasBufferedContent || this.fHasCoalescedContent) {
            return;
        }
        if ((this.fCleanupFlags & 0x100) != 0) {
            this.fDTDScanner.dropBufferReferences();
        }
        super.dropBufferReferences();
    }

    public void setDocumentEntity(InputSource inputSource, XMLInputFactoryImpl.Properties properties) throws XMLStreamException {
        if (properties != this.fProperties) {
            this.setProperties(properties);
        }
        this.fActualEncoding[0] = null;
        ParsedEntity parsedEntity = null;
        try {
            parsedEntity = this.fEntityFactory.createParsedEntity(inputSource, this.fActualEncoding);
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            StAXMessageProvider.throwXMLStreamException(iOExceptionWrapper.getIOException());
        }
        if (parsedEntity.error != null) {
            StAXMessageProvider.throwXMLStreamException(parsedEntity.error.exception);
        }
        this.fUserSpecifiedEncoding = inputSource.getEncoding() != null || inputSource.getCharacterStream() != null;
        this.fPublicId = inputSource.getPublicId();
        this.fSystemId = inputSource.getSystemId();
        this.fHasBufferedContent = false;
        this.fHasCoalescedContent = false;
        this.fShouldCoalesce = this.fProperties.isCoalescing;
        this.fIsSingleCharacter = false;
        this.fIsEmptyElement = false;
        this.fEventType = -1;
        this.fEncName.length = 0;
        this.fVersion.length = 0;
        super.setDocumentEntity(parsedEntity);
        this.next();
    }

    private void setProperties(XMLInputFactoryImpl.Properties properties) {
        XMLInputFactoryImpl.Properties properties2 = this.fProperties;
        this.fProperties = properties;
        this.setNamespaceAwareness(this.fProperties.isNamespaceAware);
        this.fDTDScanner.setScanInternalGeneralEntities(this.fProperties.isReplacingEntityReferences);
        if (this.fProperties.isReplacingEntityReferences) {
            this.fDTDScanner.setScanExternalGeneralEntities(this.fProperties.isSupportingExternalEntities);
            this.fDTDScanner.setScanExternalParameterEntities(this.fProperties.isSupportingExternalEntities);
        } else {
            this.fDTDScanner.setScanExternalGeneralEntities(false);
            this.fDTDScanner.setScanExternalParameterEntities(false);
        }
        this.fDTDScanner.setSupportDTD(this.fProperties.supportDTD);
        this.fDTDScanner.setResolveDTDURIs("http://xml.org/sax/features/resolve-dtd-uris", this.fProperties.resolveDTDURIs);
        if (!StAXImplConstants.JAXP15_SUPPORT) {
            if (this.fProperties.resolver != null) {
                this.fEntityFactory.setEntityResolver(this);
            } else {
                this.fEntityFactory.setEntityResolver(null);
            }
        } else {
            String string;
            String string2 = properties2 != null ? properties2.externalDTDPropertyValue : null;
            if (!(string2 == (string = this.fProperties.externalDTDPropertyValue) || string2 != null && string2.equals(string))) {
                this.fDTDProtocolValidator.setAllowedProtocols(string);
            }
            if (this.fProperties.resolver != null) {
                if (!this.fDTDProtocolValidator.allowsAll()) {
                    this.fEntityFactory.setEntityResolver(new XMLProtocolChecker(this));
                } else {
                    this.fEntityFactory.setEntityResolver(this);
                }
            } else if (!this.fDTDProtocolValidator.allowsAll()) {
                this.fEntityFactory.setEntityResolver(new XMLProtocolChecker(null));
            } else {
                this.fEntityFactory.setEntityResolver(null);
            }
        }
        this.fEntityFactory.setCoordinatesAware(this.fProperties.isSupportingLocationCoordinates);
    }

    @Override
    public Pool.PoolableHelper getPoolableHelper() {
        return this.fPoolableHelper;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        try {
            Object object = this.fProperties.resolver.resolveEntity(string, string2, null, null);
            if (object == null) {
                return null;
            }
            if (object instanceof InputStream) {
                return new InputSource((InputStream)object);
            }
            if (object instanceof XMLStreamReader) {
                if (this.fReaderToWriter == null) {
                    this.fReaderToWriter = new StAXReaderToWriter();
                }
                return this.fReaderToWriter.toInputSource((XMLStreamReader)object);
            }
            if (object instanceof XMLEventReader) {
                if (this.fReaderToWriter == null) {
                    this.fReaderToWriter = new StAXReaderToWriter();
                }
                return this.fReaderToWriter.toInputSource((XMLEventReader)object);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StAXMessageProvider.throwXMLStreamExceptionWrapper(xMLStreamException);
        }
        return null;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        if (string != null) {
            if (string.equals("javax.xml.stream.isInterning")) {
                return Boolean.TRUE;
            }
            if (this.fEventType == 11) {
                if (string.equals("javax.xml.stream.notations")) {
                    return this.fDTDScanner.getNotationDecls();
                }
                if (string.equals("javax.xml.stream.entities")) {
                    return this.fDTDScanner.getEntityDecls();
                }
                if (string.equals("javax.xml.stream.dtd.processingInstructions")) {
                    return this.fDTDScanner.getPIsInDTD();
                }
                if (string.equals("javax.xml.stream.dtd.comments")) {
                    return this.fDTDScanner.getCommentsInDTD();
                }
                if (string.equals("javax.xml.stream.dtd.declaration")) {
                    XMLString xMLString = this.doctypeText();
                    return xMLString != null ? xMLString.toString() : null;
                }
                return null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 9));
        return null;
    }

    boolean isPropertySupported(String string) {
        if (string.equals("javax.xml.stream.isInterning")) {
            return true;
        }
        if (this.fEventType == 11) {
            return string.equals("javax.xml.stream.dtd.declaration") || string.equals("javax.xml.stream.notations") || string.equals("javax.xml.stream.entities") || string.equals("javax.xml.stream.dtd.processingInstructions") || string.equals("javax.xml.stream.dtd.comments");
        }
        return false;
    }

    @Override
    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
        } else if (this.isEmptyElement()) {
            this.fIsEmptyElement = false;
            this.fEventType = 2;
            return 2;
        }
        try {
            this.getNextScannerEvent();
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            StAXMessageProvider.throwXMLStreamException(iOExceptionWrapper.getIOException());
        }
        catch (XMLStreamExceptionWrapper xMLStreamExceptionWrapper) {
            throw xMLStreamExceptionWrapper.getXMLStreamException();
        }
        this.fCharactersLength = -1;
        return this.fEventType;
    }

    @Override
    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.fEventType == n) {
            if (string != null) {
                if (this.hasName()) {
                    if (string.length() == 0) {
                        if (this.getNamespaceURI() != null) {
                            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                        }
                    } else if (!string.equals(this.getNamespaceURI())) {
                        StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                    }
                } else {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 12, string, this.getNamespaceURI()));
                }
            }
            if (string2 != null) {
                if (this.hasName() || this.fEventType == 9) {
                    if (!string2.equals(this.getLocalName())) {
                        StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 13, string2, this.getLocalName()));
                    }
                } else {
                    StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 13, string2, ""));
                }
            }
        } else {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 11, new Integer(n), new Integer(this.fEventType)));
        }
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (!this.isStartElement()) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 14));
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.next()) == 4 || n == 12 || n == 6 || n == 9) {
                stringBuffer.append(this.getText());
                continue;
            }
            if (n != 5 && n != 3) break;
        }
        if (!this.isEndElement()) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 15));
        }
        return stringBuffer.toString();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int n;
        while ((n = this.next()) != 1 && n != 2) {
            if (n == 5 || n == 3 || n == 6 || n == 4 && this.isWhiteSpace()) continue;
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 16));
        }
        return n;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8;
    }

    @Override
    public void close() throws XMLStreamException {
        this.reset(true);
        this.fPoolableHelper.returnToPool();
    }

    @Override
    public String getNamespaceURI(String string) {
        int n;
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
        }
        if ((n = this.fSymbolStrings.addSymbol(string)) != 1) {
            int n2 = this.fNamespaceContext.prefixMapping(this.fNSContext, n);
            return this.fSymbolStrings.toString(n2);
        }
        return this.fSymbolStrings.toString(3);
    }

    @Override
    public boolean isStartElement() {
        return this.fEventType == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.fEventType == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6;
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.fEventType == 4) {
            if (this.isSingleCharacter()) {
                return this.fSingleCh == 32 || this.fSingleCh == 10 || this.fSingleCh == 9 || this.fSingleCh == 13;
            }
            return this.content().isAllWhitespace();
        }
        return this.fEventType == 6;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        if (this.fEventType == 1) {
            int n = string != null ? this.fSymbolStrings.addSymbol(string) : 0;
            int n2 = this.fSymbolStrings.addSymbol(string2);
            XMLString xMLString = this.getAttributeValue(n, n2);
            return xMLString != null ? xMLString.toString() : null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    @Override
    public int getAttributeCount() {
        if (this.fEventType == 1) {
            return this.fAttributeCount;
        }
        if (this.fEventType == 10) {
            return -1;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return -1;
    }

    @Override
    public javax.xml.namespace.QName getAttributeName(int n) {
        if (this.fEventType == 1) {
            return this.createQName(this.attributeName(n));
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    @Override
    public String getAttributeNamespace(int n) {
        if (this.fIsNamespaceAware) {
            if (this.fEventType == 1) {
                int n2 = this.attributeName((int)n).nsHandle;
                return n2 != 0 ? this.fSymbolStrings.toString(n2) : null;
            }
            if (this.fEventType == 10) {
                return null;
            }
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }
        if (this.fEventType == 1) {
            return null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    @Override
    public String getAttributeLocalName(int n) {
        if (this.fIsNamespaceAware) {
            if (this.fEventType == 1) {
                return this.fSymbolStrings.toString(this.attributeName((int)n).localHandle);
            }
            if (this.fEventType == 10) {
                return null;
            }
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }
        if (this.fEventType == 1) {
            return this.fSymbolStrings.toString(this.attributeName((int)n).handle);
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    @Override
    public String getAttributePrefix(int n) {
        if (this.fIsNamespaceAware) {
            if (this.fEventType == 1) {
                int n2 = this.attributeName((int)n).prefixHandle;
                return n2 != 0 ? this.fSymbolStrings.toString(n2) : null;
            }
            if (this.fEventType == 10) {
                return null;
            }
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
            return null;
        }
        if (this.fEventType == 1) {
            return null;
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    @Override
    public String getAttributeType(int n) {
        if (this.fEventType == 1) {
            int n2 = this.attributeType(n);
            return n2 != 0 ? this.fSymbolStrings.toString(n2) : "CDATA";
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    @Override
    public String getAttributeValue(int n) {
        if (this.fEventType == 1) {
            return this.normalizedAttributeValue(n).toString();
        }
        if (this.fEventType == 10) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return null;
    }

    @Override
    public boolean isAttributeSpecified(int n) {
        if (this.fEventType == 1) {
            return this.attributeSpecified(n);
        }
        if (this.fEventType == 10) {
            return false;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 17));
        return false;
    }

    @Override
    public int getNamespaceCount() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fNSDecls.nsDeclCount();
        }
        if (this.fEventType == 13) {
            return -1;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return -1;
    }

    @Override
    public String getNamespacePrefix(int n) {
        if (this.fEventType == 1 || this.fEventType == 2) {
            int n2 = this.fNSDecls.nsDeclPrefix(n);
            return n2 != 0 ? this.fSymbolStrings.toString(n2) : null;
        }
        if (this.fEventType == 13) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return null;
    }

    @Override
    public String getNamespaceURI(int n) {
        if (this.fEventType == 1 || this.fEventType == 2) {
            int n2 = this.fNSDecls.nsDeclURI(n);
            return this.fSymbolStrings.toString(n2);
        }
        if (this.fEventType == 13) {
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 18));
        return null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this.fStAXNamespaceContext == null) {
            this.fStAXNamespaceContext = new StAXNamespaceContext();
        }
        if (this.fEventType != 8) {
            this.fStAXNamespaceContext.setNSContext(this.fNSContext);
        }
        return this.fStAXNamespaceContext;
    }

    @Override
    public int getEventType() {
        return this.fEventType;
    }

    @Override
    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6) {
            if (this.isSingleCharacter()) {
                if (this.fSingleCh < 65536) {
                    return String.valueOf((char)this.fSingleCh);
                }
                int n = this.fSingleCh - 65536;
                this.fSurrogatePair[0] = (char)(55296 + (n >> 10));
                this.fSurrogatePair[1] = (char)(56320 + (n & 0x3FF));
                return new String(this.fSurrogatePair);
            }
            return this.content().toString();
        }
        if (this.fEventType == 5) {
            return this.fContent.toString();
        }
        if (this.fEventType == 11) {
            XMLString xMLString = this.internalSubsetText();
            return xMLString != null ? xMLString.toString() : null;
        }
        if (this.fEventType == 9) {
            XMLString xMLString = this.entityText(this.fEntityName);
            return xMLString != null ? xMLString.toString() : null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    @Override
    public char[] getTextCharacters() {
        if (this.fCharactersLength >= 0) {
            return this.fCharacters[0];
        }
        if (this.hasTextXXX()) {
            if (this.getCharacters()) {
                return this.fCharacters[0];
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    @Override
    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this.fCharactersLength >= 0) {
            char[] cArray2 = this.fCharacters[0];
            int n4 = this.fCharactersLength - n;
            if (n4 < n3) {
                n3 = n4;
            }
            System.arraycopy(cArray2, n, cArray, n2, n3);
            return n3;
        }
        if (this.hasTextXXX()) {
            if (this.getCharacters()) {
                char[] cArray3 = this.fCharacters[0];
                int n5 = this.fCharactersLength - n;
                if (n5 < n3) {
                    n3 = n5;
                }
                System.arraycopy(cArray3, n, cArray, n2, n3);
                return n3;
            }
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    @Override
    public int getTextStart() {
        if (this.fCharactersLength >= 0 || this.hasTextXXX()) {
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    @Override
    public int getTextLength() {
        if (this.fCharactersLength >= 0) {
            return this.fCharactersLength;
        }
        if (this.hasTextXXX()) {
            if (this.getCharacters()) {
                return this.fCharactersLength;
            }
            return 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return -1;
    }

    @Override
    public String getEncoding() {
        if (this.fEventType == 7) {
            if (this.fUserSpecifiedEncoding) {
                return this.fActualEncoding[0];
            }
            if (this.fEncName.length != 0) {
                return this.fEncName.toString();
            }
            return this.fActualEncoding[0];
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    @Override
    public boolean hasText() {
        return this.hasTextXXX() || this.fEventType == 11 || this.fEventType == 9;
    }

    @Override
    public Location getLocation() {
        if (this.fLocation == null) {
            this.fDocumentPosition = new DocumentPosition();
            this.fLocation = new LocationImpl();
        }
        if (this.fProperties.isSupportingLocationCoordinates) {
            if (this.fPositionHelper == null) {
                this.fPositionHelper = new SimplePositionHelper();
            }
            this.fPositionHelper.setCurrentExternalEntity(this.fCurrentEntity);
            this.fPositionHelper.getCurrentPosition(this.fDocumentPosition);
        } else {
            this.fDocumentPosition.lineNumber = -1;
            this.fDocumentPosition.columnNumber = -1;
            this.fDocumentPosition.byteOffset = -1;
        }
        return this.fLocation;
    }

    @Override
    public javax.xml.namespace.QName getName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.createQName(this.fElementType);
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    @Override
    public String getLocalName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fSymbolStrings.toString(this.fElementType.localHandle);
        }
        if (this.fEventType == 9) {
            return this.fEntityName.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 22));
        return null;
    }

    @Override
    public boolean hasName() {
        return this.fEventType == 1 || this.fEventType == 2;
    }

    @Override
    public String getNamespaceURI() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            int n = this.fElementType.nsHandle;
            if (this.fIsNamespaceAware) {
                return n != 0 ? this.fSymbolStrings.toString(n) : null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    @Override
    public String getPrefix() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            int n = this.fElementType.prefixHandle;
            if (this.fIsNamespaceAware) {
                return n != 0 ? this.fSymbolStrings.toString(n) : null;
            }
            return null;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 21));
        return null;
    }

    @Override
    public String getVersion() {
        if (this.fEventType == 7) {
            return this.fVersion.length == 0 ? null : this.fVersion.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    @Override
    public boolean isStandalone() {
        if (this.fEventType == 7) {
            return this.fStandalone.length > 0 && "yes".equals(this.fStandalone.toString());
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return false;
    }

    @Override
    public boolean standaloneSet() {
        if (this.fEventType == 7) {
            return this.fStandalone.length > 0;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        if (this.fEventType == 7) {
            return this.fEncName.length == 0 ? null : this.fEncName.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 20));
        return null;
    }

    @Override
    public String getPITarget() {
        if (this.fEventType == 3) {
            return this.fTarget.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
        return null;
    }

    @Override
    public String getPIData() {
        if (this.fEventType == 3) {
            return this.fContent.toString();
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 23));
        return null;
    }

    private void getNextScannerEvent() {
        if (this.fHasBufferedContent || this.fHasCoalescedContent) {
            this.fHasBufferedContent = false;
            this.fHasCoalescedContent = false;
            this.setCurrentEvent(this.fNextEventType);
            this.swapContents();
            return;
        }
        if (this.fCurrentEntity.loadCalled) {
            this.fCurrentEntity.loadCalled = false;
            if (this.fCleanupFlags != 0) {
                this.dropBufferReferences();
            }
        }
        this.fEventType = -1;
        while (this.fEventType == -1) {
            this.fDocumentEntityScanner.produceEvent();
        }
        if (this.fHasBufferedContent || this.fHasCoalescedContent) {
            this.fHasBufferedContent = true;
            this.fNextEventType = this.fEventType;
            this.swapContents();
            this.setCurrentEvent(this.fBufferedContentType);
        }
    }

    private javax.xml.namespace.QName createQName(QName qName) {
        String string = this.fSymbolStrings.toString(qName.nsHandle);
        String string2 = this.fSymbolStrings.toString(qName.localHandle);
        String string3 = this.fSymbolStrings.toString(qName.prefixHandle);
        return new javax.xml.namespace.QName(string, string2, string3);
    }

    private String getErrorMessage() {
        StAXMessageProvider.loadMessageProvider();
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.fErrorURI);
        int n = this.fErrorParamsCount;
        Object[] objectArray = new XMLString[n];
        while (n-- > 0) {
            objectArray[n] = this.fErrorParams[n];
        }
        String string = messageProvider.createMessage(null, this.fErrorCode, objectArray);
        return string;
    }

    private boolean isEmptyElement() {
        return !this.fHasBufferedContent && this.fIsEmptyElement;
    }

    private boolean isSingleCharacter() {
        return !this.fHasBufferedContent && this.fIsSingleCharacter;
    }

    private boolean hasTextXXX() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 5 || this.fEventType == 6;
    }

    private boolean getCharacters() {
        if (this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6) {
            if (this.isSingleCharacter()) {
                if (this.fSingleCh < 65536) {
                    this.fCharacters[0][0] = (char)this.fSingleCh;
                    this.fCharactersLength = 1;
                } else {
                    int n = this.fSingleCh - 65536;
                    this.fCharacters[0][0] = (char)(55296 + (n >> 10));
                    this.fCharacters[0][1] = (char)(56320 + (n & 0x3FF));
                    this.fCharactersLength = 2;
                }
                return true;
            }
            this.fCharactersOffset[0] = 0;
            this.content().getChars(this.fCharacters, this.fCharactersOffset);
            this.fCharactersLength = this.fCharactersOffset[0];
            return true;
        }
        if (this.fEventType == 5) {
            this.fCharactersOffset[0] = 0;
            this.fContent.getChars(this.fCharacters, this.fCharactersOffset);
            this.fCharactersLength = this.fCharactersOffset[0];
            return true;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 25));
        return false;
    }

    private XMLString internalSubsetText() {
        return this.fDTDScanner.getInternalSubsetString();
    }

    private XMLString doctypeText() {
        return this.fDTDScanner.getDoctypeString();
    }

    protected XMLString entityText(XMLString xMLString) {
        int n = this.fDTDScanner.lookupEntity(xMLString);
        if (n != -1) {
            return this.fDTDScanner.getInternalEntityContent(n);
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 24));
        return null;
    }

    public XMLString getAttributeValue(int n, int n2) {
        if (this.fIsNamespaceAware) {
            for (int i = 0; i < this.fAttributeCount; ++i) {
                QName qName = this.attributeName(i);
                if (n2 != qName.localHandle || n != qName.nsHandle) continue;
                return this.normalizedAttributeValue(i);
            }
        } else {
            for (int i = 0; i < this.fAttributeCount; ++i) {
                QName qName = this.attributeName(i);
                if (n2 != qName.handle) continue;
                return this.normalizedAttributeValue(i);
            }
        }
        return null;
    }

    private XMLString content() {
        if (this.fHasCoalescedContent) {
            this.fStringBuffer.setStringValues(1, this.fStringBuffer.getOffset(), this.fContent);
            this.fHasCoalescedContent = false;
        }
        return this.fContent;
    }

    private QName attributeName(int n) {
        if (n >= 0 && n < this.fAttributeCount) {
            return this.fAttributeNames[n];
        }
        this.throwAIOOBException("attributeName");
        return null;
    }

    private int attributeType(int n) {
        if (n >= 0 && n < this.fAttributeCount) {
            return this.fAttributeTypes[n];
        }
        this.throwAIOOBException("attributeType");
        return -1;
    }

    private XMLString normalizedAttributeValue(int n) {
        if (n >= 0 && n < this.fAttributeCount) {
            if (!this.fAttributeValueNormalized[n]) {
                this.fStringBuffer.normalizeTextValue(this.fAttributeValues[n], null);
                this.fAttributeValueNormalized[n] = true;
            }
            return this.fAttributeValues[n];
        }
        this.throwAIOOBException("normalizedAttributeValue");
        return null;
    }

    private boolean attributeSpecified(int n) {
        if (n >= 0 && n < this.fAttributeCount) {
            if (!this.fHasDefaultAttributes) {
                return true;
            }
            return this.fAttributeSpecified[n];
        }
        this.throwAIOOBException("attributeSpecified");
        return false;
    }

    private void throwAIOOBException(String string) {
        throw new ArrayIndexOutOfBoundsException(string);
    }

    public NSDeclList nsDeclList() {
        return this.fNSDecls;
    }

    public AttrList attrList() {
        return this.fAttributes;
    }

    private void setCurrentEvent(int n) {
        this.fEventType = n;
    }

    private void startCoalescing(boolean bl) {
        this.fHasCoalescedContent = true;
        this.fStringBuffer.reset(true);
        if (bl) {
            this.fBufferedContentType = 4;
            if (this.fHasBufferedContent) {
                this.fHasBufferedContent = false;
                this.fStringBuffer.appendXMLString(this.fBufferedContent);
            }
        }
    }

    private void swapContents() {
        XMLString xMLString = this.fContent;
        this.fContent = this.fBufferedContent;
        this.fBufferedContent = xMLString;
        int n = this.fNSContext;
        this.fNSContext = this.fBufferedNSContext;
        this.fBufferedNSContext = n;
    }

    @Override
    public boolean produceStartDocumentEvent() {
        super.produceStartDocumentEvent();
        this.setCurrentEvent(7);
        return false;
    }

    @Override
    public boolean produceEndDocumentEvent() {
        super.produceEndDocumentEvent();
        this.setCurrentEvent(8);
        return false;
    }

    @Override
    public boolean produceEmptyElementEvent() {
        super.produceEmptyElementEvent();
        this.fIsEmptyElement = true;
        this.setCurrentEvent(1);
        return false;
    }

    @Override
    public boolean produceStartElementEvent() {
        super.produceStartElementEvent();
        this.setCurrentEvent(1);
        return false;
    }

    public boolean produceLeafElementEvent() {
        this.setCurrentEvent(-1);
        return false;
    }

    @Override
    public boolean produceEndElementEvent(QName qName) {
        super.produceEndElementEvent(qName);
        this.setCurrentEvent(2);
        return false;
    }

    @Override
    public boolean produceCharactersEvent() {
        super.produceCharactersEvent();
        return this.processCharactersOrWhitespaceEvent(4);
    }

    @Override
    public boolean produceWhitespaceEvent() {
        super.produceWhitespaceEvent();
        return this.processCharactersOrWhitespaceEvent(6);
    }

    private boolean processCharactersOrWhitespaceEvent(int n) {
        if (this.fHasCoalescedContent) {
            this.fStringBuffer.appendXMLString(this.fContent);
            return true;
        }
        if (!this.fHasBufferedContent && !this.fProperties.isSupportingLocationCoordinates) {
            this.fHasBufferedContent = true;
            this.fBufferedContentType = n;
            this.swapContents();
            return true;
        }
        if (this.fShouldCoalesce) {
            this.startCoalescing(true);
            this.fStringBuffer.appendXMLString(this.fContent);
            return true;
        }
        this.fIsSingleCharacter = false;
        this.setCurrentEvent(n);
        return false;
    }

    @Override
    public boolean produceStartCDATASectionEvent() {
        super.produceStartCDATASectionEvent();
        if (!this.fProperties.isCoalescing) {
            this.fShouldCoalesce = true;
            this.startCoalescing(false);
        }
        return true;
    }

    @Override
    public boolean produceEndCDATASectionEvent() {
        super.produceEndCDATASectionEvent();
        if (this.fProperties.isCoalescing) {
            return true;
        }
        this.fIsSingleCharacter = false;
        this.fShouldCoalesce = false;
        this.fStringBuffer.setStringValues(1, this.fStringBuffer.getOffset(), this.fContent);
        this.fHasCoalescedContent = false;
        this.setCurrentEvent(12);
        return false;
    }

    @Override
    public boolean produceCharacterEvent(int n) {
        super.produceCharacterEvent(n);
        return this.processSingleCharacterEvent();
    }

    @Override
    public boolean producePredefinedEntityEvent(int n) {
        super.producePredefinedEntityEvent(n);
        return this.processSingleCharacterEvent();
    }

    private boolean processSingleCharacterEvent() {
        if (this.fHasCoalescedContent) {
            this.fStringBuffer.appendChar(this.fSingleCh);
            return true;
        }
        if (this.fShouldCoalesce) {
            this.startCoalescing(true);
            this.fStringBuffer.appendChar(this.fSingleCh);
            return true;
        }
        this.fIsSingleCharacter = true;
        this.setCurrentEvent(4);
        return false;
    }

    @Override
    public boolean produceProcessingInstructionEvent() {
        super.produceProcessingInstructionEvent();
        this.setCurrentEvent(3);
        return false;
    }

    @Override
    public boolean produceCommentEvent() {
        super.produceCommentEvent();
        this.setCurrentEvent(5);
        return false;
    }

    @Override
    public boolean produceWarningEvent(String string, int n) {
        super.produceWarningEvent(string, n);
        if (this.fProperties.reporter != null) {
            try {
                this.fProperties.reporter.report(this.getErrorMessage(), "WARNING", null, this.getLocation());
            }
            catch (XMLStreamException xMLStreamException) {
                StAXMessageProvider.throwXMLStreamExceptionWrapper(xMLStreamException);
            }
        }
        return true;
    }

    @Override
    public boolean produceRecoverableErrorEvent(String string, int n) {
        super.produceRecoverableErrorEvent(string, n);
        if (this.fProperties.reporter != null) {
            try {
                this.fProperties.reporter.report(this.getErrorMessage(), "RECOVERABLE_ERROR", null, this.getLocation());
            }
            catch (XMLStreamException xMLStreamException) {
                StAXMessageProvider.throwXMLStreamExceptionWrapper(xMLStreamException);
            }
        }
        return true;
    }

    @Override
    public boolean produceFatalErrorEvent(String string, int n) {
        super.produceFatalErrorEvent(string, n);
        StAXMessageProvider.throwWrappedXMLStreamException(this.getErrorMessage(), this.getLocation());
        return true;
    }

    @Override
    public boolean reportFatalError(String string, int n) {
        this.produceFatalErrorEvent(string, n);
        return true;
    }

    @Override
    public boolean produceDoctypeEvent(boolean bl) {
        super.produceDoctypeEvent(bl);
        this.setCurrentEvent(11);
        this.fCleanupFlags |= 0x100;
        return true;
    }

    @Override
    public boolean produceEntityReferenceEvent() {
        super.produceEntityReferenceEvent();
        this.setCurrentEvent(9);
        return false;
    }

    private class LocationImpl
    implements Location {
        private LocationImpl() {
        }

        @Override
        public int getLineNumber() {
            return ((XMLStreamReaderImpl)XMLStreamReaderImpl.this).fDocumentPosition.lineNumber;
        }

        @Override
        public int getColumnNumber() {
            return ((XMLStreamReaderImpl)XMLStreamReaderImpl.this).fDocumentPosition.columnNumber;
        }

        @Override
        public int getCharacterOffset() {
            return ((XMLStreamReaderImpl)XMLStreamReaderImpl.this).fDocumentPosition.byteOffset;
        }

        @Override
        public String getPublicId() {
            return XMLStreamReaderImpl.this.fPublicId;
        }

        @Override
        public String getSystemId() {
            return XMLStreamReaderImpl.this.fSystemId;
        }
    }

    private final class StAXNamespaceContext
    implements NamespaceContext {
        private int fXLXPNSContext;

        public void setNSContext(int n) {
            this.fXLXPNSContext = n;
        }

        @Override
        public String getNamespaceURI(String string) {
            int n;
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
            }
            if ((n = XMLStreamReaderImpl.this.fSymbolStrings.addSymbol(string)) != 1) {
                int n2 = XMLStreamReaderImpl.this.fNamespaceContext.prefixMapping(this.fXLXPNSContext, n);
                return XMLStreamReaderImpl.this.fSymbolStrings.toString(n2);
            }
            return XMLStreamReaderImpl.this.fSymbolStrings.toString(3);
        }

        @Override
        public String getPrefix(String string) {
            int n;
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
            }
            if ((n = XMLStreamReaderImpl.this.fSymbolStrings.addSymbol(string)) != 3) {
                int n2 = XMLStreamReaderImpl.this.fNamespaceContext.totalMappingsCount(this.fXLXPNSContext);
                int[] nArray = new int[n2 << 1];
                int n3 = XMLStreamReaderImpl.this.fNamespaceContext.inScopeNamespaces(this.fXLXPNSContext, nArray) << 1;
                for (int i = 0; i < n3; i += 2) {
                    if (nArray[i + 1] != n) continue;
                    return XMLStreamReaderImpl.this.fSymbolStrings.toString(nArray[i]);
                }
                return null;
            }
            return XMLStreamReaderImpl.this.fSymbolStrings.toString(1);
        }

        @Override
        public Iterator getPrefixes(String string) {
            if (string == null) {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
            }
            int n = XMLStreamReaderImpl.this.fSymbolStrings.addSymbol(string);
            HashSet<String> hashSet = new HashSet<String>();
            if (n != 3) {
                int n2 = XMLStreamReaderImpl.this.fNamespaceContext.totalMappingsCount(this.fXLXPNSContext);
                int[] nArray = new int[n2 << 1];
                int n3 = XMLStreamReaderImpl.this.fNamespaceContext.inScopeNamespaces(this.fXLXPNSContext, nArray) << 1;
                for (int i = 0; i < n3; i += 2) {
                    if (nArray[i + 1] != n) continue;
                    hashSet.add(XMLStreamReaderImpl.this.fSymbolStrings.toString(nArray[i]));
                }
            } else {
                hashSet.add(XMLStreamReaderImpl.this.fSymbolStrings.toString(1));
            }
            return hashSet.iterator();
        }
    }

    private class XMLProtocolChecker
    implements EntityResolver {
        private final EntityResolver child;

        public XMLProtocolChecker(EntityResolver entityResolver) {
            this.child = entityResolver;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            InputSource inputSource = null;
            if (this.child != null) {
                inputSource = this.child.resolveEntity(string, string2);
            }
            if (inputSource == null) {
                XMLStreamReaderImpl.this.fDTDProtocolValidator.validate(string2);
            }
            return inputSource;
        }
    }
}

