/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import sun.tools.jconsole.JConsole;

public class MaximizableInternalFrame
extends JInternalFrame {
    private boolean isXP;
    private JFrame mainFrame;
    private JMenuBar mainMenuBar;
    private String mainTitle;
    private JComponent titlePane;
    private Border normalBorder;
    private PropertyChangeListener pcl;
    private static Object WP_MINBUTTON;
    private static Object WP_RESTOREBUTTON;
    private static Object WP_CLOSEBUTTON;
    private static Object WP_MDIMINBUTTON;
    private static Object WP_MDIRESTOREBUTTON;
    private static Object WP_MDICLOSEBUTTON;
    private Method setButtonIcons;
    private Method enableActions;

    public MaximizableInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, bl, bl2, bl3, bl4);
        this.init();
    }

    private void init() {
        this.normalBorder = this.getBorder();
        this.isXP = this.normalBorder.getClass().getName().endsWith("XPBorder");
        if (this.isXP) {
            this.setRootPaneCheckingEnabled(false);
            this.titlePane = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
            if (this.pcl == null) {
                this.pcl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        String string = propertyChangeEvent.getPropertyName();
                        if (string.equals("icon") || string.equals("maximum") || string.equals("closed")) {
                            MaximizableInternalFrame.this.updateFrame();
                        }
                    }
                };
                this.addPropertyChangeListener(this.pcl);
            }
        } else if (this.pcl != null) {
            this.removePropertyChangeListener(this.pcl);
            this.pcl = null;
        }
    }

    private void updateFrame() {
        JFrame jFrame;
        if (!this.isXP || (jFrame = this.getMainFrame()) == null) {
            return;
        }
        JMenuBar jMenuBar = this.getMainMenuBar();
        BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.getUI();
        if (this.isMaximum() && !this.isIcon() && !this.isClosed()) {
            if (basicInternalFrameUI.getNorthPane() != null) {
                this.mainTitle = jFrame.getTitle();
                jFrame.setTitle(this.mainTitle + " - " + this.getTitle());
                if (jMenuBar != null) {
                    this.updateButtonStates();
                    jMenuBar.add(Box.createGlue());
                    for (Component component : this.titlePane.getComponents()) {
                        if (component instanceof JButton) {
                            jMenuBar.add(component);
                            continue;
                        }
                        if (!(component instanceof JLabel)) continue;
                        jMenuBar.add(Box.createHorizontalStrut(3), 0);
                        jMenuBar.add(component, 1);
                        jMenuBar.add(Box.createHorizontalStrut(3), 2);
                    }
                    basicInternalFrameUI.setNorthPane(null);
                    this.setBorder(null);
                }
            }
        } else if (basicInternalFrameUI.getNorthPane() == null) {
            jFrame.setTitle(this.mainTitle);
            if (jMenuBar != null) {
                for (Component component : jMenuBar.getComponents()) {
                    if (component instanceof JButton || component instanceof JLabel) {
                        this.titlePane.add(component);
                        continue;
                    }
                    if (!(component instanceof Box.Filler)) continue;
                    jMenuBar.remove(component);
                }
                jMenuBar.repaint();
                this.updateButtonStates();
                basicInternalFrameUI.setNorthPane(this.titlePane);
                this.setBorder(this.normalBorder);
            }
        }
    }

    @Override
    public void updateUI() {
        boolean bl;
        boolean bl2 = bl = this.isXP && this.getBorder() == null;
        if (bl) {
            try {
                this.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        super.updateUI();
        this.init();
        if (bl) {
            try {
                this.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private JFrame getMainFrame() {
        JDesktopPane jDesktopPane;
        if (this.mainFrame == null && (jDesktopPane = this.getDesktopPane()) != null) {
            this.mainFrame = (JFrame)SwingUtilities.getWindowAncestor(jDesktopPane);
        }
        return this.mainFrame;
    }

    private JMenuBar getMainMenuBar() {
        JFrame jFrame;
        if (this.mainMenuBar == null && (jFrame = this.getMainFrame()) != null) {
            this.mainMenuBar = jFrame.getJMenuBar();
            if (this.mainMenuBar != null && !(this.mainMenuBar.getLayout() instanceof FixedMenuBarLayout)) {
                this.mainMenuBar.setLayout(new FixedMenuBarLayout(this.mainMenuBar, 0));
            }
        }
        return this.mainMenuBar;
    }

    @Override
    public void setTitle(String string) {
        if (this.isXP && this.isMaximum() && this.getMainFrame() != null) {
            this.getMainFrame().setTitle(this.mainTitle + " - " + string);
        }
        super.setTitle(string);
    }

    private void updateButtonStates() {
        block3: {
            try {
                if (this.setButtonIcons == null) {
                    Class<?> clazz = this.titlePane.getClass();
                    Class<?> clazz2 = clazz.getSuperclass();
                    this.setButtonIcons = clazz.getDeclaredMethod("setButtonIcons", new Class[0]);
                    this.enableActions = clazz2.getDeclaredMethod("enableActions", new Class[0]);
                    this.setButtonIcons.setAccessible(true);
                    this.enableActions.setAccessible(true);
                }
                this.setButtonIcons.invoke((Object)this.titlePane, new Object[0]);
                this.enableActions.invoke((Object)this.titlePane, new Object[0]);
            }
            catch (Exception exception) {
                if (!JConsole.debug) break block3;
                exception.printStackTrace();
            }
        }
    }

    static {
        block9: {
            if (JConsole.IS_WIN) {
                try {
                    Class<?> clazz = Class.forName("com.sun.java.swing.plaf.windows.TMSchema$Part");
                    if (clazz != null) {
                        WP_MINBUTTON = clazz.getField("WP_MINBUTTON").get(null);
                        WP_RESTOREBUTTON = clazz.getField("WP_RESTOREBUTTON").get(null);
                        WP_CLOSEBUTTON = clazz.getField("WP_CLOSEBUTTON").get(null);
                        WP_MDIMINBUTTON = clazz.getField("WP_MDIMINBUTTON").get(null);
                        WP_MDIRESTOREBUTTON = clazz.getField("WP_MDIRESTOREBUTTON").get(null);
                        WP_MDICLOSEBUTTON = clazz.getField("WP_MDICLOSEBUTTON").get(null);
                    }
                    for (String string : new String[]{"maximize", "minimize", "iconify", "close"}) {
                        String string2 = "InternalFrame." + string + "Icon";
                        UIManager.put(string2, new MDIButtonIcon(UIManager.getIcon(string2)));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (JConsole.debug) {
                        classNotFoundException.printStackTrace();
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (JConsole.debug) {
                        noSuchFieldException.printStackTrace();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!JConsole.debug) break block9;
                    illegalAccessException.printStackTrace();
                }
            }
        }
    }

    private class FixedMenuBarLayout
    extends BoxLayout {
        public FixedMenuBarLayout(Container container, int n) {
            super(container, n);
        }

        @Override
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            for (Component component : container.getComponents()) {
                if (!(component instanceof JButton)) continue;
                int n = (container.getHeight() - component.getHeight()) / 2;
                component.setLocation(component.getX(), Math.max(2, n));
            }
        }
    }

    private static class MDIButtonIcon
    implements Icon {
        Icon windowsIcon;
        Field part;

        MDIButtonIcon(Icon icon) {
            block3: {
                this.windowsIcon = icon;
                if (WP_MINBUTTON != null) {
                    try {
                        this.part = this.windowsIcon.getClass().getDeclaredField("part");
                        this.part.setAccessible(true);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if (!JConsole.debug) break block3;
                        noSuchFieldException.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            block15: {
                if (this.part != null) {
                    try {
                        Object object = this.part.get(this.windowsIcon);
                        if (component.getParent() instanceof JMenuBar) {
                            if (object == WP_MINBUTTON) {
                                this.part.set(this.windowsIcon, WP_MDIMINBUTTON);
                            } else if (object == WP_RESTOREBUTTON) {
                                this.part.set(this.windowsIcon, WP_MDIRESTOREBUTTON);
                            } else if (object == WP_CLOSEBUTTON) {
                                this.part.set(this.windowsIcon, WP_MDICLOSEBUTTON);
                            }
                        } else if (object == WP_MDIMINBUTTON) {
                            this.part.set(this.windowsIcon, WP_MINBUTTON);
                        } else if (object == WP_MDIRESTOREBUTTON) {
                            this.part.set(this.windowsIcon, WP_RESTOREBUTTON);
                        } else if (object == WP_MDICLOSEBUTTON) {
                            this.part.set(this.windowsIcon, WP_CLOSEBUTTON);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (!JConsole.debug) break block15;
                        illegalAccessException.printStackTrace();
                    }
                }
            }
            this.windowsIcon.paintIcon(component, graphics, n, n2);
        }

        @Override
        public int getIconWidth() {
            return this.windowsIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.windowsIcon.getIconHeight();
        }
    }
}

