/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;

public final class SecureRandom
extends SecureRandomSpi {
    private SessionManager sessionManager;
    static final long serialVersionUID = 8121567603736529455L;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");

    public SecureRandom() {
        Provider pkcs11Provider = Security.getProvider("IBMPKCS11Impl");
        this.sessionManager = ((IBMPKCS11Impl)pkcs11Provider).getSessionManager();
    }

    public SecureRandom(Provider p) {
        this.sessionManager = ((IBMPKCS11Impl)p).getSessionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void engineSetSeed(byte[] seed) {
        block7: {
            Session session = null;
            try {
                session = this.sessionManager.getOpSession();
                session.seedRandom(seed, 0, seed.length);
            }
            catch (PKCS11Exception ex) {
                if (ex.getCode() == 288) {
                    if (debug != null) {
                        System.out.println("SecureRandom.java:  engineSetSeed():  Eating a PKCS11Exception which reports:  \"Random number generator does not accept seeding\"");
                    }
                    break block7;
                }
                throw ex;
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
        }
    }

    @Override
    protected synchronized void engineNextBytes(byte[] bytes) {
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            session.generateRandom(bytes, 0, bytes.length);
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] bytes = new byte[numBytes];
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            session.generateRandom(bytes, 0, bytes.length);
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
        return bytes;
    }
}

