/*
 * livepatch_bsc1233245
 *
 * Fix for CVE-2024-50257, bsc#1233245
 *
 *  Upstream commit:
 *  f48d258f0ac5 ("netfilter: Fix use-after-free in get_info()")
 *
 *  SLE12-SP5 commit:
 *  Not affected
 *
 *  SLE15-SP3 commit:
 *  Not affected
 *
 *  SLE15-SP4 and -SP5 commit:
 *  Not affected
 *
 *  SLE15-SP6 commit:
 *  1f00653932c239399f3062507b4167053ce2759c
 *
 *  SLE MICRO-6-0 commit:
 *  1f00653932c239399f3062507b4167053ce2759c
 *
 *  Copyright (c) 2025 SUSE
 *  Author: Lucas Mulling <lucas.mulling@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/socket.h>
#include <linux/net.h>

#include <linux/seq_file.h>
#include <linux/string.h>

/* klp-ccp: from include/linux/vmalloc.h */
#define _LINUX_VMALLOC_H

/* klp-ccp: from net/netfilter/x_tables.c */
#include <linux/mutex.h>
#include <linux/mm.h>
#include <linux/slab.h>
#include <linux/audit.h>

/* klp-ccp: from include/linux/user_namespace.h */
#define _LINUX_USER_NAMESPACE_H

/* klp-ccp: from net/netfilter/x_tables.c */
#include <net/net_namespace.h>
#include <net/netns/generic.h>

#include <linux/netfilter/x_tables.h>

/* klp-ccp: from include/linux/netfilter/x_tables.h */
struct xt_table *klpp_xt_find_table_lock(struct net *net, u_int8_t af,
				    const char *name);

/* klp-ccp: from net/netfilter/x_tables.c */
#include <linux/netfilter_arp.h>

struct xt_template {
	struct list_head list;

	/* called when table is needed in the given netns */
	int (*table_init)(struct net *net);

	struct module *me;

	/* A unique name... */
	char name[XT_TABLE_MAXNAMELEN];
};

extern struct list_head xt_templates[NFPROTO_NUMPROTO];

struct xt_pernet {
	struct list_head tables[NFPROTO_NUMPROTO];
};

struct xt_af {
	struct mutex mutex;
	struct list_head match;
	struct list_head target;
#ifdef CONFIG_NETFILTER_XTABLES_COMPAT
	struct mutex compat_mutex;
	struct compat_delta *compat_tab;
	unsigned int number; /* number of slots in compat_tab[] */
	unsigned int cur; /* number of used slots in compat_tab[] */
#endif
};

extern unsigned int xt_pernet_id __read_mostly;
extern struct xt_af *xt __read_mostly;

struct xt_table *klpp_xt_find_table_lock(struct net *net, u_int8_t af,
				    const char *name)
{
	struct xt_pernet *xt_net = net_generic(net, xt_pernet_id);
	struct module *owner = NULL;
	struct xt_template *tmpl;
	struct xt_table *t;

	mutex_lock(&xt[af].mutex);
	list_for_each_entry(t, &xt_net->tables[af], list)
		if (strcmp(t->name, name) == 0 && try_module_get(t->me))
			return t;

	/* Table doesn't exist in this netns, check larval list */
	list_for_each_entry(tmpl, &xt_templates[af], list) {
		int err;

		if (strcmp(tmpl->name, name))
			continue;
		if (!try_module_get(tmpl->me))
			goto out;

		owner = tmpl->me;

		mutex_unlock(&xt[af].mutex);
		err = tmpl->table_init(net);
		if (err < 0) {
			module_put(owner);
			return ERR_PTR(err);
		}

		mutex_lock(&xt[af].mutex);
		break;
	}

	/* and once again: */
	list_for_each_entry(t, &xt_net->tables[af], list)
		if (strcmp(t->name, name) == 0 && owner == t->me)
			return t;

	module_put(owner);
 out:
	mutex_unlock(&xt[af].mutex);
	return ERR_PTR(-ENOENT);
}

#include "livepatch_bsc1233245.h"

#include <linux/livepatch.h>

extern typeof(xt) xt KLP_RELOC_SYMBOL(x_tables, x_tables, xt);
extern typeof(xt_pernet_id) xt_pernet_id
	 KLP_RELOC_SYMBOL(x_tables, x_tables, xt_pernet_id);
extern typeof(xt_templates) xt_templates
	 KLP_RELOC_SYMBOL(x_tables, x_tables, xt_templates);
