/*
 * livepatch_bsc1226324
 *
 * Fix for CVE-XXXX-XXXX, bsc#1226324
 *
 *  Upstream commit:
 *  92f1655aa2b2 ("net: fix __dst_negative_advice() race")
 *
 *  SLE12-SP5 commit:
 *  Not affected
 *
 *  SLE15-SP2 and -SP3 commit:
 *  915aad327881dce5d922cc9d2aca848ee09fda63
 *  87d8edaefcdb2a7f2e5c9eca6b57088fd2e0251e
 *
 *  SLE15-SP4 and -SP5 commit:
 *  6d5c39367848b1282da6fc197c7310583d37fdc2
 *  74d650a07ccdb0a21bb56495775287cb594cc927
 *
 *  SLE15-SP6 commit:
 *  604ed28f2720b3354a2eceb530c7e923566f70b8
 *  6d764b66d0a53f9e02971b5bc17b3c9dba660bab
 *
 *  Copyright (c) 2025 SUSE
 *  Author: Fernando Gonzalez <fernando.gonzalez@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "livepatch_bsc1226324.h"

int bsc1226324_net_core_sock_init(void);
int bsc1226324_net_ipv4_route_init(void);
int bsc1226324_net_ipv4_tcp_timer_init(void);
int bsc1226324_net_ipv6_route_init(void);
int bsc1226324_net_xfrm_xfrm_policy_init(void);

int livepatch_bsc1226324_init(void)
{
	int ret;

	ret = bsc1226324_net_core_sock_init();
	if (ret)
		return ret;

	ret = bsc1226324_net_ipv4_route_init();
	if (ret)
		return ret;

	ret = bsc1226324_net_ipv4_tcp_timer_init();
	if (ret)
		return ret;

	ret = bsc1226324_net_ipv6_route_init();
	if (ret)
		return ret;

	return bsc1226324_net_xfrm_xfrm_policy_init();
}
