# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


# DO NOT ADD THINGS OTHER THAN ERROR MESSAGES HERE.
# This file gets parsed into a JS dictionary of all known error message ids in
# gen_aboutneterror_codes.py . If we end up needing fluent attributes or
# refactoring them in some way, the script will need updating.

psmerr-ssl-disabled = എസ്എസ്എല്‍ സമ്പ്രദായം പ്രവര്‍ത്തന രഹിതമാക്കിയിരിയ്ക്കുന്നു, അതിനാല്‍ സുരക്ഷിതമായി കണക്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല.
psmerr-ssl2-disabled = പഴയതും സുരക്ഷിതവുമല്ലാത്ത എസ്എസ്എല്‍ സമ്പ്രദായം വെബ്സൈറ്റ് ഉപയോഗിയ്ക്കുന്നതിനാല്‍ സുരക്ഷിതമായി കണക്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല.
# This is a multi-line message.
psmerr-hostreusedissuerandserial =
    നിങ്ങള്‍ക്കു് അസാധുവായ സര്‍ട്ടിഫിക്കേറ്റ് ലഭിച്ചിരിയ്ക്കുന്നു. ദയവായി നിങ്ങളുടെ സര്‍വര്‍ അഡ്മിനിസ്ട്രേറ്റര്‍ അല്ലെങ്കില്‍ ഈമെയില്‍ കറസ്പോണ്ടന്റുമായി ബന്ധപ്പെട്ടു് ഈ വിവരം നല്‍കുക:
    
    മറ്റൊരു സര്‍ട്ടിഫിക്കേറ്റ് അഥോറിറ്റി ലഭ്യമാക്കിയ സര്‍ട്ടിഫിക്കേറ്റിന്റെ അതേ സീരിയല്‍ നംബര്‍ നിങ്ങളുടെ സര്‍ട്ടിഫിക്കേറ്റിലും അടങ്ങുന്നു. മറ്റൊരു പുതിയ സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമാക്കുവാന്‍ ദയവായി ശ്രമിയ്ക്കുക, ഒരു സര്‍ട്ടിഫിക്കേറ്റിനു് ഒരു സീരിയല്‍ നംബര്‍ മാത്രമേ പാടുള്ളൂ.
ssl-error-export-only-server = സുരക്ഷിതമായി ബന്ധപ്പെടുവാന്‍ സാധ്യമല്ല. പിയര്‍ ഹൈ-ഗ്രെയിഡ് എന്‍ക്രിപ്ഷന്‍ പിന്തുണയ്ക്കുന്നില്ല.
ssl-error-us-only-server = സുരക്ഷിതമായി ബന്ധപ്പെടുവാന്‍ സാധ്യമല്ല. പിയറിനു് ഹൈ-ഗ്രെയിഡ് എന്‍ക്രിപ്ഷന്‍ ആവശ്യമുണ്ടു്, എന്നാല്‍ അതിനുള്ള പിന്തുണ ലഭ്യമല്ല.
ssl-error-no-cypher-overlap = സുരക്ഷിതമായി പിയറുമായി ബന്ധപ്പെടുവാന്‍ സാധ്യമല്ല: കോമണ്‍ എന്‍ക്രിപ്ഷന്‍ ആല്‍ഗോരിഥം ലഭ്യമല്ല.
ssl-error-no-certificate = ആധികാരികത ഉറപ്പാക്കുന്നതിനുള്ള സര്‍ട്ടിഫിക്കേറ്റ് അല്ലെങ്കില്‍ കീ ലഭ്യമല്ല.
ssl-error-bad-certificate = സുരക്ഷിതമായി പിയറുമായി ബന്ധപ്പെടുവാന്‍ സാധ്യമല്ല: പിയറിന്റെ സര്‍ട്ടിഫിക്കേറ്റ് നിഷേധിച്ചിരിക്കുന്നു.
ssl-error-bad-client = സര്‍വറിനു് ക്ലൈന്റില്‍ നിന്നും തെറ്റായ ഡേറ്റ ലഭിച്ചിരിക്കുന്നു.
ssl-error-bad-server = ക്ലൈന്റിനു് സര്‍വറില്‍ നിന്നും തെറ്റായ ഡേറ്റ ലഭിച്ചിരിക്കുന്നു.
ssl-error-unsupported-certificate-type = പിന്തുണ ലഭ്യമല്ലാത്ത തരത്തിലുള്ള സര്‍ട്ടിഫിക്കേറ്റ്.
ssl-error-unsupported-version = സുരക്ഷ പ്രോട്ടോക്കളിന്റെ പിന്തുണ ലഭ്യമല്ലാത്ത പതിപ്പു് പിയര്‍ ഉപയോഗിക്കുന്നു.
ssl-error-wrong-certificate = ക്ലൈന്റിന്റെ ആധികാരികത ഉറപ്പാക്കുന്നതു് പരാജയപ്പെട്ടിരിക്കുന്നു: കീ ഡേറ്റാബെയിസിലുള്ള സ്വകാര്യ കീയും സര്‍ട്ടിഫിക്കേറ്റ് ഡേറ്റാബെയിസിലുള്ള പബ്ലിക് കീയും തമ്മില്‍ പൊരുത്തമില്ല.
ssl-error-bad-cert-domain = സുരക്ഷിതമായി പിയറുമായി ബന്ധപ്പെടുവാന്‍ സാധ്യമല്ല: ആവശ്യപ്പെട്ടിരിക്കുന്ന ഡൊമെയിന്‍ നാമം സര്‍വറിന്റെ സര്‍ട്ടിഫിക്കേറ്റുമായി പൊരുത്തപ്പെടുന്നില്ല.
ssl-error-post-warning = അപരിചിതമായ എസ്എസ്എല്‍ പിശക് കോഡ്.
ssl-error-ssl2-disabled = SSL പതിപ്പു് 2 മാത്രം പിയര്‍ പിന്തുണയ്ക്കുന്നു, ഇതു് ലോക്കലായി നിര്‍ജ്ജീവമാക്കിയിരിക്കുന്നു.
ssl-error-bad-mac-read = തെറ്റായ ഓഥന്റിക്കേഷന്‍ കോഡുള്ള ഒരു റിക്കോര്‍ഡ് SSL-നു് ലഭിച്ചിരിക്കുന്നു.
ssl-error-bad-mac-alert = SSL പിയര്‍ തെറ്റായ ഓഥന്റിക്കേഷന്‍ കോഡു് രേഖപ്പെടുത്തുന്നു.
ssl-error-bad-cert-alert = SSL പിയറിനു് നിങ്ങളുടെ സര്‍ട്ടിഫിക്കേറ്റ് ഉറപ്പാക്കുവാന്‍ സാധ്യമല്ല.
ssl-error-revoked-cert-alert = SSL പിയര്‍ നിങ്ങളുടെ സര്‍ട്ടിഫിക്കേറ്റു് നിഷേധിച്ചിരിക്കുന്നു.
ssl-error-expired-cert-alert = SSL പിയര്‍ നിങ്ങളുടെ സര്‍ട്ടിഫിക്കേറ്റിന്റെ കാലാവധി കഴിഞ്ഞിരിക്കുന്നതിനാല്‍ നിഷേധിച്ചിരിക്കുന്നു.
ssl-error-ssl-disabled = കണക്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല: SSL പ്രവര്‍ത്തന രഹിതമാക്കിയിരിക്കുന്നു.
ssl-error-fortezza-pqg = കണക്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല: SSL പിയര്‍ മറ്റൊരു FORTEZZA ഡൊമെയിന്‍ ആണു്.
ssl-error-unknown-cipher-suite = അപരിചിതമായ ഒരു SSL സിഫര്‍ സ്യൂട്ട് ആവശ്യപ്പെട്ടിരിക്കുന്നു.
ssl-error-no-ciphers-supported = ഈ പ്രോഗ്രാമില്‍ പ്രവര്‍ത്തന സജ്ജമാക്കിയിരിക്കുന്ന സിഫര്‍ സ്യൂട്ടുകള്‍ ലഭ്യമല്ല.
ssl-error-bad-block-padding = തെറ്റായ ബ്ലോക്ക് പാഡിങുള്ള ഒരു റിക്കോര്‍ഡ് SSL-നു് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-record-too-long = അനുവദനീയമായ വ്യാപ്തിയില്‍ കൂടുതലുള്ള ഒരു റിക്കോര്‍ഡ് SSL ലഭിച്ചിരിക്കുന്നു.
ssl-error-tx-record-too-long = അനുവദനീയമായ വ്യാപ്തിയില്‍ കൂടുതലുള്ള ഒരു റിക്കോര്‍ഡ് അയയ്ക്കുന്നതിനായി SSL ശ്രമിച്ചിരിക്കുന്നു.
ssl-error-rx-malformed-hello-request = SSL-നു് തെറ്റായ ഒരു ഹലോ റിക്ക്വസ്റ്റ് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-client-hello = SSL-നു് തെറ്റായ ഒരു ക്ലൈന്റ് ഹലോ ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-server-hello = SSL-നു് തെറ്റായ ഒരു സര്‍വര്‍ ഹലോ ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-certificate = SSL-നു് തെറ്റായ ഒരു സര്‍ട്ടിഫിക്കേറ്റ് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-server-key-exch = SSL-നു് തെറ്റായ ഒരു സര്‍വര്‍ കീ എക്സ്ചെയിഞ്ച് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-cert-request = SSL-നു് തെറ്റായ ഒരു സര്‍ട്ടിഫിക്കേറ്റ് റിക്ക്വസ്റ്റ് ഹാന്‍ഡ് ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-hello-done = SSL-നു് തെറ്റായ ഒരു സര്‍വര്‍ ഹലോ ഡണ്‍ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-cert-verify = SSL-നു് തെറ്റായ ഒരു സര്‍ട്ടിഫിക്കേറ്റ് വേരിഫൈ ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-client-key-exch = SSL-നു് തെറ്റായ ഒരു ക്ലൈന്റ് കീ എക്സ്ചെയിഞ്ച് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-finished = SSL-നു് തെറ്റായ ഒരു ഫിനീഷ്ഡ് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-malformed-change-cipher = SSL-നു് തെറ്റായ ഒരു ചെയിഞ്ച് സിഫര്‍ സ്പെക് റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-malformed-alert = SSL -നു് തെറ്റായ ഒരു അലേര്‍ട്ട് റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-malformed-handshake = SSL -നു് തെറ്റായ ഒരു ഹാന്‍ഡ്ഷെയിക്ക് റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-malformed-application-data = SSL -നു് തെറ്റായ ഒരു അപ്ലിക്കേഷന്‍ ഡേറ്റ റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unexpected-hello-request = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു ഹലോ റിക്ക്വസ്റ്റ് ഹാന്‍ഡ്ഷെയിക്കു് സന്ദേശം ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unexpected-client-hello = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു ക്ലൈന്റ് ഹലോ ഹാന്‍ഡ്ഷെയിക്കു് സന്ദേശം ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unexpected-server-hello = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു സര്‍വര്‍ ഹലോ ഹാന്‍ഡ്ഷെയിക്കു് സന്ദേശം ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unexpected-certificate = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു സര്‍ട്ടിഫിക്കേറ്റ് ഹാന്‍ഡ്ഷെയിക്കു് സന്ദേശം ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unexpected-server-key-exch = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു സര്‍വര്‍ കീ എക്സ്ചെയിഞ്ച് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-unexpected-cert-request = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു സര്‍ട്ടിഫിക്കേറ്റ് റിക്ക്വസ്റ്റ് ഹാന്‍ഡ് ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-unexpected-hello-done = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു സര്‍വര്‍ ഹലോ ഡണ്‍ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-unexpected-cert-verify = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു സര്‍ട്ടിഫിക്കേറ്റ് വേരിഫൈ ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-unexpected-client-key-exch = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു ക്ലൈന്റ് കീ എക്സ്ചെയിഞ്ച് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-unexpected-finished = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു ഫിനീഷ്ഡ് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-unexpected-change-cipher = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു ചെയിഞ്ച് സിഫര്‍ സ്പെക് റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unexpected-alert = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു അലേര്‍ട്ട് റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unexpected-handshake = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു ഹാന്‍ഡ്ഷെയിക്ക് റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unexpected-application-data = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു അപ്ലിക്കേഷന്‍ ഡേറ്റ റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unknown-record-type = SSL-നു് അപരിചിതമായ രീതിയിലുള്ള ഉള്ളടക്കമുള്ള ഒരു റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unknown-handshake = SSL-നു് അപരിചിതമായ രീതിയിലുള്ള സന്ദേശത്തിനൊപ്പം ഒരു ഹാന്‍ഡ്ഷെയിക്കു് സന്ദേശം ലഭിച്ചിരിക്കുന്നു.
ssl-error-rx-unknown-alert = SSL-നു് അപരിചിതമായ ഒരു അറിയിപ്പു് വിവരണം ഉള്ള ഒരു അറിയിപ്പു് റിക്കോര്‍ഡ് ലഭിച്ചിരിക്കുന്നു.
ssl-error-close-notify-alert = SSL പിയര്‍ ഈ കണക്ഷന്‍ അടച്ചുകളഞ്ഞിരിക്കുന്നു.
ssl-error-handshake-unexpected-alert = എസ്എസ്എല്‍ പിയര്‍, അതിനു് ലഭ്യമായ ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം പ്രതീക്ഷിച്ചിരുന്നില്ല.
ssl-error-decompression-failure-alert = എസ്എസ്എല്‍ പിയറിനു് ലഭ്യമായൊരു എസ്എസ്എല്‍ റിക്കോര്‍ഡ് ഡികംപ്രസ്സ് ചെയ്യുവാന്‍ അതിനു് സാധ്യമായില്ല.
ssl-error-handshake-failure-alert = എസ്എസ്എല്‍ പിയറിനു് സുരക്ഷ പരാമീറ്ററുകള്‍ തിരുത്തുവാന്‍ സാധ്യമായില്ല.
ssl-error-illegal-parameter-alert = സ്വീകാര്യമല്ലാത്ത ഉള്ളടക്കത്തിനു് എസ്എസ്എല്‍ പിയര്‍ ഹാന്‍ഡ്‌ഷെയിക്ക് സന്ദേശം നിഷേധിച്ചിരിയ്ക്കുന്നു.
ssl-error-unsupported-cert-alert = എസ്എസ്എല്‍ പിയറിനു് ലഭ്യമായ ഒരു സര്‍ട്ടിഫിക്കേറ്റുകളും അതു് പിന്തുണയ്ക്കുന്നില്ല.
ssl-error-certificate-unknown-alert = എസ്എസ്എല്‍ പിയറിനു് ലഭ്യമായ സര്‍ട്ടിഫിക്കേറ്റില്‍ നിഷ്കര്‍ഷിച്ചിട്ടില്ലാത്ത പ്രശ്നം.
ssl-error-generate-random-failure = എസ്എസ്എലിന്റെ റാന്‍ഡം നംബര്‍ ജനറേറ്ററില്‍ പരാജയം.
ssl-error-sign-hashes-failure = നിങ്ങളുടെ സര്‍ട്ടിഫിക്കേറ്റ് ഉറപ്പാക്കുന്നതായി ഡേറ്റയില്‍ ഡിജിറ്റല്‍ ഒപ്പിടുവാന്‍ സാധ്യമായില്ല.
ssl-error-extract-public-key-failure = പിയറിന്റെ സര്‍ട്ടിഫിക്കേറ്രില്‍ നിന്നും പബ്ലിക് കീ ലഭ്യമാക്കുവാന്‍ സാധ്യമായില്ല.
ssl-error-server-key-exchange-failure = എസ്എസ്എല്‍ സര്‍വര്‍ കീ എക്സ്ചെയിഞ്ച് ഹാന്‍ഡ്ഷെയിക്ക് നടപ്പിലാക്കുമ്പോള്‍ നിഷ്കര്‍ഷിച്ചിട്ടില്ലാത്ത പരാജയം
ssl-error-client-key-exchange-failure = എസ്എസ്എല്‍ ക്ലയന്റ് കീ എക്സ്ചെയിഞ്ച് ഹാന്‍ഡ്ഷെയിക്ക് നടപ്പിലാക്കുമ്പോള്‍ നിഷ്കര്‍ഷിച്ചിട്ടില്ലാത്ത പരാജയം
ssl-error-encryption-failure = തെരഞ്ഞെടുത്ത സിഫര്‍ സൂട്ടില്‍ ബള്‍ക്ക് ഡേറ്റാ എന്‍ക്രിപ്ഷന്‍ ആല്‍ഗോരിഥം പരാജയപ്പെട്ടു
ssl-error-decryption-failure = തെരഞ്ഞെടുത്ത സിഫര്‍ സൂട്ടില്‍ ബള്‍ക്ക് ഡേറ്റാ ഡീക്രിപ്ഷന്‍ ആല്‍ഗോരിഥം പരാജയപ്പെട്ടു
ssl-error-socket-write-failure = സോക്കിലേക്കു് എന്‍ക്രിപ്റ്റ് ചെയ്ത ഡേറ്റാ സൂക്ഷിയ്ക്കുന്നതില്‍ പരാജയം.
ssl-error-md5-digest-failure = MD5 ഡൈജസ്റ്റ് ഫംഗ്ഷന്‍ പരാജയപ്പെട്ടു.
ssl-error-sha-digest-failure = SHA-1 ഡൈജസ്റ്റ് ഫംഗ്ഷന്‍ പരാജയപ്പെട്ടു.
ssl-error-mac-computation-failure = മാക് കമ്പ്യൂട്ടേഷന്‍ പരാജയപ്പെട്ടു.
ssl-error-sym-key-context-failure = സിമ്മെട്രിക്ക് കീ കണ്ടെക്സ്റ്റ് തയ്യാറാക്കുന്നതില്‍ പരാജയപ്പെട്ടു.
ssl-error-sym-key-unwrap-failure = ക്ലയന്റ് കീ എക്സ്ചെയിഞ്ച് സന്ദേശത്തില്‍ സിമ്മെട്രിക്ക് കീ അണ്‍റാപ്പ് ചെയ്യുന്നതില്‍ പരാജയപ്പെട്ടു.
ssl-error-pub-key-size-limit-exceeded = എക്സ്പോര്‍ട്ട് സിഫര്‍ സ്യൂട്ടിനൊപ്പം ഡൊമസ്റ്റിക്-ഗ്രേഡ് പബ്ലിക് കീ ഉപയോഗിയ്ക്കുവാന്‍ എസ്എസ്എല്‍ സര്‍ലര്‍ ശ്രമിച്ചിരിയ്ക്കുന്നു.
ssl-error-iv-param-failure = ഐവി പരാമിലേക്കു് വേര്‍തിരിയ്ക്കുന്നതില്‍ PKCS11 കോഡ് പരാജയപ്പെട്ടു.
ssl-error-init-cipher-suite-failure = തെരഞ്ഞെടുത്ത സിഫര്‍ സൂട്ട് ആരംഭിയ്ക്കുന്നതില്‍ പരാജയപ്പെട്ടു.
ssl-error-session-key-gen-failure = എസ്എസ്എല്‍ സെഷനുള്ള സെഷന്‍ കീകള്‍ ലഭ്യമാക്കുന്നതില്‍ ക്ലയന്റ് പരാജയപ്പെട്ടു.
ssl-error-no-server-key-for-alg = കീ എക്സ്ചെയിഞ്ച് ആല്‍ഗോരിഥത്തിനുള്ള കീ സര്‍വറില്‍ ലഭ്യമല്ല.
ssl-error-token-insertion-removal = പ്രക്രിയയ്ക്കിടയില്‍ PKCS#11 ടോക്കന്‍ ഇടയ്ക്കു് ചേര്‍ത്തിരിയ്ക്കുന്നു അല്ലെങ്കില്‍ നീക്കം ചെയ്തിരിയ്ക്കുന്നു.
ssl-error-token-slot-not-found = ആവശ്യമായ പ്രക്രിയ നടപ്പാക്കുന്നതിനായി ഒരു PKCS#11 ടോക്കനും ലഭ്യമായില്ല.
ssl-error-no-compression-overlap = പിയറുമായി സുരക്ഷിതമായി ആശയവിനിമയം നടത്തുവാന്‍ സാധ്യമല്ല: പൊതുവായ കമ്പ്രഷന്‍ ആല്‍ഗോരിഥം ലഭ്യമല്ല.
ssl-error-handshake-not-completed = നിലവിലുള്ള ഹാന്‍ഡ്ഷെയിക്ക് പൂര്‍ത്തിയാക്കുന്നതു് വരെ മറ്റൊരു എസ്എസ്എല്‍ ഹാന്‍ഡ്ഷെയിക്ക് ആരംഭിയ്ക്കുവാന്‍ സാധ്യമല്ല.
ssl-error-bad-handshake-hash-value = പിയറില്‍ നിന്നും തെറ്റായ ഹാന്‍ഡ്ഷെയിക്ക് ഹാഷ് മൂല്ല്യങ്ങള്‍ ലഭിച്ചിരിയ്ക്കുന്നു.
ssl-error-cert-kea-mismatch = തെരഞ്ഞെടുത്ത കീ എക്സ്ചെയിഞ്ച് ആല്‍ഗോരിഥത്തിനൊപ്പം ലഭ്യമാക്കിയ സര്‍ട്ടിഫിക്കേറ്റ് ഉപയോഗിയ്ക്കുവാന്‍ സാധ്യമല്ല.
ssl-error-no-trusted-ssl-client-ca = എസ്എസ്എല്‍ ക്ലയന്റ് ആധികാരികത ഉറപ്പാക്കല്‍ സംവിധാനത്തിനു് വിശ്വസനീയമായ സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമല്ല.
ssl-error-session-not-found = സര്‍വറിന്റെ സെഷന്‍ കാഷില്‍ ക്ലയന്റിനുള്ള എസ്എസ്എല്‍ സെഷന്‍ ഐഡി ലഭ്യമായില്ല.
ssl-error-decryption-failed-alert = പിയറിനു് ലഭ്യമായൊരു എസ്എസ്എല്‍ റിക്കോര്‍ഡ് ഡീക്രിപ്റ്റ് ചെയ്യുവാന്‍ പിയറിനു് സാധ്യമായില്ല.
ssl-error-record-overflow-alert = അനുവദിച്ചിരിയ്ക്കുന്നതിനേക്കാള്‍ വലിയ എസ്എസ്എല്‍ റിക്കോര്‍ഡ് പിയറിനു് ലഭിച്ചിരിയ്ക്കുന്നു.
ssl-error-unknown-ca-alert = നിങ്ങള്‍ക്കു് ലഭ്യമായ സര്‍ട്ടിഫിക്കേറ്റ് പിയര്‍ തിരിച്ചറിയുകയോ വിശ്വസിയ്ക്കുകയോ ചെയ്യുന്നില്ല.
ssl-error-access-denied-alert = പിയറിനു് ശരിയായ സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമായി, പക്ഷേ പ്രവേശനം നിഷേധിച്ചിരിയ്ക്കുന്നു.
ssl-error-decode-error-alert = ഒരു എസ്എസ്എല്‍ ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ഡീക്കോഡ് ചെയ്യുവാന്‍ പിയറിനു് സാധ്യമായില്ല.
ssl-error-decrypt-error-alert = സിഗ്നേച്ചര്‍ ഉറപ്പാക്കല്‍ അല്ലെങ്കില്‍ കീ എക്സ്ചെയിഞ്ചിന്റെ പരാജയത്തപ്പെറ്റി പിയര്‍ രേഖപ്പെടുത്തുന്നു.
ssl-error-export-restriction-alert = എക്സപോര്‍ട്ട് നിയമങ്ങള്‍ക്കനുസരിച്ചല്ലാത്ത സംവാദങ്ങളെ പിയര്‍ രേഖപ്പെടുത്തുന്നു.
ssl-error-protocol-version-alert = പൊരുത്തപ്പെടാത്ത അല്ലെങ്കില്‍ പിന്തുണയ്ക്കാത്ത പ്രോട്ടോക്കോള്‍ പതിപ്പു് പിയര്‍ രേഖപ്പെടുത്തുന്നു.
ssl-error-insufficient-security-alert = ക്ലയന്റ് പിന്തുണയ്ക്കുന്നതിലും കൂടുതല്‍ സുരക്ഷിതമായ സിഫറുകള്‍ സര്‍വറിനു് ആവശ്യമുണ്ടു്.
ssl-error-internal-error-alert = പിയറില്‍ ആന്തരിക പിശകു് എന്നു് രേഖപ്പെടുത്തിയിരിയ്ക്കുന്നു.
ssl-error-user-canceled-alert = പിയര്‍ ഉപയോക്താവു് ഹാന്‍ഡ്ഷെയിക്ക് റദ്ദാക്കിയിരിയ്ക്കുന്നു.
ssl-error-no-renegotiation-alert = എസ്എസ്എല്‍ സുരക്ഷാ പരാമീറ്ററുകള്‍ വീണ്ടും സംവാദത്തില്‍ ഏര്‍പ്പെടുന്നതു് പിയര്‍ അനുവദിയ്ക്കുന്നില്ല.
ssl-error-server-cache-not-configured = ഈ സോക്കറ്റിനു് എസ്എസ്എല്‍ സര്‍വര്‍ ക്യാഷ് ക്രമീകരിച്ചിട്ടില്ല, പ്രവര്‍ത്തന രഹിതമാക്കിയിട്ടുമില്ല.
ssl-error-unsupported-extension-alert = ആവശ്യപ്പെട്ട ടിഎല്‍എസ് എക്സ്റ്റന്‍ഷന്‍ എസ്എസ്എല്‍ പിയര്‍ പിന്തുണയ്ക്കുന്നില്ല.
ssl-error-certificate-unobtainable-alert = നല്‍കി യുആര്‍എലില്‍ നിന്നും എസ്എസ്എല്‍ പിയറിനു് നിങ്ങളുടെ സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമാക്കുവാന്‍ സാധ്യമായില്ല.
ssl-error-unrecognized-name-alert = ആവശ്യപ്പെട്ട ഡിഎന്‍എസ് നാമത്തിനുള്ള സര്‍ട്ടിഫിക്കേറ്റ് എസ്എസ്എല്‍ പിയറിനു് ലഭ്യമല്ല.
ssl-error-bad-cert-status-response-alert = എസ്എസ്എല്‍ പിയറിനു് അതിനുള്ള സര്‍ട്ടിഫിക്കേറ്റിനുള്ള ഒസിഎസ്‌പി ലഭ്യമാക്കുവാന്‍ സാധ്യമായില്ല.
ssl-error-bad-cert-hash-value-alert = എസ്എസ്എല്‍ പിയര്‍ തെറ്റായ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള ഗാഷ് മൂല്ല്യം രേഖപ്പെടുത്തിയിരിയ്ക്കുന്നു.
ssl-error-rx-unexpected-new-session-ticket = എസ്എസ്എലിനു് അപ്രതീക്ഷിതമായ പുതിയ സെഷനുള്ള ടിക്കറ്റ് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം  ലഭിച്ചിരിയ്ക്കുന്നു.
ssl-error-rx-malformed-new-session-ticket = എസ്എസ്എലിനു് തകരാറുള്ള പുതിയ സെഷനുള്ള ടിക്കറ്റ് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം  ലഭിച്ചിരിയ്ക്കുന്നു.
ssl-error-decompression-failure = ഡീകംപ്രസ്സ് ചെയ്യുവാന്‍ സാധ്യമല്ലാത്ത കംപ്രസ്സ് ചെയ്തൊരു റിക്കോര്‍ഡ് എസ്എസ്എലിനു് ലഭ്യമായിരിയ്ക്കുന്നു.
ssl-error-renegotiation-not-allowed = ഈ എസ്എസ്എല്‍ സോക്കറ്റില്‍ വീണ്ടും സംവാദം അനുവദിയ്ക്കുന്നില്ല.
ssl-error-unsafe-negotiation = പഴയ ശൈലിയിലുള്ള ഹാന്‍ഡ്ഷെയിക്ക് പിയര്‍ ശ്രമിയ്ക്കുന്നു.
ssl-error-rx-unexpected-uncompressed-record = എസ്എസ്എലിനു് അപ്രതീക്ഷിതമായ കമ്പ്രസ്സ് ചെയ്യാത്ത റിക്കോര്‍ഡ് ലഭിച്ചിരിയ്ക്കുന്നു.
ssl-error-weak-server-ephemeral-dh-key = സര്‍വര്‍ കീ എക്സ്ചെയിഞ്ച് സന്ദേശത്തില്‍ എസ്എസ്എലിനു് ശക്തമല്ലാത്തൊരു എഫമെറല്‍ ഡിഫ്ഫീ-ഹെല്‍മാന്‍ കീ ലഭ്യമാക്കിയിരിയ്ക്കുന്നു.
ssl-error-next-protocol-data-invalid = എസ്എസ്എലിനു് തെറ്റായ എന്‍പിഎന്‍ എക്സ്റ്റെന്‍ഷന്‍ ഡേറ്റാ ലഭ്യമായിരിയ്ക്കുന്നു.
ssl-error-feature-not-supported-for-ssl2 = എസ്എസ്എല്‍ വിശേഷത എസ്എസ്എല്‍ 2.0 കണക്ഷനുകള്‍ പിന്തുണയ്ക്കുന്നില്ല.
ssl-error-feature-not-supported-for-servers = എസ്എസ്എല്‍ വിശേഷത സര്‍വറുകളെ പിന്തുണയ്ക്കുന്നില്ല.
ssl-error-feature-not-supported-for-clients = എസ്എസ്എല്‍ വിശേഷത ക്ലയന്റുകളെ പിന്തുണയ്ക്കുന്നില്ല.
ssl-error-invalid-version-range = എസ്എസ്എല്‍ പതിപ്പിന്റെ പരിധി അസാധുവാണ്.
ssl-error-cipher-disallowed-for-version = തെരഞ്ഞെടുത്ത പ്രോട്ടോക്കോള്‍ പതിപ്പിനു് അനുവദനീയമല്ലാത്തൊരു സിഫര്‍ സ്യൂട്ട് എസ്എസ്എല്‍ പിയര്‍ തെരഞ്ഞെടുത്തിരിയ്ക്കുന്നു.
ssl-error-rx-malformed-hello-verify-request = SSL-നു് തെറ്റായ ഒരു ഹലോ വേരിഫൈ റിക്ക്വസ്റ്റ് ഹാന്‍ഡ്ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-rx-unexpected-hello-verify-request = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു ഹലോ വേരിഫൈ റിക്ക്വസ്റ്റ് ഹാന്‍ഡ്ഷെയിക്കു് സന്ദേശം ലഭിച്ചിരിക്കുന്നു.
ssl-error-feature-not-supported-for-version = എസ്എസ്എല്‍ വിശേഷത പ്രോട്ടോക്കോളിന്റെ പതിപ്പിനെ പിന്തുണയ്ക്കുന്നില്ല.
ssl-error-rx-unexpected-cert-status = SSL-നു് അപ്രതീക്ഷിതമായ ഒരു സര്‍ട്ടിഫിക്കേറ്റ് സ്റ്റാറ്റസ് ഹാന്‍ഡ് ഷെയിക്ക് സന്ദേശം ലഭിച്ചിരിക്കൂന്നു.
ssl-error-unsupported-hash-algorithm = പിന്തുണയ്ക്കാത്ത ഹാഷ് ആല്‍ഗോരിഥമാണ് ടിഎല്‍എസ് പിയര്‍ ഉപയോഗിയ്ക്കുന്നത്.
ssl-error-digest-failure = MD5 ഡൈജസ്റ്റ് ഫംഗ്ഷന്‍ പരാജയപ്പെട്ടു.
ssl-error-incorrect-signature-algorithm = ഡിജിറ്റലായി ഒപ്പിട്ടിരിയ്ക്കുന്ന എലമെന്റില്‍ തെറ്റായ സിഗ്നേച്ചര്‍ ആല്‍ഗോരിഥം.
ssl-error-next-protocol-no-callback = അടുത്ത പ്രോട്ടോക്കേള്‍ കുടിയാലോചന എക്സ്റ്റെന്‍ഷന്‍ സജ്ജമാക്കിയിരുന്നു, പക്ഷേ ആവശ്യമാകും മുന്‍പേ കോള്‍ബാക്ക് ശുന്യമാക്കി.
ssl-error-next-protocol-no-protocol = ക്ലയന്റ് ALPN എക്സ്റ്റന്‍ഷനില്‍ ലഭ്യമാക്കുന്ന ഒരു പ്രോട്ടോക്കോളും സര്‍വര്‍ പിന്തുണയ്ക്കുന്നില്ല.
ssl-error-inappropriate-fallback-alert = സര്‍വര്‍ ഹാന്‍ഡ്ഷെയിക്ക് നിരസിച്ചിരിയ്ക്കുന്നു. കാരണം, സര്‍വര്‍ പിന്തുണയ്ക്കുന്നതിനേക്കാള്‍ കുറഞ്ഞ ടിഎല്‍എസ് പതിപ്പിലേക്കു് ക്ലയന്റിനെ താഴ്ത്തിയിരിയ്ക്കുന്നു.
ssl-error-weak-server-cert-key = സര്‍വര്‍ സാക്ഷ്യപത്രത്തില്‍ വളരെ ദുര്‍ബലമായ പബ്ലിക്‌ കീ ഉള്‍പ്പെട്ടിട്ടുണ്ട്.
sec-error-io = സുരക്ഷയുടെ ആധികാരികത ഉറപ്പാക്കുമ്പോള്‍ ഒരു ഐ/ഒ പിശകുണ്ടായിരിയ്ക്കുന്നു.
sec-error-library-failure = സുരക്ഷാ ലൈബ്രറിയില്‍ പരാജയം.
sec-error-bad-data = സുരക്ഷാ ലൈബ്രറി: തെറ്റാ ഡേറ്റാ ലഭ്യമായിരിയ്ക്കുന്നു.
sec-error-output-len = സുരക്ഷാ ലൈബ്രറി: ഫലത്തിന്റെ വ്യാപ്തിയില്‍ പിശക്.
sec-error-input-len = സുരക്ഷാ ലൈബ്രറിയില്‍ ഒരു ഇന്‍പുട്ട് വ്യാപ്തി പിശക്.
sec-error-invalid-args = സുരക്ഷാ ലൈബ്രറി: തെറ്റായ ആര്‍ഗ്യുമെന്റുകള്‍.
sec-error-invalid-algorithm = സുരക്ഷാ ലൈബ്രറി: തെറ്റായ ആല്‍ഗോരിഥം.
sec-error-invalid-ava = സുരക്ഷാ ലൈബ്രറി: തെറ്റായ എവിഎ
sec-error-invalid-time = തെറ്റായ ശൈലിയിലുള്ള സമയ സ്ട്രിങ്.
sec-error-bad-der = സുരക്ഷാ ലൈബ്രറി: തെറ്റായ ശൈലിയിലുള്ള ഡിഇആര്‍-എന്‍കോഡ് ചെയ്ത സന്ദേശം.
sec-error-bad-signature = പിയറിന്റെ സര്‍ട്ടിഫിക്കേറ്റില്‍ തെറ്റായ ഒപ്പു്.
sec-error-expired-certificate = പിയര്‍ സര്‍ട്ടിഫിക്കേറ്റിന്റെ കാലാവധി കഴിഞ്ഞിരിയ്ക്കുന്നു.
sec-error-revoked-certificate = പിയറിന്റെ സര്‍ട്ടിഫിക്കേറ്റ് പിന്‍വലിച്ചിരിയ്ക്കുന്നു.
sec-error-unknown-issuer = പിയറിന്റെ സര്‍ട്ടിഫിക്കേറ്റ് ഇഷ്യൂവര്‍ അപരിചിതമാണു്.
sec-error-bad-key = പിയറിന്റെ പൊതു കീ അസാധുവാണു്.
sec-error-bad-password = നല്‍കിയ സുരക്ഷാ ഒളിവാക്ക് തെറ്റാണു്.
sec-error-retry-password = പുതിയ ഒളിവാക്ക് തെറ്റായി നല്‍കിയിരിക്കുന്നു. ദയവായി വീണ്ടും ശ്രമിക്കുക.
sec-error-no-nodelock = സുരക്ഷാ ലൈബ്രറി: നോഡ്ലോക്ക് ആവശ്യമില്ല.
sec-error-bad-database = സുരക്ഷാ ലൈബ്രറി: തെറ്റായ ഡേറ്റാബെയിസ്.
sec-error-no-memory = സുരക്ഷാ ലൈബ്രറി: മെമ്മറി അനുവദിയ്ക്കുന്നതില്‍ പരാജയം.
sec-error-untrusted-issuer = ഉപയോക്തിവിനു് വിശ്വാസമല്ല എന്നു് പിയര്‍ സര്‍ട്ടിഫിക്കേറ്റിന്റെ ഇഷ്യൂവര്‍ അടയാളപ്പെടുത്തിയിരിയ്ക്കുന്നു.
sec-error-untrusted-cert = ഉപയോക്തിവിനു് വിശ്വാസമല്ല എന്നു് പിയര്‍ സര്‍ട്ടിഫിക്കേറ്റ് അടയാളപ്പെടുത്തിയിരിയ്ക്കുന്നു.
sec-error-duplicate-cert = സര്‍ട്ടിഫിക്കേറ്റ് നിങ്ങളുടെ ഡേറ്റാബെയിസില്‍ നിലവിലുണ്ടു്.
sec-error-duplicate-cert-name = ഡൌണ്‍ലോഡ് ചെയ്ത സര്‍ട്ടിഫിക്കേറ്റിന്റെ പേരു് നിങ്ങളുടെ ഡേറ്റാബെയിസിലുള്ളൊരെണ്ണവുമായി സാമ്യമുണ്ടു്.
sec-error-adding-cert = ഡേറ്റാബെയിസിലേക്കു് സര്‍ട്ടിഫിക്കേറ്റ് ചേര്‍ക്കുന്നതില്‍ പിശക്.
sec-error-filing-key = ഈ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള കീ വീണ്ടും ഫയല്‍ ചെയ്യുന്നതില്‍ പിശക്.
sec-error-no-key = ഈ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള സ്വകാര്യ കീ, കീ ഡേറ്റാബെയ്സില്‍ ലഭ്യമല്ല.
sec-error-cert-valid = ഈ സര്‍ട്ടിഫിക്കേറ്റ് ശരിയാണു്.
sec-error-cert-not-valid = ഈ സര്‍ട്ടിഫിക്കേറ്റ് അസാധുവാണു്.
sec-error-cert-no-response = സര്‍ട്ടി ലൈബ്രിറ:  മറുപടി ലഭ്യമല്ല
sec-error-expired-issuer-certificate = സര്‍ട്ടിഫിക്കേറ്റ് ഇഷ്യുവറിന്റെ സര്‍ട്ടിഫിക്കേറ്റിന്റെ കാലാവധി കഴിഞ്ഞിരിയ്ക്കുന്നു. നിങ്ങളുടെ സിസ്റ്റത്തിന്റെ തീയതിയും സമയവും പരിശോധിയ്ക്കുക.
sec-error-crl-expired = സര്‍ട്ടിഫിക്കേറ്റ് ഇഷ്യുവറിന്റെ സിആര്‍എലിന്റെ കാലാവധി കഴിഞ്ഞിരിയ്ക്കുന്നു. നിങ്ങളുടെ സിസ്റ്റത്തിന്റെ തീയതിയും സമയവും പരിശോധിയ്ക്കുക അല്ലെങ്കില്‍ പരിഷ്കരിയ്ക്കുക.
sec-error-crl-bad-signature = സര്‍ട്ടിഫിക്കേറ്റ് ഇഷ്യുവറിന്റെ സിആര്‍എലിനു് ശരിയായ ഒപ്പു് ലഭ്യമല്ല.
sec-error-crl-invalid = പുതിയ CRL അസാധുവായ ഫോര്‍മാറ്റിലാണു്‌.
sec-error-extension-value-invalid = സര്‍ട്ടിഫിക്കേറ്റിന്റെ എക്സ്റ്റെന്‍ഷന്‍ മൂല്ല്യം തെറ്റാണു്.
sec-error-extension-not-found = സര്‍ട്ടിഫിക്കേറ്റിന്റെ എക്സ്റ്റെന്‍ഷന്‍ ലഭ്യമായില്ല.
sec-error-ca-cert-invalid = ഇഷ്യൂവര്‍ സര്‍ട്ടിഫിക്കേറ്റ് തെറ്റാണു്.
sec-error-path-len-constraint-invalid = സര്‍ട്ടിഫിക്കേറ്റിന്റെ പാഥ് വ്യാപ്തി തെറ്റാണു്.
sec-error-cert-usages-invalid = സര്‍ട്ടിഫിക്കേറ്റ് ഉപയോഗങ്ങള്‍ക്കുള്ള ഫീള്‍ഡ് തെറ്റാണു്.
sec-internal-only = **ഇന്റേണല്‍ മാത്രമായ ഘടകം**
sec-error-invalid-key = ആവശ്യപ്പെട്ട പ്രക്രിയ കീ പിന്തുണയ്ക്കുന്നില്ല.
sec-error-unknown-critical-extension = സര്‍ട്ടിഫിക്കേറ്റില്‍ അപരിചിതമായ ക്രിട്ടിക്കല്‍ എക്സ്റ്റെന്‍ഷന്‍.
sec-error-old-crl = പുതിയ സിആര്‍എല്‍ നിലവിലുള്ളതിനേക്കാള്‍ പഴയതാണു്‌.
sec-error-no-email-cert = എന്‍ക്രിപ്റ്റ് ചെയ്തിട്ടില്ല അല്ലെങ്കില്‍ ഒപ്പില്ല: നിങ്ങള്‍ക്കു് ഈമെയില്‍ സര്‍ട്ടിഫിക്കേറ്റില്ല.
sec-error-no-recipient-certs-query = എന്‍ക്രിപ്റ്റ് ചെയ്തിട്ടില്ല: ഒരോന്നിനുമുള്ള സര്‍ട്ടിഫിക്കേറ്റുകള്‍ നിങ്ങള്‍ക്കു് ലഭ്യമല്ല.
sec-error-not-a-recipient = ഡീക്രിപ്റ്റ് ചെയ്യുവാന്‍ സാധ്യമല്ല: നിങ്ങള്‍ക്കു് ലഭ്യമാകില്ല, അല്ലെങ്കില്‍ പൊരുത്തപ്പെടുന്ന സര്‍ട്ടിഫിക്കേറ്റും സ്വകാര്യ കീയും ലഭ്യമായില്ല.
sec-error-pkcs7-keyalg-mismatch = ഡീക്രിപ്റ്റ് ചെയ്യുവാന്‍ സാധ്യമല്ല: നിങ്ങളുടെ സര്‍ട്ടിഫിക്കേറ്റുമായി കീ എന്‍ക്രിപ്ഷന്‍ ആല്‍ഗോരിഥം പൊരുത്തപ്പെടുന്നില്ല.
sec-error-pkcs7-bad-signature = ഒപ്പ് ഉറപ്പാക്കല്‍ പരാജയപ്പെട്ടു: ഒപ്പിടുന്ന ആള്‍ ലഭ്യമല്ല, അനവധി ഒപ്പിടുന്നവര്‍ ലഭ്യമായി, അല്ലെങ്കില്‍ തെറ്റായ ഡേറ്റാ.
sec-error-unsupported-keyalg = അപരിചിതമായ അല്ലെങ്കില്‍ പിന്തുണയ്ക്കാത്ത് കീ ആര്‍ഗോരിഥം.
sec-error-decryption-disallowed = ഡീക്രിപ്റ്റ് ചെയ്യുവാന്‍ സാധ്യമല്ല: അനുവദിയ്ക്കാത്ത ആര്‍ഗോരിഥം അല്ലെങ്കില്‍ കീ വ്യാപ്തി ഉപയോഗിച്ചു് എന്‍ക്രിപ്റ്റ് ചെയ്തിരിയ്ക്കുന്നു.
sec-error-no-krl = ഈ സൈറ്റിന്റ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള കെആര്‍എല്‍ ലഭ്യമല്ല.
sec-error-krl-expired = ഈ സൈറ്റിന്റെ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള കെആര്‍എലിന്റെ കാലാവധി കഴിഞ്ഞിരിയ്ക്കുന്നു.
sec-error-krl-bad-signature = ഈ സൈറ്റിന്റെ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള കെആര്‍എലിനു് തെറ്റായ ഒപ്പു്.
sec-error-revoked-key = ഈ സൈറ്റിന്റെ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള കീ വീണ്ടും ലഭ്യമാക്കിയിരിയ്ക്കുന്നു.
sec-error-krl-invalid = പുതിയ കെആര്‍എല്‍ അസാധുവായ ഫോര്‍മാറ്റിലാണു്‌.
sec-error-need-random = സുരക്ഷാ ലൈബ്രറി: പെട്ടെന്നുള്ള ഡേറ്റാ അവശ്യമാകുന്നു.
sec-error-no-module = സുരക്ഷാ ലൈബ്രറി: ആവശ്യപ്പെട്ട പ്രക്രിയ നടപ്പിലാക്കുവാന്‍ ഒരു സുരക്ഷാ ഘടകവും ലഭ്യമല്ല.
sec-error-no-token = സുരക്ഷ കാര്‍ഡ് അല്ലെങ്കില്‍ ടോക്കന്‍ നിലവിലില്ല. ആരംഭിയ്ക്കണം അല്ലെങ്കില്‍ നീക്കം ചെയ്തിരിയ്ക്കുന്നു.
sec-error-read-only = സുരക്ഷ ലൈബ്രറി: റീഡ്-ഒണ്‍ലി ഡേറ്റാബെയിസ്.
sec-error-no-slot-selected = സ്ലോട്ട് അല്ലെങ്കില്‍ ടോക്കന്‍ തെരഞ്ഞെടുത്തിട്ടില്ല.
sec-error-cert-nickname-collision = ഈ വിളിപ്പേരിലൊരു സര്‍ട്ടിഫിക്കേറ്റ് നിലവിലുണ്ടു്.
sec-error-key-nickname-collision = ഈ വിളിപ്പേരിലൊരു കീ നിലവിലുണ്ടു്.
sec-error-safe-not-created = സുരക്ഷിതമായ വസ്തു തയ്യാറാക്കുമ്പോള്‍ പിശക്
sec-error-baggage-not-created = ബാഗ്ഗേജ് വസ്തു തയ്യാറാക്കുന്നതില്‍ പിശക്
sec-error-bad-export-algorithm = ആവശ്യമായ ആര്‍ഗോരിഥം അനുവദിച്ചിട്ടില്ല.
sec-error-exporting-certificates = സര്‍ട്ടിഫിക്കേറ്റുകള്‍ എക്സ്പോര്‍ട്ട് ചെയ്യുമ്പോള്‍ പിശക്.
sec-error-importing-certificates = സര്‍ട്ടിഫിക്കേറ്റുകള്‍ ഇംപോര്‍ട്ട് ചെയ്യുമ്പോള്‍ പിശക്.
sec-error-pkcs12-decoding-pfx = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. ഡീകോഡിങില്‍ പിശക്. ഫയല്‍ ശരിയല്ല.
sec-error-pkcs12-invalid-mac = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. തെറ്റായ മാക്. തെറ്റായ ഒളിവാക്ക് അല്ലെങ്കില്‍ തകരാറുള്ള ഫയല്‍.
sec-error-pkcs12-unsupported-mac-algorithm = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. മാക് ആര്‍ഗോരിഥം പിന്തുണയ്ക്കുന്നില്ല.
sec-error-pkcs12-unsupported-transport-mode = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. ഒളിവാക്കും സ്വകാര്യ മോഡും മാത്രം പിന്തുണയ്ക്കുന്നു.
sec-error-pkcs12-corrupt-pfx-structure = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. ഫയല്‍ ശൈലിയില്‍ തകരാര്‍.
sec-error-pkcs12-unsupported-pbe-algorithm = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല.  എന്‍ക്രിപ്ഷന്‍ ആല്‍ഗോരിഥം പിന്തുണയ്ക്കുന്നില്ല.
sec-error-pkcs12-unsupported-version = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. ഫയലിന്റെ പതിപ്പു് പിന്തുണയ്ക്കുന്നില്ല.
sec-error-pkcs12-privacy-password-incorrect = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. തെറ്റായ സ്വകാര്യ ഒളിവാക്ക്.
sec-error-pkcs12-cert-collision = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. ഒരേ വിളിപ്പേരു് ഡേറ്റാബെയിസിലുണ്ടു്.
sec-error-user-cancelled = ഉപയോക്താവു് റദ്ദാക്കുവാന്‍ ആവശ്യപ്പെട്ടിരിക്കുന്നു.
sec-error-pkcs12-duplicate-data = ഇംപോര്‍ട്ട് ചെയ്തിട്ടില്ല, ഡേറ്റാബെയിസിലുണ്ടു്.
sec-error-message-send-aborted = സന്ദേശം അയച്ചിട്ടില്ല.
sec-error-inadequate-key-usage = ശ്രമിച്ച പ്രക്രിയയ്ക്കു് ആവശ്യമായ സര്‍ട്ടിഫിക്കേറ്റ് കീ ഉപയോഗം ലഭ്യമല്ല.
sec-error-inadequate-cert-type = പ്രയോഗത്തിനുള്ള സര്‍ട്ടിഫിക്കേറ്റ് തരത്തിനു് അനുവാദമില്ല.
sec-error-cert-addr-mismatch = സന്ദേശത്തിന്റെ തലക്കെട്ടുകളിലുള്ള വിലാസം ഒപ്പിടുന്ന സര്‍ട്ടിഫിക്കേറ്റിലുള്ള വിലാസവുമായി പൊരുത്തപ്പെടുന്നില്ല.
sec-error-pkcs12-unable-to-import-key = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. സ്വകാര്യ കീ ഇംപോര്‍ട്ട് ചെയ്യുവാനുള്ള ശ്രമത്തില്‍ പിശക്.
sec-error-pkcs12-importing-cert-chain = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധിക്കുന്നില്ല. സര്‍ട്ടിഫിക്കേറ്റ് ചെയിന്‍ ഇംപോര്‍ട്ട് ചെയ്യുന്ന ശ്രമത്തില്‍ പിശക്.
sec-error-pkcs12-unable-to-locate-object-by-name = എക്സ്പോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. സര്‍ട്ടിഫിക്കേറ്റ് അല്ലെങ്കില്‍ കീ വിളിപ്പേരു് ഉപയോഗിച്ച് ലഭ്യമാക്കുവാന്‍ സാധ്യമല്ല.
sec-error-pkcs12-unable-to-export-key = എക്സ്പോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. സ്വകാര്യ കീ ലഭ്യമാക്കുവാനോ എക്സ്പോര്‍ട്ട് ചെയ്യാനോ സാധിച്ചില്ല.
sec-error-pkcs12-unable-to-write = എക്സ്പോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. എക്സ്പോര്‍ട്ട് ഫയല്‍ എഴുതുവാന്‍ സാധ്യമല്ല.
sec-error-pkcs12-unable-to-read = ഇംപോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. ഇംപോര്‍ട്ട് ഫയല്‍ വായിക്കുവാന്‍ സാധ്യമല്ല.
sec-error-pkcs12-key-database-not-initialized = എക്സ്പോര്‍ട്ട് ചെയ്യുവാന്‍ സാധ്യമല്ല. കീ ഡേറ്റബെയിസ് തെറ്റാണു് അല്ലെങ്കില്‍ വെട്ടിനീക്കിയിരിക്കുന്നു.
sec-error-keygen-fail = പൊതു/സ്വകാര്യ കീ പെയര്‍ ലഭ്യമാക്കുവാന്‍ സാധ്യമല്ല.
sec-error-invalid-password = നല്‍കിയിരിക്കുന്ന ഒളിവാക്ക് അസാധുവാണ്. ദയവായി മറ്റൊന്നു് തെരഞ്ഞെടുക്കുക.
sec-error-retry-old-password = പഴയ ഒളിവാക്ക് തെറ്റായി നല്‍കിയിരിക്കുന്നു. ദയവായി വീണ്ടും ശ്രമിക്കൂ.
sec-error-bad-nickname = സര്‍ട്ടിഫിക്കേറ്റിനുള്ള വിളിപ്പേരു് നിലവിലുണ്ടു്.
sec-error-not-fortezza-issuer = പിയര്‍ FORTEZZA ചെയിനിനു് ഒരു non-FORTEZZA സാക്ഷ്യപത്രം ഉണ്ട്.
sec-error-cannot-move-sensitive-key = ആവശ്യമായ മറ്റൊരു സ്ലോട്ടിലേക്കു് ഒരു സെന്‍സിറ്റീവ് കീ നീക്കുവാന്‍ സാധ്യമല്ല.
sec-error-js-invalid-module-name = തെറ്റായ ഘടകനാമം..
sec-error-js-invalid-dll = തെറ്റായ ഘടകത്തിന്റെ പാത്ത്/ഫയല്‍നാമം.
sec-error-js-add-mod-failure = ഘടകം ‍ചേര്‍ക്കുവാന്‍ സാധ്യമല്ല.
sec-error-js-del-mod-failure = ഘടകം നീക്കം ചെയ്യുവാന്‍ സാധ്യമല്ല.
sec-error-old-krl = പുതിയ കെആര്‍എല്‍ നിലവിലുള്ളതിനേക്കാള്‍ പഴയതാണു്‌.
sec-error-ckl-conflict = പുതിയ CKL-നു് നിലവിലുള്ള CKL-നു് പുറമേ മറ്റൊരു ഇശ്യുവര്‍ ഉണ്ടു്. നിലവിലുള്ള CKL നീക്കം ചെയ്യുക.
sec-error-cert-not-in-name-space = ഈ സര്‍ട്ടിഫിക്കേറ്റിനു് ആഥികാരികത ഉള്ളവര്‍ക്കു് ഇതേ പേരില്‍ ഒരു സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമാക്കുവാന്‍ സാധ്യമല്ല.
sec-error-krl-not-yet-valid = ഈ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള കീ റിവോക്കേഷന്‍ പട്ടിക അസാധുവാണു്.
sec-error-crl-not-yet-valid = ഈ സര്‍ട്ടിഫിക്കേറ്റിനുള്ള സര്‍ട്ടിഫിക്കേറ്റ് റിവോക്കേഷന്‍ പട്ടിക അസാധുവാണു്.
sec-error-unknown-cert = ആവശ്യപ്പെട്ടിരിക്കുന്ന സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമല്ല.
sec-error-unknown-signer = സൈനറിനുള്ള സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമല്ല.
sec-error-cert-bad-access-location = സര്‍ട്ടിഫിക്കേറ്റ് സ്റ്റേറ്റസ് സര്‍വറിനുള്ള സ്ഥാനം തെറ്റായ രീതിയിലാണു്.
sec-error-ocsp-unknown-response-type = OCSP മറുപടി പൂര്‍ണ്ണമായി ഡീകോഡ് ചെയ്യുവാന്‍ സാധ്യമല്ല; ഇതു് അപരിചിതമായ തരത്തിലുള്ളതാണു്.
sec-error-ocsp-bad-http-response = OCSP സര്‍വര്‍ തെറ്റായ HTTP ഡേറ്റ നല്‍കിയിരിക്കുന്നു.
sec-error-ocsp-malformed-request = OCSP സര്‍വറിനു് ഈ ആവശ്യം തെറ്റായി ലഭിച്ചിരിക്കുന്നു.
sec-error-ocsp-server-error = OCSP സര്‍വറില്‍ ഒരു ആന്തരിക പിശക്.
sec-error-ocsp-try-server-later = OCSP സര്‍വര്‍ പിന്നീടു് വീണ്ടു് ശ്രമിക്കുന്നതിനായി നിര്‍ദ്ദേശിക്കുന്നു.
sec-error-ocsp-request-needs-sig = OCSP സര്‍വറിനു് ഈ ആവശ്യത്തില്‍ ഒരു ഒപ്പു് ആവശ്യമുണ്ടു്.
sec-error-ocsp-unauthorized-request = OCSP സര്‍വര്‍ ഈ ആവശ്യം ആധികാരികതയില്ലാത്തതായി നിഷേധിച്ചിരിക്കുന്നു.
sec-error-ocsp-unknown-response-status = OCSP സര്‍വര്‍ തിരിച്ചറിയാത്ത അവസ്ഥ ലഭ്യമാക്കിയിരിക്കുന്നു.
sec-error-ocsp-unknown-cert = OCSP സര്‍വറിനു് സര്‍ട്ടിഫിക്കേറ്റിനുള്ള അവസ്ഥ ലഭ്യമല്ല.
sec-error-ocsp-not-enabled = ഈ പ്രക്രിയ നടപ്പാക്കുന്നതിനു് മുമ്പു് നിങ്ങള്‍ OCSP പ്രവര്‍ത്തന സജ്ജമാക്കേണ്ടതാണു്.
sec-error-ocsp-no-default-responder = ഈ പ്രക്രിയ നടപ്പാക്കുന്നതിനു് മുമ്പു് നിങ്ങള്‍ OCSP ഡീഫോള്‍ട്ട് റെസ്പോണ്ടര്‍ സജ്ജമാക്കേണ്ടതാണു്.
sec-error-ocsp-malformed-response = OCSP സര്‍വറില്‍ നിന്നുള്ള മറുപടി തെറ്റായ രീതിയിലാണു്.
sec-error-ocsp-unauthorized-response = OCSP മറുപടിയുടെ സൈനറിനു് ഈ സര്‍ട്ടിഫിക്കേറ്റിന്റെ അവസ്ഥ ലഭ്യമാക്കുന്നതിനുള്ള ആധികാരികത ലഭ്യമല്ല.
sec-error-ocsp-future-response = OCSP മറുപടി തെറ്റാണു് (പിന്നീടുള്ള തീയതി ആണുള്ളതു്).
sec-error-ocsp-old-response = OCSP മറുപടിയില്‍ പഴയ വിവരം അടങ്ങുന്നു.
sec-error-digest-not-found = CMS അല്ലെങ്കില്‍ PKCS #7 ഡൈജസ്റ്റ് ഒപ്പിട്ട സന്ദേശത്തില്‍ ലഭ്യമായില്ല.
sec-error-unsupported-message-type = CMS അല്ലെങ്കില്‍ PKCS #7 സന്ദേശത്തിനുള്ള പിന്തുണ ലഭ്യമല്ല.
sec-error-module-stuck = PKCS #11 ഘടകം നീക്കം ചെയ്യുവാന്‍ സാധ്യമായില്ല, കാരണം ഇതു് ഇപ്പോഴും ഉപയോഗത്തിലാണു്.
sec-error-bad-template = ASN.1 ഡേറ്റ ഡീകോഡ് ചെയ്യുവാന്‍ സാധ്യമായില്ല. പറഞ്ഞിരിക്കുന്ന ടെംപ്ലേറ്റ് തെറ്റാണു്.
sec-error-crl-not-found = പൊരുത്തമുള്ള CRL ലഭ്യമായില്ല.
sec-error-reused-issuer-and-serial = നിലവിലുള്ള സര്‍ട്ടിഫിക്കേറ്റായി അതേ ഇഷ്യൂവര്‍/സീരിയലുള്ളൊരു സര്‍ട്ട് ഇംപോര്‍ട്ട് ചെയ്യുന്നതിനായി നിങ്ങള്‍ ശ്രമിയ്ക്കുന്നു.
sec-error-busy = NSS-നു് അടച്ചു പൂട്ടുവാന്‍ സാധ്യമായില്ല. വസ്തുക്കള്‍ ഇപ്പോഴും ഉപയോഗത്തിലാണു്.
sec-error-extra-input = DER-എന്‍കോഡ് ചെയ്ത സന്ദേശത്തില്‍ അധികമായ ഉപയോഗിയ്ക്കാത്ത ഡേറ്റാ.
sec-error-unsupported-elliptic-curve = പിന്തുണ ലഭ്യമല്ലാത്ത എലിപ്ടിക് കര്‍വ്.
sec-error-unsupported-ec-point-form = പിന്തുണ ലഭ്യമല്ലാത്ത എലിപ്ടിക് കര്‍വ് പോയിന്റ് ഫോം.
sec-error-unrecognized-oid = അപരിചിതമായ ഒബ്ജക്ട് ഐഡന്റിഫയര്‍.
sec-error-ocsp-invalid-signing-cert = OCSP മറുപടിയില്‍ തെറ്റായ OCSP സൈനിങ് സര്‍ട്ടിഫിക്കേറ്റ്.
sec-error-revoked-certificate-crl = ഇഷ്യൂവറിന്റെ റിവോക്കേഷന്‍ പട്ടികയില്‍ സര്‍ട്ടിഫിക്കേറ്റ് വീണ്ടും ലഭ്യമാക്കുന്നു.
sec-error-revoked-certificate-ocsp = ഇഷ്യൂവറിന്റെ ഒസിഎസ്പി റെസ്പോണ്ടര്‍ സര്‍ട്ടിഫിക്കേറ്റ് വിളിച്ചതായി രേഖപ്പെടുത്തുന്നു.
sec-error-crl-invalid-version = ഇഷ്യൂവറിന്റെ സര്‍ട്ടിഫിക്കേറ്റ് റിവോക്കേഷന്‍ പട്ടികയില്‍ അപരിചിതമായ പതിപ്പു് നംബര്‍.
sec-error-crl-v1-critical-extension = ഇഷ്യൂവറിന്റെ V1 സര്‍ട്ടിഫിക്കേറ്റ് റിവോക്കേഷന്‍ പട്ടികയില്‍ ഒരു തീവ്രമായ എക്സ്റ്റെന്‍ഷന്‍.
sec-error-crl-unknown-critical-extension = ഇഷ്യൂവറിന്റെ V2 സര്‍ട്ടിഫിക്കേറ്റ് റിവോക്കേഷന്‍ പട്ടികയില്‍ അപരിചിതമായ തീവ്രമായ എക്സ്റ്റെന്‍ഷന്‍.
sec-error-unknown-object-type = അപരിചിതമായ തരത്തിലുള്ള വസ്തു പറഞ്ഞിരിക്കുന്നു.
sec-error-incompatible-pkcs11 = PKCS #11 ഡ്രൈവര്‍ പൊരുത്തപ്പെടാത്ത രീതിയില്‍ സ്പെകില്‍ നിന്നും മാറുന്നു.
sec-error-no-event = ഈ സമയത്തു് പുതിയ സ്ലോട്ട് ഇവന്റ് ലഭ്യമല്ല.
sec-error-crl-already-exists = CRL നിലവിലുണ്ടു്.
sec-error-not-initialized = NSS ആരംഭിച്ചിട്ടില്ല.
sec-error-token-not-logged-in = PKCS#11 ടോക്കന്‍ ലോഗിന്‍ ചെയ്യാത്തതിനാല്‍ പ്രക്രിയ പരാജയപ്പെട്ടിരിക്കുന്നു.
sec-error-ocsp-responder-cert-invalid = ക്രമികരിച്ചിട്ടുള്ള OCSP റെസ്പോണ്ടറിന്റെ സര്‍ട്ടിഫീക്കേറ്റ് തെറ്റാണു്.
sec-error-ocsp-bad-signature = OCSP മറുപടിയില്‍ തെറ്റായ ഒപ്പു് ഉണ്ടു്.
sec-error-out-of-search-limits = Cert ഉറപ്പാക്കല്‍ തെരച്ചില്‍ പരിധിയ്ക്കു് പുറത്തു്
sec-error-invalid-policy-mapping = പോളിസി മാപ്പിങില്‍ ഏതു് പോളിസിയുമുണ്ടു്
sec-error-policy-validation-failed = പോളിസി ഉറപ്പാക്കല്‍ Cert ചെയിന്‍ പരാജയപ്പെടുത്തുന്നു
sec-error-unknown-aia-location-type = cert AIA എക്സ്റ്റെന്‍ഷനില്‍ അപരിചിതമായ സ്ഥാന രീതി
sec-error-bad-http-response = സര്‍വര്‍ തെറ്റായ എച്‌ടിടിപി മറുപടി നല്‍കിയിരിയ്ക്കുന്നു.
sec-error-bad-ldap-response = സര്‍വര്‍ തെറ്റായ എല്‍ഡിഎപി മറുപടി നല്‍കിയിരിയ്ക്കുന്നു.
sec-error-failed-to-encode-data = എഎസ്എ1 എന്‍കോഡറില്‍ ഡേറ്റാ എന്‍കോഡ് ചെയ്യുന്നതില്‍ പരാജയപ്പെട്ടു
sec-error-bad-info-access-location = cert എക്സ്റ്റെന്‍ഷനില്‍ തെറ്റായ ആക്സ്സ് സ്ഥാനം
sec-error-libpkix-internal = cert ഉറപ്പാക്കുന്ന സമയത്തു് Libpkix ആന്തരിക പിശക്.
sec-error-pkcs11-general-error = PKCS #11 ഘടകം CKR_GENERAL_ERROR തിരികെ നല്‍കിയിരിയ്ക്കുന്നു, ഇതിനര്‍ത്ഥം വീണ്ടെടുക്കുവാന്‍ സാധ്യമല്ലാത്തൊരു പിശക് ഉണ്ടായിരിയ്ക്കുന്നു എന്നാണു്.
sec-error-pkcs11-function-failed = PKCS #11 ഘടകം CKR_FUNCTION_FAILED തിരികെ നല്‍കിയിരിയ്ക്കുന്നു, ഇതിനര്‍ത്ഥം ആവശ്യപ്പെട്ട ഫംഗ്ഷന്‍ നടപ്പിലാക്കുവാന്‍ സാധ്യമായില്ല എന്നാണു്. അതേ പ്രക്രിയ വീണ്ടും ശ്രമിയ്ക്കുന്നതു് ഒരു പക്ഷേ, വിജയിയ്ക്കും.
sec-error-pkcs11-device-error = PKCS #11 ഘടകം CKR_DEVICE_ERROR തിരികെ നല്‍കിയിരിയ്ക്കുന്നു, ഇതിനര്‍ത്ഥം ടോക്കന്‍ അല്ലെങ്കില്‍ സ്ലോട്ടില്‍ ഒരു പ്രശ്നം ഉണ്ടായിരിയ്ക്കുന്നു എന്നാണു്.
sec-error-bad-info-access-method = സര്‍ട്ടിഫിക്കേറ്റ് എക്സ്റ്റെന്‍ഷനില്‍ അപരിചിതമായ ആക്സ്സ് രീതി.
sec-error-crl-import-failed = ഒരു സിആര്‍എല്‍ ഇംപോര്‍ട്ട് ചെയ്യുന്നതില്‍ പിശക്.
sec-error-expired-password = ഒളിവാക്കിന്റെ കാലാവധി കഴിഞ്ഞിരിയ്ക്കുന്നു.
sec-error-locked-password = ഒളിവാക്ക് പൂട്ടിയിരിയ്ക്കുന്നു.
sec-error-unknown-pkcs11-error = അപരിചിതമായ പികെസിഎസ് #11 പിശക്.
sec-error-bad-crl-dp-url = സിആര്‍എല്‍ വിതരണ പോയിന്റ് നാമത്തില്‍ തെറ്റായ അല്ലെങ്കില്‍ പിന്തുണയില്ലാത്ത യുആര്‍എല്‍.
sec-error-cert-signature-algorithm-disabled = സര്‍ട്ടിഫിക്കേറ്റ് സുരക്ഷിതമല്ലാത്തതിനാല്‍ പ്രവര്‍ത്തന രഹിതമായൊരു സിഗ്നേച്ചര്‍ ആല്‍ഗോരിഥം ഉപയോഗിച്ചു് ഒപ്പിട്ടിരിയ്ക്കുന്നു.
mozilla-pkix-error-key-pinning-failure = സര്‍വര്‍ കീ പിന്നിംഗ് (HPKP) ഉപയോഗിക്കുന്നു, പക്ഷെ പിന്‍സെറ്റുമായി യോജിക്കുന്ന വിശ്വാസ്യയോഗ്യമായ സര്‍റ്റിഫിക്കറ്റ് ഉണ്ടാക്കാന്‍ കഴിയുന്നില്ല. കീ പിന്നിംഗ് ലംഘനങ്ങള്‍ പിന്നീട് അസാധുവാക്കാന്‍ പറ്റില്ല.
mozilla-pkix-error-ca-cert-used-as-end-entity = ഇ സെര്‍വ്വര്‍ അടിസ്ഥാന കോണ്‍സ്ട്രൈന്‍റ്റ്സ് എക്സ്റ്റെന്‍ഷന്‍ വെച്ച് സാക്ഷ്യപത്ര അധികാരി ആയി തിരിച്ചറിയുന്നു. ശരിക്കുള്ള സാക്ഷ്യപത്രം അങ്ങനെയല്ല.
mozilla-pkix-error-inadequate-key-size = സുരക്ഷിതമായൊരു കണക്ഷന്‍ തയ്യാറാക്കുവാന്‍ മതിയാകാത്ത കീ വ്യാപ്തിയുള്ളൊരു സര്‍ട്ടിഫിക്കേറ്റ് സര്‍വര്‍ നല്‍കിയിരിക്കുന്നു.
mozilla-pkix-error-v1-cert-used-as-ca = ട്രസ്റ്റ് ആങ്കര്‍ അല്ലാത്ത ഒരു X.509 ഒന്നാം പതിപ്പു് സാക്ഷ്യപത്രം ആണ് ഈ സെര്‍വ്വറിന്റെ സാക്ഷ്യപത്രം കൊടുക്കാന്‍ ഉപയോഗിച്ചത്. X.509 ഒന്നാം പതിപ്പു് വേണ്ടെന്നുവച്ചതാണ്. അത് മറ്റുള്ള സാക്ഷ്യപത്രം ഒപ്പിടാന്‍ എ​ടുക്കരുത്.
mozilla-pkix-error-not-yet-valid-certificate = സാധുതയില്ലാത്തൊരു സര്‍ട്ടിഫിക്കേറ്റ് സര്‍വര്‍ ലഭ്യമാക്കിയിരിയ്ക്കുന്നു.
mozilla-pkix-error-not-yet-valid-issuer-certificate = ഇതുവരെ സാധുതയില്ലാത്തൊരു സര്‍ട്ടിഫിക്കേറ്റ് ഉപയോഗിച്ചു് സര്‍വറിന്റെ സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമാക്കിയിരിയ്ക്കുന്നു.
mozilla-pkix-error-signature-algorithm-mismatch = സര്‍റ്റിഫിക്കറ്റിന്റെ സിഗ്നേച്ചര്‍ ഫീല്‍ഡിലെ സിഗ്നേച്ചര്‍ അല്‍ഗോരിഥം അതിന്‍റെ സിഗ്നേച്ചര്‍ ഫീല്‍ഡിലെ അല്‍ഗോരിഥവുമായി ചേരുന്നില്ല.
mozilla-pkix-error-ocsp-response-for-cert-missing = OCSP പ്രതികരണത്തില്‍ പരിശോധിചു കൊണ്ടിരിക്കുന്ന സര്‍റ്റിഫിക്കറ്റിന്റെ അവസ്ഥ ഉള്‍പെട്ടിട്ടില്ല.
mozilla-pkix-error-validity-too-long = സര്‍വര്‍ തന്ന സാക്ഷ്യപത്രം വളരെയഥികം കാലം സാധുവാണ്.
mozilla-pkix-error-required-tls-feature-missing = ആവശ്യമായ ഒരു TLS ഫീച്ചർ കാണുന്നില്ല.
xp-java-remove-principal-error = പ്രിന്‍സിപ്പള്‍ നീക്കം ചെയ്യുവാന്‍ സാധ്യമായില്ല
xp-java-delete-privilege-error = മുന്‍ഗണന നീക്കം ചെയ്യുവാന്‍ സാധ്യമായില്ല
xp-java-cert-not-exists-error = ഈ പ്രിന്‍സിപ്പളിനു് സര്‍ട്ടിഫിക്കേറ്റ് ലഭ്യമല്ല
xp-sec-fortezza-bad-card = ഫോര്‍ട്ടെസ്സാ കാര്‍ഡ് ശരിയായി ആരംഭിച്ചിട്ടില്ല. ദയാവായി ഇതു് നീക്കം ചെയ്തു് നിങ്ങളുടെ ഇഷ്യൂവറിനു് തിരികെ നല്‍കുക.
xp-sec-fortezza-no-card = ഫോര്‍ട്ടെസ്സാ കാര്‍ഡുകള്‍ ലഭ്യമായില്ല
xp-sec-fortezza-none-selected = ഒരു ഫോര്‍ട്ടെസ്സാ കാര്‍ഡും തെരഞ്ഞെടുത്തിട്ടില്ല
xp-sec-fortezza-more-info = ദയവായി കൂടുതല്‍ വിവരം ലഭ്യമാക്കുന്നതിനായി ഒരു പെഴ്സണാലിറ്റി തെരഞ്ഞെടുക്കുക
xp-sec-fortezza-person-not-found = പെഴ്സണാലിറ്റി ലഭ്യമായില്ല
xp-sec-fortezza-no-more-info = ഈ പെഴ്സണാലിറ്റിയെപ്പറ്റി ഒരു വിവരവുമില്ല
xp-sec-fortezza-bad-pin = തെറ്റായ പിന്‍
xp-sec-fortezza-person-error = ഫോര്‍ട്ടെസ്സാ ആരംഭിയ്ക്കുവാന്‍ സാധ്യമായില്ല.
