// Code generated by protoc-gen-psrpc v0.5.1, DO NOT EDIT.
// source: rpc/ingress.proto

package rpc

import (
	"context"

	"github.com/livekit/psrpc"
	"github.com/livekit/psrpc/pkg/client"
	"github.com/livekit/psrpc/pkg/info"
	"github.com/livekit/psrpc/pkg/rand"
	"github.com/livekit/psrpc/pkg/server"
	"github.com/livekit/psrpc/version"
)
import google_protobuf "google.golang.org/protobuf/types/known/emptypb"
import livekit3 "github.com/livekit/protocol/livekit"

var _ = version.PsrpcVersion_0_5

// ================================
// IngressInternal Client Interface
// ================================

type IngressInternalClient interface {
	StartIngress(ctx context.Context, req *StartIngressRequest, opts ...psrpc.RequestOption) (*livekit3.IngressInfo, error)

	ListActiveIngress(ctx context.Context, topic string, req *ListActiveIngressRequest, opts ...psrpc.RequestOption) (<-chan *psrpc.Response[*ListActiveIngressResponse], error)
}

// ====================================
// IngressInternal ServerImpl Interface
// ====================================

type IngressInternalServerImpl interface {
	StartIngress(context.Context, *StartIngressRequest) (*livekit3.IngressInfo, error)
	StartIngressAffinity(context.Context, *StartIngressRequest) float32

	ListActiveIngress(context.Context, *ListActiveIngressRequest) (*ListActiveIngressResponse, error)
}

// ================================
// IngressInternal Server Interface
// ================================

type IngressInternalServer interface {
	RegisterListActiveIngressTopic(topic string) error
	DeregisterListActiveIngressTopic(topic string)

	// Close and wait for pending RPCs to complete
	Shutdown()

	// Close immediately, without waiting for pending RPCs
	Kill()
}

// ======================
// IngressInternal Client
// ======================

type ingressInternalClient struct {
	client *client.RPCClient
}

// NewIngressInternalClient creates a psrpc client that implements the IngressInternalClient interface.
func NewIngressInternalClient(bus psrpc.MessageBus, opts ...psrpc.ClientOption) (IngressInternalClient, error) {
	sd := &info.ServiceDefinition{
		Name: "IngressInternal",
		ID:   rand.NewClientID(),
	}

	sd.RegisterMethod("StartIngress", true, false, true, false)
	sd.RegisterMethod("ListActiveIngress", false, true, false, false)

	rpcClient, err := client.NewRPCClient(sd, bus, opts...)
	if err != nil {
		return nil, err
	}

	return &ingressInternalClient{
		client: rpcClient,
	}, nil
}

func (c *ingressInternalClient) StartIngress(ctx context.Context, req *StartIngressRequest, opts ...psrpc.RequestOption) (*livekit3.IngressInfo, error) {
	return client.RequestSingle[*livekit3.IngressInfo](ctx, c.client, "StartIngress", nil, req, opts...)
}

func (c *ingressInternalClient) ListActiveIngress(ctx context.Context, topic string, req *ListActiveIngressRequest, opts ...psrpc.RequestOption) (<-chan *psrpc.Response[*ListActiveIngressResponse], error) {
	return client.RequestMulti[*ListActiveIngressResponse](ctx, c.client, "ListActiveIngress", []string{topic}, req, opts...)
}

// ======================
// IngressInternal Server
// ======================

type ingressInternalServer struct {
	svc IngressInternalServerImpl
	rpc *server.RPCServer
}

// NewIngressInternalServer builds a RPCServer that will route requests
// to the corresponding method in the provided svc implementation.
func NewIngressInternalServer(svc IngressInternalServerImpl, bus psrpc.MessageBus, opts ...psrpc.ServerOption) (IngressInternalServer, error) {
	sd := &info.ServiceDefinition{
		Name: "IngressInternal",
		ID:   rand.NewServerID(),
	}

	s := server.NewRPCServer(sd, bus, opts...)

	sd.RegisterMethod("StartIngress", true, false, true, false)
	var err error
	err = server.RegisterHandler(s, "StartIngress", nil, svc.StartIngress, svc.StartIngressAffinity)
	if err != nil {
		s.Close(false)
		return nil, err
	}

	sd.RegisterMethod("ListActiveIngress", false, true, false, false)
	return &ingressInternalServer{
		svc: svc,
		rpc: s,
	}, nil
}

func (s *ingressInternalServer) RegisterListActiveIngressTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "ListActiveIngress", []string{topic}, s.svc.ListActiveIngress, nil)
}

func (s *ingressInternalServer) DeregisterListActiveIngressTopic(topic string) {
	s.rpc.DeregisterHandler("ListActiveIngress", []string{topic})
}

func (s *ingressInternalServer) Shutdown() {
	s.rpc.Close(false)
}

func (s *ingressInternalServer) Kill() {
	s.rpc.Close(true)
}

// ===============================
// IngressHandler Client Interface
// ===============================

type IngressHandlerClient interface {
	UpdateIngress(ctx context.Context, topic string, req *livekit3.UpdateIngressRequest, opts ...psrpc.RequestOption) (*livekit3.IngressState, error)

	DeleteIngress(ctx context.Context, topic string, req *livekit3.DeleteIngressRequest, opts ...psrpc.RequestOption) (*livekit3.IngressState, error)

	DeleteWHIPResource(ctx context.Context, topic string, req *DeleteWHIPResourceRequest, opts ...psrpc.RequestOption) (*google_protobuf.Empty, error)
}

// ===================================
// IngressHandler ServerImpl Interface
// ===================================

type IngressHandlerServerImpl interface {
	UpdateIngress(context.Context, *livekit3.UpdateIngressRequest) (*livekit3.IngressState, error)

	DeleteIngress(context.Context, *livekit3.DeleteIngressRequest) (*livekit3.IngressState, error)

	DeleteWHIPResource(context.Context, *DeleteWHIPResourceRequest) (*google_protobuf.Empty, error)
}

// ===============================
// IngressHandler Server Interface
// ===============================

type IngressHandlerServer interface {
	RegisterUpdateIngressTopic(topic string) error
	DeregisterUpdateIngressTopic(topic string)
	RegisterDeleteIngressTopic(topic string) error
	DeregisterDeleteIngressTopic(topic string)
	RegisterDeleteWHIPResourceTopic(topic string) error
	DeregisterDeleteWHIPResourceTopic(topic string)

	// Close and wait for pending RPCs to complete
	Shutdown()

	// Close immediately, without waiting for pending RPCs
	Kill()
}

// =====================
// IngressHandler Client
// =====================

type ingressHandlerClient struct {
	client *client.RPCClient
}

// NewIngressHandlerClient creates a psrpc client that implements the IngressHandlerClient interface.
func NewIngressHandlerClient(bus psrpc.MessageBus, opts ...psrpc.ClientOption) (IngressHandlerClient, error) {
	sd := &info.ServiceDefinition{
		Name: "IngressHandler",
		ID:   rand.NewClientID(),
	}

	sd.RegisterMethod("UpdateIngress", false, false, true, true)
	sd.RegisterMethod("DeleteIngress", false, false, true, true)
	sd.RegisterMethod("DeleteWHIPResource", false, false, true, true)

	rpcClient, err := client.NewRPCClient(sd, bus, opts...)
	if err != nil {
		return nil, err
	}

	return &ingressHandlerClient{
		client: rpcClient,
	}, nil
}

func (c *ingressHandlerClient) UpdateIngress(ctx context.Context, topic string, req *livekit3.UpdateIngressRequest, opts ...psrpc.RequestOption) (*livekit3.IngressState, error) {
	return client.RequestSingle[*livekit3.IngressState](ctx, c.client, "UpdateIngress", []string{topic}, req, opts...)
}

func (c *ingressHandlerClient) DeleteIngress(ctx context.Context, topic string, req *livekit3.DeleteIngressRequest, opts ...psrpc.RequestOption) (*livekit3.IngressState, error) {
	return client.RequestSingle[*livekit3.IngressState](ctx, c.client, "DeleteIngress", []string{topic}, req, opts...)
}

func (c *ingressHandlerClient) DeleteWHIPResource(ctx context.Context, topic string, req *DeleteWHIPResourceRequest, opts ...psrpc.RequestOption) (*google_protobuf.Empty, error) {
	return client.RequestSingle[*google_protobuf.Empty](ctx, c.client, "DeleteWHIPResource", []string{topic}, req, opts...)
}

// =====================
// IngressHandler Server
// =====================

type ingressHandlerServer struct {
	svc IngressHandlerServerImpl
	rpc *server.RPCServer
}

// NewIngressHandlerServer builds a RPCServer that will route requests
// to the corresponding method in the provided svc implementation.
func NewIngressHandlerServer(svc IngressHandlerServerImpl, bus psrpc.MessageBus, opts ...psrpc.ServerOption) (IngressHandlerServer, error) {
	sd := &info.ServiceDefinition{
		Name: "IngressHandler",
		ID:   rand.NewServerID(),
	}

	s := server.NewRPCServer(sd, bus, opts...)

	sd.RegisterMethod("UpdateIngress", false, false, true, true)
	sd.RegisterMethod("DeleteIngress", false, false, true, true)
	sd.RegisterMethod("DeleteWHIPResource", false, false, true, true)
	return &ingressHandlerServer{
		svc: svc,
		rpc: s,
	}, nil
}

func (s *ingressHandlerServer) RegisterUpdateIngressTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "UpdateIngress", []string{topic}, s.svc.UpdateIngress, nil)
}

func (s *ingressHandlerServer) DeregisterUpdateIngressTopic(topic string) {
	s.rpc.DeregisterHandler("UpdateIngress", []string{topic})
}

func (s *ingressHandlerServer) RegisterDeleteIngressTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "DeleteIngress", []string{topic}, s.svc.DeleteIngress, nil)
}

func (s *ingressHandlerServer) DeregisterDeleteIngressTopic(topic string) {
	s.rpc.DeregisterHandler("DeleteIngress", []string{topic})
}

func (s *ingressHandlerServer) RegisterDeleteWHIPResourceTopic(topic string) error {
	return server.RegisterHandler(s.rpc, "DeleteWHIPResource", []string{topic}, s.svc.DeleteWHIPResource, nil)
}

func (s *ingressHandlerServer) DeregisterDeleteWHIPResourceTopic(topic string) {
	s.rpc.DeregisterHandler("DeleteWHIPResource", []string{topic})
}

func (s *ingressHandlerServer) Shutdown() {
	s.rpc.Close(false)
}

func (s *ingressHandlerServer) Kill() {
	s.rpc.Close(true)
}

var psrpcFileDescriptor2 = []byte{
	// 524 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x53, 0xd1, 0x8b, 0xd3, 0x4e,
	0x10, 0x66, 0xd3, 0xfb, 0x95, 0xdf, 0xcd, 0xd9, 0xb3, 0xb7, 0x5e, 0x25, 0x17, 0x39, 0x2d, 0x79,
	0x2a, 0x2a, 0x89, 0xd4, 0x17, 0x11, 0x1f, 0xaa, 0x78, 0xd2, 0xe2, 0x09, 0x92, 0xf3, 0x10, 0x14,
	0x0c, 0x69, 0x32, 0x8d, 0x4b, 0xd3, 0x6c, 0xdc, 0xdd, 0xf4, 0xe8, 0xab, 0xf8, 0xd2, 0x7f, 0xa7,
	0xaf, 0xfe, 0x73, 0x92, 0x6c, 0x72, 0xb4, 0xb6, 0x05, 0x9f, 0xda, 0xfd, 0xe6, 0x9b, 0x6f, 0xbe,
	0x99, 0xcc, 0xc0, 0x89, 0xc8, 0x42, 0x97, 0xa5, 0xb1, 0x40, 0x29, 0x9d, 0x4c, 0x70, 0xc5, 0x69,
	0x43, 0x64, 0xa1, 0xd5, 0xe2, 0x99, 0x62, 0x3c, 0xad, 0x30, 0xab, 0x93, 0xb0, 0x39, 0x4e, 0x99,
	0xf2, 0x37, 0xa8, 0xd6, 0x83, 0x98, 0xf3, 0x38, 0x41, 0xb7, 0x7c, 0x8d, 0xf3, 0x89, 0x8b, 0xb3,
	0x4c, 0x2d, 0x74, 0xd0, 0xb6, 0xc0, 0xbc, 0x64, 0x52, 0xbd, 0x0e, 0x15, 0x9b, 0xe3, 0x48, 0xe7,
	0x79, 0xf8, 0x23, 0x47, 0xa9, 0xec, 0x57, 0x70, 0xb6, 0x23, 0x26, 0x33, 0x9e, 0x4a, 0xa4, 0x8f,
	0xe0, 0xa8, 0x2a, 0xe3, 0xb3, 0x48, 0x9a, 0xa4, 0xdb, 0xe8, 0x1d, 0x7a, 0x50, 0x41, 0xa3, 0x48,
	0xda, 0x5f, 0xe1, 0xec, 0x2d, 0x26, 0xa8, 0xf0, 0xf3, 0x70, 0xf4, 0xd1, 0x43, 0xc9, 0x73, 0x11,
	0x62, 0x25, 0x5d, 0x64, 0x8b, 0x0a, 0xf2, 0x59, 0x64, 0x92, 0x2e, 0x29, 0xb2, 0x6b, 0x68, 0x14,
	0xd1, 0x73, 0x00, 0xa9, 0x04, 0x06, 0x33, 0x7f, 0x8a, 0x0b, 0xd3, 0x28, 0xe3, 0x87, 0x1a, 0x79,
	0x8f, 0x0b, 0xfb, 0xa7, 0x01, 0xf7, 0xae, 0x54, 0x20, 0xd4, 0xa6, 0x65, 0xda, 0x83, 0x03, 0x96,
	0x4e, 0x78, 0x29, 0x78, 0xd4, 0x3f, 0x75, 0xaa, 0x89, 0x38, 0x15, 0x6d, 0x94, 0x4e, 0xb8, 0x57,
	0x32, 0xe8, 0x29, 0xfc, 0xa7, 0xf8, 0x14, 0xd3, 0x4a, 0x5b, 0x3f, 0x68, 0x07, 0x9a, 0x37, 0xd2,
	0xcf, 0x45, 0x62, 0x36, 0x34, 0x7c, 0x23, 0xaf, 0x45, 0x42, 0x3d, 0x38, 0x4e, 0x78, 0x1c, 0xb3,
	0x34, 0xf6, 0x27, 0x0c, 0x93, 0x48, 0x9a, 0x07, 0xdd, 0x46, 0xef, 0xa8, 0xff, 0xc4, 0x11, 0x59,
	0xe8, 0xec, 0x30, 0xe2, 0x5c, 0x6a, 0xfa, 0xbb, 0x92, 0x7d, 0x91, 0x2a, 0xb1, 0xf0, 0x5a, 0xc9,
	0x3a, 0x66, 0x0d, 0x80, 0x6e, 0x93, 0x68, 0x1b, 0x1a, 0x45, 0xc3, 0x7a, 0x20, 0xc5, 0xdf, 0xc2,
	0xe8, 0x3c, 0x48, 0x72, 0xac, 0x8d, 0x96, 0x8f, 0x97, 0xc6, 0x0b, 0xd2, 0xff, 0x4d, 0xe0, 0xee,
	0x6d, 0x63, 0x0a, 0x45, 0x1a, 0x24, 0x74, 0x08, 0x77, 0xd6, 0xed, 0x50, 0x73, 0x9f, 0x43, 0x6b,
	0xe7, 0x70, 0xec, 0xff, 0x57, 0x4b, 0x72, 0x30, 0x20, 0xcf, 0x08, 0xfd, 0x06, 0x27, 0x5b, 0x5f,
	0x9f, 0x9e, 0x97, 0x72, 0xfb, 0x36, 0xc6, 0x7a, 0xb8, 0x2f, 0xac, 0x97, 0xc6, 0x86, 0xd5, 0x92,
	0x34, 0xdb, 0x64, 0x60, 0xf4, 0x48, 0xff, 0x97, 0x01, 0xc7, 0x55, 0x7c, 0x18, 0xa4, 0x51, 0x82,
	0x82, 0x7e, 0x80, 0xd6, 0x75, 0x16, 0x05, 0x6a, 0xad, 0x5c, 0xed, 0x71, 0x03, 0xaf, 0xcb, 0x75,
	0xfe, 0x6e, 0xe1, 0x4a, 0x05, 0x0a, 0xed, 0xe6, 0x6a, 0x49, 0x8c, 0x36, 0x29, 0xe4, 0xf4, 0x06,
	0x6e, 0xcb, 0x6d, 0xe0, 0xff, 0x28, 0xf7, 0x09, 0xe8, 0xf6, 0x42, 0x53, 0xdd, 0xf2, 0xde, 0x4d,
	0xb7, 0xee, 0x3b, 0xfa, 0xfc, 0x9c, 0xfa, 0xfc, 0x9c, 0x8b, 0xe2, 0xfc, 0x6a, 0xd5, 0x37, 0x4f,
	0xbf, 0x3c, 0x8e, 0x99, 0xfa, 0x9e, 0x8f, 0x9d, 0x90, 0xcf, 0xdc, 0xca, 0xc0, 0xed, 0x6f, 0x36,
	0x8d, 0x5d, 0x89, 0x62, 0xce, 0x42, 0x74, 0x45, 0x16, 0x8e, 0x9b, 0xa5, 0xca, 0xf3, 0x3f, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x92, 0x24, 0x86, 0x55, 0x12, 0x04, 0x00, 0x00,
}
