// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v1.7.2 with parameter "target=js+dts"
// @generated from file livekit_sip.proto (package livekit, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import { proto3 } from "@bufbuild/protobuf";

/**
 * @generated from message livekit.CreateSIPTrunkRequest
 */
export const CreateSIPTrunkRequest = proto3.makeMessageType(
  "livekit.CreateSIPTrunkRequest",
  () => [
    { no: 1, name: "inbound_addresses", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "outbound_address", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "outbound_number", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "inbound_numbers_regex", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 5, name: "inbound_username", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 6, name: "inbound_password", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 7, name: "outbound_username", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 8, name: "outbound_password", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.SIPTrunkInfo
 */
export const SIPTrunkInfo = proto3.makeMessageType(
  "livekit.SIPTrunkInfo",
  () => [
    { no: 1, name: "sip_trunk_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "inbound_addresses", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "outbound_address", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "outbound_number", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "inbound_numbers_regex", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 6, name: "inbound_username", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 7, name: "inbound_password", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 8, name: "outbound_username", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 9, name: "outbound_password", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.ListSIPTrunkRequest
 */
export const ListSIPTrunkRequest = proto3.makeMessageType(
  "livekit.ListSIPTrunkRequest",
  [],
);

/**
 * @generated from message livekit.ListSIPTrunkResponse
 */
export const ListSIPTrunkResponse = proto3.makeMessageType(
  "livekit.ListSIPTrunkResponse",
  () => [
    { no: 1, name: "items", kind: "message", T: SIPTrunkInfo, repeated: true },
  ],
);

/**
 * @generated from message livekit.DeleteSIPTrunkRequest
 */
export const DeleteSIPTrunkRequest = proto3.makeMessageType(
  "livekit.DeleteSIPTrunkRequest",
  () => [
    { no: 1, name: "sip_trunk_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.SIPDispatchRuleDirect
 */
export const SIPDispatchRuleDirect = proto3.makeMessageType(
  "livekit.SIPDispatchRuleDirect",
  () => [
    { no: 1, name: "room_name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "pin", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.SIPDispatchRuleIndividual
 */
export const SIPDispatchRuleIndividual = proto3.makeMessageType(
  "livekit.SIPDispatchRuleIndividual",
  () => [
    { no: 1, name: "room_prefix", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "pin", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.SIPDispatchRule
 */
export const SIPDispatchRule = proto3.makeMessageType(
  "livekit.SIPDispatchRule",
  () => [
    { no: 1, name: "dispatch_rule_direct", kind: "message", T: SIPDispatchRuleDirect, oneof: "rule" },
    { no: 2, name: "dispatch_rule_individual", kind: "message", T: SIPDispatchRuleIndividual, oneof: "rule" },
  ],
);

/**
 * @generated from message livekit.CreateSIPDispatchRuleRequest
 */
export const CreateSIPDispatchRuleRequest = proto3.makeMessageType(
  "livekit.CreateSIPDispatchRuleRequest",
  () => [
    { no: 1, name: "rule", kind: "message", T: SIPDispatchRule },
    { no: 2, name: "trunk_ids", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "hide_phone_number", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ],
);

/**
 * @generated from message livekit.SIPDispatchRuleInfo
 */
export const SIPDispatchRuleInfo = proto3.makeMessageType(
  "livekit.SIPDispatchRuleInfo",
  () => [
    { no: 1, name: "sip_dispatch_rule_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "rule", kind: "message", T: SIPDispatchRule },
    { no: 3, name: "trunk_ids", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "hide_phone_number", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ],
);

/**
 * @generated from message livekit.ListSIPDispatchRuleRequest
 */
export const ListSIPDispatchRuleRequest = proto3.makeMessageType(
  "livekit.ListSIPDispatchRuleRequest",
  [],
);

/**
 * @generated from message livekit.ListSIPDispatchRuleResponse
 */
export const ListSIPDispatchRuleResponse = proto3.makeMessageType(
  "livekit.ListSIPDispatchRuleResponse",
  () => [
    { no: 1, name: "items", kind: "message", T: SIPDispatchRuleInfo, repeated: true },
  ],
);

/**
 * @generated from message livekit.DeleteSIPDispatchRuleRequest
 */
export const DeleteSIPDispatchRuleRequest = proto3.makeMessageType(
  "livekit.DeleteSIPDispatchRuleRequest",
  () => [
    { no: 1, name: "sip_dispatch_rule_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * A SIP Participant is a singular SIP session connected to a LiveKit room via
 * a SIP Trunk into a SIP DispatchRule
 *
 * @generated from message livekit.CreateSIPParticipantRequest
 */
export const CreateSIPParticipantRequest = proto3.makeMessageType(
  "livekit.CreateSIPParticipantRequest",
  () => [
    { no: 1, name: "sip_trunk_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "sip_call_to", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "room_name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "participant_identity", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

/**
 * @generated from message livekit.SIPParticipantInfo
 */
export const SIPParticipantInfo = proto3.makeMessageType(
  "livekit.SIPParticipantInfo",
  () => [
    { no: 1, name: "participant_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "participant_identity", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "room_name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ],
);

