// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.4
// source: livekit_sip.proto

package livekit

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CreateSIPTrunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CIDR or IPs that traffic is accepted from
	// An empty list means all inbound traffic is accepted.
	InboundAddresses []string `protobuf:"bytes,1,rep,name=inbound_addresses,json=inboundAddresses,proto3" json:"inbound_addresses,omitempty"`
	// IP that SIP INVITE is sent too
	OutboundAddress string `protobuf:"bytes,2,opt,name=outbound_address,json=outboundAddress,proto3" json:"outbound_address,omitempty"`
	// Number used to make outbound calls
	OutboundNumber string `protobuf:"bytes,3,opt,name=outbound_number,json=outboundNumber,proto3" json:"outbound_number,omitempty"`
	// Accepted `To` values. This Trunk will only accept a call made to
	// these numbers. This allows you to have distinct Trunks for different phone
	// numbers at the same provider.
	InboundNumbersRegex []string `protobuf:"bytes,4,rep,name=inbound_numbers_regex,json=inboundNumbersRegex,proto3" json:"inbound_numbers_regex,omitempty"`
	// Username and password used to authenticate inbound and outbound SIP invites
	// May be empty to have no Authentication
	InboundUsername  string `protobuf:"bytes,5,opt,name=inbound_username,json=inboundUsername,proto3" json:"inbound_username,omitempty"`
	InboundPassword  string `protobuf:"bytes,6,opt,name=inbound_password,json=inboundPassword,proto3" json:"inbound_password,omitempty"`
	OutboundUsername string `protobuf:"bytes,7,opt,name=outbound_username,json=outboundUsername,proto3" json:"outbound_username,omitempty"`
	OutboundPassword string `protobuf:"bytes,8,opt,name=outbound_password,json=outboundPassword,proto3" json:"outbound_password,omitempty"`
}

func (x *CreateSIPTrunkRequest) Reset() {
	*x = CreateSIPTrunkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSIPTrunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSIPTrunkRequest) ProtoMessage() {}

func (x *CreateSIPTrunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSIPTrunkRequest.ProtoReflect.Descriptor instead.
func (*CreateSIPTrunkRequest) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{0}
}

func (x *CreateSIPTrunkRequest) GetInboundAddresses() []string {
	if x != nil {
		return x.InboundAddresses
	}
	return nil
}

func (x *CreateSIPTrunkRequest) GetOutboundAddress() string {
	if x != nil {
		return x.OutboundAddress
	}
	return ""
}

func (x *CreateSIPTrunkRequest) GetOutboundNumber() string {
	if x != nil {
		return x.OutboundNumber
	}
	return ""
}

func (x *CreateSIPTrunkRequest) GetInboundNumbersRegex() []string {
	if x != nil {
		return x.InboundNumbersRegex
	}
	return nil
}

func (x *CreateSIPTrunkRequest) GetInboundUsername() string {
	if x != nil {
		return x.InboundUsername
	}
	return ""
}

func (x *CreateSIPTrunkRequest) GetInboundPassword() string {
	if x != nil {
		return x.InboundPassword
	}
	return ""
}

func (x *CreateSIPTrunkRequest) GetOutboundUsername() string {
	if x != nil {
		return x.OutboundUsername
	}
	return ""
}

func (x *CreateSIPTrunkRequest) GetOutboundPassword() string {
	if x != nil {
		return x.OutboundPassword
	}
	return ""
}

type SIPTrunkInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SipTrunkId string `protobuf:"bytes,1,opt,name=sip_trunk_id,json=sipTrunkId,proto3" json:"sip_trunk_id,omitempty"`
	// CIDR or IPs that traffic is accepted from
	// An empty list means all inbound traffic is accepted.
	InboundAddresses []string `protobuf:"bytes,2,rep,name=inbound_addresses,json=inboundAddresses,proto3" json:"inbound_addresses,omitempty"`
	// IP that SIP INVITE is sent too
	OutboundAddress string `protobuf:"bytes,3,opt,name=outbound_address,json=outboundAddress,proto3" json:"outbound_address,omitempty"`
	// Number used to make outbound calls
	OutboundNumber string `protobuf:"bytes,4,opt,name=outbound_number,json=outboundNumber,proto3" json:"outbound_number,omitempty"`
	// Accepted `To` values. This Trunk will only accept a call made to
	// these numbers. This allows you to have distinct Trunks for different phone
	// numbers at the same provider.
	InboundNumbersRegex []string `protobuf:"bytes,5,rep,name=inbound_numbers_regex,json=inboundNumbersRegex,proto3" json:"inbound_numbers_regex,omitempty"`
	// Username and password used to authenticate inbound and outbound SIP invites
	// May be empty to have no Authentication
	InboundUsername  string `protobuf:"bytes,6,opt,name=inbound_username,json=inboundUsername,proto3" json:"inbound_username,omitempty"`
	InboundPassword  string `protobuf:"bytes,7,opt,name=inbound_password,json=inboundPassword,proto3" json:"inbound_password,omitempty"`
	OutboundUsername string `protobuf:"bytes,8,opt,name=outbound_username,json=outboundUsername,proto3" json:"outbound_username,omitempty"`
	OutboundPassword string `protobuf:"bytes,9,opt,name=outbound_password,json=outboundPassword,proto3" json:"outbound_password,omitempty"`
}

func (x *SIPTrunkInfo) Reset() {
	*x = SIPTrunkInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SIPTrunkInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SIPTrunkInfo) ProtoMessage() {}

func (x *SIPTrunkInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SIPTrunkInfo.ProtoReflect.Descriptor instead.
func (*SIPTrunkInfo) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{1}
}

func (x *SIPTrunkInfo) GetSipTrunkId() string {
	if x != nil {
		return x.SipTrunkId
	}
	return ""
}

func (x *SIPTrunkInfo) GetInboundAddresses() []string {
	if x != nil {
		return x.InboundAddresses
	}
	return nil
}

func (x *SIPTrunkInfo) GetOutboundAddress() string {
	if x != nil {
		return x.OutboundAddress
	}
	return ""
}

func (x *SIPTrunkInfo) GetOutboundNumber() string {
	if x != nil {
		return x.OutboundNumber
	}
	return ""
}

func (x *SIPTrunkInfo) GetInboundNumbersRegex() []string {
	if x != nil {
		return x.InboundNumbersRegex
	}
	return nil
}

func (x *SIPTrunkInfo) GetInboundUsername() string {
	if x != nil {
		return x.InboundUsername
	}
	return ""
}

func (x *SIPTrunkInfo) GetInboundPassword() string {
	if x != nil {
		return x.InboundPassword
	}
	return ""
}

func (x *SIPTrunkInfo) GetOutboundUsername() string {
	if x != nil {
		return x.OutboundUsername
	}
	return ""
}

func (x *SIPTrunkInfo) GetOutboundPassword() string {
	if x != nil {
		return x.OutboundPassword
	}
	return ""
}

type ListSIPTrunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListSIPTrunkRequest) Reset() {
	*x = ListSIPTrunkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSIPTrunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSIPTrunkRequest) ProtoMessage() {}

func (x *ListSIPTrunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSIPTrunkRequest.ProtoReflect.Descriptor instead.
func (*ListSIPTrunkRequest) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{2}
}

type ListSIPTrunkResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Items []*SIPTrunkInfo `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListSIPTrunkResponse) Reset() {
	*x = ListSIPTrunkResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSIPTrunkResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSIPTrunkResponse) ProtoMessage() {}

func (x *ListSIPTrunkResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSIPTrunkResponse.ProtoReflect.Descriptor instead.
func (*ListSIPTrunkResponse) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{3}
}

func (x *ListSIPTrunkResponse) GetItems() []*SIPTrunkInfo {
	if x != nil {
		return x.Items
	}
	return nil
}

type DeleteSIPTrunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SipTrunkId string `protobuf:"bytes,1,opt,name=sip_trunk_id,json=sipTrunkId,proto3" json:"sip_trunk_id,omitempty"`
}

func (x *DeleteSIPTrunkRequest) Reset() {
	*x = DeleteSIPTrunkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSIPTrunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSIPTrunkRequest) ProtoMessage() {}

func (x *DeleteSIPTrunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSIPTrunkRequest.ProtoReflect.Descriptor instead.
func (*DeleteSIPTrunkRequest) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteSIPTrunkRequest) GetSipTrunkId() string {
	if x != nil {
		return x.SipTrunkId
	}
	return ""
}

type SIPDispatchRuleDirect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// What room should call be directed into
	RoomName string `protobuf:"bytes,1,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`
	// Optional pin required to enter room
	Pin string `protobuf:"bytes,2,opt,name=pin,proto3" json:"pin,omitempty"`
}

func (x *SIPDispatchRuleDirect) Reset() {
	*x = SIPDispatchRuleDirect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SIPDispatchRuleDirect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SIPDispatchRuleDirect) ProtoMessage() {}

func (x *SIPDispatchRuleDirect) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SIPDispatchRuleDirect.ProtoReflect.Descriptor instead.
func (*SIPDispatchRuleDirect) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{5}
}

func (x *SIPDispatchRuleDirect) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *SIPDispatchRuleDirect) GetPin() string {
	if x != nil {
		return x.Pin
	}
	return ""
}

type SIPDispatchRuleIndividual struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Prefix used on new room name
	RoomPrefix string `protobuf:"bytes,1,opt,name=room_prefix,json=roomPrefix,proto3" json:"room_prefix,omitempty"`
	// Optional pin required to enter room
	Pin string `protobuf:"bytes,2,opt,name=pin,proto3" json:"pin,omitempty"`
}

func (x *SIPDispatchRuleIndividual) Reset() {
	*x = SIPDispatchRuleIndividual{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SIPDispatchRuleIndividual) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SIPDispatchRuleIndividual) ProtoMessage() {}

func (x *SIPDispatchRuleIndividual) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SIPDispatchRuleIndividual.ProtoReflect.Descriptor instead.
func (*SIPDispatchRuleIndividual) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{6}
}

func (x *SIPDispatchRuleIndividual) GetRoomPrefix() string {
	if x != nil {
		return x.RoomPrefix
	}
	return ""
}

func (x *SIPDispatchRuleIndividual) GetPin() string {
	if x != nil {
		return x.Pin
	}
	return ""
}

type SIPDispatchRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Rule:
	//
	//	*SIPDispatchRule_DispatchRuleDirect
	//	*SIPDispatchRule_DispatchRuleIndividual
	Rule isSIPDispatchRule_Rule `protobuf_oneof:"rule"`
}

func (x *SIPDispatchRule) Reset() {
	*x = SIPDispatchRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SIPDispatchRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SIPDispatchRule) ProtoMessage() {}

func (x *SIPDispatchRule) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SIPDispatchRule.ProtoReflect.Descriptor instead.
func (*SIPDispatchRule) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{7}
}

func (m *SIPDispatchRule) GetRule() isSIPDispatchRule_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (x *SIPDispatchRule) GetDispatchRuleDirect() *SIPDispatchRuleDirect {
	if x, ok := x.GetRule().(*SIPDispatchRule_DispatchRuleDirect); ok {
		return x.DispatchRuleDirect
	}
	return nil
}

func (x *SIPDispatchRule) GetDispatchRuleIndividual() *SIPDispatchRuleIndividual {
	if x, ok := x.GetRule().(*SIPDispatchRule_DispatchRuleIndividual); ok {
		return x.DispatchRuleIndividual
	}
	return nil
}

type isSIPDispatchRule_Rule interface {
	isSIPDispatchRule_Rule()
}

type SIPDispatchRule_DispatchRuleDirect struct {
	// SIPDispatchRuleDirect is a `SIP Dispatch Rule` that puts a user directly into a room
	// This places users into an existing room. Optionally you can require a pin before a user can
	// enter the room
	DispatchRuleDirect *SIPDispatchRuleDirect `protobuf:"bytes,1,opt,name=dispatch_rule_direct,json=dispatchRuleDirect,proto3,oneof"`
}

type SIPDispatchRule_DispatchRuleIndividual struct {
	// SIPDispatchRuleIndividual is a `SIP Dispatch Rule` that creates a new room for each caller.
	DispatchRuleIndividual *SIPDispatchRuleIndividual `protobuf:"bytes,2,opt,name=dispatch_rule_individual,json=dispatchRuleIndividual,proto3,oneof"`
}

func (*SIPDispatchRule_DispatchRuleDirect) isSIPDispatchRule_Rule() {}

func (*SIPDispatchRule_DispatchRuleIndividual) isSIPDispatchRule_Rule() {}

type CreateSIPDispatchRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rule *SIPDispatchRule `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	// What trunks are accepted for this dispatch rule
	// If empty all trunks will match this dispatch rule
	TrunkIds []string `protobuf:"bytes,2,rep,name=trunk_ids,json=trunkIds,proto3" json:"trunk_ids,omitempty"`
	// By default the From value (Phone number) is used as the participant identity
	// If true a random value will be used instead
	HidePhoneNumber bool `protobuf:"varint,3,opt,name=hide_phone_number,json=hidePhoneNumber,proto3" json:"hide_phone_number,omitempty"`
}

func (x *CreateSIPDispatchRuleRequest) Reset() {
	*x = CreateSIPDispatchRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSIPDispatchRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSIPDispatchRuleRequest) ProtoMessage() {}

func (x *CreateSIPDispatchRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSIPDispatchRuleRequest.ProtoReflect.Descriptor instead.
func (*CreateSIPDispatchRuleRequest) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{8}
}

func (x *CreateSIPDispatchRuleRequest) GetRule() *SIPDispatchRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *CreateSIPDispatchRuleRequest) GetTrunkIds() []string {
	if x != nil {
		return x.TrunkIds
	}
	return nil
}

func (x *CreateSIPDispatchRuleRequest) GetHidePhoneNumber() bool {
	if x != nil {
		return x.HidePhoneNumber
	}
	return false
}

type SIPDispatchRuleInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SipDispatchRuleId string           `protobuf:"bytes,1,opt,name=sip_dispatch_rule_id,json=sipDispatchRuleId,proto3" json:"sip_dispatch_rule_id,omitempty"`
	Rule              *SIPDispatchRule `protobuf:"bytes,2,opt,name=rule,proto3" json:"rule,omitempty"`
	TrunkIds          []string         `protobuf:"bytes,3,rep,name=trunk_ids,json=trunkIds,proto3" json:"trunk_ids,omitempty"`
	HidePhoneNumber   bool             `protobuf:"varint,4,opt,name=hide_phone_number,json=hidePhoneNumber,proto3" json:"hide_phone_number,omitempty"`
}

func (x *SIPDispatchRuleInfo) Reset() {
	*x = SIPDispatchRuleInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SIPDispatchRuleInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SIPDispatchRuleInfo) ProtoMessage() {}

func (x *SIPDispatchRuleInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SIPDispatchRuleInfo.ProtoReflect.Descriptor instead.
func (*SIPDispatchRuleInfo) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{9}
}

func (x *SIPDispatchRuleInfo) GetSipDispatchRuleId() string {
	if x != nil {
		return x.SipDispatchRuleId
	}
	return ""
}

func (x *SIPDispatchRuleInfo) GetRule() *SIPDispatchRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *SIPDispatchRuleInfo) GetTrunkIds() []string {
	if x != nil {
		return x.TrunkIds
	}
	return nil
}

func (x *SIPDispatchRuleInfo) GetHidePhoneNumber() bool {
	if x != nil {
		return x.HidePhoneNumber
	}
	return false
}

type ListSIPDispatchRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ListSIPDispatchRuleRequest) Reset() {
	*x = ListSIPDispatchRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSIPDispatchRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSIPDispatchRuleRequest) ProtoMessage() {}

func (x *ListSIPDispatchRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSIPDispatchRuleRequest.ProtoReflect.Descriptor instead.
func (*ListSIPDispatchRuleRequest) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{10}
}

type ListSIPDispatchRuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Items []*SIPDispatchRuleInfo `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListSIPDispatchRuleResponse) Reset() {
	*x = ListSIPDispatchRuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSIPDispatchRuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSIPDispatchRuleResponse) ProtoMessage() {}

func (x *ListSIPDispatchRuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSIPDispatchRuleResponse.ProtoReflect.Descriptor instead.
func (*ListSIPDispatchRuleResponse) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{11}
}

func (x *ListSIPDispatchRuleResponse) GetItems() []*SIPDispatchRuleInfo {
	if x != nil {
		return x.Items
	}
	return nil
}

type DeleteSIPDispatchRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SipDispatchRuleId string `protobuf:"bytes,1,opt,name=sip_dispatch_rule_id,json=sipDispatchRuleId,proto3" json:"sip_dispatch_rule_id,omitempty"`
}

func (x *DeleteSIPDispatchRuleRequest) Reset() {
	*x = DeleteSIPDispatchRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSIPDispatchRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSIPDispatchRuleRequest) ProtoMessage() {}

func (x *DeleteSIPDispatchRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSIPDispatchRuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteSIPDispatchRuleRequest) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteSIPDispatchRuleRequest) GetSipDispatchRuleId() string {
	if x != nil {
		return x.SipDispatchRuleId
	}
	return ""
}

// A SIP Participant is a singular SIP session connected to a LiveKit room via
// a SIP Trunk into a SIP DispatchRule
type CreateSIPParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// What SIP Trunk should be used to dial the user
	SipTrunkId string `protobuf:"bytes,1,opt,name=sip_trunk_id,json=sipTrunkId,proto3" json:"sip_trunk_id,omitempty"`
	// What number should be dialed via SIP
	SipCallTo string `protobuf:"bytes,2,opt,name=sip_call_to,json=sipCallTo,proto3" json:"sip_call_to,omitempty"`
	// What LiveKit room should this participant be connected too
	RoomName string `protobuf:"bytes,3,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`
	// Optional identity of the participant in LiveKit room
	ParticipantIdentity string `protobuf:"bytes,4,opt,name=participant_identity,json=participantIdentity,proto3" json:"participant_identity,omitempty"`
}

func (x *CreateSIPParticipantRequest) Reset() {
	*x = CreateSIPParticipantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSIPParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSIPParticipantRequest) ProtoMessage() {}

func (x *CreateSIPParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSIPParticipantRequest.ProtoReflect.Descriptor instead.
func (*CreateSIPParticipantRequest) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{13}
}

func (x *CreateSIPParticipantRequest) GetSipTrunkId() string {
	if x != nil {
		return x.SipTrunkId
	}
	return ""
}

func (x *CreateSIPParticipantRequest) GetSipCallTo() string {
	if x != nil {
		return x.SipCallTo
	}
	return ""
}

func (x *CreateSIPParticipantRequest) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *CreateSIPParticipantRequest) GetParticipantIdentity() string {
	if x != nil {
		return x.ParticipantIdentity
	}
	return ""
}

type SIPParticipantInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParticipantId       string `protobuf:"bytes,1,opt,name=participant_id,json=participantId,proto3" json:"participant_id,omitempty"`
	ParticipantIdentity string `protobuf:"bytes,2,opt,name=participant_identity,json=participantIdentity,proto3" json:"participant_identity,omitempty"`
	RoomName            string `protobuf:"bytes,3,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`
}

func (x *SIPParticipantInfo) Reset() {
	*x = SIPParticipantInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_sip_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SIPParticipantInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SIPParticipantInfo) ProtoMessage() {}

func (x *SIPParticipantInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_sip_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SIPParticipantInfo.ProtoReflect.Descriptor instead.
func (*SIPParticipantInfo) Descriptor() ([]byte, []int) {
	return file_livekit_sip_proto_rawDescGZIP(), []int{14}
}

func (x *SIPParticipantInfo) GetParticipantId() string {
	if x != nil {
		return x.ParticipantId
	}
	return ""
}

func (x *SIPParticipantInfo) GetParticipantIdentity() string {
	if x != nil {
		return x.ParticipantIdentity
	}
	return ""
}

func (x *SIPParticipantInfo) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

var File_livekit_sip_proto protoreflect.FileDescriptor

var file_livekit_sip_proto_rawDesc = []byte{
	0x0a, 0x11, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x73, 0x69, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x22, 0xfc, 0x02, 0x0a,
	0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f,
	0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x29, 0x0a, 0x10, 0x69,
	0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x12, 0x2b, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x75,
	0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b,
	0x0a, 0x11, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x95, 0x03, 0x0a, 0x0c,
	0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x20, 0x0a, 0x0c,
	0x73, 0x69, 0x70, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x49, 0x64, 0x12, 0x2b,
	0x0a, 0x11, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x69, 0x6e, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x6f,
	0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x32, 0x0a, 0x15, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13,
	0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x67, 0x65, 0x78, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69,
	0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x6f, 0x75, 0x74,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x22, 0x15, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x49, 0x50, 0x54, 0x72,
	0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x43, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x49, 0x50, 0x54,
	0x72, 0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22,
	0x39, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x69, 0x70, 0x5f,
	0x74, 0x72, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x73, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x49, 0x64, 0x22, 0x46, 0x0a, 0x15, 0x53, 0x49,
	0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x70, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70,
	0x69, 0x6e, 0x22, 0x4e, 0x0a, 0x19, 0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x12,
	0x1f, 0x0a, 0x0b, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x6f, 0x6f, 0x6d, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x10, 0x0a, 0x03, 0x70, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70,
	0x69, 0x6e, 0x22, 0xcd, 0x01, 0x0a, 0x0f, 0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x52, 0x0a, 0x14, 0x64, 0x69, 0x73, 0x70, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53,
	0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x12, 0x64, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x75, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x12, 0x5e, 0x0a, 0x18, 0x64, 0x69,
	0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x69,
	0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c,
	0x48, 0x00, 0x52, 0x16, 0x64, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65,
	0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x42, 0x06, 0x0a, 0x04, 0x72, 0x75,
	0x6c, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49, 0x50,
	0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x49, 0x50, 0x44,
	0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x75, 0x6c,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x49, 0x64, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x68, 0x69, 0x64, 0x65, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x68, 0x69, 0x64, 0x65, 0x50,
	0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0xbd, 0x01, 0x0a, 0x13, 0x53,
	0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x2f, 0x0a, 0x14, 0x73, 0x69, 0x70, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x73, 0x69, 0x70, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c,
	0x65, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x49, 0x50, 0x44,
	0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x75, 0x6c,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x49, 0x64, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x68, 0x69, 0x64, 0x65, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x68, 0x69, 0x64, 0x65, 0x50,
	0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x1c, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x51, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x4f, 0x0a, 0x1c, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x14, 0x73,
	0x69, 0x70, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x69, 0x70, 0x44, 0x69,
	0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x64, 0x22, 0xaf, 0x01, 0x0a,
	0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49, 0x50, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0c,
	0x73, 0x69, 0x70, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x49, 0x64, 0x12, 0x1e,
	0x0a, 0x0b, 0x73, 0x69, 0x70, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x6f, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x69, 0x70, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x6f, 0x12, 0x1b,
	0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x14, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x8b,
	0x01, 0x0a, 0x12, 0x53, 0x49, 0x50, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x14,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x32, 0xdd, 0x04, 0x0a,
	0x03, 0x53, 0x49, 0x50, 0x12, 0x47, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49,
	0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x12, 0x1e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4b, 0x0a,
	0x0c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x12, 0x1c, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x49, 0x50, 0x54,
	0x72, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75,
	0x6e, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x12, 0x1e, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x49, 0x50,
	0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x49, 0x50, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x5c, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49, 0x50,
	0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x25, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49, 0x50,
	0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x49,
	0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x60, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x23, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x49, 0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x49, 0x50, 0x44,
	0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x49, 0x50,
	0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x25, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x49, 0x50,
	0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x49,
	0x50, 0x44, 0x69, 0x73, 0x70, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x59, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49, 0x50, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x24, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x49, 0x50, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x49, 0x50, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x46, 0x5a, 0x23,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0xaa, 0x02, 0x0d, 0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69, 0x74, 0x2e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0xea, 0x02, 0x0e, 0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69, 0x74, 0x3a, 0x3a, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_livekit_sip_proto_rawDescOnce sync.Once
	file_livekit_sip_proto_rawDescData = file_livekit_sip_proto_rawDesc
)

func file_livekit_sip_proto_rawDescGZIP() []byte {
	file_livekit_sip_proto_rawDescOnce.Do(func() {
		file_livekit_sip_proto_rawDescData = protoimpl.X.CompressGZIP(file_livekit_sip_proto_rawDescData)
	})
	return file_livekit_sip_proto_rawDescData
}

var file_livekit_sip_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_livekit_sip_proto_goTypes = []interface{}{
	(*CreateSIPTrunkRequest)(nil),        // 0: livekit.CreateSIPTrunkRequest
	(*SIPTrunkInfo)(nil),                 // 1: livekit.SIPTrunkInfo
	(*ListSIPTrunkRequest)(nil),          // 2: livekit.ListSIPTrunkRequest
	(*ListSIPTrunkResponse)(nil),         // 3: livekit.ListSIPTrunkResponse
	(*DeleteSIPTrunkRequest)(nil),        // 4: livekit.DeleteSIPTrunkRequest
	(*SIPDispatchRuleDirect)(nil),        // 5: livekit.SIPDispatchRuleDirect
	(*SIPDispatchRuleIndividual)(nil),    // 6: livekit.SIPDispatchRuleIndividual
	(*SIPDispatchRule)(nil),              // 7: livekit.SIPDispatchRule
	(*CreateSIPDispatchRuleRequest)(nil), // 8: livekit.CreateSIPDispatchRuleRequest
	(*SIPDispatchRuleInfo)(nil),          // 9: livekit.SIPDispatchRuleInfo
	(*ListSIPDispatchRuleRequest)(nil),   // 10: livekit.ListSIPDispatchRuleRequest
	(*ListSIPDispatchRuleResponse)(nil),  // 11: livekit.ListSIPDispatchRuleResponse
	(*DeleteSIPDispatchRuleRequest)(nil), // 12: livekit.DeleteSIPDispatchRuleRequest
	(*CreateSIPParticipantRequest)(nil),  // 13: livekit.CreateSIPParticipantRequest
	(*SIPParticipantInfo)(nil),           // 14: livekit.SIPParticipantInfo
}
var file_livekit_sip_proto_depIdxs = []int32{
	1,  // 0: livekit.ListSIPTrunkResponse.items:type_name -> livekit.SIPTrunkInfo
	5,  // 1: livekit.SIPDispatchRule.dispatch_rule_direct:type_name -> livekit.SIPDispatchRuleDirect
	6,  // 2: livekit.SIPDispatchRule.dispatch_rule_individual:type_name -> livekit.SIPDispatchRuleIndividual
	7,  // 3: livekit.CreateSIPDispatchRuleRequest.rule:type_name -> livekit.SIPDispatchRule
	7,  // 4: livekit.SIPDispatchRuleInfo.rule:type_name -> livekit.SIPDispatchRule
	9,  // 5: livekit.ListSIPDispatchRuleResponse.items:type_name -> livekit.SIPDispatchRuleInfo
	0,  // 6: livekit.SIP.CreateSIPTrunk:input_type -> livekit.CreateSIPTrunkRequest
	2,  // 7: livekit.SIP.ListSIPTrunk:input_type -> livekit.ListSIPTrunkRequest
	4,  // 8: livekit.SIP.DeleteSIPTrunk:input_type -> livekit.DeleteSIPTrunkRequest
	8,  // 9: livekit.SIP.CreateSIPDispatchRule:input_type -> livekit.CreateSIPDispatchRuleRequest
	10, // 10: livekit.SIP.ListSIPDispatchRule:input_type -> livekit.ListSIPDispatchRuleRequest
	12, // 11: livekit.SIP.DeleteSIPDispatchRule:input_type -> livekit.DeleteSIPDispatchRuleRequest
	13, // 12: livekit.SIP.CreateSIPParticipant:input_type -> livekit.CreateSIPParticipantRequest
	1,  // 13: livekit.SIP.CreateSIPTrunk:output_type -> livekit.SIPTrunkInfo
	3,  // 14: livekit.SIP.ListSIPTrunk:output_type -> livekit.ListSIPTrunkResponse
	1,  // 15: livekit.SIP.DeleteSIPTrunk:output_type -> livekit.SIPTrunkInfo
	9,  // 16: livekit.SIP.CreateSIPDispatchRule:output_type -> livekit.SIPDispatchRuleInfo
	11, // 17: livekit.SIP.ListSIPDispatchRule:output_type -> livekit.ListSIPDispatchRuleResponse
	9,  // 18: livekit.SIP.DeleteSIPDispatchRule:output_type -> livekit.SIPDispatchRuleInfo
	14, // 19: livekit.SIP.CreateSIPParticipant:output_type -> livekit.SIPParticipantInfo
	13, // [13:20] is the sub-list for method output_type
	6,  // [6:13] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_livekit_sip_proto_init() }
func file_livekit_sip_proto_init() {
	if File_livekit_sip_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_livekit_sip_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSIPTrunkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SIPTrunkInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSIPTrunkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSIPTrunkResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSIPTrunkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SIPDispatchRuleDirect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SIPDispatchRuleIndividual); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SIPDispatchRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSIPDispatchRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SIPDispatchRuleInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSIPDispatchRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSIPDispatchRuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSIPDispatchRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSIPParticipantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_sip_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SIPParticipantInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_livekit_sip_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*SIPDispatchRule_DispatchRuleDirect)(nil),
		(*SIPDispatchRule_DispatchRuleIndividual)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_livekit_sip_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_livekit_sip_proto_goTypes,
		DependencyIndexes: file_livekit_sip_proto_depIdxs,
		MessageInfos:      file_livekit_sip_proto_msgTypes,
	}.Build()
	File_livekit_sip_proto = out.File
	file_livekit_sip_proto_rawDesc = nil
	file_livekit_sip_proto_goTypes = nil
	file_livekit_sip_proto_depIdxs = nil
}
