// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.4
// source: livekit_models.proto

package livekit

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AudioCodec int32

const (
	AudioCodec_DEFAULT_AC AudioCodec = 0
	AudioCodec_OPUS       AudioCodec = 1
	AudioCodec_AAC        AudioCodec = 2
)

// Enum value maps for AudioCodec.
var (
	AudioCodec_name = map[int32]string{
		0: "DEFAULT_AC",
		1: "OPUS",
		2: "AAC",
	}
	AudioCodec_value = map[string]int32{
		"DEFAULT_AC": 0,
		"OPUS":       1,
		"AAC":        2,
	}
)

func (x AudioCodec) Enum() *AudioCodec {
	p := new(AudioCodec)
	*p = x
	return p
}

func (x AudioCodec) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudioCodec) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[0].Descriptor()
}

func (AudioCodec) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[0]
}

func (x AudioCodec) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudioCodec.Descriptor instead.
func (AudioCodec) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{0}
}

type VideoCodec int32

const (
	VideoCodec_DEFAULT_VC    VideoCodec = 0
	VideoCodec_H264_BASELINE VideoCodec = 1
	VideoCodec_H264_MAIN     VideoCodec = 2
	VideoCodec_H264_HIGH     VideoCodec = 3
	VideoCodec_VP8           VideoCodec = 4
)

// Enum value maps for VideoCodec.
var (
	VideoCodec_name = map[int32]string{
		0: "DEFAULT_VC",
		1: "H264_BASELINE",
		2: "H264_MAIN",
		3: "H264_HIGH",
		4: "VP8",
	}
	VideoCodec_value = map[string]int32{
		"DEFAULT_VC":    0,
		"H264_BASELINE": 1,
		"H264_MAIN":     2,
		"H264_HIGH":     3,
		"VP8":           4,
	}
)

func (x VideoCodec) Enum() *VideoCodec {
	p := new(VideoCodec)
	*p = x
	return p
}

func (x VideoCodec) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VideoCodec) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[1].Descriptor()
}

func (VideoCodec) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[1]
}

func (x VideoCodec) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VideoCodec.Descriptor instead.
func (VideoCodec) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{1}
}

type ImageCodec int32

const (
	ImageCodec_IC_DEFAULT ImageCodec = 0
	ImageCodec_IC_JPEG    ImageCodec = 1
)

// Enum value maps for ImageCodec.
var (
	ImageCodec_name = map[int32]string{
		0: "IC_DEFAULT",
		1: "IC_JPEG",
	}
	ImageCodec_value = map[string]int32{
		"IC_DEFAULT": 0,
		"IC_JPEG":    1,
	}
)

func (x ImageCodec) Enum() *ImageCodec {
	p := new(ImageCodec)
	*p = x
	return p
}

func (x ImageCodec) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImageCodec) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[2].Descriptor()
}

func (ImageCodec) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[2]
}

func (x ImageCodec) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImageCodec.Descriptor instead.
func (ImageCodec) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{2}
}

type TrackType int32

const (
	TrackType_AUDIO TrackType = 0
	TrackType_VIDEO TrackType = 1
	TrackType_DATA  TrackType = 2
)

// Enum value maps for TrackType.
var (
	TrackType_name = map[int32]string{
		0: "AUDIO",
		1: "VIDEO",
		2: "DATA",
	}
	TrackType_value = map[string]int32{
		"AUDIO": 0,
		"VIDEO": 1,
		"DATA":  2,
	}
)

func (x TrackType) Enum() *TrackType {
	p := new(TrackType)
	*p = x
	return p
}

func (x TrackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrackType) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[3].Descriptor()
}

func (TrackType) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[3]
}

func (x TrackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrackType.Descriptor instead.
func (TrackType) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{3}
}

type TrackSource int32

const (
	TrackSource_UNKNOWN            TrackSource = 0
	TrackSource_CAMERA             TrackSource = 1
	TrackSource_MICROPHONE         TrackSource = 2
	TrackSource_SCREEN_SHARE       TrackSource = 3
	TrackSource_SCREEN_SHARE_AUDIO TrackSource = 4
)

// Enum value maps for TrackSource.
var (
	TrackSource_name = map[int32]string{
		0: "UNKNOWN",
		1: "CAMERA",
		2: "MICROPHONE",
		3: "SCREEN_SHARE",
		4: "SCREEN_SHARE_AUDIO",
	}
	TrackSource_value = map[string]int32{
		"UNKNOWN":            0,
		"CAMERA":             1,
		"MICROPHONE":         2,
		"SCREEN_SHARE":       3,
		"SCREEN_SHARE_AUDIO": 4,
	}
)

func (x TrackSource) Enum() *TrackSource {
	p := new(TrackSource)
	*p = x
	return p
}

func (x TrackSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrackSource) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[4].Descriptor()
}

func (TrackSource) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[4]
}

func (x TrackSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrackSource.Descriptor instead.
func (TrackSource) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{4}
}

type VideoQuality int32

const (
	VideoQuality_LOW    VideoQuality = 0
	VideoQuality_MEDIUM VideoQuality = 1
	VideoQuality_HIGH   VideoQuality = 2
	VideoQuality_OFF    VideoQuality = 3
)

// Enum value maps for VideoQuality.
var (
	VideoQuality_name = map[int32]string{
		0: "LOW",
		1: "MEDIUM",
		2: "HIGH",
		3: "OFF",
	}
	VideoQuality_value = map[string]int32{
		"LOW":    0,
		"MEDIUM": 1,
		"HIGH":   2,
		"OFF":    3,
	}
)

func (x VideoQuality) Enum() *VideoQuality {
	p := new(VideoQuality)
	*p = x
	return p
}

func (x VideoQuality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VideoQuality) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[5].Descriptor()
}

func (VideoQuality) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[5]
}

func (x VideoQuality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VideoQuality.Descriptor instead.
func (VideoQuality) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{5}
}

type ConnectionQuality int32

const (
	ConnectionQuality_POOR      ConnectionQuality = 0
	ConnectionQuality_GOOD      ConnectionQuality = 1
	ConnectionQuality_EXCELLENT ConnectionQuality = 2
	ConnectionQuality_LOST      ConnectionQuality = 3
)

// Enum value maps for ConnectionQuality.
var (
	ConnectionQuality_name = map[int32]string{
		0: "POOR",
		1: "GOOD",
		2: "EXCELLENT",
		3: "LOST",
	}
	ConnectionQuality_value = map[string]int32{
		"POOR":      0,
		"GOOD":      1,
		"EXCELLENT": 2,
		"LOST":      3,
	}
)

func (x ConnectionQuality) Enum() *ConnectionQuality {
	p := new(ConnectionQuality)
	*p = x
	return p
}

func (x ConnectionQuality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionQuality) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[6].Descriptor()
}

func (ConnectionQuality) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[6]
}

func (x ConnectionQuality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionQuality.Descriptor instead.
func (ConnectionQuality) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{6}
}

type ClientConfigSetting int32

const (
	ClientConfigSetting_UNSET    ClientConfigSetting = 0
	ClientConfigSetting_DISABLED ClientConfigSetting = 1
	ClientConfigSetting_ENABLED  ClientConfigSetting = 2
)

// Enum value maps for ClientConfigSetting.
var (
	ClientConfigSetting_name = map[int32]string{
		0: "UNSET",
		1: "DISABLED",
		2: "ENABLED",
	}
	ClientConfigSetting_value = map[string]int32{
		"UNSET":    0,
		"DISABLED": 1,
		"ENABLED":  2,
	}
)

func (x ClientConfigSetting) Enum() *ClientConfigSetting {
	p := new(ClientConfigSetting)
	*p = x
	return p
}

func (x ClientConfigSetting) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClientConfigSetting) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[7].Descriptor()
}

func (ClientConfigSetting) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[7]
}

func (x ClientConfigSetting) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClientConfigSetting.Descriptor instead.
func (ClientConfigSetting) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{7}
}

type DisconnectReason int32

const (
	DisconnectReason_UNKNOWN_REASON      DisconnectReason = 0
	DisconnectReason_CLIENT_INITIATED    DisconnectReason = 1
	DisconnectReason_DUPLICATE_IDENTITY  DisconnectReason = 2
	DisconnectReason_SERVER_SHUTDOWN     DisconnectReason = 3
	DisconnectReason_PARTICIPANT_REMOVED DisconnectReason = 4
	DisconnectReason_ROOM_DELETED        DisconnectReason = 5
	DisconnectReason_STATE_MISMATCH      DisconnectReason = 6
	DisconnectReason_JOIN_FAILURE        DisconnectReason = 7
	DisconnectReason_MIGRATION           DisconnectReason = 8
	DisconnectReason_SIGNAL_CLOSE        DisconnectReason = 9
)

// Enum value maps for DisconnectReason.
var (
	DisconnectReason_name = map[int32]string{
		0: "UNKNOWN_REASON",
		1: "CLIENT_INITIATED",
		2: "DUPLICATE_IDENTITY",
		3: "SERVER_SHUTDOWN",
		4: "PARTICIPANT_REMOVED",
		5: "ROOM_DELETED",
		6: "STATE_MISMATCH",
		7: "JOIN_FAILURE",
		8: "MIGRATION",
		9: "SIGNAL_CLOSE",
	}
	DisconnectReason_value = map[string]int32{
		"UNKNOWN_REASON":      0,
		"CLIENT_INITIATED":    1,
		"DUPLICATE_IDENTITY":  2,
		"SERVER_SHUTDOWN":     3,
		"PARTICIPANT_REMOVED": 4,
		"ROOM_DELETED":        5,
		"STATE_MISMATCH":      6,
		"JOIN_FAILURE":        7,
		"MIGRATION":           8,
		"SIGNAL_CLOSE":        9,
	}
)

func (x DisconnectReason) Enum() *DisconnectReason {
	p := new(DisconnectReason)
	*p = x
	return p
}

func (x DisconnectReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DisconnectReason) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[8].Descriptor()
}

func (DisconnectReason) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[8]
}

func (x DisconnectReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DisconnectReason.Descriptor instead.
func (DisconnectReason) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{8}
}

type ReconnectReason int32

const (
	ReconnectReason_RR_UNKNOWN             ReconnectReason = 0
	ReconnectReason_RR_SIGNAL_DISCONNECTED ReconnectReason = 1
	ReconnectReason_RR_PUBLISHER_FAILED    ReconnectReason = 2
	ReconnectReason_RR_SUBSCRIBER_FAILED   ReconnectReason = 3
	ReconnectReason_RR_SWITCH_CANDIDATE    ReconnectReason = 4
)

// Enum value maps for ReconnectReason.
var (
	ReconnectReason_name = map[int32]string{
		0: "RR_UNKNOWN",
		1: "RR_SIGNAL_DISCONNECTED",
		2: "RR_PUBLISHER_FAILED",
		3: "RR_SUBSCRIBER_FAILED",
		4: "RR_SWITCH_CANDIDATE",
	}
	ReconnectReason_value = map[string]int32{
		"RR_UNKNOWN":             0,
		"RR_SIGNAL_DISCONNECTED": 1,
		"RR_PUBLISHER_FAILED":    2,
		"RR_SUBSCRIBER_FAILED":   3,
		"RR_SWITCH_CANDIDATE":    4,
	}
)

func (x ReconnectReason) Enum() *ReconnectReason {
	p := new(ReconnectReason)
	*p = x
	return p
}

func (x ReconnectReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReconnectReason) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[9].Descriptor()
}

func (ReconnectReason) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[9]
}

func (x ReconnectReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReconnectReason.Descriptor instead.
func (ReconnectReason) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{9}
}

type SubscriptionError int32

const (
	SubscriptionError_SE_UNKNOWN           SubscriptionError = 0
	SubscriptionError_SE_CODEC_UNSUPPORTED SubscriptionError = 1
	SubscriptionError_SE_TRACK_NOTFOUND    SubscriptionError = 2
)

// Enum value maps for SubscriptionError.
var (
	SubscriptionError_name = map[int32]string{
		0: "SE_UNKNOWN",
		1: "SE_CODEC_UNSUPPORTED",
		2: "SE_TRACK_NOTFOUND",
	}
	SubscriptionError_value = map[string]int32{
		"SE_UNKNOWN":           0,
		"SE_CODEC_UNSUPPORTED": 1,
		"SE_TRACK_NOTFOUND":    2,
	}
)

func (x SubscriptionError) Enum() *SubscriptionError {
	p := new(SubscriptionError)
	*p = x
	return p
}

func (x SubscriptionError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubscriptionError) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[10].Descriptor()
}

func (SubscriptionError) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[10]
}

func (x SubscriptionError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubscriptionError.Descriptor instead.
func (SubscriptionError) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{10}
}

type ParticipantInfo_State int32

const (
	// websocket' connected, but not offered yet
	ParticipantInfo_JOINING ParticipantInfo_State = 0
	// server received client offer
	ParticipantInfo_JOINED ParticipantInfo_State = 1
	// ICE connectivity established
	ParticipantInfo_ACTIVE ParticipantInfo_State = 2
	// WS disconnected
	ParticipantInfo_DISCONNECTED ParticipantInfo_State = 3
)

// Enum value maps for ParticipantInfo_State.
var (
	ParticipantInfo_State_name = map[int32]string{
		0: "JOINING",
		1: "JOINED",
		2: "ACTIVE",
		3: "DISCONNECTED",
	}
	ParticipantInfo_State_value = map[string]int32{
		"JOINING":      0,
		"JOINED":       1,
		"ACTIVE":       2,
		"DISCONNECTED": 3,
	}
)

func (x ParticipantInfo_State) Enum() *ParticipantInfo_State {
	p := new(ParticipantInfo_State)
	*p = x
	return p
}

func (x ParticipantInfo_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ParticipantInfo_State) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[11].Descriptor()
}

func (ParticipantInfo_State) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[11]
}

func (x ParticipantInfo_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ParticipantInfo_State.Descriptor instead.
func (ParticipantInfo_State) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{4, 0}
}

type ParticipantInfo_Kind int32

const (
	// standard participants, e.g. web clients
	ParticipantInfo_STANDARD ParticipantInfo_Kind = 0
	// only ingests streams
	ParticipantInfo_INGRESS ParticipantInfo_Kind = 1
	// only consumes streams
	ParticipantInfo_EGRESS ParticipantInfo_Kind = 2
	// SIP participants
	ParticipantInfo_SIP ParticipantInfo_Kind = 3
	// LiveKit agents
	ParticipantInfo_AGENT ParticipantInfo_Kind = 4
)

// Enum value maps for ParticipantInfo_Kind.
var (
	ParticipantInfo_Kind_name = map[int32]string{
		0: "STANDARD",
		1: "INGRESS",
		2: "EGRESS",
		3: "SIP",
		4: "AGENT",
	}
	ParticipantInfo_Kind_value = map[string]int32{
		"STANDARD": 0,
		"INGRESS":  1,
		"EGRESS":   2,
		"SIP":      3,
		"AGENT":    4,
	}
)

func (x ParticipantInfo_Kind) Enum() *ParticipantInfo_Kind {
	p := new(ParticipantInfo_Kind)
	*p = x
	return p
}

func (x ParticipantInfo_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ParticipantInfo_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[12].Descriptor()
}

func (ParticipantInfo_Kind) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[12]
}

func (x ParticipantInfo_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ParticipantInfo_Kind.Descriptor instead.
func (ParticipantInfo_Kind) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{4, 1}
}

type Encryption_Type int32

const (
	Encryption_NONE   Encryption_Type = 0
	Encryption_GCM    Encryption_Type = 1
	Encryption_CUSTOM Encryption_Type = 2
)

// Enum value maps for Encryption_Type.
var (
	Encryption_Type_name = map[int32]string{
		0: "NONE",
		1: "GCM",
		2: "CUSTOM",
	}
	Encryption_Type_value = map[string]int32{
		"NONE":   0,
		"GCM":    1,
		"CUSTOM": 2,
	}
)

func (x Encryption_Type) Enum() *Encryption_Type {
	p := new(Encryption_Type)
	*p = x
	return p
}

func (x Encryption_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Encryption_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[13].Descriptor()
}

func (Encryption_Type) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[13]
}

func (x Encryption_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Encryption_Type.Descriptor instead.
func (Encryption_Type) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{5, 0}
}

type DataPacket_Kind int32

const (
	DataPacket_RELIABLE DataPacket_Kind = 0
	DataPacket_LOSSY    DataPacket_Kind = 1
)

// Enum value maps for DataPacket_Kind.
var (
	DataPacket_Kind_name = map[int32]string{
		0: "RELIABLE",
		1: "LOSSY",
	}
	DataPacket_Kind_value = map[string]int32{
		"RELIABLE": 0,
		"LOSSY":    1,
	}
)

func (x DataPacket_Kind) Enum() *DataPacket_Kind {
	p := new(DataPacket_Kind)
	*p = x
	return p
}

func (x DataPacket_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataPacket_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[14].Descriptor()
}

func (DataPacket_Kind) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[14]
}

func (x DataPacket_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataPacket_Kind.Descriptor instead.
func (DataPacket_Kind) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{9, 0}
}

type ServerInfo_Edition int32

const (
	ServerInfo_Standard ServerInfo_Edition = 0
	ServerInfo_Cloud    ServerInfo_Edition = 1
)

// Enum value maps for ServerInfo_Edition.
var (
	ServerInfo_Edition_name = map[int32]string{
		0: "Standard",
		1: "Cloud",
	}
	ServerInfo_Edition_value = map[string]int32{
		"Standard": 0,
		"Cloud":    1,
	}
)

func (x ServerInfo_Edition) Enum() *ServerInfo_Edition {
	p := new(ServerInfo_Edition)
	*p = x
	return p
}

func (x ServerInfo_Edition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerInfo_Edition) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[15].Descriptor()
}

func (ServerInfo_Edition) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[15]
}

func (x ServerInfo_Edition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServerInfo_Edition.Descriptor instead.
func (ServerInfo_Edition) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{14, 0}
}

type ClientInfo_SDK int32

const (
	ClientInfo_UNKNOWN      ClientInfo_SDK = 0
	ClientInfo_JS           ClientInfo_SDK = 1
	ClientInfo_SWIFT        ClientInfo_SDK = 2
	ClientInfo_ANDROID      ClientInfo_SDK = 3
	ClientInfo_FLUTTER      ClientInfo_SDK = 4
	ClientInfo_GO           ClientInfo_SDK = 5
	ClientInfo_UNITY        ClientInfo_SDK = 6
	ClientInfo_REACT_NATIVE ClientInfo_SDK = 7
	ClientInfo_RUST         ClientInfo_SDK = 8
	ClientInfo_PYTHON       ClientInfo_SDK = 9
	ClientInfo_CPP          ClientInfo_SDK = 10
)

// Enum value maps for ClientInfo_SDK.
var (
	ClientInfo_SDK_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "JS",
		2:  "SWIFT",
		3:  "ANDROID",
		4:  "FLUTTER",
		5:  "GO",
		6:  "UNITY",
		7:  "REACT_NATIVE",
		8:  "RUST",
		9:  "PYTHON",
		10: "CPP",
	}
	ClientInfo_SDK_value = map[string]int32{
		"UNKNOWN":      0,
		"JS":           1,
		"SWIFT":        2,
		"ANDROID":      3,
		"FLUTTER":      4,
		"GO":           5,
		"UNITY":        6,
		"REACT_NATIVE": 7,
		"RUST":         8,
		"PYTHON":       9,
		"CPP":          10,
	}
)

func (x ClientInfo_SDK) Enum() *ClientInfo_SDK {
	p := new(ClientInfo_SDK)
	*p = x
	return p
}

func (x ClientInfo_SDK) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClientInfo_SDK) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_models_proto_enumTypes[16].Descriptor()
}

func (ClientInfo_SDK) Type() protoreflect.EnumType {
	return &file_livekit_models_proto_enumTypes[16]
}

func (x ClientInfo_SDK) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClientInfo_SDK.Descriptor instead.
func (ClientInfo_SDK) EnumDescriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{15, 0}
}

type Room struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sid             string        `protobuf:"bytes,1,opt,name=sid,proto3" json:"sid,omitempty"`
	Name            string        `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	EmptyTimeout    uint32        `protobuf:"varint,3,opt,name=empty_timeout,json=emptyTimeout,proto3" json:"empty_timeout,omitempty"`
	MaxParticipants uint32        `protobuf:"varint,4,opt,name=max_participants,json=maxParticipants,proto3" json:"max_participants,omitempty"`
	CreationTime    int64         `protobuf:"varint,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	TurnPassword    string        `protobuf:"bytes,6,opt,name=turn_password,json=turnPassword,proto3" json:"turn_password,omitempty"`
	EnabledCodecs   []*Codec      `protobuf:"bytes,7,rep,name=enabled_codecs,json=enabledCodecs,proto3" json:"enabled_codecs,omitempty"`
	Metadata        string        `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	NumParticipants uint32        `protobuf:"varint,9,opt,name=num_participants,json=numParticipants,proto3" json:"num_participants,omitempty"`
	NumPublishers   uint32        `protobuf:"varint,11,opt,name=num_publishers,json=numPublishers,proto3" json:"num_publishers,omitempty"`
	ActiveRecording bool          `protobuf:"varint,10,opt,name=active_recording,json=activeRecording,proto3" json:"active_recording,omitempty"`
	Version         *TimedVersion `protobuf:"bytes,13,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Room) Reset() {
	*x = Room{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Room) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Room) ProtoMessage() {}

func (x *Room) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Room.ProtoReflect.Descriptor instead.
func (*Room) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{0}
}

func (x *Room) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

func (x *Room) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Room) GetEmptyTimeout() uint32 {
	if x != nil {
		return x.EmptyTimeout
	}
	return 0
}

func (x *Room) GetMaxParticipants() uint32 {
	if x != nil {
		return x.MaxParticipants
	}
	return 0
}

func (x *Room) GetCreationTime() int64 {
	if x != nil {
		return x.CreationTime
	}
	return 0
}

func (x *Room) GetTurnPassword() string {
	if x != nil {
		return x.TurnPassword
	}
	return ""
}

func (x *Room) GetEnabledCodecs() []*Codec {
	if x != nil {
		return x.EnabledCodecs
	}
	return nil
}

func (x *Room) GetMetadata() string {
	if x != nil {
		return x.Metadata
	}
	return ""
}

func (x *Room) GetNumParticipants() uint32 {
	if x != nil {
		return x.NumParticipants
	}
	return 0
}

func (x *Room) GetNumPublishers() uint32 {
	if x != nil {
		return x.NumPublishers
	}
	return 0
}

func (x *Room) GetActiveRecording() bool {
	if x != nil {
		return x.ActiveRecording
	}
	return false
}

func (x *Room) GetVersion() *TimedVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

type Codec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mime     string `protobuf:"bytes,1,opt,name=mime,proto3" json:"mime,omitempty"`
	FmtpLine string `protobuf:"bytes,2,opt,name=fmtp_line,json=fmtpLine,proto3" json:"fmtp_line,omitempty"`
}

func (x *Codec) Reset() {
	*x = Codec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Codec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Codec) ProtoMessage() {}

func (x *Codec) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Codec.ProtoReflect.Descriptor instead.
func (*Codec) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{1}
}

func (x *Codec) GetMime() string {
	if x != nil {
		return x.Mime
	}
	return ""
}

func (x *Codec) GetFmtpLine() string {
	if x != nil {
		return x.FmtpLine
	}
	return ""
}

type PlayoutDelay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled bool   `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Min     uint32 `protobuf:"varint,2,opt,name=min,proto3" json:"min,omitempty"`
	Max     uint32 `protobuf:"varint,3,opt,name=max,proto3" json:"max,omitempty"`
}

func (x *PlayoutDelay) Reset() {
	*x = PlayoutDelay{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlayoutDelay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlayoutDelay) ProtoMessage() {}

func (x *PlayoutDelay) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlayoutDelay.ProtoReflect.Descriptor instead.
func (*PlayoutDelay) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{2}
}

func (x *PlayoutDelay) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *PlayoutDelay) GetMin() uint32 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *PlayoutDelay) GetMax() uint32 {
	if x != nil {
		return x.Max
	}
	return 0
}

type ParticipantPermission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// allow participant to subscribe to other tracks in the room
	CanSubscribe bool `protobuf:"varint,1,opt,name=can_subscribe,json=canSubscribe,proto3" json:"can_subscribe,omitempty"`
	// allow participant to publish new tracks to room
	CanPublish bool `protobuf:"varint,2,opt,name=can_publish,json=canPublish,proto3" json:"can_publish,omitempty"`
	// allow participant to publish data
	CanPublishData bool `protobuf:"varint,3,opt,name=can_publish_data,json=canPublishData,proto3" json:"can_publish_data,omitempty"`
	// sources that are allowed to be published
	CanPublishSources []TrackSource `protobuf:"varint,9,rep,packed,name=can_publish_sources,json=canPublishSources,proto3,enum=livekit.TrackSource" json:"can_publish_sources,omitempty"`
	// indicates that it's hidden to others
	Hidden bool `protobuf:"varint,7,opt,name=hidden,proto3" json:"hidden,omitempty"`
	// indicates it's a recorder instance
	Recorder bool `protobuf:"varint,8,opt,name=recorder,proto3" json:"recorder,omitempty"`
	// indicates that participant can update own metadata
	CanUpdateMetadata bool `protobuf:"varint,10,opt,name=can_update_metadata,json=canUpdateMetadata,proto3" json:"can_update_metadata,omitempty"`
	// indicates that participant is an agent
	Agent bool `protobuf:"varint,11,opt,name=agent,proto3" json:"agent,omitempty"`
}

func (x *ParticipantPermission) Reset() {
	*x = ParticipantPermission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParticipantPermission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParticipantPermission) ProtoMessage() {}

func (x *ParticipantPermission) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParticipantPermission.ProtoReflect.Descriptor instead.
func (*ParticipantPermission) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{3}
}

func (x *ParticipantPermission) GetCanSubscribe() bool {
	if x != nil {
		return x.CanSubscribe
	}
	return false
}

func (x *ParticipantPermission) GetCanPublish() bool {
	if x != nil {
		return x.CanPublish
	}
	return false
}

func (x *ParticipantPermission) GetCanPublishData() bool {
	if x != nil {
		return x.CanPublishData
	}
	return false
}

func (x *ParticipantPermission) GetCanPublishSources() []TrackSource {
	if x != nil {
		return x.CanPublishSources
	}
	return nil
}

func (x *ParticipantPermission) GetHidden() bool {
	if x != nil {
		return x.Hidden
	}
	return false
}

func (x *ParticipantPermission) GetRecorder() bool {
	if x != nil {
		return x.Recorder
	}
	return false
}

func (x *ParticipantPermission) GetCanUpdateMetadata() bool {
	if x != nil {
		return x.CanUpdateMetadata
	}
	return false
}

func (x *ParticipantPermission) GetAgent() bool {
	if x != nil {
		return x.Agent
	}
	return false
}

type ParticipantInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sid      string                `protobuf:"bytes,1,opt,name=sid,proto3" json:"sid,omitempty"`
	Identity string                `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	State    ParticipantInfo_State `protobuf:"varint,3,opt,name=state,proto3,enum=livekit.ParticipantInfo_State" json:"state,omitempty"`
	Tracks   []*TrackInfo          `protobuf:"bytes,4,rep,name=tracks,proto3" json:"tracks,omitempty"`
	Metadata string                `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// timestamp when participant joined room, in seconds
	JoinedAt   int64                  `protobuf:"varint,6,opt,name=joined_at,json=joinedAt,proto3" json:"joined_at,omitempty"`
	Name       string                 `protobuf:"bytes,9,opt,name=name,proto3" json:"name,omitempty"`
	Version    uint32                 `protobuf:"varint,10,opt,name=version,proto3" json:"version,omitempty"`
	Permission *ParticipantPermission `protobuf:"bytes,11,opt,name=permission,proto3" json:"permission,omitempty"`
	Region     string                 `protobuf:"bytes,12,opt,name=region,proto3" json:"region,omitempty"`
	// indicates the participant has an active publisher connection
	// and can publish to the server
	IsPublisher bool                 `protobuf:"varint,13,opt,name=is_publisher,json=isPublisher,proto3" json:"is_publisher,omitempty"`
	Kind        ParticipantInfo_Kind `protobuf:"varint,14,opt,name=kind,proto3,enum=livekit.ParticipantInfo_Kind" json:"kind,omitempty"`
}

func (x *ParticipantInfo) Reset() {
	*x = ParticipantInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParticipantInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParticipantInfo) ProtoMessage() {}

func (x *ParticipantInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParticipantInfo.ProtoReflect.Descriptor instead.
func (*ParticipantInfo) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{4}
}

func (x *ParticipantInfo) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

func (x *ParticipantInfo) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *ParticipantInfo) GetState() ParticipantInfo_State {
	if x != nil {
		return x.State
	}
	return ParticipantInfo_JOINING
}

func (x *ParticipantInfo) GetTracks() []*TrackInfo {
	if x != nil {
		return x.Tracks
	}
	return nil
}

func (x *ParticipantInfo) GetMetadata() string {
	if x != nil {
		return x.Metadata
	}
	return ""
}

func (x *ParticipantInfo) GetJoinedAt() int64 {
	if x != nil {
		return x.JoinedAt
	}
	return 0
}

func (x *ParticipantInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ParticipantInfo) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ParticipantInfo) GetPermission() *ParticipantPermission {
	if x != nil {
		return x.Permission
	}
	return nil
}

func (x *ParticipantInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *ParticipantInfo) GetIsPublisher() bool {
	if x != nil {
		return x.IsPublisher
	}
	return false
}

func (x *ParticipantInfo) GetKind() ParticipantInfo_Kind {
	if x != nil {
		return x.Kind
	}
	return ParticipantInfo_STANDARD
}

type Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption) Reset() {
	*x = Encryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption) ProtoMessage() {}

func (x *Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption.ProtoReflect.Descriptor instead.
func (*Encryption) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{5}
}

type SimulcastCodecInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MimeType string        `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	Mid      string        `protobuf:"bytes,2,opt,name=mid,proto3" json:"mid,omitempty"`
	Cid      string        `protobuf:"bytes,3,opt,name=cid,proto3" json:"cid,omitempty"`
	Layers   []*VideoLayer `protobuf:"bytes,4,rep,name=layers,proto3" json:"layers,omitempty"`
}

func (x *SimulcastCodecInfo) Reset() {
	*x = SimulcastCodecInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulcastCodecInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulcastCodecInfo) ProtoMessage() {}

func (x *SimulcastCodecInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulcastCodecInfo.ProtoReflect.Descriptor instead.
func (*SimulcastCodecInfo) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{6}
}

func (x *SimulcastCodecInfo) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *SimulcastCodecInfo) GetMid() string {
	if x != nil {
		return x.Mid
	}
	return ""
}

func (x *SimulcastCodecInfo) GetCid() string {
	if x != nil {
		return x.Cid
	}
	return ""
}

func (x *SimulcastCodecInfo) GetLayers() []*VideoLayer {
	if x != nil {
		return x.Layers
	}
	return nil
}

type TrackInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sid   string    `protobuf:"bytes,1,opt,name=sid,proto3" json:"sid,omitempty"`
	Type  TrackType `protobuf:"varint,2,opt,name=type,proto3,enum=livekit.TrackType" json:"type,omitempty"`
	Name  string    `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Muted bool      `protobuf:"varint,4,opt,name=muted,proto3" json:"muted,omitempty"`
	// original width of video (unset for audio)
	// clients may receive a lower resolution version with simulcast
	Width uint32 `protobuf:"varint,5,opt,name=width,proto3" json:"width,omitempty"`
	// original height of video (unset for audio)
	Height uint32 `protobuf:"varint,6,opt,name=height,proto3" json:"height,omitempty"`
	// true if track is simulcasted
	Simulcast bool `protobuf:"varint,7,opt,name=simulcast,proto3" json:"simulcast,omitempty"`
	// true if DTX (Discontinuous Transmission) is disabled for audio
	DisableDtx bool `protobuf:"varint,8,opt,name=disable_dtx,json=disableDtx,proto3" json:"disable_dtx,omitempty"`
	// source of media
	Source TrackSource   `protobuf:"varint,9,opt,name=source,proto3,enum=livekit.TrackSource" json:"source,omitempty"`
	Layers []*VideoLayer `protobuf:"bytes,10,rep,name=layers,proto3" json:"layers,omitempty"`
	// mime type of codec
	MimeType string                `protobuf:"bytes,11,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	Mid      string                `protobuf:"bytes,12,opt,name=mid,proto3" json:"mid,omitempty"`
	Codecs   []*SimulcastCodecInfo `protobuf:"bytes,13,rep,name=codecs,proto3" json:"codecs,omitempty"`
	Stereo   bool                  `protobuf:"varint,14,opt,name=stereo,proto3" json:"stereo,omitempty"`
	// true if RED (Redundant Encoding) is disabled for audio
	DisableRed bool            `protobuf:"varint,15,opt,name=disable_red,json=disableRed,proto3" json:"disable_red,omitempty"`
	Encryption Encryption_Type `protobuf:"varint,16,opt,name=encryption,proto3,enum=livekit.Encryption_Type" json:"encryption,omitempty"`
	Stream     string          `protobuf:"bytes,17,opt,name=stream,proto3" json:"stream,omitempty"`
	Version    *TimedVersion   `protobuf:"bytes,18,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *TrackInfo) Reset() {
	*x = TrackInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrackInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrackInfo) ProtoMessage() {}

func (x *TrackInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrackInfo.ProtoReflect.Descriptor instead.
func (*TrackInfo) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{7}
}

func (x *TrackInfo) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

func (x *TrackInfo) GetType() TrackType {
	if x != nil {
		return x.Type
	}
	return TrackType_AUDIO
}

func (x *TrackInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TrackInfo) GetMuted() bool {
	if x != nil {
		return x.Muted
	}
	return false
}

func (x *TrackInfo) GetWidth() uint32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *TrackInfo) GetHeight() uint32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *TrackInfo) GetSimulcast() bool {
	if x != nil {
		return x.Simulcast
	}
	return false
}

func (x *TrackInfo) GetDisableDtx() bool {
	if x != nil {
		return x.DisableDtx
	}
	return false
}

func (x *TrackInfo) GetSource() TrackSource {
	if x != nil {
		return x.Source
	}
	return TrackSource_UNKNOWN
}

func (x *TrackInfo) GetLayers() []*VideoLayer {
	if x != nil {
		return x.Layers
	}
	return nil
}

func (x *TrackInfo) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *TrackInfo) GetMid() string {
	if x != nil {
		return x.Mid
	}
	return ""
}

func (x *TrackInfo) GetCodecs() []*SimulcastCodecInfo {
	if x != nil {
		return x.Codecs
	}
	return nil
}

func (x *TrackInfo) GetStereo() bool {
	if x != nil {
		return x.Stereo
	}
	return false
}

func (x *TrackInfo) GetDisableRed() bool {
	if x != nil {
		return x.DisableRed
	}
	return false
}

func (x *TrackInfo) GetEncryption() Encryption_Type {
	if x != nil {
		return x.Encryption
	}
	return Encryption_NONE
}

func (x *TrackInfo) GetStream() string {
	if x != nil {
		return x.Stream
	}
	return ""
}

func (x *TrackInfo) GetVersion() *TimedVersion {
	if x != nil {
		return x.Version
	}
	return nil
}

// provide information about available spatial layers
type VideoLayer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// for tracks with a single layer, this should be HIGH
	Quality VideoQuality `protobuf:"varint,1,opt,name=quality,proto3,enum=livekit.VideoQuality" json:"quality,omitempty"`
	Width   uint32       `protobuf:"varint,2,opt,name=width,proto3" json:"width,omitempty"`
	Height  uint32       `protobuf:"varint,3,opt,name=height,proto3" json:"height,omitempty"`
	// target bitrate in bit per second (bps), server will measure actual
	Bitrate uint32 `protobuf:"varint,4,opt,name=bitrate,proto3" json:"bitrate,omitempty"`
	Ssrc    uint32 `protobuf:"varint,5,opt,name=ssrc,proto3" json:"ssrc,omitempty"`
}

func (x *VideoLayer) Reset() {
	*x = VideoLayer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoLayer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoLayer) ProtoMessage() {}

func (x *VideoLayer) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoLayer.ProtoReflect.Descriptor instead.
func (*VideoLayer) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{8}
}

func (x *VideoLayer) GetQuality() VideoQuality {
	if x != nil {
		return x.Quality
	}
	return VideoQuality_LOW
}

func (x *VideoLayer) GetWidth() uint32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *VideoLayer) GetHeight() uint32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *VideoLayer) GetBitrate() uint32 {
	if x != nil {
		return x.Bitrate
	}
	return 0
}

func (x *VideoLayer) GetSsrc() uint32 {
	if x != nil {
		return x.Ssrc
	}
	return 0
}

// new DataPacket API
type DataPacket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind DataPacket_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=livekit.DataPacket_Kind" json:"kind,omitempty"`
	// Types that are assignable to Value:
	//
	//	*DataPacket_User
	//	*DataPacket_Speaker
	Value isDataPacket_Value `protobuf_oneof:"value"`
}

func (x *DataPacket) Reset() {
	*x = DataPacket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataPacket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataPacket) ProtoMessage() {}

func (x *DataPacket) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataPacket.ProtoReflect.Descriptor instead.
func (*DataPacket) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{9}
}

func (x *DataPacket) GetKind() DataPacket_Kind {
	if x != nil {
		return x.Kind
	}
	return DataPacket_RELIABLE
}

func (m *DataPacket) GetValue() isDataPacket_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *DataPacket) GetUser() *UserPacket {
	if x, ok := x.GetValue().(*DataPacket_User); ok {
		return x.User
	}
	return nil
}

func (x *DataPacket) GetSpeaker() *ActiveSpeakerUpdate {
	if x, ok := x.GetValue().(*DataPacket_Speaker); ok {
		return x.Speaker
	}
	return nil
}

type isDataPacket_Value interface {
	isDataPacket_Value()
}

type DataPacket_User struct {
	User *UserPacket `protobuf:"bytes,2,opt,name=user,proto3,oneof"`
}

type DataPacket_Speaker struct {
	Speaker *ActiveSpeakerUpdate `protobuf:"bytes,3,opt,name=speaker,proto3,oneof"`
}

func (*DataPacket_User) isDataPacket_Value() {}

func (*DataPacket_Speaker) isDataPacket_Value() {}

type ActiveSpeakerUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Speakers []*SpeakerInfo `protobuf:"bytes,1,rep,name=speakers,proto3" json:"speakers,omitempty"`
}

func (x *ActiveSpeakerUpdate) Reset() {
	*x = ActiveSpeakerUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActiveSpeakerUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActiveSpeakerUpdate) ProtoMessage() {}

func (x *ActiveSpeakerUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActiveSpeakerUpdate.ProtoReflect.Descriptor instead.
func (*ActiveSpeakerUpdate) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{10}
}

func (x *ActiveSpeakerUpdate) GetSpeakers() []*SpeakerInfo {
	if x != nil {
		return x.Speakers
	}
	return nil
}

type SpeakerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sid string `protobuf:"bytes,1,opt,name=sid,proto3" json:"sid,omitempty"`
	// audio level, 0-1.0, 1 is loudest
	Level float32 `protobuf:"fixed32,2,opt,name=level,proto3" json:"level,omitempty"`
	// true if speaker is currently active
	Active bool `protobuf:"varint,3,opt,name=active,proto3" json:"active,omitempty"`
}

func (x *SpeakerInfo) Reset() {
	*x = SpeakerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeakerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeakerInfo) ProtoMessage() {}

func (x *SpeakerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeakerInfo.ProtoReflect.Descriptor instead.
func (*SpeakerInfo) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{11}
}

func (x *SpeakerInfo) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

func (x *SpeakerInfo) GetLevel() float32 {
	if x != nil {
		return x.Level
	}
	return 0
}

func (x *SpeakerInfo) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

type UserPacket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// participant ID of user that sent the message
	ParticipantSid      string `protobuf:"bytes,1,opt,name=participant_sid,json=participantSid,proto3" json:"participant_sid,omitempty"`
	ParticipantIdentity string `protobuf:"bytes,5,opt,name=participant_identity,json=participantIdentity,proto3" json:"participant_identity,omitempty"`
	// user defined payload
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// the ID of the participants who will receive the message (sent to all by default)
	DestinationSids []string `protobuf:"bytes,3,rep,name=destination_sids,json=destinationSids,proto3" json:"destination_sids,omitempty"`
	// identities of participants who will receive the message (sent to all by default)
	DestinationIdentities []string `protobuf:"bytes,6,rep,name=destination_identities,json=destinationIdentities,proto3" json:"destination_identities,omitempty"`
	// topic under which the message was published
	Topic *string `protobuf:"bytes,4,opt,name=topic,proto3,oneof" json:"topic,omitempty"`
}

func (x *UserPacket) Reset() {
	*x = UserPacket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserPacket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserPacket) ProtoMessage() {}

func (x *UserPacket) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserPacket.ProtoReflect.Descriptor instead.
func (*UserPacket) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{12}
}

func (x *UserPacket) GetParticipantSid() string {
	if x != nil {
		return x.ParticipantSid
	}
	return ""
}

func (x *UserPacket) GetParticipantIdentity() string {
	if x != nil {
		return x.ParticipantIdentity
	}
	return ""
}

func (x *UserPacket) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *UserPacket) GetDestinationSids() []string {
	if x != nil {
		return x.DestinationSids
	}
	return nil
}

func (x *UserPacket) GetDestinationIdentities() []string {
	if x != nil {
		return x.DestinationIdentities
	}
	return nil
}

func (x *UserPacket) GetTopic() string {
	if x != nil && x.Topic != nil {
		return *x.Topic
	}
	return ""
}

type ParticipantTracks struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// participant ID of participant to whom the tracks belong
	ParticipantSid string   `protobuf:"bytes,1,opt,name=participant_sid,json=participantSid,proto3" json:"participant_sid,omitempty"`
	TrackSids      []string `protobuf:"bytes,2,rep,name=track_sids,json=trackSids,proto3" json:"track_sids,omitempty"`
}

func (x *ParticipantTracks) Reset() {
	*x = ParticipantTracks{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParticipantTracks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParticipantTracks) ProtoMessage() {}

func (x *ParticipantTracks) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParticipantTracks.ProtoReflect.Descriptor instead.
func (*ParticipantTracks) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{13}
}

func (x *ParticipantTracks) GetParticipantSid() string {
	if x != nil {
		return x.ParticipantSid
	}
	return ""
}

func (x *ParticipantTracks) GetTrackSids() []string {
	if x != nil {
		return x.TrackSids
	}
	return nil
}

// details about the server
type ServerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Edition  ServerInfo_Edition `protobuf:"varint,1,opt,name=edition,proto3,enum=livekit.ServerInfo_Edition" json:"edition,omitempty"`
	Version  string             `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Protocol int32              `protobuf:"varint,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Region   string             `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
	NodeId   string             `protobuf:"bytes,5,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// additional debugging information. sent only if server is in development mode
	DebugInfo string `protobuf:"bytes,6,opt,name=debug_info,json=debugInfo,proto3" json:"debug_info,omitempty"`
}

func (x *ServerInfo) Reset() {
	*x = ServerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerInfo) ProtoMessage() {}

func (x *ServerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerInfo.ProtoReflect.Descriptor instead.
func (*ServerInfo) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{14}
}

func (x *ServerInfo) GetEdition() ServerInfo_Edition {
	if x != nil {
		return x.Edition
	}
	return ServerInfo_Standard
}

func (x *ServerInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ServerInfo) GetProtocol() int32 {
	if x != nil {
		return x.Protocol
	}
	return 0
}

func (x *ServerInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *ServerInfo) GetNodeId() string {
	if x != nil {
		return x.NodeId
	}
	return ""
}

func (x *ServerInfo) GetDebugInfo() string {
	if x != nil {
		return x.DebugInfo
	}
	return ""
}

// details about the client
type ClientInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sdk            ClientInfo_SDK `protobuf:"varint,1,opt,name=sdk,proto3,enum=livekit.ClientInfo_SDK" json:"sdk,omitempty"`
	Version        string         `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Protocol       int32          `protobuf:"varint,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Os             string         `protobuf:"bytes,4,opt,name=os,proto3" json:"os,omitempty"`
	OsVersion      string         `protobuf:"bytes,5,opt,name=os_version,json=osVersion,proto3" json:"os_version,omitempty"`
	DeviceModel    string         `protobuf:"bytes,6,opt,name=device_model,json=deviceModel,proto3" json:"device_model,omitempty"`
	Browser        string         `protobuf:"bytes,7,opt,name=browser,proto3" json:"browser,omitempty"`
	BrowserVersion string         `protobuf:"bytes,8,opt,name=browser_version,json=browserVersion,proto3" json:"browser_version,omitempty"`
	Address        string         `protobuf:"bytes,9,opt,name=address,proto3" json:"address,omitempty"`
	// wifi, wired, cellular, vpn, empty if not known
	Network string `protobuf:"bytes,10,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *ClientInfo) Reset() {
	*x = ClientInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientInfo) ProtoMessage() {}

func (x *ClientInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientInfo.ProtoReflect.Descriptor instead.
func (*ClientInfo) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{15}
}

func (x *ClientInfo) GetSdk() ClientInfo_SDK {
	if x != nil {
		return x.Sdk
	}
	return ClientInfo_UNKNOWN
}

func (x *ClientInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClientInfo) GetProtocol() int32 {
	if x != nil {
		return x.Protocol
	}
	return 0
}

func (x *ClientInfo) GetOs() string {
	if x != nil {
		return x.Os
	}
	return ""
}

func (x *ClientInfo) GetOsVersion() string {
	if x != nil {
		return x.OsVersion
	}
	return ""
}

func (x *ClientInfo) GetDeviceModel() string {
	if x != nil {
		return x.DeviceModel
	}
	return ""
}

func (x *ClientInfo) GetBrowser() string {
	if x != nil {
		return x.Browser
	}
	return ""
}

func (x *ClientInfo) GetBrowserVersion() string {
	if x != nil {
		return x.BrowserVersion
	}
	return ""
}

func (x *ClientInfo) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ClientInfo) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

// server provided client configuration
type ClientConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Video            *VideoConfiguration `protobuf:"bytes,1,opt,name=video,proto3" json:"video,omitempty"`
	Screen           *VideoConfiguration `protobuf:"bytes,2,opt,name=screen,proto3" json:"screen,omitempty"`
	ResumeConnection ClientConfigSetting `protobuf:"varint,3,opt,name=resume_connection,json=resumeConnection,proto3,enum=livekit.ClientConfigSetting" json:"resume_connection,omitempty"`
	DisabledCodecs   *DisabledCodecs     `protobuf:"bytes,4,opt,name=disabled_codecs,json=disabledCodecs,proto3" json:"disabled_codecs,omitempty"`
	ForceRelay       ClientConfigSetting `protobuf:"varint,5,opt,name=force_relay,json=forceRelay,proto3,enum=livekit.ClientConfigSetting" json:"force_relay,omitempty"`
}

func (x *ClientConfiguration) Reset() {
	*x = ClientConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConfiguration) ProtoMessage() {}

func (x *ClientConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConfiguration.ProtoReflect.Descriptor instead.
func (*ClientConfiguration) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{16}
}

func (x *ClientConfiguration) GetVideo() *VideoConfiguration {
	if x != nil {
		return x.Video
	}
	return nil
}

func (x *ClientConfiguration) GetScreen() *VideoConfiguration {
	if x != nil {
		return x.Screen
	}
	return nil
}

func (x *ClientConfiguration) GetResumeConnection() ClientConfigSetting {
	if x != nil {
		return x.ResumeConnection
	}
	return ClientConfigSetting_UNSET
}

func (x *ClientConfiguration) GetDisabledCodecs() *DisabledCodecs {
	if x != nil {
		return x.DisabledCodecs
	}
	return nil
}

func (x *ClientConfiguration) GetForceRelay() ClientConfigSetting {
	if x != nil {
		return x.ForceRelay
	}
	return ClientConfigSetting_UNSET
}

type VideoConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HardwareEncoder ClientConfigSetting `protobuf:"varint,1,opt,name=hardware_encoder,json=hardwareEncoder,proto3,enum=livekit.ClientConfigSetting" json:"hardware_encoder,omitempty"`
}

func (x *VideoConfiguration) Reset() {
	*x = VideoConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoConfiguration) ProtoMessage() {}

func (x *VideoConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoConfiguration.ProtoReflect.Descriptor instead.
func (*VideoConfiguration) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{17}
}

func (x *VideoConfiguration) GetHardwareEncoder() ClientConfigSetting {
	if x != nil {
		return x.HardwareEncoder
	}
	return ClientConfigSetting_UNSET
}

type DisabledCodecs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// disabled for both publish and subscribe
	Codecs []*Codec `protobuf:"bytes,1,rep,name=codecs,proto3" json:"codecs,omitempty"`
	// only disable for publish
	Publish []*Codec `protobuf:"bytes,2,rep,name=publish,proto3" json:"publish,omitempty"`
}

func (x *DisabledCodecs) Reset() {
	*x = DisabledCodecs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisabledCodecs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisabledCodecs) ProtoMessage() {}

func (x *DisabledCodecs) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisabledCodecs.ProtoReflect.Descriptor instead.
func (*DisabledCodecs) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{18}
}

func (x *DisabledCodecs) GetCodecs() []*Codec {
	if x != nil {
		return x.Codecs
	}
	return nil
}

func (x *DisabledCodecs) GetPublish() []*Codec {
	if x != nil {
		return x.Publish
	}
	return nil
}

type RTPDrift struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartTime      *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	EndTime        *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	Duration       float64                `protobuf:"fixed64,3,opt,name=duration,proto3" json:"duration,omitempty"`
	StartTimestamp uint64                 `protobuf:"varint,4,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
	EndTimestamp   uint64                 `protobuf:"varint,5,opt,name=end_timestamp,json=endTimestamp,proto3" json:"end_timestamp,omitempty"`
	RtpClockTicks  uint64                 `protobuf:"varint,6,opt,name=rtp_clock_ticks,json=rtpClockTicks,proto3" json:"rtp_clock_ticks,omitempty"`
	DriftSamples   int64                  `protobuf:"varint,7,opt,name=drift_samples,json=driftSamples,proto3" json:"drift_samples,omitempty"`
	DriftMs        float64                `protobuf:"fixed64,8,opt,name=drift_ms,json=driftMs,proto3" json:"drift_ms,omitempty"`
	ClockRate      float64                `protobuf:"fixed64,9,opt,name=clock_rate,json=clockRate,proto3" json:"clock_rate,omitempty"`
}

func (x *RTPDrift) Reset() {
	*x = RTPDrift{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RTPDrift) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RTPDrift) ProtoMessage() {}

func (x *RTPDrift) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RTPDrift.ProtoReflect.Descriptor instead.
func (*RTPDrift) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{19}
}

func (x *RTPDrift) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *RTPDrift) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *RTPDrift) GetDuration() float64 {
	if x != nil {
		return x.Duration
	}
	return 0
}

func (x *RTPDrift) GetStartTimestamp() uint64 {
	if x != nil {
		return x.StartTimestamp
	}
	return 0
}

func (x *RTPDrift) GetEndTimestamp() uint64 {
	if x != nil {
		return x.EndTimestamp
	}
	return 0
}

func (x *RTPDrift) GetRtpClockTicks() uint64 {
	if x != nil {
		return x.RtpClockTicks
	}
	return 0
}

func (x *RTPDrift) GetDriftSamples() int64 {
	if x != nil {
		return x.DriftSamples
	}
	return 0
}

func (x *RTPDrift) GetDriftMs() float64 {
	if x != nil {
		return x.DriftMs
	}
	return 0
}

func (x *RTPDrift) GetClockRate() float64 {
	if x != nil {
		return x.ClockRate
	}
	return 0
}

type RTPStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartTime            *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	EndTime              *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	Duration             float64                `protobuf:"fixed64,3,opt,name=duration,proto3" json:"duration,omitempty"`
	Packets              uint32                 `protobuf:"varint,4,opt,name=packets,proto3" json:"packets,omitempty"`
	PacketRate           float64                `protobuf:"fixed64,5,opt,name=packet_rate,json=packetRate,proto3" json:"packet_rate,omitempty"`
	Bytes                uint64                 `protobuf:"varint,6,opt,name=bytes,proto3" json:"bytes,omitempty"`
	HeaderBytes          uint64                 `protobuf:"varint,39,opt,name=header_bytes,json=headerBytes,proto3" json:"header_bytes,omitempty"`
	Bitrate              float64                `protobuf:"fixed64,7,opt,name=bitrate,proto3" json:"bitrate,omitempty"`
	PacketsLost          uint32                 `protobuf:"varint,8,opt,name=packets_lost,json=packetsLost,proto3" json:"packets_lost,omitempty"`
	PacketLossRate       float64                `protobuf:"fixed64,9,opt,name=packet_loss_rate,json=packetLossRate,proto3" json:"packet_loss_rate,omitempty"`
	PacketLossPercentage float32                `protobuf:"fixed32,10,opt,name=packet_loss_percentage,json=packetLossPercentage,proto3" json:"packet_loss_percentage,omitempty"`
	PacketsDuplicate     uint32                 `protobuf:"varint,11,opt,name=packets_duplicate,json=packetsDuplicate,proto3" json:"packets_duplicate,omitempty"`
	PacketDuplicateRate  float64                `protobuf:"fixed64,12,opt,name=packet_duplicate_rate,json=packetDuplicateRate,proto3" json:"packet_duplicate_rate,omitempty"`
	BytesDuplicate       uint64                 `protobuf:"varint,13,opt,name=bytes_duplicate,json=bytesDuplicate,proto3" json:"bytes_duplicate,omitempty"`
	HeaderBytesDuplicate uint64                 `protobuf:"varint,40,opt,name=header_bytes_duplicate,json=headerBytesDuplicate,proto3" json:"header_bytes_duplicate,omitempty"`
	BitrateDuplicate     float64                `protobuf:"fixed64,14,opt,name=bitrate_duplicate,json=bitrateDuplicate,proto3" json:"bitrate_duplicate,omitempty"`
	PacketsPadding       uint32                 `protobuf:"varint,15,opt,name=packets_padding,json=packetsPadding,proto3" json:"packets_padding,omitempty"`
	PacketPaddingRate    float64                `protobuf:"fixed64,16,opt,name=packet_padding_rate,json=packetPaddingRate,proto3" json:"packet_padding_rate,omitempty"`
	BytesPadding         uint64                 `protobuf:"varint,17,opt,name=bytes_padding,json=bytesPadding,proto3" json:"bytes_padding,omitempty"`
	HeaderBytesPadding   uint64                 `protobuf:"varint,41,opt,name=header_bytes_padding,json=headerBytesPadding,proto3" json:"header_bytes_padding,omitempty"`
	BitratePadding       float64                `protobuf:"fixed64,18,opt,name=bitrate_padding,json=bitratePadding,proto3" json:"bitrate_padding,omitempty"`
	PacketsOutOfOrder    uint32                 `protobuf:"varint,19,opt,name=packets_out_of_order,json=packetsOutOfOrder,proto3" json:"packets_out_of_order,omitempty"`
	Frames               uint32                 `protobuf:"varint,20,opt,name=frames,proto3" json:"frames,omitempty"`
	FrameRate            float64                `protobuf:"fixed64,21,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
	JitterCurrent        float64                `protobuf:"fixed64,22,opt,name=jitter_current,json=jitterCurrent,proto3" json:"jitter_current,omitempty"`
	JitterMax            float64                `protobuf:"fixed64,23,opt,name=jitter_max,json=jitterMax,proto3" json:"jitter_max,omitempty"`
	GapHistogram         map[int32]uint32       `protobuf:"bytes,24,rep,name=gap_histogram,json=gapHistogram,proto3" json:"gap_histogram,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	Nacks                uint32                 `protobuf:"varint,25,opt,name=nacks,proto3" json:"nacks,omitempty"`
	NackAcks             uint32                 `protobuf:"varint,37,opt,name=nack_acks,json=nackAcks,proto3" json:"nack_acks,omitempty"`
	NackMisses           uint32                 `protobuf:"varint,26,opt,name=nack_misses,json=nackMisses,proto3" json:"nack_misses,omitempty"`
	NackRepeated         uint32                 `protobuf:"varint,38,opt,name=nack_repeated,json=nackRepeated,proto3" json:"nack_repeated,omitempty"`
	Plis                 uint32                 `protobuf:"varint,27,opt,name=plis,proto3" json:"plis,omitempty"`
	LastPli              *timestamppb.Timestamp `protobuf:"bytes,28,opt,name=last_pli,json=lastPli,proto3" json:"last_pli,omitempty"`
	Firs                 uint32                 `protobuf:"varint,29,opt,name=firs,proto3" json:"firs,omitempty"`
	LastFir              *timestamppb.Timestamp `protobuf:"bytes,30,opt,name=last_fir,json=lastFir,proto3" json:"last_fir,omitempty"`
	RttCurrent           uint32                 `protobuf:"varint,31,opt,name=rtt_current,json=rttCurrent,proto3" json:"rtt_current,omitempty"`
	RttMax               uint32                 `protobuf:"varint,32,opt,name=rtt_max,json=rttMax,proto3" json:"rtt_max,omitempty"`
	KeyFrames            uint32                 `protobuf:"varint,33,opt,name=key_frames,json=keyFrames,proto3" json:"key_frames,omitempty"`
	LastKeyFrame         *timestamppb.Timestamp `protobuf:"bytes,34,opt,name=last_key_frame,json=lastKeyFrame,proto3" json:"last_key_frame,omitempty"`
	LayerLockPlis        uint32                 `protobuf:"varint,35,opt,name=layer_lock_plis,json=layerLockPlis,proto3" json:"layer_lock_plis,omitempty"`
	LastLayerLockPli     *timestamppb.Timestamp `protobuf:"bytes,36,opt,name=last_layer_lock_pli,json=lastLayerLockPli,proto3" json:"last_layer_lock_pli,omitempty"`
	PacketDrift          *RTPDrift              `protobuf:"bytes,44,opt,name=packet_drift,json=packetDrift,proto3" json:"packet_drift,omitempty"`
	ReportDrift          *RTPDrift              `protobuf:"bytes,45,opt,name=report_drift,json=reportDrift,proto3" json:"report_drift,omitempty"` // NEXT_ID: 46
}

func (x *RTPStats) Reset() {
	*x = RTPStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RTPStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RTPStats) ProtoMessage() {}

func (x *RTPStats) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RTPStats.ProtoReflect.Descriptor instead.
func (*RTPStats) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{20}
}

func (x *RTPStats) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *RTPStats) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *RTPStats) GetDuration() float64 {
	if x != nil {
		return x.Duration
	}
	return 0
}

func (x *RTPStats) GetPackets() uint32 {
	if x != nil {
		return x.Packets
	}
	return 0
}

func (x *RTPStats) GetPacketRate() float64 {
	if x != nil {
		return x.PacketRate
	}
	return 0
}

func (x *RTPStats) GetBytes() uint64 {
	if x != nil {
		return x.Bytes
	}
	return 0
}

func (x *RTPStats) GetHeaderBytes() uint64 {
	if x != nil {
		return x.HeaderBytes
	}
	return 0
}

func (x *RTPStats) GetBitrate() float64 {
	if x != nil {
		return x.Bitrate
	}
	return 0
}

func (x *RTPStats) GetPacketsLost() uint32 {
	if x != nil {
		return x.PacketsLost
	}
	return 0
}

func (x *RTPStats) GetPacketLossRate() float64 {
	if x != nil {
		return x.PacketLossRate
	}
	return 0
}

func (x *RTPStats) GetPacketLossPercentage() float32 {
	if x != nil {
		return x.PacketLossPercentage
	}
	return 0
}

func (x *RTPStats) GetPacketsDuplicate() uint32 {
	if x != nil {
		return x.PacketsDuplicate
	}
	return 0
}

func (x *RTPStats) GetPacketDuplicateRate() float64 {
	if x != nil {
		return x.PacketDuplicateRate
	}
	return 0
}

func (x *RTPStats) GetBytesDuplicate() uint64 {
	if x != nil {
		return x.BytesDuplicate
	}
	return 0
}

func (x *RTPStats) GetHeaderBytesDuplicate() uint64 {
	if x != nil {
		return x.HeaderBytesDuplicate
	}
	return 0
}

func (x *RTPStats) GetBitrateDuplicate() float64 {
	if x != nil {
		return x.BitrateDuplicate
	}
	return 0
}

func (x *RTPStats) GetPacketsPadding() uint32 {
	if x != nil {
		return x.PacketsPadding
	}
	return 0
}

func (x *RTPStats) GetPacketPaddingRate() float64 {
	if x != nil {
		return x.PacketPaddingRate
	}
	return 0
}

func (x *RTPStats) GetBytesPadding() uint64 {
	if x != nil {
		return x.BytesPadding
	}
	return 0
}

func (x *RTPStats) GetHeaderBytesPadding() uint64 {
	if x != nil {
		return x.HeaderBytesPadding
	}
	return 0
}

func (x *RTPStats) GetBitratePadding() float64 {
	if x != nil {
		return x.BitratePadding
	}
	return 0
}

func (x *RTPStats) GetPacketsOutOfOrder() uint32 {
	if x != nil {
		return x.PacketsOutOfOrder
	}
	return 0
}

func (x *RTPStats) GetFrames() uint32 {
	if x != nil {
		return x.Frames
	}
	return 0
}

func (x *RTPStats) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

func (x *RTPStats) GetJitterCurrent() float64 {
	if x != nil {
		return x.JitterCurrent
	}
	return 0
}

func (x *RTPStats) GetJitterMax() float64 {
	if x != nil {
		return x.JitterMax
	}
	return 0
}

func (x *RTPStats) GetGapHistogram() map[int32]uint32 {
	if x != nil {
		return x.GapHistogram
	}
	return nil
}

func (x *RTPStats) GetNacks() uint32 {
	if x != nil {
		return x.Nacks
	}
	return 0
}

func (x *RTPStats) GetNackAcks() uint32 {
	if x != nil {
		return x.NackAcks
	}
	return 0
}

func (x *RTPStats) GetNackMisses() uint32 {
	if x != nil {
		return x.NackMisses
	}
	return 0
}

func (x *RTPStats) GetNackRepeated() uint32 {
	if x != nil {
		return x.NackRepeated
	}
	return 0
}

func (x *RTPStats) GetPlis() uint32 {
	if x != nil {
		return x.Plis
	}
	return 0
}

func (x *RTPStats) GetLastPli() *timestamppb.Timestamp {
	if x != nil {
		return x.LastPli
	}
	return nil
}

func (x *RTPStats) GetFirs() uint32 {
	if x != nil {
		return x.Firs
	}
	return 0
}

func (x *RTPStats) GetLastFir() *timestamppb.Timestamp {
	if x != nil {
		return x.LastFir
	}
	return nil
}

func (x *RTPStats) GetRttCurrent() uint32 {
	if x != nil {
		return x.RttCurrent
	}
	return 0
}

func (x *RTPStats) GetRttMax() uint32 {
	if x != nil {
		return x.RttMax
	}
	return 0
}

func (x *RTPStats) GetKeyFrames() uint32 {
	if x != nil {
		return x.KeyFrames
	}
	return 0
}

func (x *RTPStats) GetLastKeyFrame() *timestamppb.Timestamp {
	if x != nil {
		return x.LastKeyFrame
	}
	return nil
}

func (x *RTPStats) GetLayerLockPlis() uint32 {
	if x != nil {
		return x.LayerLockPlis
	}
	return 0
}

func (x *RTPStats) GetLastLayerLockPli() *timestamppb.Timestamp {
	if x != nil {
		return x.LastLayerLockPli
	}
	return nil
}

func (x *RTPStats) GetPacketDrift() *RTPDrift {
	if x != nil {
		return x.PacketDrift
	}
	return nil
}

func (x *RTPStats) GetReportDrift() *RTPDrift {
	if x != nil {
		return x.ReportDrift
	}
	return nil
}

type TimedVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UnixMicro int64 `protobuf:"varint,1,opt,name=unix_micro,json=unixMicro,proto3" json:"unix_micro,omitempty"`
	Ticks     int32 `protobuf:"varint,2,opt,name=ticks,proto3" json:"ticks,omitempty"`
}

func (x *TimedVersion) Reset() {
	*x = TimedVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_models_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimedVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimedVersion) ProtoMessage() {}

func (x *TimedVersion) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_models_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimedVersion.ProtoReflect.Descriptor instead.
func (*TimedVersion) Descriptor() ([]byte, []int) {
	return file_livekit_models_proto_rawDescGZIP(), []int{21}
}

func (x *TimedVersion) GetUnixMicro() int64 {
	if x != nil {
		return x.UnixMicro
	}
	return 0
}

func (x *TimedVersion) GetTicks() int32 {
	if x != nil {
		return x.Ticks
	}
	return 0
}

var File_livekit_models_proto protoreflect.FileDescriptor

var file_livekit_models_proto_rawDesc = []byte{
	0x0a, 0x14, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xc7, 0x03, 0x0a, 0x04, 0x52, 0x6f, 0x6f, 0x6d, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x54, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f,
	0x6d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x75, 0x72,
	0x6e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x35, 0x0a, 0x0e, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x0e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6f, 0x64, 0x65,
	0x63, 0x52, 0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x29, 0x0a, 0x10,
	0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x6e, 0x75, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0d, 0x6e, 0x75, 0x6d, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x12, 0x29,
	0x0a, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2f, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x38, 0x0a, 0x05, 0x43, 0x6f,
	0x64, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6d, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6d, 0x74, 0x70, 0x5f,
	0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6d, 0x74, 0x70,
	0x4c, 0x69, 0x6e, 0x65, 0x22, 0x4c, 0x0a, 0x0c, 0x50, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x44,
	0x65, 0x6c, 0x61, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x10,
	0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6d, 0x69, 0x6e,
	0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6d,
	0x61, 0x78, 0x22, 0xc7, 0x02, 0x0a, 0x15, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d,
	0x63, 0x61, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x63, 0x61, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x61, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x63, 0x61,
	0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x44, 0x0a, 0x13,
	0x63, 0x61, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x11, 0x63, 0x61, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x61, 0x6e, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x11, 0x63, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22, 0xb9, 0x04, 0x0a,
	0x0f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73,
	0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x34,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x09,
	0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12,
	0x21, 0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x73, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x12, 0x31, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1d, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x3e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b,
	0x0a, 0x07, 0x4a, 0x4f, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4a,
	0x4f, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43,
	0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0x41, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0c, 0x0a,
	0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49,
	0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x47, 0x52, 0x45,
	0x53, 0x53, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x49, 0x50, 0x10, 0x03, 0x12, 0x09, 0x0a,
	0x05, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x22, 0x33, 0x0a, 0x0a, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x25, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08,
	0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x43, 0x4d, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x22, 0x82, 0x01,
	0x0a, 0x12, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x63, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x63,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6d, 0x69, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x63, 0x69, 0x64, 0x12, 0x2b, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x65,
	0x72, 0x73, 0x22, 0xd7, 0x04, 0x0a, 0x09, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73,
	0x69, 0x64, 0x12, 0x26, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x6d, 0x75, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6d,
	0x75, 0x74, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x63, 0x61, 0x73, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x63, 0x61, 0x73, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x74, 0x78, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x74,
	0x78, 0x12, 0x2c, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x14, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63,
	0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x2b, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4c,
	0x61, 0x79, 0x65, 0x72, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x64,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6d, 0x69, 0x64, 0x12, 0x33, 0x0a, 0x06, 0x63,
	0x6f, 0x64, 0x65, 0x63, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x63, 0x61, 0x73, 0x74, 0x43,
	0x6f, 0x64, 0x65, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x65, 0x72, 0x65, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x73, 0x74, 0x65, 0x72, 0x65, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x2f, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0x0a,
	0x0a, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x07, 0x71,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x69,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x62, 0x69, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x73, 0x72, 0x63, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x04, 0x73, 0x73, 0x72, 0x63, 0x22, 0xc9, 0x01, 0x0a, 0x0a, 0x44, 0x61, 0x74,
	0x61, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x2c, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x29, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x00, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72,
	0x12, 0x38, 0x0a, 0x07, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48,
	0x00, 0x52, 0x07, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x22, 0x1f, 0x0a, 0x04, 0x4b, 0x69,
	0x6e, 0x64, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4c, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x4c, 0x4f, 0x53, 0x53, 0x59, 0x10, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x47, 0x0a, 0x13, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70,
	0x65, 0x61, 0x6b, 0x65, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x30, 0x0a, 0x08, 0x73,
	0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x08, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x73, 0x22, 0x4d, 0x0a,
	0x0b, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a, 0x03,
	0x73, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x69, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x22, 0x89, 0x02, 0x0a,
	0x0a, 0x55, 0x73, 0x65, 0x72, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x53, 0x69, 0x64, 0x12, 0x31, 0x0a, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x64, 0x73, 0x12, 0x35, 0x0a, 0x16,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x88, 0x01, 0x01, 0x42, 0x08,
	0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x5b, 0x0a, 0x11, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x12, 0x27, 0x0a,
	0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x53, 0x69, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f,
	0x73, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x53, 0x69, 0x64, 0x73, 0x22, 0xed, 0x01, 0x0a, 0x0a, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x35, 0x0a, 0x07, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x45, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x07, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65,
	0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x22, 0x22, 0x0a, 0x07, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x10, 0x01, 0x22, 0xbc, 0x03, 0x0a, 0x0a, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x29, 0x0a, 0x03, 0x73, 0x64, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x44, 0x4b, 0x52, 0x03, 0x73, 0x64, 0x6b, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x0e, 0x0a, 0x02, 0x6f, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x6f, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x73, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x72, 0x6f, 0x77, 0x73,
	0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x72, 0x6f, 0x77, 0x73, 0x65,
	0x72, 0x12, 0x27, 0x0a, 0x0f, 0x62, 0x72, 0x6f, 0x77, 0x73, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x72, 0x6f, 0x77,
	0x73, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x83,
	0x01, 0x0a, 0x03, 0x53, 0x44, 0x4b, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4a, 0x53, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x53,
	0x57, 0x49, 0x46, 0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x4e, 0x44, 0x52, 0x4f, 0x49,
	0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4c, 0x55, 0x54, 0x54, 0x45, 0x52, 0x10, 0x04,
	0x12, 0x06, 0x0a, 0x02, 0x47, 0x4f, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x4e, 0x49, 0x54,
	0x59, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x41, 0x43, 0x54, 0x5f, 0x4e, 0x41, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x07, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x55, 0x53, 0x54, 0x10, 0x08, 0x12,
	0x0a, 0x0a, 0x06, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x10, 0x09, 0x12, 0x07, 0x0a, 0x03, 0x43,
	0x50, 0x50, 0x10, 0x0a, 0x22, 0xc9, 0x02, 0x0a, 0x13, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x05,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x12,
	0x33, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x73, 0x63,
	0x72, 0x65, 0x65, 0x6e, 0x12, 0x49, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x10, 0x72,
	0x65, 0x73, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x40, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x63, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x63,
	0x73, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x63,
	0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x52, 0x65, 0x6c, 0x61, 0x79,
	0x22, 0x5d, 0x0a, 0x12, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x10, 0x68, 0x61, 0x72, 0x64, 0x77, 0x61,
	0x72, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x0f,
	0x68, 0x61, 0x72, 0x64, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x22,
	0x62, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x63,
	0x73, 0x12, 0x26, 0x0a, 0x06, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x0e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6f, 0x64, 0x65,
	0x63, 0x52, 0x06, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x12, 0x28, 0x0a, 0x07, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x52, 0x07, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x22, 0xed, 0x02, 0x0a, 0x08, 0x52, 0x54, 0x50, 0x44, 0x72, 0x69, 0x66, 0x74,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27,
	0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x26, 0x0a, 0x0f,
	0x72, 0x74, 0x70, 0x5f, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x72, 0x74, 0x70, 0x43, 0x6c, 0x6f, 0x63, 0x6b, 0x54,
	0x69, 0x63, 0x6b, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x72, 0x69, 0x66, 0x74, 0x5f, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x64, 0x72, 0x69,
	0x66, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x64, 0x72, 0x69,
	0x66, 0x74, 0x5f, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x01, 0x52, 0x07, 0x64, 0x72, 0x69,
	0x66, 0x74, 0x4d, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x52,
	0x61, 0x74, 0x65, 0x22, 0xb1, 0x0e, 0x0a, 0x08, 0x52, 0x54, 0x50, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x70,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x62, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x27, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x07, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x4c, 0x6f, 0x73, 0x74, 0x12,
	0x28, 0x0a, 0x10, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x73, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x70, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x4c, 0x6f, 0x73, 0x73, 0x52, 0x61, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x70, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x02, 0x52, 0x14, 0x70, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x4c, 0x6f, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x64, 0x75, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a, 0x15,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x01, 0x52, 0x13, 0x70, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x61, 0x74, 0x65,
	0x12, 0x27, 0x0a, 0x0f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x04, 0x52, 0x14, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x74, 0x65, 0x73, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x75, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x62, 0x69, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x61,
	0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x11, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70,
	0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x30, 0x0a, 0x14, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x29, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x27, 0x0a, 0x0f,
	0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x50, 0x61,
	0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2f, 0x0a, 0x14, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x11, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x4f,
	0x66, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1d,
	0x0a, 0x0a, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x6a, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0d, 0x6a, 0x69, 0x74, 0x74, 0x65, 0x72, 0x43, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6a, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x6d,
	0x61, 0x78, 0x18, 0x17, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6a, 0x69, 0x74, 0x74, 0x65, 0x72,
	0x4d, 0x61, 0x78, 0x12, 0x48, 0x0a, 0x0d, 0x67, 0x61, 0x70, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x18, 0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x54, 0x50, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x47, 0x61,
	0x70, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0c, 0x67, 0x61, 0x70, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x14, 0x0a,
	0x05, 0x6e, 0x61, 0x63, 0x6b, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6e, 0x61,
	0x63, 0x6b, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x61, 0x63, 0x6b, 0x5f, 0x61, 0x63, 0x6b, 0x73,
	0x18, 0x25, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x6e, 0x61, 0x63, 0x6b, 0x41, 0x63, 0x6b, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x61, 0x63, 0x6b, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x65, 0x73, 0x18,
	0x1a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6e, 0x61, 0x63, 0x6b, 0x4d, 0x69, 0x73, 0x73, 0x65,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6e, 0x61, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6e, 0x61, 0x63, 0x6b, 0x52, 0x65,
	0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6c, 0x69, 0x73, 0x18, 0x1b,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x6c, 0x69, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x70, 0x6c, 0x69, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x6c,
	0x69, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x69, 0x72, 0x73, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x04, 0x66, 0x69, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x66, 0x69,
	0x72, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x6c, 0x61, 0x73, 0x74, 0x46, 0x69, 0x72, 0x12, 0x1f, 0x0a, 0x0b,
	0x72, 0x74, 0x74, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x1f, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0a, 0x72, 0x74, 0x74, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a,
	0x07, 0x72, 0x74, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06,
	0x72, 0x74, 0x74, 0x4d, 0x61, 0x78, 0x12, 0x1d, 0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x73, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x4b,
	0x65, 0x79, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6c, 0x61, 0x79, 0x65, 0x72,
	0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x70, 0x6c, 0x69, 0x73, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0d, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x6b, 0x50, 0x6c, 0x69, 0x73, 0x12,
	0x49, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x5f, 0x6c, 0x6f,
	0x63, 0x6b, 0x5f, 0x70, 0x6c, 0x69, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x4c, 0x61,
	0x79, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x6b, 0x50, 0x6c, 0x69, 0x12, 0x34, 0x0a, 0x0c, 0x70, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x5f, 0x64, 0x72, 0x69, 0x66, 0x74, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x54, 0x50, 0x44, 0x72,
	0x69, 0x66, 0x74, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x44, 0x72, 0x69, 0x66, 0x74,
	0x12, 0x34, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x72, 0x69, 0x66, 0x74,
	0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x52, 0x54, 0x50, 0x44, 0x72, 0x69, 0x66, 0x74, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x72, 0x69, 0x66, 0x74, 0x1a, 0x3f, 0x0a, 0x11, 0x47, 0x61, 0x70, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x43, 0x0a, 0x0c, 0x54, 0x69, 0x6d, 0x65, 0x64,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x6e, 0x69, 0x78, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x75, 0x6e, 0x69,
	0x78, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x74, 0x69, 0x63, 0x6b, 0x73, 0x2a, 0x2f, 0x0a, 0x0a,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45,
	0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x41, 0x43, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4f, 0x50,
	0x55, 0x53, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x41, 0x43, 0x10, 0x02, 0x2a, 0x56, 0x0a,
	0x0a, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x0e, 0x0a, 0x0a, 0x44,
	0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x56, 0x43, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x48,
	0x32, 0x36, 0x34, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x48, 0x32, 0x36, 0x34, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x48, 0x32, 0x36, 0x34, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03,
	0x56, 0x50, 0x38, 0x10, 0x04, 0x2a, 0x29, 0x0a, 0x0a, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x63, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x43, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c,
	0x54, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x43, 0x5f, 0x4a, 0x50, 0x45, 0x47, 0x10, 0x01,
	0x2a, 0x2b, 0x0a, 0x09, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x09, 0x0a,
	0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x56, 0x49, 0x44, 0x45,
	0x4f, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x41, 0x10, 0x02, 0x2a, 0x60, 0x0a,
	0x0b, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x0b, 0x0a, 0x07,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x41, 0x4d,
	0x45, 0x52, 0x41, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x49, 0x43, 0x52, 0x4f, 0x50, 0x48,
	0x4f, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x43, 0x52, 0x45, 0x45, 0x4e, 0x5f,
	0x53, 0x48, 0x41, 0x52, 0x45, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x43, 0x52, 0x45, 0x45,
	0x4e, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x45, 0x5f, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x04, 0x2a,
	0x36, 0x0a, 0x0c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12,
	0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49,
	0x55, 0x4d, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x02, 0x12, 0x07,
	0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x03, 0x2a, 0x40, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x08, 0x0a, 0x04,
	0x50, 0x4f, 0x4f, 0x52, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x4f, 0x4f, 0x44, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x45, 0x58, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12,
	0x08, 0x0a, 0x04, 0x4c, 0x4f, 0x53, 0x54, 0x10, 0x03, 0x2a, 0x3b, 0x0a, 0x13, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x09, 0x0a, 0x05, 0x55, 0x4e, 0x53, 0x45, 0x54, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x2a, 0xdb, 0x01, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x0e, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43, 0x41,
	0x54, 0x45, 0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12, 0x13, 0x0a,
	0x0f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x48, 0x55, 0x54, 0x44, 0x4f, 0x57, 0x4e,
	0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43, 0x49, 0x50, 0x41, 0x4e,
	0x54, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x52,
	0x4f, 0x4f, 0x4d, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x12, 0x0a,
	0x0e, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10,
	0x06, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52,
	0x45, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x08, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x49, 0x47, 0x4e, 0x41, 0x4c, 0x5f, 0x43, 0x4c, 0x4f,
	0x53, 0x45, 0x10, 0x09, 0x2a, 0x89, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x52, 0x5f, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x52, 0x5f, 0x53,
	0x49, 0x47, 0x4e, 0x41, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x52, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49,
	0x53, 0x48, 0x45, 0x52, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x18, 0x0a,
	0x14, 0x52, 0x52, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x52, 0x5f, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x52, 0x5f, 0x53, 0x57,
	0x49, 0x54, 0x43, 0x48, 0x5f, 0x43, 0x41, 0x4e, 0x44, 0x49, 0x44, 0x41, 0x54, 0x45, 0x10, 0x04,
	0x2a, 0x54, 0x0a, 0x11, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x44, 0x45,
	0x43, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x4e, 0x4f, 0x54, 0x46,
	0x4f, 0x55, 0x4e, 0x44, 0x10, 0x02, 0x42, 0x46, 0x5a, 0x23, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0xaa, 0x02, 0x0d,
	0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xea, 0x02, 0x0e,
	0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69, 0x74, 0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_livekit_models_proto_rawDescOnce sync.Once
	file_livekit_models_proto_rawDescData = file_livekit_models_proto_rawDesc
)

func file_livekit_models_proto_rawDescGZIP() []byte {
	file_livekit_models_proto_rawDescOnce.Do(func() {
		file_livekit_models_proto_rawDescData = protoimpl.X.CompressGZIP(file_livekit_models_proto_rawDescData)
	})
	return file_livekit_models_proto_rawDescData
}

var file_livekit_models_proto_enumTypes = make([]protoimpl.EnumInfo, 17)
var file_livekit_models_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_livekit_models_proto_goTypes = []interface{}{
	(AudioCodec)(0),               // 0: livekit.AudioCodec
	(VideoCodec)(0),               // 1: livekit.VideoCodec
	(ImageCodec)(0),               // 2: livekit.ImageCodec
	(TrackType)(0),                // 3: livekit.TrackType
	(TrackSource)(0),              // 4: livekit.TrackSource
	(VideoQuality)(0),             // 5: livekit.VideoQuality
	(ConnectionQuality)(0),        // 6: livekit.ConnectionQuality
	(ClientConfigSetting)(0),      // 7: livekit.ClientConfigSetting
	(DisconnectReason)(0),         // 8: livekit.DisconnectReason
	(ReconnectReason)(0),          // 9: livekit.ReconnectReason
	(SubscriptionError)(0),        // 10: livekit.SubscriptionError
	(ParticipantInfo_State)(0),    // 11: livekit.ParticipantInfo.State
	(ParticipantInfo_Kind)(0),     // 12: livekit.ParticipantInfo.Kind
	(Encryption_Type)(0),          // 13: livekit.Encryption.Type
	(DataPacket_Kind)(0),          // 14: livekit.DataPacket.Kind
	(ServerInfo_Edition)(0),       // 15: livekit.ServerInfo.Edition
	(ClientInfo_SDK)(0),           // 16: livekit.ClientInfo.SDK
	(*Room)(nil),                  // 17: livekit.Room
	(*Codec)(nil),                 // 18: livekit.Codec
	(*PlayoutDelay)(nil),          // 19: livekit.PlayoutDelay
	(*ParticipantPermission)(nil), // 20: livekit.ParticipantPermission
	(*ParticipantInfo)(nil),       // 21: livekit.ParticipantInfo
	(*Encryption)(nil),            // 22: livekit.Encryption
	(*SimulcastCodecInfo)(nil),    // 23: livekit.SimulcastCodecInfo
	(*TrackInfo)(nil),             // 24: livekit.TrackInfo
	(*VideoLayer)(nil),            // 25: livekit.VideoLayer
	(*DataPacket)(nil),            // 26: livekit.DataPacket
	(*ActiveSpeakerUpdate)(nil),   // 27: livekit.ActiveSpeakerUpdate
	(*SpeakerInfo)(nil),           // 28: livekit.SpeakerInfo
	(*UserPacket)(nil),            // 29: livekit.UserPacket
	(*ParticipantTracks)(nil),     // 30: livekit.ParticipantTracks
	(*ServerInfo)(nil),            // 31: livekit.ServerInfo
	(*ClientInfo)(nil),            // 32: livekit.ClientInfo
	(*ClientConfiguration)(nil),   // 33: livekit.ClientConfiguration
	(*VideoConfiguration)(nil),    // 34: livekit.VideoConfiguration
	(*DisabledCodecs)(nil),        // 35: livekit.DisabledCodecs
	(*RTPDrift)(nil),              // 36: livekit.RTPDrift
	(*RTPStats)(nil),              // 37: livekit.RTPStats
	(*TimedVersion)(nil),          // 38: livekit.TimedVersion
	nil,                           // 39: livekit.RTPStats.GapHistogramEntry
	(*timestamppb.Timestamp)(nil), // 40: google.protobuf.Timestamp
}
var file_livekit_models_proto_depIdxs = []int32{
	18, // 0: livekit.Room.enabled_codecs:type_name -> livekit.Codec
	38, // 1: livekit.Room.version:type_name -> livekit.TimedVersion
	4,  // 2: livekit.ParticipantPermission.can_publish_sources:type_name -> livekit.TrackSource
	11, // 3: livekit.ParticipantInfo.state:type_name -> livekit.ParticipantInfo.State
	24, // 4: livekit.ParticipantInfo.tracks:type_name -> livekit.TrackInfo
	20, // 5: livekit.ParticipantInfo.permission:type_name -> livekit.ParticipantPermission
	12, // 6: livekit.ParticipantInfo.kind:type_name -> livekit.ParticipantInfo.Kind
	25, // 7: livekit.SimulcastCodecInfo.layers:type_name -> livekit.VideoLayer
	3,  // 8: livekit.TrackInfo.type:type_name -> livekit.TrackType
	4,  // 9: livekit.TrackInfo.source:type_name -> livekit.TrackSource
	25, // 10: livekit.TrackInfo.layers:type_name -> livekit.VideoLayer
	23, // 11: livekit.TrackInfo.codecs:type_name -> livekit.SimulcastCodecInfo
	13, // 12: livekit.TrackInfo.encryption:type_name -> livekit.Encryption.Type
	38, // 13: livekit.TrackInfo.version:type_name -> livekit.TimedVersion
	5,  // 14: livekit.VideoLayer.quality:type_name -> livekit.VideoQuality
	14, // 15: livekit.DataPacket.kind:type_name -> livekit.DataPacket.Kind
	29, // 16: livekit.DataPacket.user:type_name -> livekit.UserPacket
	27, // 17: livekit.DataPacket.speaker:type_name -> livekit.ActiveSpeakerUpdate
	28, // 18: livekit.ActiveSpeakerUpdate.speakers:type_name -> livekit.SpeakerInfo
	15, // 19: livekit.ServerInfo.edition:type_name -> livekit.ServerInfo.Edition
	16, // 20: livekit.ClientInfo.sdk:type_name -> livekit.ClientInfo.SDK
	34, // 21: livekit.ClientConfiguration.video:type_name -> livekit.VideoConfiguration
	34, // 22: livekit.ClientConfiguration.screen:type_name -> livekit.VideoConfiguration
	7,  // 23: livekit.ClientConfiguration.resume_connection:type_name -> livekit.ClientConfigSetting
	35, // 24: livekit.ClientConfiguration.disabled_codecs:type_name -> livekit.DisabledCodecs
	7,  // 25: livekit.ClientConfiguration.force_relay:type_name -> livekit.ClientConfigSetting
	7,  // 26: livekit.VideoConfiguration.hardware_encoder:type_name -> livekit.ClientConfigSetting
	18, // 27: livekit.DisabledCodecs.codecs:type_name -> livekit.Codec
	18, // 28: livekit.DisabledCodecs.publish:type_name -> livekit.Codec
	40, // 29: livekit.RTPDrift.start_time:type_name -> google.protobuf.Timestamp
	40, // 30: livekit.RTPDrift.end_time:type_name -> google.protobuf.Timestamp
	40, // 31: livekit.RTPStats.start_time:type_name -> google.protobuf.Timestamp
	40, // 32: livekit.RTPStats.end_time:type_name -> google.protobuf.Timestamp
	39, // 33: livekit.RTPStats.gap_histogram:type_name -> livekit.RTPStats.GapHistogramEntry
	40, // 34: livekit.RTPStats.last_pli:type_name -> google.protobuf.Timestamp
	40, // 35: livekit.RTPStats.last_fir:type_name -> google.protobuf.Timestamp
	40, // 36: livekit.RTPStats.last_key_frame:type_name -> google.protobuf.Timestamp
	40, // 37: livekit.RTPStats.last_layer_lock_pli:type_name -> google.protobuf.Timestamp
	36, // 38: livekit.RTPStats.packet_drift:type_name -> livekit.RTPDrift
	36, // 39: livekit.RTPStats.report_drift:type_name -> livekit.RTPDrift
	40, // [40:40] is the sub-list for method output_type
	40, // [40:40] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_livekit_models_proto_init() }
func file_livekit_models_proto_init() {
	if File_livekit_models_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_livekit_models_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Room); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Codec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlayoutDelay); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParticipantPermission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParticipantInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Encryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SimulcastCodecInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrackInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoLayer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataPacket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActiveSpeakerUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeakerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserPacket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParticipantTracks); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisabledCodecs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RTPDrift); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RTPStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_models_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimedVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_livekit_models_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*DataPacket_User)(nil),
		(*DataPacket_Speaker)(nil),
	}
	file_livekit_models_proto_msgTypes[12].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_livekit_models_proto_rawDesc,
			NumEnums:      17,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_livekit_models_proto_goTypes,
		DependencyIndexes: file_livekit_models_proto_depIdxs,
		EnumInfos:         file_livekit_models_proto_enumTypes,
		MessageInfos:      file_livekit_models_proto_msgTypes,
	}.Build()
	File_livekit_models_proto = out.File
	file_livekit_models_proto_rawDesc = nil
	file_livekit_models_proto_goTypes = nil
	file_livekit_models_proto_depIdxs = nil
}
