// Code generated by protoc-gen-twirp v8.1.3, DO NOT EDIT.
// source: livekit_ingress.proto

package livekit

import context "context"
import fmt "fmt"
import http "net/http"
import io "io"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Version compatibility assertion.
// If the constant is not defined in the package, that likely means
// the package needs to be updated to work with this generated code.
// See https://twitchtv.github.io/twirp/docs/version_matrix.html
const _ = twirp.TwirpPackageMinVersion_8_1_0

// =================
// Ingress Interface
// =================

type Ingress interface {
	// Create a new Ingress
	CreateIngress(context.Context, *CreateIngressRequest) (*IngressInfo, error)

	// Update an existing Ingress. Ingress can only be updated when it's in ENDPOINT_WAITING state.
	UpdateIngress(context.Context, *UpdateIngressRequest) (*IngressInfo, error)

	ListIngress(context.Context, *ListIngressRequest) (*ListIngressResponse, error)

	DeleteIngress(context.Context, *DeleteIngressRequest) (*IngressInfo, error)
}

// =======================
// Ingress Protobuf Client
// =======================

type ingressProtobufClient struct {
	client      HTTPClient
	urls        [4]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewIngressProtobufClient creates a Protobuf client that implements the Ingress interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewIngressProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Ingress {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "livekit", "Ingress")
	urls := [4]string{
		serviceURL + "CreateIngress",
		serviceURL + "UpdateIngress",
		serviceURL + "ListIngress",
		serviceURL + "DeleteIngress",
	}

	return &ingressProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *ingressProtobufClient) CreateIngress(ctx context.Context, in *CreateIngressRequest) (*IngressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithMethodName(ctx, "CreateIngress")
	caller := c.callCreateIngress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateIngressRequest) (*IngressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateIngressRequest) when calling interceptor")
					}
					return c.callCreateIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *ingressProtobufClient) callCreateIngress(ctx context.Context, in *CreateIngressRequest) (*IngressInfo, error) {
	out := new(IngressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *ingressProtobufClient) UpdateIngress(ctx context.Context, in *UpdateIngressRequest) (*IngressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateIngress")
	caller := c.callUpdateIngress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateIngressRequest) (*IngressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateIngressRequest) when calling interceptor")
					}
					return c.callUpdateIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *ingressProtobufClient) callUpdateIngress(ctx context.Context, in *UpdateIngressRequest) (*IngressInfo, error) {
	out := new(IngressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *ingressProtobufClient) ListIngress(ctx context.Context, in *ListIngressRequest) (*ListIngressResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithMethodName(ctx, "ListIngress")
	caller := c.callListIngress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListIngressRequest) (*ListIngressResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListIngressRequest) when calling interceptor")
					}
					return c.callListIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListIngressResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListIngressResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *ingressProtobufClient) callListIngress(ctx context.Context, in *ListIngressRequest) (*ListIngressResponse, error) {
	out := new(ListIngressResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *ingressProtobufClient) DeleteIngress(ctx context.Context, in *DeleteIngressRequest) (*IngressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIngress")
	caller := c.callDeleteIngress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteIngressRequest) (*IngressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteIngressRequest) when calling interceptor")
					}
					return c.callDeleteIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *ingressProtobufClient) callDeleteIngress(ctx context.Context, in *DeleteIngressRequest) (*IngressInfo, error) {
	out := new(IngressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================
// Ingress JSON Client
// ===================

type ingressJSONClient struct {
	client      HTTPClient
	urls        [4]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewIngressJSONClient creates a JSON client that implements the Ingress interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewIngressJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Ingress {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "livekit", "Ingress")
	urls := [4]string{
		serviceURL + "CreateIngress",
		serviceURL + "UpdateIngress",
		serviceURL + "ListIngress",
		serviceURL + "DeleteIngress",
	}

	return &ingressJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *ingressJSONClient) CreateIngress(ctx context.Context, in *CreateIngressRequest) (*IngressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithMethodName(ctx, "CreateIngress")
	caller := c.callCreateIngress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateIngressRequest) (*IngressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateIngressRequest) when calling interceptor")
					}
					return c.callCreateIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *ingressJSONClient) callCreateIngress(ctx context.Context, in *CreateIngressRequest) (*IngressInfo, error) {
	out := new(IngressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *ingressJSONClient) UpdateIngress(ctx context.Context, in *UpdateIngressRequest) (*IngressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateIngress")
	caller := c.callUpdateIngress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateIngressRequest) (*IngressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateIngressRequest) when calling interceptor")
					}
					return c.callUpdateIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *ingressJSONClient) callUpdateIngress(ctx context.Context, in *UpdateIngressRequest) (*IngressInfo, error) {
	out := new(IngressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *ingressJSONClient) ListIngress(ctx context.Context, in *ListIngressRequest) (*ListIngressResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithMethodName(ctx, "ListIngress")
	caller := c.callListIngress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListIngressRequest) (*ListIngressResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListIngressRequest) when calling interceptor")
					}
					return c.callListIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListIngressResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListIngressResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *ingressJSONClient) callListIngress(ctx context.Context, in *ListIngressRequest) (*ListIngressResponse, error) {
	out := new(ListIngressResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *ingressJSONClient) DeleteIngress(ctx context.Context, in *DeleteIngressRequest) (*IngressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIngress")
	caller := c.callDeleteIngress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteIngressRequest) (*IngressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteIngressRequest) when calling interceptor")
					}
					return c.callDeleteIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *ingressJSONClient) callDeleteIngress(ctx context.Context, in *DeleteIngressRequest) (*IngressInfo, error) {
	out := new(IngressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================
// Ingress Server Handler
// ======================

type ingressServer struct {
	Ingress
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
	jsonCamelCase    bool   // JSON fields are serialized as lowerCamelCase rather than keeping the original proto names
}

// NewIngressServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewIngressServer(svc Ingress, opts ...interface{}) TwirpServer {
	serverOpts := newServerOpts(opts)

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	jsonSkipDefaults := false
	_ = serverOpts.ReadOpt("jsonSkipDefaults", &jsonSkipDefaults)
	jsonCamelCase := false
	_ = serverOpts.ReadOpt("jsonCamelCase", &jsonCamelCase)
	var pathPrefix string
	if ok := serverOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	return &ingressServer{
		Ingress:          svc,
		hooks:            serverOpts.Hooks,
		interceptor:      twirp.ChainInterceptors(serverOpts.Interceptors...),
		pathPrefix:       pathPrefix,
		jsonSkipDefaults: jsonSkipDefaults,
		jsonCamelCase:    jsonCamelCase,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *ingressServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *ingressServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// IngressPathPrefix is a convenience constant that may identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// with the default "/twirp" prefix and default CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const IngressPathPrefix = "/twirp/livekit.Ingress/"

func (s *ingressServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Ingress")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "livekit.Ingress" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "CreateIngress":
		s.serveCreateIngress(ctx, resp, req)
		return
	case "UpdateIngress":
		s.serveUpdateIngress(ctx, resp, req)
		return
	case "ListIngress":
		s.serveListIngress(ctx, resp, req)
		return
	case "DeleteIngress":
		s.serveDeleteIngress(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *ingressServer) serveCreateIngress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateIngressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateIngressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *ingressServer) serveCreateIngressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateIngress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CreateIngressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Ingress.CreateIngress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateIngressRequest) (*IngressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateIngressRequest) when calling interceptor")
					}
					return s.Ingress.CreateIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *IngressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IngressInfo and nil error while calling CreateIngress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *ingressServer) serveCreateIngressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateIngress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CreateIngressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Ingress.CreateIngress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateIngressRequest) (*IngressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateIngressRequest) when calling interceptor")
					}
					return s.Ingress.CreateIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *IngressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IngressInfo and nil error while calling CreateIngress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *ingressServer) serveUpdateIngress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateIngressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateIngressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *ingressServer) serveUpdateIngressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateIngress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(UpdateIngressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Ingress.UpdateIngress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateIngressRequest) (*IngressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateIngressRequest) when calling interceptor")
					}
					return s.Ingress.UpdateIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *IngressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IngressInfo and nil error while calling UpdateIngress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *ingressServer) serveUpdateIngressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateIngress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(UpdateIngressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Ingress.UpdateIngress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateIngressRequest) (*IngressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateIngressRequest) when calling interceptor")
					}
					return s.Ingress.UpdateIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *IngressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IngressInfo and nil error while calling UpdateIngress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *ingressServer) serveListIngress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListIngressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListIngressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *ingressServer) serveListIngressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListIngress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListIngressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Ingress.ListIngress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListIngressRequest) (*ListIngressResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListIngressRequest) when calling interceptor")
					}
					return s.Ingress.ListIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListIngressResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListIngressResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListIngressResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListIngressResponse and nil error while calling ListIngress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *ingressServer) serveListIngressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListIngress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListIngressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Ingress.ListIngress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListIngressRequest) (*ListIngressResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListIngressRequest) when calling interceptor")
					}
					return s.Ingress.ListIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListIngressResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListIngressResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListIngressResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListIngressResponse and nil error while calling ListIngress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *ingressServer) serveDeleteIngress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteIngressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteIngressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *ingressServer) serveDeleteIngressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIngress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(DeleteIngressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Ingress.DeleteIngress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteIngressRequest) (*IngressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteIngressRequest) when calling interceptor")
					}
					return s.Ingress.DeleteIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *IngressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IngressInfo and nil error while calling DeleteIngress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *ingressServer) serveDeleteIngressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIngress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(DeleteIngressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Ingress.DeleteIngress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteIngressRequest) (*IngressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteIngressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteIngressRequest) when calling interceptor")
					}
					return s.Ingress.DeleteIngress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*IngressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*IngressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *IngressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IngressInfo and nil error while calling DeleteIngress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *ingressServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *ingressServer) ProtocGenTwirpVersion() string {
	return "v8.1.3"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *ingressServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "livekit", "Ingress")
}

var twirpFileDescriptor1 = []byte{
	// 1401 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcf, 0x6e, 0xdb, 0xc6,
	0x13, 0x36, 0x25, 0xeb, 0xdf, 0x28, 0x92, 0x95, 0x95, 0x9c, 0x30, 0xfe, 0x83, 0x9f, 0xa1, 0xe4,
	0x87, 0x38, 0x4e, 0xab, 0x38, 0x8a, 0x93, 0xb6, 0x01, 0x02, 0xd4, 0xb2, 0xe5, 0x88, 0xb0, 0x2c,
	0x09, 0x2b, 0x39, 0x45, 0x7b, 0x59, 0xd0, 0xe2, 0xc6, 0x26, 0x22, 0x89, 0x2c, 0xb9, 0x72, 0x23,
	0xf4, 0xda, 0x43, 0x1f, 0xa0, 0xf7, 0x1e, 0x8a, 0x5e, 0x72, 0x2f, 0xfa, 0x28, 0x7d, 0x87, 0xa2,
	0x0f, 0x51, 0xec, 0x72, 0x45, 0x93, 0x12, 0x15, 0x24, 0x6d, 0x91, 0xf6, 0xc6, 0x99, 0xef, 0x9b,
	0xe1, 0xec, 0xcc, 0xec, 0x67, 0xca, 0xb0, 0x3a, 0x30, 0x2f, 0xe9, 0x2b, 0x93, 0x11, 0x73, 0x74,
	0xee, 0x50, 0xd7, 0xad, 0xd8, 0x8e, 0xc5, 0x2c, 0x94, 0x92, 0xee, 0xb5, 0xd2, 0x14, 0x1f, 0x5a,
	0x06, 0x1d, 0x48, 0xb8, 0xfc, 0x6b, 0x1c, 0x4a, 0x07, 0x0e, 0xd5, 0x19, 0xd5, 0xbc, 0x30, 0x4c,
	0xbf, 0x1e, 0x53, 0x97, 0xa1, 0x3d, 0x00, 0x73, 0x64, 0x8f, 0x19, 0x61, 0x13, 0x9b, 0xaa, 0xca,
	0x96, 0xb2, 0x9d, 0xaf, 0xae, 0x56, 0x64, 0x8e, 0x8a, 0x24, 0x6b, 0x9c, 0x81, 0x33, 0x82, 0xd8,
	0x9b, 0xd8, 0x14, 0x15, 0x20, 0x3e, 0x76, 0x06, 0x6a, 0x66, 0x4b, 0xd9, 0xce, 0x60, 0xfe, 0x88,
	0x10, 0x2c, 0x8f, 0xf4, 0x21, 0x55, 0x63, 0xc2, 0x25, 0x9e, 0xd1, 0x3a, 0x64, 0x1c, 0xcb, 0x1a,
	0x12, 0x01, 0xc4, 0x05, 0x90, 0xe6, 0x8e, 0x16, 0x07, 0x1f, 0x42, 0xc9, 0xd6, 0x1d, 0x66, 0xf6,
	0x4d, 0x5b, 0x1f, 0x31, 0x62, 0x1a, 0x74, 0xc4, 0x4c, 0x36, 0x51, 0x97, 0x05, 0xaf, 0x18, 0xc0,
	0x34, 0x09, 0xa1, 0x7b, 0x50, 0x08, 0x86, 0x88, 0xb4, 0x09, 0x41, 0x5f, 0x09, 0xf8, 0xa3, 0xb2,
	0x0f, 0x29, 0xd3, 0x0d, 0x9d, 0xe9, 0x2a, 0xcc, 0x65, 0x3f, 0x91, 0x10, 0xfa, 0x18, 0xd0, 0xd9,
	0xc4, 0xd6, 0x5d, 0x97, 0x30, 0x47, 0x1f, 0xb9, 0x7d, 0xcb, 0x30, 0x47, 0xe7, 0x6a, 0x7a, 0x4b,
	0xd9, 0x4e, 0xe3, 0xeb, 0x1e, 0xd2, 0xbb, 0x02, 0x50, 0x15, 0x12, 0xfa, 0xd8, 0x30, 0x2d, 0x35,
	0xb9, 0xa5, 0x6c, 0x67, 0xab, 0x1b, 0xb3, 0x3d, 0xdb, 0xe7, 0x60, 0xdb, 0x66, 0xa6, 0x35, 0x72,
	0xb1, 0x47, 0xe5, 0x31, 0x97, 0xa6, 0x41, 0x2d, 0x35, 0x15, 0x1d, 0xf3, 0x82, 0x83, 0x7e, 0x8c,
	0xa0, 0x96, 0xff, 0x50, 0xa0, 0x18, 0x91, 0xd2, 0x6f, 0xb8, 0x12, 0x68, 0xf8, 0x47, 0x90, 0x74,
	0xad, 0xb1, 0xd3, 0xf7, 0xc6, 0x90, 0xaf, 0x96, 0xfc, 0x17, 0xf4, 0x1c, 0xbd, 0xff, 0xaa, 0x2b,
	0x30, 0x2c, 0x39, 0xe8, 0x19, 0x24, 0x6d, 0x87, 0xba, 0x94, 0x89, 0xd9, 0xe4, 0xab, 0xb7, 0x23,
	0x8f, 0x50, 0x1f, 0x79, 0x07, 0xee, 0x08, 0x6a, 0x63, 0x09, 0xcb, 0x20, 0xf4, 0x39, 0xa4, 0x2c,
	0xaf, 0x16, 0x31, 0xb3, 0x6c, 0xf5, 0xce, 0x5b, 0xe3, 0x65, 0xdd, 0x8d, 0x25, 0x3c, 0x0d, 0xab,
	0x21, 0x28, 0x50, 0x89, 0x12, 0xe9, 0x0b, 0x1e, 0x37, 0xd8, 0x8d, 0x0f, 0x71, 0x5c, 0xf1, 0xbe,
	0xbf, 0x71, 0xdc, 0x50, 0xfc, 0x3b, 0x1e, 0xf7, 0x8d, 0x02, 0xeb, 0x6f, 0xe9, 0x16, 0xda, 0x83,
	0xac, 0x58, 0x1d, 0xd2, 0xb7, 0x0c, 0xda, 0x97, 0xf7, 0xb3, 0xe8, 0xbf, 0x59, 0xc4, 0x1c, 0x70,
	0x08, 0x83, 0xee, 0x3f, 0x23, 0x15, 0x52, 0x67, 0x26, 0x73, 0x74, 0xe6, 0x75, 0x26, 0x87, 0xa7,
	0x26, 0xfa, 0x1f, 0x64, 0x0d, 0xd3, 0xd5, 0xcf, 0x06, 0x94, 0x18, 0xec, 0xb5, 0xe8, 0x44, 0x1a,
	0x83, 0x74, 0x1d, 0xb2, 0xd7, 0x68, 0x0d, 0xd2, 0xfd, 0x0b, 0x7d, 0x34, 0xa2, 0x03, 0xef, 0x9c,
	0x39, 0xec, 0xdb, 0xe5, 0x1f, 0xaf, 0x8a, 0x8d, 0x3a, 0x2b, 0x2f, 0x56, 0xec, 0xec, 0x82, 0x62,
	0x45, 0x8c, 0x2c, 0xf6, 0xd2, 0x7f, 0x46, 0x9b, 0x00, 0x2f, 0x1d, 0x7d, 0x48, 0x89, 0x5f, 0xaf,
	0x82, 0x33, 0xc2, 0x83, 0x79, 0xc5, 0xf7, 0x21, 0x39, 0xd0, 0x27, 0xd4, 0x71, 0xd5, 0xf8, 0x56,
	0x7c, 0x3b, 0x3b, 0x9b, 0xaf, 0xc9, 0x31, 0x2c, 0x29, 0xe5, 0x5f, 0x96, 0x21, 0xeb, 0x6b, 0xd6,
	0x4b, 0x8b, 0xe7, 0x96, 0x32, 0x49, 0x4c, 0x43, 0xee, 0x4e, 0x46, 0x7a, 0x34, 0x23, 0x52, 0xb4,
	0x36, 0x01, 0x5c, 0xe6, 0x50, 0x7d, 0x48, 0x5e, 0xd1, 0x89, 0x54, 0xad, 0x8c, 0xe7, 0x39, 0xa6,
	0x93, 0xa9, 0xf2, 0x2d, 0x5f, 0x29, 0x5f, 0x58, 0x41, 0x13, 0xef, 0xa8, 0xa0, 0xd1, 0x6a, 0x93,
	0xfb, 0x97, 0xd5, 0x26, 0x2c, 0xd9, 0xe9, 0x77, 0x94, 0xec, 0xcc, 0xfb, 0x49, 0x36, 0xbc, 0x9f,
	0x64, 0xe7, 0x17, 0x4b, 0xf6, 0x1a, 0xa4, 0x1d, 0x3a, 0x16, 0xbb, 0xab, 0x66, 0x45, 0xeb, 0x7c,
	0x1b, 0xdd, 0x87, 0x84, 0xcb, 0xf8, 0x46, 0x5d, 0x13, 0xa7, 0x9f, 0x9b, 0x48, 0x97, 0x83, 0xd8,
	0xe3, 0x94, 0x7f, 0x8b, 0xc3, 0xb5, 0xa0, 0x1f, 0xed, 0x41, 0x92, 0x23, 0x63, 0x57, 0x6e, 0xf1,
	0x46, 0x64, 0x78, 0xa5, 0x2b, 0x38, 0x58, 0x72, 0x51, 0x09, 0x12, 0xd4, 0x71, 0x2c, 0x47, 0x2e,
	0x94, 0x67, 0xa0, 0xca, 0x74, 0x0e, 0x71, 0x51, 0x89, 0x1a, 0x48, 0x65, 0x8f, 0x99, 0x98, 0x82,
	0x2c, 0xc6, 0x9b, 0x41, 0x65, 0x3a, 0xeb, 0xe5, 0x28, 0xbe, 0x98, 0xb4, 0xe4, 0x7b, 0x73, 0xbe,
	0x09, 0x29, 0x31, 0x33, 0xd3, 0x90, 0x7f, 0x0d, 0x93, 0xdc, 0xd4, 0x0c, 0x6f, 0x95, 0x75, 0x87,
	0x51, 0x83, 0xe8, 0x4c, 0x6c, 0x41, 0x9c, 0xaf, 0xb2, 0xf0, 0xec, 0x33, 0x74, 0x0b, 0xd2, 0x74,
	0x64, 0x78, 0x60, 0x5a, 0x80, 0x29, 0x61, 0xef, 0x33, 0x2e, 0x13, 0x0e, 0xf5, 0x74, 0x93, 0xa7,
	0xf5, 0x06, 0x0c, 0x53, 0x97, 0x66, 0xa0, 0x1d, 0x48, 0x32, 0xae, 0xb1, 0xae, 0x9a, 0x14, 0xb7,
	0x12, 0x85, 0xa5, 0x97, 0x5f, 0x3e, 0x2c, 0x19, 0xe5, 0x6f, 0x21, 0xe9, 0xf5, 0x09, 0xad, 0xc2,
	0xf5, 0x7a, 0xeb, 0xb0, 0xd3, 0xd6, 0x5a, 0x3d, 0xa2, 0xb5, 0xf6, 0x0f, 0x7a, 0xda, 0x8b, 0x7a,
	0x61, 0x09, 0xdd, 0x00, 0xe4, 0xbb, 0x6b, 0xa7, 0x47, 0x47, 0x75, 0xac, 0xb5, 0x9e, 0x17, 0x14,
	0x74, 0x13, 0x8a, 0xbe, 0xbf, 0x73, 0x5a, 0x6b, 0x6a, 0xdd, 0x06, 0x07, 0x62, 0x08, 0x41, 0xde,
	0x07, 0xea, 0x18, 0xb7, 0x71, 0x21, 0x1e, 0xca, 0x7d, 0xd0, 0x3e, 0xe9, 0x34, 0xeb, 0xbd, 0x7a,
	0x61, 0xb9, 0xfc, 0x93, 0x02, 0x2b, 0x33, 0x7d, 0xe6, 0x4b, 0x3e, 0x34, 0x87, 0xf4, 0xea, 0x93,
	0x27, 0x83, 0xd3, 0xdc, 0x21, 0x2e, 0xe6, 0x5d, 0x58, 0xd1, 0x2f, 0xa9, 0xa3, 0x9f, 0x53, 0x12,
	0xd6, 0xd0, 0xbc, 0x74, 0xd7, 0xa4, 0x94, 0x96, 0x20, 0xf1, 0x8d, 0x69, 0xb0, 0x0b, 0x31, 0xd6,
	0x1c, 0xf6, 0x0c, 0x74, 0x03, 0x92, 0x17, 0xd4, 0x3c, 0xbf, 0x60, 0x52, 0x3d, 0xa5, 0x85, 0x36,
	0xc0, 0xd3, 0x34, 0x91, 0x30, 0x11, 0x10, 0x39, 0xee, 0x28, 0xff, 0x30, 0xad, 0xf2, 0x6a, 0xba,
	0xff, 0x50, 0x95, 0x41, 0x3d, 0x8f, 0x87, 0xf5, 0x9c, 0x4f, 0xd9, 0xd5, 0x87, 0xf6, 0x40, 0x4a,
	0xaf, 0x57, 0x30, 0x78, 0x2e, 0xae, 0xbd, 0xe5, 0x37, 0x71, 0x28, 0x9d, 0xda, 0xc6, 0xfc, 0x57,
	0xe3, 0x5f, 0xd0, 0xd5, 0xff, 0xe0, 0xc7, 0x60, 0x66, 0xb1, 0xb2, 0x54, 0x17, 0x7f, 0x0c, 0x36,
	0x96, 0x22, 0x04, 0xfa, 0x7b, 0x45, 0xf9, 0x50, 0x1a, 0x5d, 0x5b, 0x85, 0x22, 0x99, 0x2f, 0xae,
	0xdc, 0x01, 0xd4, 0x34, 0x5d, 0x36, 0x33, 0xa9, 0x50, 0xdb, 0x95, 0x99, 0xb6, 0x87, 0xc7, 0x18,
	0x9b, 0x19, 0x63, 0x79, 0x1f, 0x8a, 0xa1, 0x8c, 0xae, 0x6d, 0x8d, 0x5c, 0x8a, 0x76, 0x20, 0x61,
	0x32, 0x3a, 0xe4, 0xd2, 0xc8, 0xaf, 0x7e, 0x69, 0xfe, 0x6f, 0xdd, 0x4b, 0x0b, 0x7b, 0x94, 0xf2,
	0x63, 0x28, 0x1d, 0xd2, 0x01, 0x7d, 0xcf, 0x05, 0xda, 0x79, 0xe6, 0xcb, 0xb1, 0xb8, 0x15, 0x28,
	0x0f, 0x80, 0x7b, 0x27, 0x1d, 0xa2, 0xb5, 0x3a, 0xa7, 0xbd, 0xc2, 0x12, 0xb7, 0xbf, 0x68, 0x68,
	0x53, 0x5b, 0x41, 0x39, 0xc8, 0x9c, 0xe2, 0xa6, 0x34, 0x63, 0x3b, 0x1a, 0xac, 0x2d, 0xfe, 0x84,
	0xe5, 0x72, 0xd3, 0xee, 0x9c, 0x76, 0x49, 0xb7, 0x57, 0xc7, 0xf5, 0x36, 0xf9, 0xec, 0xc9, 0x71,
	0xad, 0xd3, 0x2d, 0x2c, 0xa1, 0x22, 0xac, 0x08, 0xff, 0x49, 0xbb, 0xd5, 0x26, 0x4f, 0xf6, 0x8e,
	0x6b, 0xdd, 0x82, 0xb2, 0xf3, 0x5d, 0xdc, 0xcf, 0x15, 0xf1, 0x7d, 0x88, 0x36, 0x40, 0x6d, 0x54,
	0x9f, 0xec, 0x91, 0x4f, 0xaa, 0xbb, 0x1d, 0xf2, 0x68, 0xf7, 0xa8, 0xd3, 0x25, 0x8f, 0x48, 0x73,
	0xff, 0xcb, 0x3a, 0xe6, 0x19, 0x37, 0xe1, 0x96, 0x40, 0x1f, 0xee, 0x7e, 0x3a, 0x0f, 0x2b, 0x7e,
	0xf0, 0xe3, 0xbd, 0xdd, 0x0e, 0xa9, 0x3e, 0xe6, 0x68, 0x75, 0x8a, 0xc6, 0xd0, 0x3a, 0xdc, 0x9c,
	0x4d, 0xfd, 0xd0, 0x43, 0x0b, 0x71, 0x3f, 0x34, 0x98, 0x79, 0x8a, 0x2e, 0xa3, 0x6d, 0xb8, 0xb3,
	0xa8, 0x2a, 0xd2, 0xd0, 0x9e, 0x37, 0xc8, 0x49, 0xbb, 0xa7, 0xb5, 0x5b, 0x85, 0x04, 0xba, 0x07,
	0xff, 0x5f, 0x58, 0x61, 0x88, 0x9a, 0xf4, 0x93, 0x46, 0x54, 0x1b, 0x62, 0xa6, 0xd0, 0x5d, 0xb8,
	0xbd, 0xa0, 0xf2, 0x10, 0x31, 0xed, 0xa7, 0x8c, 0x38, 0x45, 0x88, 0x99, 0xa9, 0xfe, 0x1c, 0x83,
	0x94, 0x1c, 0x03, 0x3a, 0x84, 0x5c, 0xe8, 0xa7, 0x2c, 0xda, 0xf4, 0x37, 0x30, 0xea, 0x27, 0xee,
	0x5a, 0xe4, 0x82, 0xf2, 0x2c, 0x21, 0x69, 0x0b, 0x64, 0x89, 0x92, 0xbc, 0x05, 0x59, 0x1a, 0x90,
	0x0d, 0x5c, 0x11, 0xb4, 0xee, 0x93, 0xe6, 0xaf, 0xe2, 0xda, 0x46, 0x34, 0x28, 0x6f, 0xd5, 0x21,
	0xe4, 0x42, 0x37, 0x25, 0x50, 0x4f, 0xd4, 0x0d, 0x8a, 0xae, 0xa7, 0x76, 0xf4, 0xd5, 0xed, 0x73,
	0x93, 0x5d, 0x8c, 0xcf, 0x2a, 0x7d, 0x6b, 0xf8, 0x40, 0x32, 0x1e, 0x88, 0xff, 0x01, 0xf4, 0xad,
	0xc1, 0xd4, 0xf1, 0x26, 0x96, 0x6b, 0x9a, 0x97, 0xf4, 0xd8, 0x64, 0x95, 0x0e, 0x87, 0x7e, 0x8f,
	0xe5, 0xa5, 0xfd, 0xf4, 0xa9, 0x70, 0x9c, 0x25, 0x45, 0xc8, 0xa3, 0x3f, 0x03, 0x00, 0x00, 0xff,
	0xff, 0x09, 0x1d, 0x1d, 0x75, 0x6e, 0x10, 0x00, 0x00,
}
