// Code generated by protoc-gen-twirp v8.1.3, DO NOT EDIT.
// source: livekit_egress.proto

package livekit

import context "context"
import fmt "fmt"
import http "net/http"
import io "io"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import bytes "bytes"
import errors "errors"
import path "path"
import url "net/url"

// Version compatibility assertion.
// If the constant is not defined in the package, that likely means
// the package needs to be updated to work with this generated code.
// See https://twitchtv.github.io/twirp/docs/version_matrix.html
const _ = twirp.TwirpPackageMinVersion_8_1_0

// ================
// Egress Interface
// ================

type Egress interface {
	// start recording or streaming a room, participant, or tracks
	StartRoomCompositeEgress(context.Context, *RoomCompositeEgressRequest) (*EgressInfo, error)

	StartWebEgress(context.Context, *WebEgressRequest) (*EgressInfo, error)

	StartParticipantEgress(context.Context, *ParticipantEgressRequest) (*EgressInfo, error)

	StartTrackCompositeEgress(context.Context, *TrackCompositeEgressRequest) (*EgressInfo, error)

	StartTrackEgress(context.Context, *TrackEgressRequest) (*EgressInfo, error)

	// update web composite layout
	UpdateLayout(context.Context, *UpdateLayoutRequest) (*EgressInfo, error)

	// add or remove stream endpoints
	UpdateStream(context.Context, *UpdateStreamRequest) (*EgressInfo, error)

	// list available egress
	ListEgress(context.Context, *ListEgressRequest) (*ListEgressResponse, error)

	// stop a recording or stream
	StopEgress(context.Context, *StopEgressRequest) (*EgressInfo, error)
}

// ======================
// Egress Protobuf Client
// ======================

type egressProtobufClient struct {
	client      HTTPClient
	urls        [9]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewEgressProtobufClient creates a Protobuf client that implements the Egress interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewEgressProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Egress {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "livekit", "Egress")
	urls := [9]string{
		serviceURL + "StartRoomCompositeEgress",
		serviceURL + "StartWebEgress",
		serviceURL + "StartParticipantEgress",
		serviceURL + "StartTrackCompositeEgress",
		serviceURL + "StartTrackEgress",
		serviceURL + "UpdateLayout",
		serviceURL + "UpdateStream",
		serviceURL + "ListEgress",
		serviceURL + "StopEgress",
	}

	return &egressProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *egressProtobufClient) StartRoomCompositeEgress(ctx context.Context, in *RoomCompositeEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartRoomCompositeEgress")
	caller := c.callStartRoomCompositeEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RoomCompositeEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RoomCompositeEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RoomCompositeEgressRequest) when calling interceptor")
					}
					return c.callStartRoomCompositeEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callStartRoomCompositeEgress(ctx context.Context, in *RoomCompositeEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressProtobufClient) StartWebEgress(ctx context.Context, in *WebEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartWebEgress")
	caller := c.callStartWebEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *WebEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*WebEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*WebEgressRequest) when calling interceptor")
					}
					return c.callStartWebEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callStartWebEgress(ctx context.Context, in *WebEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressProtobufClient) StartParticipantEgress(ctx context.Context, in *ParticipantEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartParticipantEgress")
	caller := c.callStartParticipantEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ParticipantEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ParticipantEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ParticipantEgressRequest) when calling interceptor")
					}
					return c.callStartParticipantEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callStartParticipantEgress(ctx context.Context, in *ParticipantEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressProtobufClient) StartTrackCompositeEgress(ctx context.Context, in *TrackCompositeEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartTrackCompositeEgress")
	caller := c.callStartTrackCompositeEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *TrackCompositeEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*TrackCompositeEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*TrackCompositeEgressRequest) when calling interceptor")
					}
					return c.callStartTrackCompositeEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callStartTrackCompositeEgress(ctx context.Context, in *TrackCompositeEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressProtobufClient) StartTrackEgress(ctx context.Context, in *TrackEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartTrackEgress")
	caller := c.callStartTrackEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *TrackEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*TrackEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*TrackEgressRequest) when calling interceptor")
					}
					return c.callStartTrackEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callStartTrackEgress(ctx context.Context, in *TrackEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressProtobufClient) UpdateLayout(ctx context.Context, in *UpdateLayoutRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLayout")
	caller := c.callUpdateLayout
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateLayoutRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateLayoutRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateLayoutRequest) when calling interceptor")
					}
					return c.callUpdateLayout(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callUpdateLayout(ctx context.Context, in *UpdateLayoutRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressProtobufClient) UpdateStream(ctx context.Context, in *UpdateStreamRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStream")
	caller := c.callUpdateStream
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateStreamRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateStreamRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateStreamRequest) when calling interceptor")
					}
					return c.callUpdateStream(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callUpdateStream(ctx context.Context, in *UpdateStreamRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressProtobufClient) ListEgress(ctx context.Context, in *ListEgressRequest) (*ListEgressResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "ListEgress")
	caller := c.callListEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListEgressRequest) (*ListEgressResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListEgressRequest) when calling interceptor")
					}
					return c.callListEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListEgressResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListEgressResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callListEgress(ctx context.Context, in *ListEgressRequest) (*ListEgressResponse, error) {
	out := new(ListEgressResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressProtobufClient) StopEgress(ctx context.Context, in *StopEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StopEgress")
	caller := c.callStopEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *StopEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*StopEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*StopEgressRequest) when calling interceptor")
					}
					return c.callStopEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressProtobufClient) callStopEgress(ctx context.Context, in *StopEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==================
// Egress JSON Client
// ==================

type egressJSONClient struct {
	client      HTTPClient
	urls        [9]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewEgressJSONClient creates a JSON client that implements the Egress interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewEgressJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Egress {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "livekit", "Egress")
	urls := [9]string{
		serviceURL + "StartRoomCompositeEgress",
		serviceURL + "StartWebEgress",
		serviceURL + "StartParticipantEgress",
		serviceURL + "StartTrackCompositeEgress",
		serviceURL + "StartTrackEgress",
		serviceURL + "UpdateLayout",
		serviceURL + "UpdateStream",
		serviceURL + "ListEgress",
		serviceURL + "StopEgress",
	}

	return &egressJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *egressJSONClient) StartRoomCompositeEgress(ctx context.Context, in *RoomCompositeEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartRoomCompositeEgress")
	caller := c.callStartRoomCompositeEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RoomCompositeEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RoomCompositeEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RoomCompositeEgressRequest) when calling interceptor")
					}
					return c.callStartRoomCompositeEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callStartRoomCompositeEgress(ctx context.Context, in *RoomCompositeEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressJSONClient) StartWebEgress(ctx context.Context, in *WebEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartWebEgress")
	caller := c.callStartWebEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *WebEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*WebEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*WebEgressRequest) when calling interceptor")
					}
					return c.callStartWebEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callStartWebEgress(ctx context.Context, in *WebEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressJSONClient) StartParticipantEgress(ctx context.Context, in *ParticipantEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartParticipantEgress")
	caller := c.callStartParticipantEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ParticipantEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ParticipantEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ParticipantEgressRequest) when calling interceptor")
					}
					return c.callStartParticipantEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callStartParticipantEgress(ctx context.Context, in *ParticipantEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressJSONClient) StartTrackCompositeEgress(ctx context.Context, in *TrackCompositeEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartTrackCompositeEgress")
	caller := c.callStartTrackCompositeEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *TrackCompositeEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*TrackCompositeEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*TrackCompositeEgressRequest) when calling interceptor")
					}
					return c.callStartTrackCompositeEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callStartTrackCompositeEgress(ctx context.Context, in *TrackCompositeEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressJSONClient) StartTrackEgress(ctx context.Context, in *TrackEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StartTrackEgress")
	caller := c.callStartTrackEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *TrackEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*TrackEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*TrackEgressRequest) when calling interceptor")
					}
					return c.callStartTrackEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callStartTrackEgress(ctx context.Context, in *TrackEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressJSONClient) UpdateLayout(ctx context.Context, in *UpdateLayoutRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLayout")
	caller := c.callUpdateLayout
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateLayoutRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateLayoutRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateLayoutRequest) when calling interceptor")
					}
					return c.callUpdateLayout(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callUpdateLayout(ctx context.Context, in *UpdateLayoutRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressJSONClient) UpdateStream(ctx context.Context, in *UpdateStreamRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStream")
	caller := c.callUpdateStream
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateStreamRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateStreamRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateStreamRequest) when calling interceptor")
					}
					return c.callUpdateStream(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callUpdateStream(ctx context.Context, in *UpdateStreamRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressJSONClient) ListEgress(ctx context.Context, in *ListEgressRequest) (*ListEgressResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "ListEgress")
	caller := c.callListEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListEgressRequest) (*ListEgressResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListEgressRequest) when calling interceptor")
					}
					return c.callListEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListEgressResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListEgressResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callListEgress(ctx context.Context, in *ListEgressRequest) (*ListEgressResponse, error) {
	out := new(ListEgressResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *egressJSONClient) StopEgress(ctx context.Context, in *StopEgressRequest) (*EgressInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithMethodName(ctx, "StopEgress")
	caller := c.callStopEgress
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *StopEgressRequest) (*EgressInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*StopEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*StopEgressRequest) when calling interceptor")
					}
					return c.callStopEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *egressJSONClient) callStopEgress(ctx context.Context, in *StopEgressRequest) (*EgressInfo, error) {
	out := new(EgressInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =====================
// Egress Server Handler
// =====================

type egressServer struct {
	Egress
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
	jsonCamelCase    bool   // JSON fields are serialized as lowerCamelCase rather than keeping the original proto names
}

// NewEgressServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewEgressServer(svc Egress, opts ...interface{}) TwirpServer {
	serverOpts := newServerOpts(opts)

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	jsonSkipDefaults := false
	_ = serverOpts.ReadOpt("jsonSkipDefaults", &jsonSkipDefaults)
	jsonCamelCase := false
	_ = serverOpts.ReadOpt("jsonCamelCase", &jsonCamelCase)
	var pathPrefix string
	if ok := serverOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	return &egressServer{
		Egress:           svc,
		hooks:            serverOpts.Hooks,
		interceptor:      twirp.ChainInterceptors(serverOpts.Interceptors...),
		pathPrefix:       pathPrefix,
		jsonSkipDefaults: jsonSkipDefaults,
		jsonCamelCase:    jsonCamelCase,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *egressServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *egressServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// EgressPathPrefix is a convenience constant that may identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// with the default "/twirp" prefix and default CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const EgressPathPrefix = "/twirp/livekit.Egress/"

func (s *egressServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "Egress")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "livekit.Egress" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "StartRoomCompositeEgress":
		s.serveStartRoomCompositeEgress(ctx, resp, req)
		return
	case "StartWebEgress":
		s.serveStartWebEgress(ctx, resp, req)
		return
	case "StartParticipantEgress":
		s.serveStartParticipantEgress(ctx, resp, req)
		return
	case "StartTrackCompositeEgress":
		s.serveStartTrackCompositeEgress(ctx, resp, req)
		return
	case "StartTrackEgress":
		s.serveStartTrackEgress(ctx, resp, req)
		return
	case "UpdateLayout":
		s.serveUpdateLayout(ctx, resp, req)
		return
	case "UpdateStream":
		s.serveUpdateStream(ctx, resp, req)
		return
	case "ListEgress":
		s.serveListEgress(ctx, resp, req)
		return
	case "StopEgress":
		s.serveStopEgress(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *egressServer) serveStartRoomCompositeEgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStartRoomCompositeEgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStartRoomCompositeEgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveStartRoomCompositeEgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartRoomCompositeEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(RoomCompositeEgressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.StartRoomCompositeEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RoomCompositeEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RoomCompositeEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RoomCompositeEgressRequest) when calling interceptor")
					}
					return s.Egress.StartRoomCompositeEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartRoomCompositeEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartRoomCompositeEgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartRoomCompositeEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(RoomCompositeEgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.StartRoomCompositeEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RoomCompositeEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RoomCompositeEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RoomCompositeEgressRequest) when calling interceptor")
					}
					return s.Egress.StartRoomCompositeEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartRoomCompositeEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartWebEgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStartWebEgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStartWebEgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveStartWebEgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartWebEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(WebEgressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.StartWebEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *WebEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*WebEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*WebEgressRequest) when calling interceptor")
					}
					return s.Egress.StartWebEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartWebEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartWebEgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartWebEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(WebEgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.StartWebEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *WebEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*WebEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*WebEgressRequest) when calling interceptor")
					}
					return s.Egress.StartWebEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartWebEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartParticipantEgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStartParticipantEgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStartParticipantEgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveStartParticipantEgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartParticipantEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ParticipantEgressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.StartParticipantEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ParticipantEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ParticipantEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ParticipantEgressRequest) when calling interceptor")
					}
					return s.Egress.StartParticipantEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartParticipantEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartParticipantEgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartParticipantEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ParticipantEgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.StartParticipantEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ParticipantEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ParticipantEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ParticipantEgressRequest) when calling interceptor")
					}
					return s.Egress.StartParticipantEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartParticipantEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartTrackCompositeEgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStartTrackCompositeEgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStartTrackCompositeEgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveStartTrackCompositeEgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartTrackCompositeEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(TrackCompositeEgressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.StartTrackCompositeEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *TrackCompositeEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*TrackCompositeEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*TrackCompositeEgressRequest) when calling interceptor")
					}
					return s.Egress.StartTrackCompositeEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartTrackCompositeEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartTrackCompositeEgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartTrackCompositeEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(TrackCompositeEgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.StartTrackCompositeEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *TrackCompositeEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*TrackCompositeEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*TrackCompositeEgressRequest) when calling interceptor")
					}
					return s.Egress.StartTrackCompositeEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartTrackCompositeEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartTrackEgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStartTrackEgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStartTrackEgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveStartTrackEgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartTrackEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(TrackEgressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.StartTrackEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *TrackEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*TrackEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*TrackEgressRequest) when calling interceptor")
					}
					return s.Egress.StartTrackEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartTrackEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStartTrackEgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartTrackEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(TrackEgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.StartTrackEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *TrackEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*TrackEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*TrackEgressRequest) when calling interceptor")
					}
					return s.Egress.StartTrackEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StartTrackEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveUpdateLayout(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateLayoutJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateLayoutProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveUpdateLayoutJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLayout")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(UpdateLayoutRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.UpdateLayout
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateLayoutRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateLayoutRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateLayoutRequest) when calling interceptor")
					}
					return s.Egress.UpdateLayout(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling UpdateLayout. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveUpdateLayoutProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLayout")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(UpdateLayoutRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.UpdateLayout
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateLayoutRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateLayoutRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateLayoutRequest) when calling interceptor")
					}
					return s.Egress.UpdateLayout(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling UpdateLayout. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveUpdateStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveUpdateStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(UpdateStreamRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.UpdateStream
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateStreamRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateStreamRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateStreamRequest) when calling interceptor")
					}
					return s.Egress.UpdateStream(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling UpdateStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveUpdateStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(UpdateStreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.UpdateStream
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateStreamRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateStreamRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateStreamRequest) when calling interceptor")
					}
					return s.Egress.UpdateStream(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling UpdateStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveListEgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveListEgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListEgressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.ListEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListEgressRequest) (*ListEgressResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListEgressRequest) when calling interceptor")
					}
					return s.Egress.ListEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListEgressResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListEgressResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListEgressResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEgressResponse and nil error while calling ListEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveListEgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListEgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.ListEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListEgressRequest) (*ListEgressResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListEgressRequest) when calling interceptor")
					}
					return s.Egress.ListEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListEgressResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListEgressResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListEgressResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEgressResponse and nil error while calling ListEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStopEgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStopEgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStopEgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *egressServer) serveStopEgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StopEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(StopEgressRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.Egress.StopEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *StopEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*StopEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*StopEgressRequest) when calling interceptor")
					}
					return s.Egress.StopEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StopEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) serveStopEgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StopEgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(StopEgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Egress.StopEgress
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *StopEgressRequest) (*EgressInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*StopEgressRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*StopEgressRequest) when calling interceptor")
					}
					return s.Egress.StopEgress(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EgressInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EgressInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EgressInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EgressInfo and nil error while calling StopEgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *egressServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *egressServer) ProtocGenTwirpVersion() string {
	return "v8.1.3"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *egressServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "livekit", "Egress")
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler

	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// google.golang.org/protobuf/types/descriptorpb.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)

	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string

	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route Twirp requests.
	// The path prefix is in the form: "/<prefix>/<package>.<Service>/"
	// that is, everything in a Twirp route except for the <Method> at the end.
	PathPrefix() string
}

func newServerOpts(opts []interface{}) *twirp.ServerOptions {
	serverOpts := &twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T, please use a twirp.ServerOption", o))
		}
	}
	return serverOpts
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Convert to a twirp.Error. Non-twirp errors are converted to internal errors.
	var twerr twirp.Error
	if !errors.As(err, &twerr) {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// sanitizeBaseURL parses the the baseURL, and adds the "http" scheme if needed.
// If the URL is unparsable, the baseURL is returned unchanged.
func sanitizeBaseURL(baseURL string) string {
	u, err := url.Parse(baseURL)
	if err != nil {
		return baseURL // invalid URL will fail later when making requests
	}
	if u.Scheme == "" {
		u.Scheme = "http"
	}
	return u.String()
}

// baseServicePath composes the path prefix for the service (without <Method>).
// e.g.: baseServicePath("/twirp", "my.pkg", "MyService")
//
//	returns => "/twirp/my.pkg.MyService/"
//
// e.g.: baseServicePath("", "", "MyService")
//
//	returns => "/MyService/"
func baseServicePath(prefix, pkg, service string) string {
	fullServiceName := service
	if pkg != "" {
		fullServiceName = pkg + "." + service
	}
	return path.Join("/", prefix, fullServiceName) + "/"
}

// parseTwirpPath extracts path components form a valid Twirp route.
// Expected format: "[<prefix>]/<package>.<Service>/<Method>"
// e.g.: prefix, pkgService, method := parseTwirpPath("/twirp/pkg.Svc/MakeHat")
func parseTwirpPath(path string) (string, string, string) {
	parts := strings.Split(path, "/")
	if len(parts) < 2 {
		return "", "", ""
	}
	method := parts[len(parts)-1]
	pkgService := parts[len(parts)-2]
	prefix := strings.Join(parts[0:len(parts)-2], "/")
	return prefix, pkgService, method
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v8.1.3")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := io.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429: // Too Many Requests
			code = twirp.ResourceExhausted
		case 502, 503, 504: // Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}
	defer func() { _ = resp.Body.Close() }()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := io.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	marshaler := &protojson.MarshalOptions{UseProtoNames: true}
	reqBytes, err := marshaler.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, bytes.NewReader(reqBytes), "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	d := json.NewDecoder(resp.Body)
	rawRespBody := json.RawMessage{}
	if err := d.Decode(&rawRespBody); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawRespBody, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2868 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x1a, 0x4d, 0x73, 0x23, 0x57,
	0xd1, 0x33, 0xfa, 0x6e, 0x7d, 0x78, 0xfc, 0xd6, 0xbb, 0xd1, 0x7a, 0x43, 0xe2, 0x68, 0xf3, 0xb1,
	0xd9, 0x24, 0x5e, 0xb3, 0xde, 0x6c, 0x36, 0x1b, 0x12, 0x90, 0xed, 0xb1, 0x2d, 0xe2, 0x0f, 0x31,
	0x92, 0x93, 0xc0, 0x65, 0x6a, 0xac, 0x79, 0x96, 0xa7, 0x76, 0x34, 0xa3, 0xcc, 0x3c, 0x79, 0x51,
	0x8a, 0x1f, 0xc0, 0x95, 0xe2, 0x46, 0x51, 0xc5, 0x85, 0x13, 0x45, 0x71, 0xe5, 0xcc, 0x15, 0x0e,
	0x1c, 0xf8, 0x05, 0x1c, 0xa8, 0xa2, 0xa8, 0x82, 0x03, 0x67, 0x0e, 0xd4, 0xfb, 0x98, 0x0f, 0x8d,
	0xc6, 0x8a, 0x1c, 0xa5, 0x0a, 0x8a, 0xe2, 0xf6, 0x5e, 0x7f, 0x4d, 0xbf, 0xee, 0x7e, 0xfd, 0xba,
	0x5b, 0x82, 0x55, 0xdb, 0xba, 0xc4, 0xcf, 0x2c, 0xa2, 0xe3, 0xbe, 0x87, 0x7d, 0x7f, 0x63, 0xe8,
	0xb9, 0xc4, 0x45, 0x05, 0x01, 0x5d, 0x0b, 0xd1, 0x03, 0xd7, 0xc4, 0xb6, 0x40, 0x37, 0xfe, 0x9a,
	0x83, 0x35, 0xcd, 0x75, 0x07, 0x3b, 0xee, 0x60, 0xe8, 0xfa, 0x16, 0xc1, 0x2a, 0x63, 0xd6, 0xf0,
	0xe7, 0x23, 0xec, 0x13, 0x74, 0x07, 0x4a, 0x9e, 0xeb, 0x0e, 0x74, 0xc7, 0x18, 0xe0, 0xba, 0xb4,
	0x2e, 0xdd, 0x2b, 0x69, 0x45, 0x0a, 0x38, 0x36, 0x06, 0x18, 0xdd, 0x82, 0xbc, 0x6d, 0x8c, 0xdd,
	0x11, 0xa9, 0xcb, 0x0c, 0x23, 0x76, 0xe8, 0x1b, 0x00, 0xc6, 0xc8, 0xb4, 0x5c, 0xdd, 0x75, 0xec,
	0x71, 0x3d, 0xb3, 0x2e, 0xdd, 0x2b, 0x6a, 0x25, 0x06, 0x39, 0x71, 0xec, 0x31, 0x45, 0x5f, 0x5a,
	0x26, 0x16, 0xe8, 0x2c, 0x47, 0x33, 0x08, 0x43, 0xbf, 0x0e, 0xcb, 0xbd, 0x91, 0x4f, 0xdc, 0x81,
	0x7e, 0x66, 0xf8, 0x58, 0x1f, 0x79, 0x76, 0x3d, 0xc7, 0xc4, 0x57, 0x39, 0x78, 0xdb, 0xf0, 0xf1,
	0xa9, 0x67, 0xa3, 0x47, 0x90, 0x3d, 0xb7, 0x6c, 0x5c, 0xcf, 0xaf, 0x4b, 0xf7, 0xca, 0x0f, 0xd7,
	0x36, 0xc4, 0xf1, 0x36, 0x54, 0xa7, 0xe7, 0x9a, 0xd8, 0xdc, 0xb3, 0x6c, 0x7c, 0x32, 0x22, 0xc3,
	0x11, 0xd9, 0x96, 0xeb, 0xd2, 0xc1, 0x92, 0xc6, 0xa8, 0xd1, 0x16, 0xe4, 0x7d, 0xe2, 0x61, 0x63,
	0x50, 0x2f, 0x30, 0xbe, 0x9b, 0x21, 0x5f, 0x87, 0x81, 0x27, 0x58, 0x04, 0x29, 0xfa, 0x08, 0x8a,
	0x3e, 0xee, 0x0f, 0xb0, 0x43, 0xfc, 0x3a, 0x30, 0xb6, 0x17, 0x23, 0x36, 0x8e, 0x48, 0xf9, 0x60,
	0xc8, 0x83, 0x9e, 0x40, 0x7e, 0xe8, 0x61, 0x1f, 0x93, 0x7a, 0x71, 0x5d, 0xba, 0x57, 0x7b, 0xf8,
	0xd2, 0xa4, 0xb2, 0x96, 0xd3, 0x3f, 0x19, 0x12, 0xcb, 0x75, 0xfc, 0x36, 0xa3, 0x3a, 0x90, 0x34,
	0x41, 0x8f, 0x1e, 0x43, 0xd1, 0x30, 0x2f, 0x0d, 0xa7, 0x87, 0xcd, 0x7a, 0x89, 0x7d, 0xb9, 0x7e,
	0x15, 0xef, 0x81, 0xa4, 0x85, 0xb4, 0xe8, 0x43, 0xa8, 0xd0, 0xe3, 0xea, 0x2e, 0x53, 0xc8, 0xaf,
	0x97, 0xd7, 0x33, 0xb3, 0x8d, 0xa4, 0x95, 0xcf, 0xc3, 0xb5, 0x8f, 0xbe, 0x05, 0x35, 0x7e, 0xf4,
	0x50, 0x40, 0x85, 0x09, 0x48, 0xb7, 0x96, 0x56, 0xf5, 0x63, 0x3b, 0x1f, 0xa9, 0xb0, 0x2c, 0x8e,
	0x1e, 0xb2, 0x57, 0x19, 0xfb, 0x4c, 0xab, 0x69, 0x35, 0xc1, 0x14, 0x88, 0x79, 0x1f, 0xaa, 0xd6,
	0xc0, 0xe8, 0x47, 0x87, 0xa8, 0x31, 0x21, 0xab, 0xa1, 0x90, 0x16, 0xc5, 0x0a, 0xe6, 0x8a, 0x15,
	0x6d, 0xfc, 0xed, 0x22, 0xe4, 0x39, 0xd3, 0x76, 0x09, 0x0a, 0x2e, 0xb7, 0x4f, 0xe3, 0x77, 0x39,
	0x50, 0x3e, 0xc5, 0x67, 0x93, 0x01, 0xae, 0x40, 0x86, 0x46, 0x18, 0x0f, 0x6d, 0xba, 0x4c, 0x44,
	0xaf, 0x3c, 0x3b, 0x7a, 0x33, 0xc9, 0xe8, 0x7d, 0x1b, 0x90, 0xf1, 0xdc, 0xb0, 0x88, 0xee, 0x13,
	0xc3, 0x23, 0xba, 0x6f, 0xf5, 0x1d, 0xc3, 0xae, 0x57, 0x18, 0x99, 0xc2, 0x30, 0x1d, 0x8a, 0xe8,
	0x30, 0x78, 0x18, 0xc3, 0xd9, 0xaf, 0x18, 0xc3, 0xb9, 0xaf, 0x16, 0xc3, 0xf9, 0x85, 0x62, 0xb8,
	0xb0, 0x40, 0x0c, 0x17, 0x17, 0x88, 0xe1, 0xd2, 0xa2, 0x31, 0x0c, 0x8b, 0xc5, 0x70, 0xf9, 0xeb,
	0x88, 0xe1, 0xea, 0x62, 0x31, 0xfc, 0xcf, 0x0c, 0xd4, 0xdb, 0x86, 0x47, 0xac, 0x9e, 0x35, 0x34,
	0x1c, 0x72, 0x8d, 0x64, 0xbd, 0x06, 0x45, 0xcb, 0xc4, 0x0e, 0xb1, 0xc8, 0x58, 0xa4, 0xeb, 0x70,
	0x8f, 0x5e, 0x81, 0x8a, 0xdf, 0xf3, 0x30, 0x76, 0x74, 0xff, 0xc2, 0xf0, 0xb0, 0x88, 0xea, 0x32,
	0x87, 0x75, 0x28, 0x28, 0xe6, 0xfe, 0xec, 0x5c, 0xee, 0x5f, 0x4a, 0x75, 0x7f, 0xee, 0x4b, 0xdc,
	0xbf, 0x34, 0xc3, 0xfd, 0xf9, 0x45, 0xdd, 0x5f, 0x58, 0xcc, 0xfd, 0xc5, 0xaf, 0xc3, 0xfd, 0xa5,
	0xb9, 0xdd, 0x1f, 0x73, 0xfa, 0x6f, 0x73, 0x70, 0xa7, 0xeb, 0x19, 0xbd, 0x67, 0x5f, 0xe5, 0x91,
	0x7e, 0x15, 0x6a, 0x3c, 0x9d, 0x11, 0x2a, 0x41, 0xb7, 0x4c, 0xe1, 0xfd, 0x0a, 0x83, 0x32, 0xb1,
	0x2d, 0x93, 0x52, 0xf1, 0xac, 0x16, 0x52, 0x65, 0x38, 0x15, 0x83, 0x06, 0x54, 0xff, 0xa1, 0x74,
	0x55, 0x5c, 0x28, 0x5d, 0xe5, 0x17, 0x48, 0x57, 0x85, 0xff, 0x3f, 0xb9, 0x0b, 0xa5, 0xab, 0xdf,
	0x48, 0x80, 0x58, 0xf0, 0x5c, 0x23, 0x60, 0x6f, 0x43, 0x31, 0x11, 0xaa, 0x05, 0x22, 0xe2, 0xef,
	0x81, 0x88, 0xbf, 0x0c, 0x73, 0xcb, 0xed, 0x50, 0xab, 0x5d, 0xcb, 0xc3, 0x3d, 0x12, 0x9d, 0x2b,
	0x0c, 0xbd, 0xd7, 0xa0, 0xfa, 0x1c, 0x9f, 0xf9, 0x6e, 0xef, 0x19, 0x26, 0xac, 0x92, 0xa4, 0x91,
	0x5b, 0x3a, 0x58, 0xd2, 0x2a, 0x21, 0xf8, 0xd4, 0xb3, 0x23, 0xdd, 0x1b, 0x7f, 0x90, 0x61, 0x65,
	0xca, 0x51, 0xe8, 0x5d, 0x28, 0x31, 0xd7, 0x92, 0xf1, 0x90, 0xeb, 0x5b, 0x4b, 0xc6, 0x04, 0x27,
	0xef, 0x8e, 0x87, 0x58, 0x2b, 0x9e, 0x8b, 0x15, 0x4d, 0xb9, 0x74, 0x3d, 0x34, 0xc8, 0x45, 0x90,
	0x72, 0x83, 0x3d, 0x7a, 0x13, 0x14, 0xd3, 0xf2, 0x8d, 0x33, 0x1b, 0xeb, 0x03, 0xc3, 0xb1, 0xce,
	0xb1, 0xcf, 0x23, 0xb5, 0xa8, 0x2d, 0x0b, 0xf8, 0x91, 0x00, 0xa3, 0xbb, 0x20, 0xfb, 0x5b, 0xe2,
	0xcc, 0x2b, 0x91, 0x3b, 0xb7, 0x4e, 0x87, 0xb6, 0x6b, 0x98, 0x07, 0x4b, 0x9a, 0xec, 0x6f, 0xa1,
	0xd7, 0x21, 0xd3, 0xef, 0x0d, 0xc5, 0xcd, 0x44, 0x21, 0xd5, 0xfe, 0x4e, 0x3b, 0x24, 0xa3, 0x04,
	0x68, 0x13, 0x72, 0xc6, 0x17, 0x23, 0x0f, 0x4f, 0xa5, 0xe2, 0x26, 0x85, 0x6e, 0xdb, 0xee, 0x59,
	0x48, 0xcf, 0x09, 0xd1, 0x03, 0xc8, 0x1b, 0xb6, 0x75, 0xd2, 0xe9, 0x4c, 0x55, 0xcc, 0x4d, 0x06,
	0x0e, 0xe9, 0x05, 0x59, 0xcc, 0x9a, 0xbf, 0xcc, 0xc2, 0x8d, 0x94, 0xb0, 0x43, 0x4f, 0xa1, 0xc8,
	0xba, 0x8f, 0x9e, 0x6b, 0x0b, 0x73, 0xbe, 0x94, 0x1e, 0xa6, 0x6d, 0x41, 0xa5, 0x85, 0xf4, 0xe8,
	0x0d, 0x58, 0xa6, 0x46, 0xa4, 0xa1, 0xa3, 0x0f, 0x3d, 0x7c, 0x6e, 0xfd, 0x50, 0xd8, 0xb6, 0x16,
	0x80, 0xdb, 0x0c, 0x8a, 0xee, 0x42, 0x75, 0x68, 0x1b, 0x63, 0xdb, 0xf2, 0x09, 0x0f, 0x34, 0x91,
	0xd1, 0x02, 0x20, 0x0b, 0xb6, 0xb7, 0x01, 0xd1, 0x0f, 0xeb, 0x93, 0x94, 0x65, 0x46, 0xa9, 0x50,
	0x4c, 0x3b, 0x4e, 0xfd, 0x26, 0x28, 0xc1, 0x2d, 0x33, 0x47, 0x9e, 0x41, 0x63, 0x9c, 0x59, 0xbc,
	0xaa, 0x05, 0xb7, 0x6f, 0x57, 0x80, 0xe9, 0x85, 0x0c, 0xd5, 0xf4, 0x47, 0xe7, 0x54, 0x4d, 0x60,
	0x27, 0xbd, 0xe2, 0x42, 0x76, 0x18, 0x4d, 0x74, 0x08, 0xbe, 0x4f, 0x0d, 0x93, 0xe2, 0xac, 0x30,
	0xc9, 0xcd, 0x15, 0x26, 0xf9, 0xb9, 0xc3, 0xa4, 0x70, 0xfd, 0x30, 0x29, 0x5d, 0x37, 0x4c, 0x7e,
	0x2a, 0x83, 0x92, 0xbc, 0xc2, 0x13, 0x97, 0x47, 0x9a, 0xe3, 0xf2, 0xe4, 0x66, 0x59, 0x45, 0x9e,
	0xcb, 0x2a, 0x99, 0xb9, 0xad, 0x92, 0xbd, 0xbe, 0x55, 0xf2, 0xd7, 0xb5, 0xca, 0xdf, 0x33, 0x50,
	0x8e, 0xa5, 0x5b, 0x7a, 0xe8, 0x9e, 0x31, 0x24, 0x23, 0x0f, 0xeb, 0x96, 0x43, 0xb0, 0x77, 0x69,
	0xf0, 0xcb, 0x53, 0xd5, 0x96, 0x05, 0xbc, 0x25, 0xc0, 0x68, 0x15, 0x72, 0xcf, 0x2d, 0x53, 0x64,
	0x9d, 0x9c, 0xc6, 0x37, 0xb4, 0x5d, 0xbf, 0xc0, 0x56, 0xff, 0x82, 0xb0, 0x83, 0xe6, 0x34, 0xb1,
	0x4b, 0xbb, 0x51, 0xd9, 0xd4, 0x1b, 0xd5, 0x9c, 0x8e, 0xe9, 0x5c, 0x22, 0x19, 0x32, 0x85, 0x67,
	0xc4, 0xf3, 0x23, 0x28, 0xf3, 0x07, 0x86, 0xe6, 0xcc, 0x9e, 0x78, 0x9b, 0x6f, 0x4c, 0xb2, 0xef,
	0x50, 0x94, 0x06, 0x56, 0xb8, 0x4e, 0xf5, 0x77, 0x61, 0x96, 0xbf, 0x8b, 0x73, 0xf9, 0xbb, 0x34,
	0xb7, 0xbf, 0xe1, 0xfa, 0xfe, 0x2e, 0x5f, 0xd7, 0xdf, 0xff, 0x92, 0xa1, 0x18, 0xe8, 0xc9, 0x9a,
	0xd0, 0x5e, 0x0f, 0xfb, 0xbe, 0xfe, 0x0c, 0x8f, 0x45, 0xfc, 0x97, 0x38, 0xe4, 0x63, 0x3c, 0xa6,
	0xae, 0xf4, 0x71, 0xcf, 0xc3, 0xe1, 0xe4, 0x85, 0xef, 0x28, 0xdc, 0xc3, 0x7d, 0x9a, 0x96, 0x78,
	0xb2, 0x13, 0x3b, 0x7a, 0x99, 0xb0, 0x63, 0x0e, 0x5d, 0xcb, 0x21, 0xc2, 0xb7, 0xe1, 0x9e, 0xf2,
	0x9c, 0x8d, 0xe8, 0x4b, 0x28, 0xc6, 0x2c, 0x62, 0x87, 0xee, 0x81, 0x72, 0xee, 0x7a, 0x3d, 0xac,
	0xd3, 0x2b, 0xa7, 0xfb, 0x64, 0x2c, 0x66, 0x2d, 0x45, 0xad, 0xc6, 0xe0, 0x6d, 0x83, 0x5c, 0x74,
	0x28, 0x14, 0x7d, 0x00, 0xc5, 0x01, 0x26, 0x86, 0x69, 0x10, 0x43, 0x14, 0xd9, 0x2f, 0x4f, 0x59,
	0x7e, 0xe3, 0x48, 0x50, 0xa8, 0x0e, 0xf1, 0xc6, 0x5a, 0xc8, 0x80, 0xea, 0x50, 0x20, 0x46, 0xbf,
	0x6f, 0x39, 0x7d, 0xe6, 0x35, 0xfa, 0xda, 0xf3, 0x2d, 0x7a, 0x00, 0x37, 0x7a, 0xae, 0x43, 0x58,
	0xb6, 0xb5, 0x7c, 0x56, 0xf8, 0xd2, 0x93, 0x95, 0x18, 0x15, 0x12, 0xa8, 0xdd, 0x08, 0xb3, 0xf6,
	0x01, 0x54, 0x27, 0xbe, 0x42, 0x9b, 0xfb, 0xc8, 0x7c, 0x74, 0x49, 0x6f, 0xc6, 0xa5, 0x61, 0x8f,
	0xb0, 0xb0, 0x1b, 0xdf, 0x3c, 0x95, 0x9f, 0x48, 0x0d, 0x15, 0x4a, 0xa1, 0xff, 0xd1, 0x3a, 0x94,
	0x7b, 0x1e, 0x66, 0xed, 0x91, 0x61, 0xfb, 0x42, 0x40, 0x1c, 0x14, 0xb3, 0x9a, 0x1c, 0xb7, 0x5a,
	0xe3, 0x47, 0xb0, 0x9c, 0x08, 0x0e, 0xda, 0x5d, 0x19, 0xbd, 0x9e, 0x3b, 0x72, 0x48, 0xbc, 0xe0,
	0x29, 0x0b, 0x18, 0x7b, 0x58, 0x5e, 0x86, 0x60, 0xcb, 0xfc, 0xcd, 0x45, 0x82, 0x00, 0x51, 0x87,
	0xbf, 0x06, 0x35, 0x7a, 0x60, 0xc3, 0x72, 0xb0, 0x17, 0x7f, 0xcd, 0xaa, 0x21, 0x94, 0xca, 0x69,
	0xfc, 0x44, 0x82, 0x4a, 0x3c, 0xd0, 0xfe, 0x0b, 0xe2, 0xa8, 0xf1, 0x29, 0x54, 0xe2, 0x95, 0x2b,
	0xda, 0x9a, 0x7a, 0xfc, 0x5f, 0x48, 0x94, 0xb8, 0x29, 0xaf, 0x3e, 0x82, 0xec, 0xc8, 0xb3, 0xfd,
	0xba, 0xbc, 0x9e, 0xb9, 0x57, 0xd2, 0xd8, 0xba, 0xf1, 0xfb, 0x0c, 0x2c, 0x27, 0x0a, 0xf2, 0x28,
	0xf3, 0x49, 0xe9, 0x99, 0x4f, 0x9e, 0xc8, 0x7c, 0xab, 0x90, 0x33, 0xf1, 0x90, 0x5c, 0x88, 0x84,
	0xc8, 0x37, 0xe8, 0x45, 0x28, 0x9d, 0x7b, 0xc6, 0x00, 0x7b, 0x06, 0xe1, 0x99, 0x3e, 0xa7, 0x45,
	0x00, 0x9a, 0xc1, 0x78, 0x3f, 0xc5, 0x33, 0x58, 0x2e, 0x91, 0xc1, 0x9a, 0x14, 0x27, 0x32, 0x98,
	0x11, 0xae, 0x69, 0x31, 0xc2, 0xb9, 0xce, 0x2c, 0xc2, 0xe4, 0xe6, 0x99, 0x5c, 0xde, 0x84, 0x6d,
	0x73, 0x58, 0x44, 0xf4, 0xf9, 0xc8, 0xb0, 0x69, 0x9f, 0x5e, 0x8e, 0x11, 0x7d, 0x8f, 0xc3, 0x68,
	0xb6, 0xe6, 0x44, 0xe7, 0x1e, 0xad, 0xa6, 0x9d, 0xde, 0x98, 0xa5, 0xc2, 0x9c, 0xc6, 0xdb, 0xbc,
	0xbd, 0x00, 0x4a, 0x15, 0xe5, 0x2d, 0x1d, 0x57, 0xb4, 0x98, 0x50, 0xf4, 0x13, 0x8a, 0x13, 0x8a,
	0x5e, 0x86, 0x6b, 0xaa, 0x03, 0xe7, 0x0a, 0x14, 0x2d, 0x71, 0x1d, 0x18, 0x30, 0xa6, 0x28, 0x27,
	0x0a, 0x14, 0xad, 0xc4, 0x88, 0x02, 0x45, 0xdf, 0x06, 0xf4, 0x0c, 0x8f, 0x75, 0x66, 0xb9, 0xe8,
	0xc5, 0xa2, 0x99, 0x54, 0xd2, 0x94, 0x67, 0x78, 0xbc, 0x47, 0x11, 0xc1, 0x93, 0xd5, 0xf8, 0x2e,
	0xdc, 0x38, 0x1d, 0x9a, 0x06, 0xc1, 0x87, 0x6c, 0x86, 0x1c, 0xeb, 0x14, 0xf8, 0x34, 0x9b, 0x76,
	0x03, 0xa2, 0x0c, 0xe0, 0x80, 0x96, 0x79, 0xd5, 0xfc, 0xb9, 0xf1, 0x63, 0x29, 0x10, 0xc6, 0xe3,
	0x69, 0x2e, 0x61, 0xaf, 0xc3, 0xb2, 0x61, 0x9a, 0xa2, 0xf1, 0xd1, 0x63, 0xc1, 0x56, 0x35, 0x4c,
	0x93, 0x87, 0xee, 0xa9, 0x67, 0xfb, 0xf4, 0x58, 0x1e, 0x1e, 0xb8, 0x97, 0x78, 0x82, 0x34, 0xc3,
	0x48, 0x15, 0x8e, 0x89, 0xa8, 0x1b, 0x18, 0x56, 0x0e, 0x2d, 0xff, 0x3a, 0x73, 0x9a, 0x09, 0x25,
	0xe5, 0xe9, 0x13, 0x1b, 0x3d, 0x62, 0x5d, 0x06, 0x23, 0x1a, 0xb1, 0x6b, 0x7c, 0x1b, 0x50, 0xfc,
	0x33, 0xfe, 0xd0, 0x75, 0x7c, 0x5a, 0xae, 0xe6, 0x2c, 0x82, 0x07, 0x34, 0x7f, 0xd1, 0xa4, 0x1c,
	0xf9, 0x9e, 0xd3, 0xb5, 0x9c, 0x73, 0x57, 0xe3, 0x14, 0x8d, 0x4d, 0x58, 0xe9, 0x10, 0x77, 0x38,
	0xa5, 0xe7, 0x95, 0xf6, 0x6a, 0xfc, 0xa5, 0x00, 0x10, 0xc9, 0x99, 0x6d, 0xdb, 0x17, 0xa0, 0xc0,
	0x0e, 0x1c, 0x9e, 0x28, 0x4f, 0xb7, 0x2d, 0x73, 0xd2, 0x12, 0xd5, 0x84, 0x25, 0xde, 0x81, 0xbc,
	0x4f, 0x0c, 0x32, 0xf2, 0xd9, 0x61, 0x6b, 0xb1, 0xb7, 0x94, 0x7f, 0xb7, 0xc3, 0x90, 0x9a, 0x20,
	0xa2, 0xa9, 0x8e, 0xcd, 0x5c, 0xb1, 0xa9, 0x1b, 0x84, 0xc5, 0x59, 0x46, 0x2b, 0x09, 0x48, 0x93,
	0xd0, 0xb6, 0x12, 0x3b, 0x26, 0x47, 0x96, 0x19, 0xb2, 0xc0, 0xf6, 0x4d, 0xf6, 0x7b, 0xc5, 0x88,
	0x85, 0x0b, 0x43, 0x22, 0xce, 0x29, 0x20, 0x4d, 0x96, 0x25, 0xb0, 0xe7, 0xb9, 0x9e, 0x78, 0x79,
	0xf8, 0x06, 0x1d, 0x42, 0x8d, 0xa9, 0xde, 0x0b, 0x66, 0x32, 0xa2, 0x28, 0xbc, 0x1b, 0x6a, 0x79,
	0xf5, 0xcf, 0x2a, 0x07, 0x4b, 0x5a, 0xd5, 0x8b, 0x63, 0xd1, 0x3b, 0x90, 0x79, 0x8e, 0xcf, 0xea,
	0xb5, 0x44, 0x63, 0x9b, 0x1c, 0x57, 0xd3, 0xc2, 0xe4, 0x39, 0x3e, 0x43, 0x2a, 0x94, 0x87, 0xd1,
	0x14, 0xb0, 0x7e, 0x83, 0xb1, 0xbd, 0x12, 0xb2, 0x5d, 0x35, 0x21, 0x3c, 0x58, 0xd2, 0xe2, 0x7c,
	0xe8, 0x04, 0x96, 0x79, 0xab, 0x1d, 0x1d, 0x82, 0xf7, 0x0f, 0xaf, 0x86, 0xa2, 0x66, 0xcc, 0x9d,
	0x0e, 0x96, 0xb4, 0x1a, 0x99, 0x40, 0xa3, 0x2d, 0xc8, 0x31, 0x88, 0xa8, 0x76, 0xef, 0x4c, 0x8a,
	0x49, 0x72, 0x73, 0x5a, 0xf4, 0x6e, 0xe2, 0x27, 0x99, 0xe4, 0x73, 0x40, 0xe3, 0x8b, 0x46, 0x37,
	0x9b, 0xf1, 0x48, 0xe1, 0x84, 0xe8, 0x2d, 0x31, 0x0c, 0x48, 0xd6, 0x7a, 0xb4, 0xfa, 0xa4, 0x2c,
	0x82, 0x9c, 0x0f, 0x02, 0xde, 0x8b, 0x8d, 0x93, 0x2a, 0xc9, 0x29, 0x94, 0x40, 0xc4, 0x98, 0xa2,
	0x39, 0xd2, 0xd3, 0x70, 0x2c, 0xe3, 0x61, 0x7f, 0x64, 0x13, 0xbf, 0xbe, 0x9c, 0xb8, 0x4c, 0x91,
	0x92, 0xc1, 0x50, 0x46, 0xe3, 0x94, 0xe8, 0x91, 0x98, 0x08, 0x05, 0x9c, 0x0a, 0xe3, 0x9c, 0xd6,
	0x94, 0x0f, 0x82, 0x02, 0xae, 0x8f, 0xa2, 0x51, 0x4e, 0xc0, 0xb8, 0x92, 0x9c, 0x04, 0xc5, 0x34,
	0x0e, 0x67, 0x38, 0x01, 0xff, 0x93, 0x60, 0x86, 0x13, 0x70, 0xaf, 0x26, 0x14, 0x66, 0x45, 0x36,
	0xe7, 0xe5, 0x23, 0x1c, 0xc1, 0xb9, 0x5d, 0x82, 0x82, 0xc7, 0x9d, 0x43, 0xcb, 0x52, 0xce, 0xde,
	0xf8, 0x10, 0x6a, 0x93, 0x6e, 0x40, 0x6f, 0x40, 0xd6, 0x72, 0xce, 0xdd, 0xa9, 0xac, 0x12, 0x33,
	0x04, 0x23, 0x78, 0x2a, 0xd7, 0xa5, 0xc6, 0x3f, 0x24, 0x80, 0x08, 0x91, 0xfe, 0x73, 0x4b, 0xec,
	0xda, 0xca, 0xb3, 0xae, 0x6d, 0x66, 0xf2, 0xda, 0xae, 0x41, 0x71, 0xa2, 0x0b, 0xcf, 0x68, 0xe1,
	0x1e, 0x3d, 0x0c, 0x73, 0x07, 0x7f, 0xa0, 0xd7, 0x52, 0xb4, 0xdc, 0x48, 0x24, 0x90, 0xf0, 0x9e,
	0xe7, 0x63, 0xf7, 0xbc, 0xb1, 0x01, 0x79, 0x4e, 0x87, 0x00, 0xf2, 0xcd, 0x9d, 0x6e, 0xeb, 0x13,
	0x55, 0x59, 0x42, 0x15, 0x28, 0xee, 0xb5, 0x8e, 0x5b, 0x9d, 0x03, 0x75, 0x57, 0x91, 0x28, 0x66,
	0xaf, 0xd9, 0x3a, 0x54, 0x77, 0x15, 0xb9, 0xf1, 0x6b, 0x09, 0x8a, 0x81, 0x63, 0x83, 0x26, 0x36,
	0x9e, 0xe8, 0x83, 0xfd, 0xd7, 0x74, 0xf0, 0x7c, 0xe2, 0xe0, 0x08, 0xb2, 0xbe, 0xf5, 0x05, 0x16,
	0x06, 0x61, 0x6b, 0x4a, 0x6f, 0xbb, 0x3d, 0x4e, 0xcf, 0x6b, 0xb3, 0x70, 0xdf, 0xf8, 0x93, 0x0c,
	0x95, 0x78, 0x38, 0x4d, 0x8f, 0x4d, 0xa4, 0xb9, 0xc7, 0x26, 0xc5, 0x2b, 0xc6, 0x26, 0x71, 0x7d,
	0xe5, 0x2b, 0xf4, 0xcd, 0xc4, 0xf4, 0x7d, 0x0b, 0x56, 0x42, 0xc1, 0xa1, 0xe2, 0xbc, 0xdc, 0x54,
	0x02, 0xc4, 0xa1, 0x80, 0xa3, 0x47, 0x70, 0x6b, 0x52, 0x95, 0x90, 0x83, 0xa7, 0xeb, 0xd5, 0xb8,
	0x3a, 0x21, 0xd7, 0x5d, 0xa8, 0x06, 0x97, 0x8c, 0xd5, 0xd8, 0xcc, 0x2e, 0x19, 0xad, 0x22, 0x80,
	0x3b, 0x14, 0x96, 0xf0, 0x50, 0x7e, 0x96, 0x87, 0x0a, 0x13, 0x1e, 0x6a, 0xf4, 0x01, 0xa2, 0x5b,
	0x46, 0xab, 0xfb, 0xa0, 0xe9, 0xa5, 0x9f, 0x92, 0x18, 0x6d, 0xd0, 0xdf, 0x4e, 0x7f, 0xe8, 0x1a,
	0xa1, 0xd0, 0xf8, 0x99, 0x0c, 0x37, 0x9b, 0x23, 0xe2, 0x4e, 0x65, 0xfc, 0xd8, 0x00, 0x5c, 0x5a,
	0xe0, 0x07, 0x1b, 0x79, 0x81, 0x1f, 0x6c, 0x32, 0xd7, 0x1b, 0x80, 0xa7, 0x8c, 0xb0, 0xb3, 0xd7,
	0x1f, 0x61, 0xc7, 0xa7, 0xcf, 0x7f, 0x96, 0x60, 0x99, 0x1a, 0x27, 0xf6, 0xf8, 0xfc, 0x6f, 0x8c,
	0x95, 0xa2, 0xa9, 0xc1, 0xfd, 0xf7, 0x45, 0x0f, 0x14, 0x0d, 0xa0, 0xd1, 0x2a, 0x28, 0xbb, 0xea,
	0x5e, 0xf3, 0xf4, 0xb0, 0xab, 0xef, 0xb5, 0x0e, 0xd5, 0xee, 0xf7, 0xdb, 0x34, 0x63, 0x15, 0x20,
	0x73, 0xd4, 0x7e, 0xa4, 0x48, 0x74, 0x71, 0xb2, 0xbf, 0xaf, 0xc8, 0xf7, 0x8f, 0xe1, 0x66, 0xea,
	0xb0, 0x15, 0xdd, 0x85, 0x97, 0x03, 0x01, 0x1d, 0x75, 0xff, 0x48, 0x3d, 0xee, 0xaa, 0xbb, 0x4c,
	0x94, 0xde, 0xd6, 0x4e, 0xba, 0x27, 0x3b, 0x27, 0x87, 0xca, 0x12, 0x52, 0xa0, 0x72, 0x70, 0xd8,
	0x89, 0x20, 0xd2, 0xfd, 0x07, 0x89, 0x61, 0xaf, 0x18, 0xf9, 0x94, 0x20, 0xd7, 0x3a, 0xde, 0x55,
	0x3f, 0x53, 0x96, 0x50, 0x15, 0x4a, 0xdd, 0xd6, 0x91, 0xda, 0xe9, 0x36, 0x8f, 0xda, 0x8a, 0x74,
	0x5f, 0x85, 0xe5, 0xc4, 0xbc, 0x08, 0xdd, 0x02, 0xd4, 0x3a, 0x6a, 0xee, 0xab, 0x7a, 0xe7, 0x74,
	0x6f, 0xaf, 0xf5, 0x99, 0x1e, 0x70, 0xae, 0xc1, 0xad, 0x09, 0x78, 0x5c, 0xcc, 0x66, 0xf0, 0x42,
	0x85, 0x07, 0x88, 0x59, 0x20, 0xa6, 0x71, 0x11, 0xb2, 0x5a, 0x97, 0x71, 0xfc, 0x51, 0x82, 0x9b,
	0xa9, 0xb7, 0x80, 0x9d, 0xea, 0xe1, 0xe3, 0x47, 0xfa, 0x7b, 0x0f, 0x37, 0xdb, 0xfa, 0xd6, 0xa6,
	0x38, 0x67, 0x08, 0x79, 0xbc, 0xa9, 0x48, 0x68, 0x05, 0xaa, 0x0c, 0xf2, 0xcd, 0xcd, 0x27, 0x9c,
	0x48, 0x4e, 0x80, 0x1e, 0x6f, 0x2a, 0x19, 0x74, 0x1b, 0x6e, 0xb6, 0x4f, 0xb4, 0xae, 0xd6, 0x6c,
	0x75, 0xf5, 0x09, 0x91, 0xd9, 0x2b, 0x50, 0x8f, 0x37, 0x95, 0x1c, 0x3d, 0xe7, 0x24, 0x2a, 0xfc,
	0x48, 0xfe, 0x2a, 0xdc, 0xe3, 0x4d, 0xa5, 0x70, 0xff, 0x17, 0x12, 0x54, 0xe2, 0x55, 0x31, 0xba,
	0x01, 0xcb, 0xea, 0xbe, 0xa6, 0x76, 0x3a, 0x7a, 0xa7, 0xdb, 0xd4, 0xba, 0xad, 0xe3, 0x7d, 0x65,
	0x89, 0xaa, 0x29, 0x80, 0xe2, 0x21, 0x93, 0x62, 0x20, 0xf5, 0x78, 0x97, 0x52, 0xc9, 0x31, 0xd6,
	0x9d, 0x93, 0xa3, 0xf6, 0xa1, 0xda, 0x55, 0x95, 0x4c, 0x8c, 0x4e, 0xbc, 0x74, 0x59, 0x84, 0xa0,
	0x16, 0x48, 0xdb, 0x3e, 0xd1, 0xba, 0xea, 0xae, 0x92, 0x43, 0x75, 0x58, 0x15, 0xb0, 0xc3, 0xd6,
	0x51, 0xab, 0xab, 0x6b, 0x6a, 0x73, 0x87, 0xbe, 0x91, 0xf9, 0x87, 0x3f, 0xcf, 0x41, 0x5e, 0xdc,
	0xc1, 0x2e, 0xd4, 0xd9, 0x9f, 0x20, 0x52, 0x0a, 0x64, 0x34, 0x4f, 0xf9, 0xbc, 0x96, 0xd6, 0xc9,
	0xa0, 0xef, 0xd0, 0x30, 0x30, 0x3c, 0x12, 0xd6, 0xcc, 0xe8, 0xea, 0x3a, 0x3a, 0x5d, 0x42, 0x1b,
	0x6e, 0x31, 0x09, 0xd3, 0xc9, 0xf4, 0xcb, 0x4b, 0xeb, 0x74, 0x89, 0x9f, 0xc0, 0x6d, 0x26, 0x31,
	0xad, 0x8a, 0x46, 0x73, 0x15, 0xd9, 0xe9, 0x72, 0x77, 0x41, 0x89, 0xe4, 0x0a, 0x71, 0xb3, 0x8a,
	0xed, 0x74, 0x29, 0x4d, 0xa8, 0xc4, 0x7b, 0x6e, 0x14, 0x25, 0xda, 0x94, 0x56, 0xfc, 0x4b, 0x44,
	0xf0, 0x1b, 0x38, 0x25, 0x62, 0xa2, 0x01, 0x4f, 0x17, 0xa1, 0x02, 0x44, 0xbd, 0x2b, 0x8a, 0x9e,
	0x8b, 0xa9, 0xbe, 0x79, 0xed, 0x4e, 0x2a, 0x4e, 0x34, 0xbb, 0x1f, 0xd2, 0x3a, 0x33, 0xe8, 0x60,
	0x51, 0xbc, 0xde, 0x4b, 0xb4, 0xb5, 0xa9, 0x5a, 0x6c, 0xef, 0xfd, 0xe0, 0x6e, 0xdf, 0x22, 0x17,
	0xa3, 0xb3, 0x8d, 0x9e, 0x3b, 0x78, 0x20, 0x08, 0x1e, 0x04, 0xf3, 0xa7, 0x00, 0xf0, 0x2b, 0xb9,
	0x7a, 0x68, 0x5d, 0xe2, 0x8f, 0x69, 0x20, 0x50, 0xd4, 0xdf, 0xe4, 0x9a, 0xd8, 0x3f, 0x7d, 0xca,
	0x00, 0x67, 0x79, 0xc6, 0xb2, 0xf5, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf7, 0x8b, 0x60, 0x28,
	0x8d, 0x27, 0x00, 0x00,
}
