// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The location of the custom terminology data.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TerminologyDataLocation {
    /// <p>The repository type for the custom terminology data.</p>
    pub repository_type: ::std::string::String,
    /// <p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration .</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub location: ::std::string::String,
}
impl TerminologyDataLocation {
    /// <p>The repository type for the custom terminology data.</p>
    pub fn repository_type(&self) -> &str {
        use std::ops::Deref;
        self.repository_type.deref()
    }
    /// <p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration .</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn location(&self) -> &str {
        use std::ops::Deref;
        self.location.deref()
    }
}
impl TerminologyDataLocation {
    /// Creates a new builder-style object to manufacture [`TerminologyDataLocation`](crate::types::TerminologyDataLocation).
    pub fn builder() -> crate::types::builders::TerminologyDataLocationBuilder {
        crate::types::builders::TerminologyDataLocationBuilder::default()
    }
}

/// A builder for [`TerminologyDataLocation`](crate::types::TerminologyDataLocation).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct TerminologyDataLocationBuilder {
    pub(crate) repository_type: ::std::option::Option<::std::string::String>,
    pub(crate) location: ::std::option::Option<::std::string::String>,
}
impl TerminologyDataLocationBuilder {
    /// <p>The repository type for the custom terminology data.</p>
    /// This field is required.
    pub fn repository_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.repository_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The repository type for the custom terminology data.</p>
    pub fn set_repository_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.repository_type = input;
        self
    }
    /// <p>The repository type for the custom terminology data.</p>
    pub fn get_repository_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.repository_type
    }
    /// <p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration .</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    /// This field is required.
    pub fn location(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.location = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration .</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn set_location(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.location = input;
        self
    }
    /// <p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30-minute expiration .</p><important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.</p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn get_location(&self) -> &::std::option::Option<::std::string::String> {
        &self.location
    }
    /// Consumes the builder and constructs a [`TerminologyDataLocation`](crate::types::TerminologyDataLocation).
    /// This method will fail if any of the following fields are not set:
    /// - [`repository_type`](crate::types::builders::TerminologyDataLocationBuilder::repository_type)
    /// - [`location`](crate::types::builders::TerminologyDataLocationBuilder::location)
    pub fn build(self) -> ::std::result::Result<crate::types::TerminologyDataLocation, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::TerminologyDataLocation {
            repository_type: self.repository_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "repository_type",
                    "repository_type was not specified but it is required when building TerminologyDataLocation",
                )
            })?,
            location: self.location.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "location",
                    "location was not specified but it is required when building TerminologyDataLocation",
                )
            })?,
        })
    }
}
