// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The number of documents successfully and unsuccessfully processed during a translation job.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct JobDetails {
    /// <p>The number of documents successfully processed during a translation job.</p>
    pub translated_documents_count: ::std::option::Option<i32>,
    /// <p>The number of documents that could not be processed during a translation job.</p>
    pub documents_with_errors_count: ::std::option::Option<i32>,
    /// <p>The number of documents used as input in a translation job.</p>
    pub input_documents_count: ::std::option::Option<i32>,
}
impl JobDetails {
    /// <p>The number of documents successfully processed during a translation job.</p>
    pub fn translated_documents_count(&self) -> ::std::option::Option<i32> {
        self.translated_documents_count
    }
    /// <p>The number of documents that could not be processed during a translation job.</p>
    pub fn documents_with_errors_count(&self) -> ::std::option::Option<i32> {
        self.documents_with_errors_count
    }
    /// <p>The number of documents used as input in a translation job.</p>
    pub fn input_documents_count(&self) -> ::std::option::Option<i32> {
        self.input_documents_count
    }
}
impl JobDetails {
    /// Creates a new builder-style object to manufacture [`JobDetails`](crate::types::JobDetails).
    pub fn builder() -> crate::types::builders::JobDetailsBuilder {
        crate::types::builders::JobDetailsBuilder::default()
    }
}

/// A builder for [`JobDetails`](crate::types::JobDetails).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct JobDetailsBuilder {
    pub(crate) translated_documents_count: ::std::option::Option<i32>,
    pub(crate) documents_with_errors_count: ::std::option::Option<i32>,
    pub(crate) input_documents_count: ::std::option::Option<i32>,
}
impl JobDetailsBuilder {
    /// <p>The number of documents successfully processed during a translation job.</p>
    pub fn translated_documents_count(mut self, input: i32) -> Self {
        self.translated_documents_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of documents successfully processed during a translation job.</p>
    pub fn set_translated_documents_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.translated_documents_count = input;
        self
    }
    /// <p>The number of documents successfully processed during a translation job.</p>
    pub fn get_translated_documents_count(&self) -> &::std::option::Option<i32> {
        &self.translated_documents_count
    }
    /// <p>The number of documents that could not be processed during a translation job.</p>
    pub fn documents_with_errors_count(mut self, input: i32) -> Self {
        self.documents_with_errors_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of documents that could not be processed during a translation job.</p>
    pub fn set_documents_with_errors_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.documents_with_errors_count = input;
        self
    }
    /// <p>The number of documents that could not be processed during a translation job.</p>
    pub fn get_documents_with_errors_count(&self) -> &::std::option::Option<i32> {
        &self.documents_with_errors_count
    }
    /// <p>The number of documents used as input in a translation job.</p>
    pub fn input_documents_count(mut self, input: i32) -> Self {
        self.input_documents_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of documents used as input in a translation job.</p>
    pub fn set_input_documents_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.input_documents_count = input;
        self
    }
    /// <p>The number of documents used as input in a translation job.</p>
    pub fn get_input_documents_count(&self) -> &::std::option::Option<i32> {
        &self.input_documents_count
    }
    /// Consumes the builder and constructs a [`JobDetails`](crate::types::JobDetails).
    pub fn build(self) -> crate::types::JobDetails {
        crate::types::JobDetails {
            translated_documents_count: self.translated_documents_count,
            documents_with_errors_count: self.documents_with_errors_count,
            input_documents_count: self.input_documents_count,
        }
    }
}
