// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ListLanguagesOutput {
    /// <p>The list of supported languages.</p>
    pub languages: ::std::option::Option<::std::vec::Vec<crate::types::Language>>,
    /// <p>The language code passed in with the request.</p>
    pub display_language_code: ::std::option::Option<crate::types::DisplayLanguageCode>,
    /// <p>If the response does not include all remaining results, use the NextToken in the next request to fetch the next group of supported languages.</p>
    pub next_token: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl ListLanguagesOutput {
    /// <p>The list of supported languages.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.languages.is_none()`.
    pub fn languages(&self) -> &[crate::types::Language] {
        self.languages.as_deref().unwrap_or_default()
    }
    /// <p>The language code passed in with the request.</p>
    pub fn display_language_code(&self) -> ::std::option::Option<&crate::types::DisplayLanguageCode> {
        self.display_language_code.as_ref()
    }
    /// <p>If the response does not include all remaining results, use the NextToken in the next request to fetch the next group of supported languages.</p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl ::aws_types::request_id::RequestId for ListLanguagesOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl ListLanguagesOutput {
    /// Creates a new builder-style object to manufacture [`ListLanguagesOutput`](crate::operation::list_languages::ListLanguagesOutput).
    pub fn builder() -> crate::operation::list_languages::builders::ListLanguagesOutputBuilder {
        crate::operation::list_languages::builders::ListLanguagesOutputBuilder::default()
    }
}

/// A builder for [`ListLanguagesOutput`](crate::operation::list_languages::ListLanguagesOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ListLanguagesOutputBuilder {
    pub(crate) languages: ::std::option::Option<::std::vec::Vec<crate::types::Language>>,
    pub(crate) display_language_code: ::std::option::Option<crate::types::DisplayLanguageCode>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
    _request_id: Option<String>,
}
impl ListLanguagesOutputBuilder {
    /// Appends an item to `languages`.
    ///
    /// To override the contents of this collection use [`set_languages`](Self::set_languages).
    ///
    /// <p>The list of supported languages.</p>
    pub fn languages(mut self, input: crate::types::Language) -> Self {
        let mut v = self.languages.unwrap_or_default();
        v.push(input);
        self.languages = ::std::option::Option::Some(v);
        self
    }
    /// <p>The list of supported languages.</p>
    pub fn set_languages(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Language>>) -> Self {
        self.languages = input;
        self
    }
    /// <p>The list of supported languages.</p>
    pub fn get_languages(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Language>> {
        &self.languages
    }
    /// <p>The language code passed in with the request.</p>
    pub fn display_language_code(mut self, input: crate::types::DisplayLanguageCode) -> Self {
        self.display_language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>The language code passed in with the request.</p>
    pub fn set_display_language_code(mut self, input: ::std::option::Option<crate::types::DisplayLanguageCode>) -> Self {
        self.display_language_code = input;
        self
    }
    /// <p>The language code passed in with the request.</p>
    pub fn get_display_language_code(&self) -> &::std::option::Option<crate::types::DisplayLanguageCode> {
        &self.display_language_code
    }
    /// <p>If the response does not include all remaining results, use the NextToken in the next request to fetch the next group of supported languages.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If the response does not include all remaining results, use the NextToken in the next request to fetch the next group of supported languages.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p>If the response does not include all remaining results, use the NextToken in the next request to fetch the next group of supported languages.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`ListLanguagesOutput`](crate::operation::list_languages::ListLanguagesOutput).
    pub fn build(self) -> crate::operation::list_languages::ListLanguagesOutput {
        crate::operation::list_languages::ListLanguagesOutput {
            languages: self.languages,
            display_language_code: self.display_language_code,
            next_token: self.next_token,
            _request_id: self._request_id,
        }
    }
}
