// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_terminology::_get_terminology_output::GetTerminologyOutputBuilder;

pub use crate::operation::get_terminology::_get_terminology_input::GetTerminologyInputBuilder;

impl GetTerminologyInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_terminology::GetTerminologyOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_terminology::GetTerminologyError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_terminology();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetTerminology`.
///
/// <p>Retrieves a custom terminology.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetTerminologyFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_terminology::builders::GetTerminologyInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_terminology::GetTerminologyOutput,
        crate::operation::get_terminology::GetTerminologyError,
    > for GetTerminologyFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_terminology::GetTerminologyOutput,
            crate::operation::get_terminology::GetTerminologyError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetTerminologyFluentBuilder {
    /// Creates a new `GetTerminology`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetTerminology as a reference.
    pub fn as_input(&self) -> &crate::operation::get_terminology::builders::GetTerminologyInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_terminology::GetTerminologyOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_terminology::GetTerminologyError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::get_terminology::GetTerminology::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::get_terminology::GetTerminology::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_terminology::GetTerminologyOutput,
        crate::operation::get_terminology::GetTerminologyError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl Into<crate::config::Builder>) -> Self {
        self.set_config_override(Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the custom terminology being retrieved.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.name(input.into());
        self
    }
    /// <p>The name of the custom terminology being retrieved.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_name(input);
        self
    }
    /// <p>The name of the custom terminology being retrieved.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_name()
    }
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub fn terminology_data_format(mut self, input: crate::types::TerminologyDataFormat) -> Self {
        self.inner = self.inner.terminology_data_format(input);
        self
    }
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub fn set_terminology_data_format(mut self, input: ::std::option::Option<crate::types::TerminologyDataFormat>) -> Self {
        self.inner = self.inner.set_terminology_data_format(input);
        self
    }
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was imported to create the terminology.</p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub fn get_terminology_data_format(&self) -> &::std::option::Option<crate::types::TerminologyDataFormat> {
        self.inner.get_terminology_data_format()
    }
}
