// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A list of possible alternative transcriptions for the input audio. Each alternative may contain one or more of <code>Items</code>, <code>Entities</code>, or <code>Transcript</code>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalAlternative {
    /// <p>Contains transcribed text.</p>
    pub transcript: ::std::option::Option<::std::string::String>,
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    pub items: ::std::option::Option<::std::vec::Vec<crate::types::MedicalItem>>,
    /// <p>Contains entities identified as personal health information (PHI) in your transcription output.</p>
    pub entities: ::std::option::Option<::std::vec::Vec<crate::types::MedicalEntity>>,
}
impl MedicalAlternative {
    /// <p>Contains transcribed text.</p>
    pub fn transcript(&self) -> ::std::option::Option<&str> {
        self.transcript.as_deref()
    }
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.items.is_none()`.
    pub fn items(&self) -> &[crate::types::MedicalItem] {
        self.items.as_deref().unwrap_or_default()
    }
    /// <p>Contains entities identified as personal health information (PHI) in your transcription output.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.entities.is_none()`.
    pub fn entities(&self) -> &[crate::types::MedicalEntity] {
        self.entities.as_deref().unwrap_or_default()
    }
}
impl MedicalAlternative {
    /// Creates a new builder-style object to manufacture [`MedicalAlternative`](crate::types::MedicalAlternative).
    pub fn builder() -> crate::types::builders::MedicalAlternativeBuilder {
        crate::types::builders::MedicalAlternativeBuilder::default()
    }
}

/// A builder for [`MedicalAlternative`](crate::types::MedicalAlternative).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct MedicalAlternativeBuilder {
    pub(crate) transcript: ::std::option::Option<::std::string::String>,
    pub(crate) items: ::std::option::Option<::std::vec::Vec<crate::types::MedicalItem>>,
    pub(crate) entities: ::std::option::Option<::std::vec::Vec<crate::types::MedicalEntity>>,
}
impl MedicalAlternativeBuilder {
    /// <p>Contains transcribed text.</p>
    pub fn transcript(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.transcript = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Contains transcribed text.</p>
    pub fn set_transcript(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.transcript = input;
        self
    }
    /// <p>Contains transcribed text.</p>
    pub fn get_transcript(&self) -> &::std::option::Option<::std::string::String> {
        &self.transcript
    }
    /// Appends an item to `items`.
    ///
    /// To override the contents of this collection use [`set_items`](Self::set_items).
    ///
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    pub fn items(mut self, input: crate::types::MedicalItem) -> Self {
        let mut v = self.items.unwrap_or_default();
        v.push(input);
        self.items = ::std::option::Option::Some(v);
        self
    }
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    pub fn set_items(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::MedicalItem>>) -> Self {
        self.items = input;
        self
    }
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    pub fn get_items(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::MedicalItem>> {
        &self.items
    }
    /// Appends an item to `entities`.
    ///
    /// To override the contents of this collection use [`set_entities`](Self::set_entities).
    ///
    /// <p>Contains entities identified as personal health information (PHI) in your transcription output.</p>
    pub fn entities(mut self, input: crate::types::MedicalEntity) -> Self {
        let mut v = self.entities.unwrap_or_default();
        v.push(input);
        self.entities = ::std::option::Option::Some(v);
        self
    }
    /// <p>Contains entities identified as personal health information (PHI) in your transcription output.</p>
    pub fn set_entities(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::MedicalEntity>>) -> Self {
        self.entities = input;
        self
    }
    /// <p>Contains entities identified as personal health information (PHI) in your transcription output.</p>
    pub fn get_entities(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::MedicalEntity>> {
        &self.entities
    }
    /// Consumes the builder and constructs a [`MedicalAlternative`](crate::types::MedicalAlternative).
    pub fn build(self) -> crate::types::MedicalAlternative {
        crate::types::MedicalAlternative {
            transcript: self.transcript,
            items: self.items,
            entities: self.entities,
        }
    }
}
