// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A wrapper for your audio chunks. Your audio stream consists of one or more audio events, which consist of one or more audio chunks.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/event-stream.html">Event stream encoding</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AudioEvent {
    /// <p>An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio chunk size is 32 KB.</p>
    pub audio_chunk: ::std::option::Option<::aws_smithy_types::Blob>,
}
impl AudioEvent {
    /// <p>An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio chunk size is 32 KB.</p>
    pub fn audio_chunk(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.audio_chunk.as_ref()
    }
}
impl AudioEvent {
    /// Creates a new builder-style object to manufacture [`AudioEvent`](crate::types::AudioEvent).
    pub fn builder() -> crate::types::builders::AudioEventBuilder {
        crate::types::builders::AudioEventBuilder::default()
    }
}

/// A builder for [`AudioEvent`](crate::types::AudioEvent).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct AudioEventBuilder {
    pub(crate) audio_chunk: ::std::option::Option<::aws_smithy_types::Blob>,
}
impl AudioEventBuilder {
    /// <p>An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio chunk size is 32 KB.</p>
    pub fn audio_chunk(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.audio_chunk = ::std::option::Option::Some(input);
        self
    }
    /// <p>An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio chunk size is 32 KB.</p>
    pub fn set_audio_chunk(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.audio_chunk = input;
        self
    }
    /// <p>An audio blob that contains the next part of the audio that you want to transcribe. The maximum audio chunk size is 32 KB.</p>
    pub fn get_audio_chunk(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.audio_chunk
    }
    /// Consumes the builder and constructs a [`AudioEvent`](crate::types::AudioEvent).
    pub fn build(self) -> crate::types::AudioEvent {
        crate::types::AudioEvent {
            audio_chunk: self.audio_chunk,
        }
    }
}
