// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`StartCallAnalyticsStreamTranscription`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`language_code(CallAnalyticsLanguageCode)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::language_code) / [`set_language_code(Option<CallAnalyticsLanguageCode>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_language_code):<br>required: **true**<br><p>Specify the language code that represents the language spoken in your audio.</p> <p>If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable automatic language identification.</p> <p>For a list of languages supported with streaming Call Analytics, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p><br>
    ///   - [`media_sample_rate_hertz(i32)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::media_sample_rate_hertz) / [`set_media_sample_rate_hertz(Option<i32>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_media_sample_rate_hertz):<br>required: **true**<br><p>The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p><br>
    ///   - [`media_encoding(MediaEncoding)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::media_encoding) / [`set_media_encoding(Option<MediaEncoding>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_media_encoding):<br>required: **true**<br><p>Specify the encoding of your input audio. Supported formats are:</p> <ul>  <li>   <p>FLAC</p></li>  <li>   <p>OPUS-encoded audio in an Ogg container</p></li>  <li>   <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p><br>
    ///   - [`vocabulary_name(impl Into<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::vocabulary_name) / [`set_vocabulary_name(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_vocabulary_name):<br>required: **false**<br><p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p> <p>If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p><br>
    ///   - [`session_id(impl Into<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::session_id) / [`set_session_id(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_session_id):<br>required: **false**<br><p>Specify a name for your Call Analytics transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.</p> <p>You can use a session ID to retry a streaming session.</p><br>
    ///   - [`audio_stream(EventStreamSender<AudioStream, AudioStreamError>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::audio_stream) / [`set_audio_stream(EventStreamSender<AudioStream, AudioStreamError>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_audio_stream):<br>required: **true**<br><p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p><br>
    ///   - [`vocabulary_filter_name(impl Into<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::vocabulary_filter_name) / [`set_vocabulary_filter_name(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_vocabulary_filter_name):<br>required: **false**<br><p>Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p> <p>If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p><br>
    ///   - [`vocabulary_filter_method(VocabularyFilterMethod)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::vocabulary_filter_method) / [`set_vocabulary_filter_method(Option<VocabularyFilterMethod>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_vocabulary_filter_method):<br>required: **false**<br><p>Specify how you want your vocabulary filter applied to your transcript.</p> <p>To replace words with <code>***</code>, choose <code>mask</code>.</p> <p>To delete words, choose <code>remove</code>.</p> <p>To flag words without changing them, choose <code>tag</code>.</p><br>
    ///   - [`language_model_name(impl Into<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::language_model_name) / [`set_language_model_name(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_language_model_name):<br>required: **false**<br><p>Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.</p> <p>The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.</p><br>
    ///   - [`enable_partial_results_stabilization(bool)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::enable_partial_results_stabilization) / [`set_enable_partial_results_stabilization(Option<bool>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_enable_partial_results_stabilization):<br>required: **false**<br><p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p><br>
    ///   - [`partial_results_stability(PartialResultsStability)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::partial_results_stability) / [`set_partial_results_stability(Option<PartialResultsStability>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_partial_results_stability):<br>required: **false**<br><p>Specify the level of stability to use when you enable partial results stabilization (<code>EnablePartialResultsStabilization</code>).</p> <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p><br>
    ///   - [`content_identification_type(ContentIdentificationType)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::content_identification_type) / [`set_content_identification_type(Option<ContentIdentificationType>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_content_identification_type):<br>required: **false**<br><p>Labels all personally identifiable information (PII) identified in your transcript.</p> <p>Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio segment.</p> <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p><br>
    ///   - [`content_redaction_type(ContentRedactionType)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::content_redaction_type) / [`set_content_redaction_type(Option<ContentRedactionType>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_content_redaction_type):<br>required: **false**<br><p>Redacts all personally identifiable information (PII) identified in your transcript.</p> <p>Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted upon complete transcription of an audio segment.</p> <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p><br>
    ///   - [`pii_entity_types(impl Into<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::pii_entity_types) / [`set_pii_entity_types(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::set_pii_entity_types):<br>required: **false**<br><p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p> <p>To include <code>PiiEntityTypes</code> in your Call Analytics request, you must also include either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p> <p>Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, or <code>ALL</code>.</p><br>
    /// - On success, responds with [`StartCallAnalyticsStreamTranscriptionOutput`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::request_id): <p>Provides the identifier for your Call Analytics streaming request.</p>
    ///   - [`language_code(Option<CallAnalyticsLanguageCode>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::language_code): <p>Provides the language code that you specified in your Call Analytics request.</p>
    ///   - [`media_sample_rate_hertz(Option<i32>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::media_sample_rate_hertz): <p>Provides the sample rate that you specified in your Call Analytics request.</p>
    ///   - [`media_encoding(Option<MediaEncoding>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::media_encoding): <p>Provides the media encoding you specified in your Call Analytics request.</p>
    ///   - [`vocabulary_name(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::vocabulary_name): <p>Provides the name of the custom vocabulary that you specified in your Call Analytics request.</p>
    ///   - [`session_id(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::session_id): <p>Provides the identifier for your Call Analytics transcription session.</p>
    ///   - [`call_analytics_transcript_result_stream(EventReceiver<CallAnalyticsTranscriptResultStream, CallAnalyticsTranscriptResultStreamError>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::call_analytics_transcript_result_stream): <p>Provides detailed information about your Call Analytics streaming session.</p>
    ///   - [`vocabulary_filter_name(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::vocabulary_filter_name): <p>Provides the name of the custom vocabulary filter that you specified in your Call Analytics request.</p>
    ///   - [`vocabulary_filter_method(Option<VocabularyFilterMethod>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::vocabulary_filter_method): <p>Provides the vocabulary filtering method used in your Call Analytics transcription.</p>
    ///   - [`language_model_name(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::language_model_name): <p>Provides the name of the custom language model that you specified in your Call Analytics request.</p>
    ///   - [`enable_partial_results_stabilization(bool)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::enable_partial_results_stabilization): <p>Shows whether partial results stabilization was enabled for your Call Analytics transcription.</p>
    ///   - [`partial_results_stability(Option<PartialResultsStability>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::partial_results_stability): <p>Provides the stabilization level used for your transcription.</p>
    ///   - [`content_identification_type(Option<ContentIdentificationType>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::content_identification_type): <p>Shows whether content identification was enabled for your Call Analytics transcription.</p>
    ///   - [`content_redaction_type(Option<ContentRedactionType>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::content_redaction_type): <p>Shows whether content redaction was enabled for your Call Analytics transcription.</p>
    ///   - [`pii_entity_types(Option<String>)`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionOutput::pii_entity_types): <p>Lists the PII entity types you specified in your Call Analytics request.</p>
    /// - On failure, responds with [`SdkError<StartCallAnalyticsStreamTranscriptionError>`](crate::operation::start_call_analytics_stream_transcription::StartCallAnalyticsStreamTranscriptionError)
    pub fn start_call_analytics_stream_transcription(
        &self,
    ) -> crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder {
        crate::operation::start_call_analytics_stream_transcription::builders::StartCallAnalyticsStreamTranscriptionFluentBuilder::new(
            self.handle.clone(),
        )
    }
}
