// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Container for <code>TagSet</code> elements.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Tagging {
    /// <p>A collection for a set of tags</p>
    pub tag_set: ::std::vec::Vec<crate::types::Tag>,
}
impl Tagging {
    /// <p>A collection for a set of tags</p>
    pub fn tag_set(&self) -> &[crate::types::Tag] {
        use std::ops::Deref;
        self.tag_set.deref()
    }
}
impl Tagging {
    /// Creates a new builder-style object to manufacture [`Tagging`](crate::types::Tagging).
    pub fn builder() -> crate::types::builders::TaggingBuilder {
        crate::types::builders::TaggingBuilder::default()
    }
}

/// A builder for [`Tagging`](crate::types::Tagging).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct TaggingBuilder {
    pub(crate) tag_set: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>,
}
impl TaggingBuilder {
    /// Appends an item to `tag_set`.
    ///
    /// To override the contents of this collection use [`set_tag_set`](Self::set_tag_set).
    ///
    /// <p>A collection for a set of tags</p>
    pub fn tag_set(mut self, input: crate::types::Tag) -> Self {
        let mut v = self.tag_set.unwrap_or_default();
        v.push(input);
        self.tag_set = ::std::option::Option::Some(v);
        self
    }
    /// <p>A collection for a set of tags</p>
    pub fn set_tag_set(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.tag_set = input;
        self
    }
    /// <p>A collection for a set of tags</p>
    pub fn get_tag_set(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        &self.tag_set
    }
    /// Consumes the builder and constructs a [`Tagging`](crate::types::Tagging).
    /// This method will fail if any of the following fields are not set:
    /// - [`tag_set`](crate::types::builders::TaggingBuilder::tag_set)
    pub fn build(self) -> ::std::result::Result<crate::types::Tagging, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Tagging {
            tag_set: self.tag_set.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "tag_set",
                    "tag_set was not specified but it is required when building Tagging",
                )
            })?,
        })
    }
}
